import platform
import os
import sys
import django

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck310')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()


init()


# find_foodcards_with_equal_amounts.py

import os
import django
import sys
from datetime import datetime, timezone
import json


from APIs.models import FoodCard
from django.contrib.auth.models import User as DjangoUser

# --------------------------------------------
# 3. Define the Main Function
# --------------------------------------------

def find_foodcards_with_equal_amounts():
    """
    Find FoodCard instances created on Aug 16-17, 2025 where foods JSON array
    contains objects with home_unit_amount equal to amount
    
    Note: amount is typically in grams, home_unit_amount is in home units (e.g., tablespoons)
    """
    
    # Define the date range (Aug 16-17, 2025)
    start_date = datetime(2025, 8, 16, 0, 0, 0)
    end_date = datetime(2025, 8, 18, 0, 0, 0)  # End of Aug 17
    
    print(f"Searching for FoodCard instances created between {start_date.strftime('%Y-%m-%d')} and {end_date.strftime('%Y-%m-%d')}")
    print("Looking for foods where home_unit_amount equals amount...")
    print("Note: amount (grams) vs home_unit_amount (home units like tablespoons)")
    print("-" * 80)
    
    # Query FoodCard instances created in the specified date range
    foodcards = FoodCard.objects.filter(
        created_at__gte=start_date,
        created_at__lt=end_date
    ).order_by('created_at')
    
    print(f"Found {foodcards.count()} FoodCard instances in the specified date range")
    print()
    
    matching_foodcards = []
    
    for foodcard in foodcards:
        # Check if foods field exists and is a list
        if not foodcard.foods or not isinstance(foodcard.foods, list):
            continue
        
        matching_foods = []
        
        # Check each food in the foods JSON array
        for food in foodcard.foods:
            if isinstance(food, dict):
                home_unit_amount = food.get('home_unit_amount')
                amount = food.get('amount')
                
                # Check if both fields exist and are equal
                if (home_unit_amount is not None and 
                    amount is not None and 
                    home_unit_amount == amount):
                    
                    matching_foods.append(food)
        
        # Only process FoodCards that have matching foods
        if matching_foods:
            matching_foodcards.append({
                'foodcard': foodcard,
                'matching_foods': matching_foods
            })
    
    # Summary
    print("=" * 80)
    print("FOODCARDS WITH EQUAL home_unit_amount AND amount")
    print("=" * 80)
    print(f"Total FoodCard instances checked: {foodcards.count()}")
    print(f"FoodCard instances with matching foods: {len(matching_foodcards)}")
    
    if matching_foodcards:
        print("\nMatching FoodCard instances:")
        print("FA_Name | Calories")
        print("-" * 40)
        for item in matching_foodcards:
            foodcard = item['foodcard']
            matching_count = len(item['matching_foods'])
            print(f"{foodcard.FA_Name} | {foodcard.Calories}")
    else:
        print("\nNo FoodCard instances found with foods having equal home_unit_amount and amount")
    
    return matching_foodcards

# --------------------------------------------
# 4. Main Execution
# --------------------------------------------

# if __name__ == '__main__':
try:
    print("Starting FoodCard search script...")
    print("=" * 80)
    
    matching_foodcards = find_foodcards_with_equal_amounts()
    
    print("\nScript completed successfully!")
    
except Exception as e:
    print(f"Error occurred: {str(e)}")
    import traceback
    traceback.print_exc() 
    