from django.contrib.auth import authenticate
from rest_framework.views import APIView
from rest_framework.response import Response
from rest_framework import status
from APIs.models import UserScript
import subprocess
import platform

version = platform.version()
if "#52-Ubuntu" in version:
    activation = "source ~/Documents/ziluck_project/venv/bin/activate"
elif "your platform name" in version:
    activation = "source ~/path/to/activate/file/in/venv/bin"
else:
    activation = "source /home/idiair/virtualenv/.ziluck310/3.10/bin/activate"


SETUP_CODE = """
"""


class ExecuteScriptView(APIView):
    def post(self, request):
        username = request.data.get('username')
        password = request.data.get('password')
        script_file = request.FILES.get('script_file')

        # user auth
        user = authenticate(username=username, password=password)
        if user is None:
            return Response({"error": "Authentication failed"}, status=status.HTTP_401_UNAUTHORIZED)

        if not user.is_staff:
            return Response({"error": "Authentication failed, you are not a staff user!"}, status=status.HTTP_401_UNAUTHORIZED)

        # save file
        user_script = UserScript(django_user=user, script_file=script_file)
        user_script.save()

        # run in virtual env
        try:
            file_path = user_script.script_file.path

            command = activation + f" && python {file_path}"

            process = subprocess.Popen(['bash', '-c', command], stdout=subprocess.PIPE, stderr=subprocess.PIPE, text=True)
            stdout, stderr = process.communicate()

            output = f"STDOUT:\n{stdout}\nSTDERR:\n{stderr}"
            user_script.returncode = process.returncode
            user_script.output = output
            user_script.returncode = process.returncode
            user_script.save()
            if process.returncode == 0:
                return Response({"message": "Script executed successfully", "output": output}, status=status.HTTP_200_OK)
            else:
                return Response({"error": "Script execution failed", "details": output}, status=status.HTTP_400_BAD_REQUEST)
        except Exception as e:
            return Response({"error": str(e)}, status=status.HTTP_500_INTERNAL_SERVER_ERROR)