import datetime
from turtle import delay

from .views import *
import jsonpickle
import requests
import cv2
from panel.models import Message as PanelMessage
from panel.models import Challenge, ChallengeSelection
import pandas as pd
import numpy as np
from APIs.modules.like_dislike import update_foods

# from sklearn.preprocessing import MinMaxScaler
from django.db.models import Sum
from APIs.views.views import notif_cal
from panel.assistant import calorie_distributions, cr_list
import os
import tempfile
import shutil
from APIs.models import FoodRecommendationsCache
from APIs.modules.BloodTestReport_generat import (
    convert_pdf_to_images,
    run_ocr_on_images,
    process_text_with_llm,
    analyze_test_ranges,
    build_lacto_report_prompt,
    generate_report_with_llm,
    clean_markdown_report,
)


@api_view(["POST", "GET"])
def activities_log(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن اشتباه وارد شده است",
                    },
                    {
                        "name": "phone_number",
                        "format": "^09[0-9]{9}$",
                        "required": False,
                        "errorMessage": "شماره تلفن اشتباه وارد شده است",
                    },
                    {
                        "name": "start_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "زمان شروع اشتباه وارد شده است",
                    },
                    {
                        "name": "end_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "زمان پایان اشتباه وارد شده است",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                        "errorMessage": "مقدار اشتباه وارد شده است",
                    },
                    {
                        "name": "activity_code",
                        "format": "^[\d]+$",
                        "errorMessage": "فیلد activity_code را به صورت یک عدد طبیعی وارد کنید",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]
            amount = int(request.POST["amount"])
            activity_code = int(request.POST["activity_code"])
            temp = Activity.objects.filter(id=activity_code)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidActivity.message, Errors.InvalidActivity.code
                )
            activity = temp[0]

            sdt = int(request.POST["start_date_time"])
            edt = int(request.POST["end_date_time"])

            start_date_time = datetime.fromtimestamp(sdt)
            end_date_time = datetime.fromtimestamp(edt)

            now = datetime.now().date()
            today = date.today()
            today_start = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=0,
                minute=0,
                second=0,
            )
            today_end = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=23,
                minute=59,
                second=59,
            )
            amount_challenge_1 = 0
            amount_challenge_2 = 0

            record_date = start_date_time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            Metz = activity.Metz
            A = (Metz - 1) * ((1.15 / 0.9) * amount) / 1440
            BMR = user.profile.BMR
            B = BMR / (0.0175 * 1440 * user.profile.weight)
            PALx = round(A / B, 5)
            PALX = record.PALX + PALx
            record.PALX = PALX
            y = 0
            if PALX <= 1.1:
                y = 0
            elif PALX > 1.8:
                y = 1
            else:
                y = PALX / 1.8

            # record.total_Activity_Point = y
            record.save()

            energy = round(amount * user.profile.weight * 0.0175 * Metz, 1)
            new_log = Activities_log(
                user=user,
                activity=activity,
                start_date_time=start_date_time,
                end_date_time=end_date_time,
                amount=amount,
                energy=energy,
                PALx=PALx,
                point=0,
            )

            new_log.save()

            challenges = ChallengeSelection.objects.filter(user=user)
            for c in challenges:
                if c.challenge.category == 2:
                    if c.challenge.sub_category == 2:
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            logs = Activities_log.objects.filter(
                                user=user,
                                start_date_time__range=(today_start, today_end),
                            )
                            if logs is not None:
                                for w in logs:
                                    amount_challenge_1 = amount_challenge_1 + w.amount
                                    if (
                                        amount_challenge_1
                                        > c.challenge.exercise_duration
                                        / (end_day - start_day).days
                                    ):
                                        c.day_status["status"][duration] = True
                                        c.save()
                    if c.challenge.sub_category == 1:
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            logs = Activities_log.objects.filter(
                                user=user,
                                start_date_time__range=(today_start, today_end),
                            )
                            if logs is not None:
                                for w in logs:
                                    amount_challenge_2 = amount_challenge_2 + w.energy
                                    if c.challenge.calorie_burnt * 0.9 < w.energy:
                                        c.day_status["status"][duration] = True
                                        c.save()

            u = updateTotalPointDay(user, record, is_Activity=True)
            # Calculate points gained
            points_awarded = u["points_awarded"]
            activity_points_gained = points_awarded["Activity_points_gained"]
            engagement_points_gained = points_awarded["Engagement_points_gained"]

            # Construct the message
            messages = []
            if activity_points_gained > 0:
                messages.append(
                    f"شما{activity_points_gained}امتیاز بابت ثبت ورزش به دست آوردید! "
                )
            else:
                messages.append(
                    "امروز امتیاز حداکثری ورزش رو به دست آوردی! آفرین به تو! 🏆"
                )

            if engagement_points_gained > 0:
                messages.append(
                    f"{engagement_points_gained} امتیاز ثبت فعالیت گرفتی! همیشه عالی پیش میری! 🎉"
                )
            else:
                messages.append(
                    "امروز به حداکثر امتیاز ثبت فعالیت رسیدی! کلی تلاش کردی، احسنت! 💪🏅"
                )

            total_message = " ".join(messages)

            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            data = {
                "PALx": PALx,
                "energy": energy,
                "DayPoint": totalPoint,
                "activity_name": activity.name,
                "activity_points": record.total_Activity_Point,
                "engagement_points": record.this_day_DataEntry_score,
                "message": total_message,
            }
            return myResponse.OK("Information was recorded", data)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر",
                    },
                    {
                        "name": "phone_number",
                        "format": "^09[0-9]{9}$",
                        "required": False,
                        "errorMessage": "شماره تلفن اشتباه وارد شده است",
                    },
                    {
                        "name": "start_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "code",
                        "format": "^[/d]+$",  # 0 or 1 for true or false
                        "required": False,
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )

            token = str(request.GET["token"])
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            sdt = int(request.GET["start_date_time"])
            edt = int(request.GET["end_date_time"])
            t1 = datetime.fromtimestamp(sdt)
            t2 = datetime.fromtimestamp(edt)

            if request.GET.get("code") is None:
                logs = Activities_log.objects.filter(
                    user=user, start_date_time__range=(t1, t2)
                )
            else:
                logs = Activities_log.objects.filter(
                    user=user,
                    start_date_time__range=(t1, t2),
                    activity_id=int(request.GET["code"]),
                )
            acs = []
            result = {
                "total_time": 0,
                "total_amount": 0,
                "total_point": 0,
                "total_energy": 0,
                # "total_step": 0,
                "count": 0,
                "walking_steps": 0,
                "walking_amount": 0,
                "walking_energy": 0,
            }
            for i in range(logs.count()):
                acs.append(
                    {
                        "activity_type": logs[i].activity.name,
                        "amount": logs[i].amount,
                        "point": logs[i].point,
                        "start_date_time": int(logs[i].start_date_time.timestamp()),
                        "end_date_time": int(logs[i].end_date_time.timestamp()),
                        "energy": int(logs[i].energy),
                        "activity_code": logs[i].activity.id,
                        "id": int(logs[i].id),
                    }
                )
                result["total_time"] += logs[i].amount  # time in minute
                result["total_amount"] += logs[i].amount
                result["total_point"] += logs[i].point
                result["total_energy"] += logs[i].energy
            result["count"] = logs.count()

            logsWalking = Walking.objects.filter(
                user=user, date__range=(t1.date(), t2.date())
            )
            for i in range(logsWalking.count()):
                result["walking_steps"] += logsWalking[i].steps
                result["walking_amount"] += logsWalking[i].amount
                result["walking_energy"] += logsWalking[i].energy
                result["total_energy"] += logsWalking[i].energy

            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = acs

            return myResponse.OK("List of activities in this period", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def eating(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن را درست وارد کنید",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن را درست وارد کنید 0900",
                    },
                    {
                        "name": "date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161",
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^(\S)+$",
                    },
                    {
                        "name": "food_code",
                        "format": "^(\S)+$",
                        "errorMessage": "نوع غذا باید به صورت یک عدد طبیعی باشد و در طرفین اعداد & باشد",
                    },
                    {
                        "name": "home_unit_index",
                        "format": "^(\S)+$",
                        "errorMessage": "نوع واحد خانگی باید به صورت یک عدد طبیعی باشد و در طرفین اعداد & باشد",
                        "required": False,
                    },
                    {
                        "name": "meal",
                        "format": "^[\d]+$",
                        "errorMessage": "وعده غذایی باید به صورت یک عدد طبیعی باشد",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            dt = int(request.POST["date_time"])
            date_time = datetime.fromtimestamp(dt)

            now = datetime.now().date()
            today = date.today()
            today_start = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=0,
                minute=0,
                second=0,
            )
            today_end = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=23,
                minute=59,
                second=59,
            )
            amount_microbiome_challenge = 0
            amount_fat_challenge = 0
            amount_calorie_challenge = 0
            amount_protein_challenge = 0
            amount_carbohydrate_challenge = 0

            meal = int(request.POST["meal"])
            if meal > 5:
                return myResponse.Error(
                    Errors.InvalidMealId.message, Errors.InvalidMealId.code
                )

            amounts = getList(request.POST["amount"])
            food_codes = getList(request.POST["food_code"])
            if request.POST.get("home_unit_index") is None:
                home_unit_index = []
                for i in range(len(food_codes)):
                    home_unit_index.append(0)
            else:
                home_unit_index = getIntegerList(request.POST["home_unit_index"])

            data = user.calculate_cr_macro_nutrients_distribution()

            user.profile.CR = data["CR"]
            user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
            user.profile.Carbohydrates_unit = data["macro_nutrients"][
                "carbohydrates_unit"
            ]
            user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
            user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
            user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
            user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]
            user.profile.Fiber_g = data["macro_nutrients"]["fiber_g"]
            user.profile.Fiber_unit = data["macro_nutrients"]["fiber_unit"]

            Carbohydrates_distribution_str = listToStr(
                data["carbohydrate_distribution_g"]
            )

            user.profile.Carbohydrates_distribution_list_g = (
                Carbohydrates_distribution_str
            )
            user.profile.Protein_distribution_g = data["protein_distribution_g"]
            user.profile.Fat_distribution_g = data["fat_distribution_g"]
            user.profile.Fiber_distribution_g = data["fiber_distribution_g"]
            user.profile.save()

            Carbohydrates_list_to_use = getList(
                user.profile.Carbohydrates_distribution_list_g
            )
            Fat_to_use = user.profile.Fat_distribution_g
            Protein_to_use = user.profile.Protein_distribution_g
            Fiber_to_use = user.profile.Fiber_distribution_g

            record_date = date_time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)
            # this meal used:
            HEI_elements_sum = [
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
                0,
            ]

            Carbohydrates_used = 0
            Protein_used = 0
            Fat_used = 0
            Calorie_used = 0
            Fiber_used = 0

            for i in range(min(len(amounts), len(food_codes))):
                f = Food.objects.filter(Data_Base_Number=str(int(food_codes[i])))
                if not f.exists():
                    return myResponse.Error(
                        Errors.InvalidFoodId.message, Errors.InvalidFoodId.code
                    )
                food = f[0]
                HUIi = home_unit_index[i]
                real_amount_g = (
                    amounts[i] * getFloatList(food.Weight_of_home_units)[HUIi]
                )
                Carbohydrates_used += (real_amount_g / 100) * food.Carbohydrates_g
                Protein_used += (real_amount_g / 100) * food.Protein_g
                Fat_used += (real_amount_g / 100) * food.Fat_g
                Calorie_used += (real_amount_g / 100) * food.Calories
                Fiber_used += (real_amount_g / 100) * food.Fiber_g
                HEI_elements_i = getHEI_List(food, real_amount_g)
                HEI_elements_sum = myListAdder(HEI_elements_sum, HEI_elements_i)
                # save eating log in it's table...
                new_log = Eating(
                    user=user,
                    food=food,
                    date_time=date_time,
                    amount=real_amount_g,
                    meal=meal,
                )
                new_log.save()
            # Carbohydrates calculations
            this_day_Carbohydrates_point = getList(record.this_day_Carbohydrates_point)
            this_day_Carbohydrates_g = getList(record.this_day_Carbohydrates_g)
            this_day_Carbohydrates_g[meal] += Carbohydrates_used
            record.this_day_Carbohydrates_g = listToStr(this_day_Carbohydrates_g)
            this_day_Carbohydrates_point[meal] = normalize(
                this_day_Carbohydrates_g[meal] / Carbohydrates_list_to_use[meal]
            )
            record.this_day_Carbohydrates_point = listToStr(
                this_day_Carbohydrates_point
            )
            totalCarboControl = myListSum(this_day_Carbohydrates_point) / len(
                this_day_Carbohydrates_point
            )
            record.totalCarboControlPoint = totalCarboControl

            # Fat calculations
            this_day_Fat_g = getList(record.this_day_Fat_list_g)
            this_day_Fat_g[meal] += Fat_used
            record.this_day_Fat_list_g = listToStr(this_day_Fat_g)
            this_day_Fat_list_point = getList(record.this_day_Fat_list_point)
            this_day_Fat_list_point[meal] = normalize(this_day_Fat_g[meal] / Fat_to_use)
            record.this_day_Fat_list_point = listToStr(this_day_Fat_list_point)

            # Protein calculations
            this_day_Protein_list_g = getList(record.this_day_Protein_list_g)
            this_day_Protein_list_g[meal] += Protein_used
            record.this_day_Protein_list_g = listToStr(this_day_Protein_list_g)
            this_day_Protein_list_point = getList(record.this_day_Protein_list_point)
            this_day_Protein_list_point[meal] = normalize(
                this_day_Protein_list_g[meal] / Protein_to_use
            )
            record.this_day_Protein_list_point = listToStr(this_day_Protein_list_point)

            # Fiber calculations
            this_day_Fiber_list_g = getList(record.this_day_Fiber_list_g)
            this_day_Fiber_list_g[meal] += Fiber_used
            record.this_day_Fiber_list_g = listToStr(this_day_Fiber_list_g)
            this_day_Fiber_list_point = getList(record.this_day_Fiber_list_point)
            this_day_Fiber_list_point[meal] = normalize(
                this_day_Fiber_list_g[meal] / Fiber_to_use
            )
            record.this_day_Fiber_list_point = listToStr(this_day_Fiber_list_point)

            print(this_day_Protein_list_g[meal])
            challenges = ChallengeSelection.objects.filter(user=user)
            for c in challenges:
                if c.challenge.category == 0:
                    if c.challenge.sub_category == 3:  # protein
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            sleep = Sleep.objects.filter(
                                user=user, time__range=(today_start, today_end)
                            )
                            if sleep is not None:
                                if (
                                    c.challenge.protein - 0.5
                                    < this_day_Protein_list_g[meal]
                                    < c.challenge.sleep_duration + 0.5
                                ):
                                    c.day_status["status"][duration] = True
                                    c.save()

            # Calorie Calculations
            total_Calories_used = Calorie_used + record.total_Calories_used
            record.total_Calories_used = total_Calories_used
            record.total_Calories_Point = normalize(
                total_Calories_used / user.profile.CR
            )
            record.save()

            total_Fiber_used = Fiber_used + record.total_Fiber_used
            record.total_Fiber_used = total_Fiber_used
            record.save()

            # HEI elements used and calculations ...
            # HEI_elements_used = getHEI_List(food, amount)  #
            Last_HEI_elements = getList(record.HEI_elements_list)
            sum_Of_HEI_elements = myListAdder(Last_HEI_elements, HEI_elements_sum)
            total_HEI_Point = HEI_Point_Calculator(
                sum_Of_HEI_elements, record.total_Calories_used
            )
            record.HEI_elements_list = listToStr(sum_Of_HEI_elements)
            record.total_HEI_Point = total_HEI_Point

            # update and save changes
            record.save()
            before_log_point = record.this_day_total_diet_Point
            before_fiber_point = record.total_Fiber_Point

            u = updateTotalPointDay(user, record, isCall=-1, is_Diet=True)
            try:
                DietPoint = u["Diet_score"]
                notif = (
                    notif_cal(
                        record.this_day_total_diet_Point - before_log_point, "غذا"
                    )
                    if before_log_point != 10
                    else notif_cal(-100, "غذا")
                )
                notif_fiber = (
                    notif_cal(record.total_Fiber_Point - before_fiber_point, "فیبر")
                    if before_fiber_point != 15
                    else notif_cal(-100, "فیبر")
                )
            except Exception as e:
                notif = ""
                notif_fiber = ""

            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            try:
                update_foods(token, [food_codes], "log")
            except Exception as e:
                pass

            data = {
                "DayPoint": totalPoint,
                "notif_cal": notif,
                "notif_cal_fiber": notif_fiber,
            }
            return myResponse.OK("Information on this meal(s) was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], -1)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان شروع اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان  پایان اشتباه وارد شده اند",
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.GET["token"])
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            sdt = int(request.GET["start_date_time"])
            edt = int(request.GET["end_date_time"])
            t1 = datetime.fromtimestamp(sdt)
            d1 = t1.date()
            t2 = datetime.fromtimestamp(edt)
            d2 = t2.date()

            if t1 > t2:
                return myResponse.Error(
                    Errors.InvalidArgument.message, Errors.InvalidArgument.code
                )

            result = {
                "total_amount": 0,
                "total_calorie": 0,
                "total_fat": 0,
                "total_protein": 0,
                "total_carbohydrate": 0,
                "total_fiber": 0,
                "total_microbiome_score": 0,
                "count": 0,
            }

            # breakfast ********************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=0)
            # return myResponse.OK("0",str(temp))
            breakfast = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=0 --> breakfast
                breakfast["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                breakfast["fat"] += round(
                    (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                )
                breakfast["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                breakfast["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                breakfast["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                breakfast["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                breakfast["microbiome_score"] = round(
                    breakfast["microbiome_score"] / temp.count(), 2
                )

            # morning_snack ****************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=3)
            # return myResponse.OK("1", str(temp))
            morning_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=1 --> morning_snack
                morning_snack["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                morning_snack["fat"] += round(
                    (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                )
                morning_snack["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                morning_snack["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                morning_snack["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                morning_snack["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                morning_snack["microbiome_score"] = round(
                    morning_snack["microbiome_score"] / temp.count(), 2
                )

            # lunch ************************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=1)
            # return myResponse.OK("2", str(temp))
            lunch = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=2 --> lunch
                lunch["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                lunch["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                lunch["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                lunch["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                lunch["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                lunch["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                lunch["microbiome_score"] = round(
                    lunch["microbiome_score"] / temp.count(), 2
                )

            # evening_snack ****************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=4)
            # return myResponse.OK("3", str(temp))
            evening_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=3 --> evening_snack
                evening_snack["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                evening_snack["fat"] += round(
                    (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                )
                evening_snack["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                evening_snack["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                evening_snack["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                evening_snack["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                evening_snack["microbiome_score"] = round(
                    evening_snack["microbiome_score"] / temp.count(), 2
                )

            # dinner ***********************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=2)
            # return myResponse.OK("4", str(temp))
            dinner = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=4 --> dinner
                dinner["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                dinner["fat"] += round((temp[i].food.Fat_g * temp[i].amount) / 100, 2)
                dinner["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                dinner["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                dinner["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                dinner["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                dinner["microbiome_score"] = round(
                    dinner["microbiome_score"] / temp.count(), 2
                )

            # night_snack ******************************************
            temp = Eating.objects.filter(user=user, date_time__range=(t1, t2), meal=5)
            # return myResponse.OK("5", str(temp))
            night_snack = {
                "calorie": 0,
                "fat": 0,
                "protein": 0,
                "carbohydrate": 0,
                "fiber": 0,
                "microbiome_score": 0,
            }
            for i in range(temp.count()):  # meal=5 --> night_snack
                night_snack["calorie"] += round(
                    (temp[i].food.Calories * temp[i].amount) / 100, 2
                )
                night_snack["fat"] += round(
                    (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                )
                night_snack["protein"] += round(
                    (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                )
                night_snack["carbohydrate"] += round(
                    (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                )
                night_snack["fiber"] += round(
                    (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                )
                night_snack["microbiome_score"] += temp[i].food.microbiome_score
            if temp.count() > 0:
                night_snack["microbiome_score"] = round(
                    night_snack["microbiome_score"] / temp.count(), 2
                )

            # all eating logs ******************************************
            items = []
            logs = Eating.objects.filter(user=user, date_time__range=(t1, t2))
            for i in range(logs.count()):
                item = {
                    "food_name": logs[i].food.FA_Name,
                    "id": logs[i].id,
                    "calorie": round(
                        (logs[i].food.Calories * int(logs[i].amount)) / 100, 2
                    ),
                    "fat": round((logs[i].food.Fat_g * logs[i].amount) / 100, 2),
                    "protein": round(
                        (logs[i].food.Protein_g * logs[i].amount) / 100, 2
                    ),
                    "carbohydrate": round(
                        (logs[i].food.Carbohydrates_g * logs[i].amount) / 100, 2
                    ),
                    "fiber": round((logs[i].food.Fiber_g * logs[i].amount) / 100, 2),
                    "amount": logs[i].amount,
                    "point": logs[i].point,
                    "date_time": int(logs[i].date_time.timestamp()),
                    "meal": logs[i].meal,
                    "microbiome_score": logs[i].food.microbiome_score,
                }
                items.append(item)
                result["total_calorie"] += item["calorie"]
                result["total_fat"] += item["fat"]
                result["total_protein"] += item["protein"]
                result["total_carbohydrate"] += item["carbohydrate"]
                result["total_fiber"] += item["fiber"]
                result["total_microbiome_score"] += item["microbiome_score"]
                result["total_amount"] += logs[i].amount
            if logs.count() > 0:
                result["total_microbiome_score"] = round(
                    result["total_microbiome_score"] / logs.count(), 2
                )

            # target amounts:
            days = (d2 - d1).days + 1
            Carbohydrates_list_to_use = list(
                map(
                    lambda x: days * x,
                    getList(user.profile.Carbohydrates_distribution_list_g),
                )
            )
            Fat_to_use = user.profile.Fat_distribution_g * days
            Protein_to_use = user.profile.Protein_distribution_g * days
            Fiber_to_use = user.profile.Fiber_distribution_g * days

            # set outputs ******************************************
            result["breakfast"] = breakfast
            result["morning_snack"] = morning_snack
            result["lunch"] = lunch
            result["evening_snack"] = evening_snack
            result["dinner"] = dinner
            result["night_snack"] = night_snack
            result["count"] = logs.count()
            result["days"] = days
            result["Carbohydrates_list_to_use"] = Carbohydrates_list_to_use
            result["Fat_to_use"] = Fat_to_use
            result["Protein_to_use"] = Protein_to_use
            result["Fiber_to_use"] = Fiber_to_use

            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = items
            return myResponse.OK(
                "List of foods consumed in this period along with analytical information",
                result,
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], -1)


@api_view(["POST", "GET"])
def check_meal_parameters(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن را درست وارد کنید",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن را درست وارد کنید 0900",
                    },
                    {
                        "name": "meal",
                        "format": "^[\d]+$",
                        "errorMessage": "وعده غذایی باید به صورت یک عدد صحیح باشد",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            meal = int(request.POST["meal"])
            if meal > 5:
                return myResponse.Error(
                    Errors.InvalidMealId.message, Errors.InvalidMealId.code
                )

            Protein_g = user.profile.Protein_distribution_g
            goal_Protein_distribution = [
                Protein_g,
                Protein_g,
                Protein_g,
                Protein_g,
                Protein_g,
                Protein_g,
            ]

            Fat_g = user.profile.Fat_distribution_g
            goal_Fat_distribution = [Fat_g, Fat_g, Fat_g, Fat_g, Fat_g, Fat_g]

            goal_Carbohydrates_distribution = getList(
                user.profile.Carbohydrates_distribution_list_g
            )

            temp = Points.objects.filter(user=user, date=date.today())

            data = {}
            data["goal_Protein_g"] = goal_Protein_distribution[meal]
            data["goal_Fat_g"] = goal_Fat_distribution[meal]
            data["goal_Carbohydrates_g"] = goal_Carbohydrates_distribution[meal]

            if not temp.exists():
                data["Protein_used_g"] = 0
                data["Fat_used_g"] = 0
                data["Carbohydrates_used_g"] = 0
            else:
                record = temp[0]
                data["Protein_used_g"] = getList(record.this_day_Protein_list_g)[meal]
                data["Fat_used_g"] = getList(record.this_day_Fat_list_g)[meal]
                data["Carbohydrates_used_g"] = getList(record.this_day_Carbohydrates_g)[
                    meal
                ]

            return myResponse.OK("meal " + str(meal), data)

        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error("no GET!", -1)


@api_view(["POST", "GET"])
def insertFoodWithPic(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن را درست وارد کنید",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن را درست وارد کنید 0900",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            time = str(int(datetime.now().timestamp()))

            if request.FILES == {}:
                return myResponse.Error(Errors.InsertPic.message, Errors.InsertPic.code)
            f = request.FILES["image"]

            # now save Food.jpg file in the server...
            path = (
                "/assets/AI/foods/"
                + "eating_"
                + time
                + "_"
                + str(user.id)
                + "_"
                + ".jpg"
            )
            newFile = STATIC_ROOT + path
            with open(newFile, "wb+") as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            if os.path.getsize(newFile) < 1:  # temp file!
                os.remove(newFile)
                return myResponse.Error("empty file!!", -1)

            # Perform food detection on the uploaded image
            detection_results = []
            try:
                from APIs.food_detection_service import FoodDetectionService

                if FoodDetectionService.is_model_available():
                    detection_results = FoodDetectionService.detect_food_in_image(
                        newFile
                    )
                    print(
                        f"Food detection completed. Found {len(detection_results)} items."
                    )
                else:
                    print("Food detection model not available, skipping detection.")
            except Exception as e:
                print(f"Error during food detection: {str(e)}")
                # Continue with saving the image even if detection fails

            # save to data base
            img = FoodImage(user=user, path=path)
            img.save()

            data = {"detection_results": detection_results}
            return myResponse.OK("saved!", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.OK("Just POST", [request.method])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def insulinUse(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                    {
                        "name": "insulin_code",
                        "format": "^[\d]+$",
                        # "errorMessage": ""
                    },
                    # {
                    #     "name": "insulin_effect",
                    #     "format": "^[\d]+$"  # date time format "%Y-%m-%d %H:%M:%S
                    #     # "errorMessage": ""
                    # },
                    {
                        "name": "meal",
                        "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST["amount"])
            insulin_code = int(request.POST["insulin_code"])
            i = Insulin.objects.filter(Data_Base_Number=insulin_code)
            if not i.exists():
                return myResponse.Error(
                    Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code
                )
            insulin = i[0]

            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            if not (request.POST.get("meal") is None):
                meal = int((request.POST.get("meal")))
            else:
                meal = MEAL[dt.hour]

            # get record of day
            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # add insulin usage:
            new_log = InsulinUsage(
                user=user,
                Insulin=insulin,
                time=dt,
                amount=amount,
                meal=meal,
                point=record.total_points,
            )
            new_log.save()

            # update and save changes
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            # record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            # save total point after updateTotalPointDay() call
            new_log.point = totalPoint
            new_log.save()

            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.GET["token"])
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            sd = datetime.fromtimestamp(int(request.GET.get("start_date")))
            ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = InsulinUsage.objects.filter(user=user, time__range=(sd, ed))
            items = []
            result = {"total_amount": 0, "total_point": 0, "count": 0}
            for i in range(logs.count()):
                items.append(
                    {
                        "insulin_name": logs[i].Insulin.name,
                        "insulin_code": logs[i].Insulin.Data_Base_Number,
                        "code": logs[i].Insulin.Data_Base_Number,
                        "amount": logs[i].amount,
                        "point": logs[i].point,
                        "date_time": int(logs[i].time.timestamp()),
                        "meal": logs[i].meal,
                        "id": logs[i].id,
                    }
                )
                result["total_amount"] += logs[i].amount
                result["total_point"] += logs[i].point
            result["count"] = logs.count()
            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = items
            return myResponse.OK("The list of insulins used in this period", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def feel(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[-+]?[0-9]+$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                    {
                        "name": "feel_name",
                        "format": ".",  # date time format "%Y-%m-%d %H:%M:%S"
                        # "errorMessage": ""
                    },
                    {
                        "name": "description",
                        "format": "^(\S)+$",  # date time format "%Y-%m-%d %H:%M:%S
                        # "errorMessage": ""
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST.get("amount"))
            name = str(request.POST.get("feel_name"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))
            description = str((request.POST.get("description")))

            # points of Day
            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # update and save changes
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            # record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            new_log = Feeling(
                user=user,
                time=dt,
                amount=amount,
                name=name,
                description=description,
                point=totalPoint,
            )
            new_log.save()
            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("Information was recorded", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[-+]?[0-9]+$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[-+]?[0-9]+$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    # {
                    #     "name": "only_total",
                    #     "format": "^[0-1]$",  # 0 or 1 for true or false
                    #     "required": False
                    # }
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = request.GET["phone_number"]
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]

            sd = datetime.fromtimestamp(int(request.GET.get("start_date")))
            ed = datetime.fromtimestamp(int(request.GET.get("end_date")))
            logs = Feeling.objects.filter(user=user, time__range=(sd, ed)).order_by(
                "time"
            )
            items = []
            result = {
                # "total_amount": 0,
                # "total_point": 0,
                "count": 0
            }
            for i in range(logs.count()):
                items.append(
                    {
                        "name": logs[i].name,
                        "time": logs[i].time.timestamp(),
                        "description": logs[i].description,
                    }
                )
            result["count"] = logs.count()
            result["list"] = items
            return myResponse.OK("List of feelings in this period", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def drugUsage(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                    {
                        "name": "drug_code",
                        "format": "^[\d]+$",
                        # "errorMessage": ""
                    },
                    {
                        "name": "meal",
                        "format": "^[\d]+$",
                        # "errorMessage": ""
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST.get("amount"))
            drug_code = int(request.POST.get("drug_code"))
            temp = Drug.objects.filter(DataBaseNumber=drug_code)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidDrugId.message, Errors.InvalidDrugId.code
                )
            drug = temp[0]
            dt = datetime.fromtimestamp(int(request.POST.get("time")))
            meal = int((request.POST.get("meal")))

            # points of Day
            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # update and save changes
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            # record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            new_log = DrugUsage(
                user=user,
                drug=drug,
                time=dt,
                amount=amount,
                meal=meal,
                point=totalPoint,
            )
            new_log.save()
            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = request.GET["phone_number"]
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]

            sd = datetime.fromtimestamp(int(request.GET.get("start_date")))
            ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = DrugUsage.objects.filter(user=user, time__range=(sd, ed))
            items = []
            result = {"total_amount": 0, "total_point": 0, "count": 0}
            for i in range(logs.count()):
                items.append(
                    {
                        "drug_name": logs[i].drug.name,
                        "amount": logs[i].amount,
                        "point": logs[i].point,
                        "date_time": int(logs[i].time.timestamp()),
                        "meal": logs[i].meal,
                    }
                )
                result["total_amount"] += logs[i].amount
                result["total_point"] += logs[i].point
            result["count"] = logs.count()
            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = items
            return myResponse.OK("The list of drugs used in this period", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def glp1Usage(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[0-9]+\.?[0-9]*$",
                    },
                    {
                        "name": "meal",
                        "format": "^[\d]+$",
                        # "errorMessage": ""
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = float(request.POST.get("amount"))
            glp1 = user.profile.glp1
            if glp1 is None:
                return myResponse.Error(
                    Errors.NotSellectedGLP1.message, Errors.NotSellectedGLP1.code
                )
            dt = datetime.fromtimestamp(int(request.POST.get("time")))
            meal = int((request.POST.get("meal")))

            # points of Day
            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # update and save changes
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            # record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            new_log = GLP1Usage(
                user=user,
                glp1=glp1,
                time=dt,
                amount=amount,
                meal=meal,
                point=totalPoint,
            )
            new_log.save()
            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = request.GET["phone_number"]
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]

            sd = datetime.fromtimestamp(int(request.GET.get("start_date")))
            ed = datetime.fromtimestamp(int(request.GET.get("end_date")))
            logs = GLP1Usage.objects.filter(user=user, time__range=(sd, ed))
            items = []
            result = {"total_amount": 0, "count": 0}
            for i in range(logs.count()):
                items.append(
                    {
                        "glp1_name": logs[i].glp1.name,
                        "amount": logs[i].amount,
                        "point": logs[i].point,
                        "date_time": int(logs[i].time.timestamp()),
                        "meal": logs[i].meal,
                    }
                )
                result["total_amount"] += logs[i].amount
            result["count"] = logs.count()
            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = items
            return myResponse.OK("The list of glp1s used in this interval", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def sugar(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                    {"name": "meal", "format": "^[\d]+$", "required": False},
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST.get("amount"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            if not (request.POST.get("meal") is None):
                meal = int(request.POST.get("meal"))
            else:
                meal = MEAL[dt.hour]

            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            if record.HypoHyperNumber == 0:
                record.totalHypoHyperControlPoint = 1

            if (amount > user.profile.hyper) or (amount < user.profile.hypo):
                HPs = record.HypoHyperNumber + 1
                record.HypoHyperNumber = HPs
                if HPs == 1:
                    record.totalHypoHyperControlPoint = 0.6
                elif HPs == 2:
                    record.totalHypoHyperControlPoint = 0.2
                else:
                    record.totalHypoHyperControlPoint = 0

            sugarList = getList(record.sugar_point_list_y)
            y = 0
            if meal == 0:
                x = amount / 120
                if x < 0.6 or x > 1.5:
                    y = 0
                elif x <= 1 and x >= 0.6:
                    y = 10
                elif x > 1 and x < 1.5:
                    y = (1.5 - x) * 20
                sugarList[meal] = y
            elif meal == 1 or meal == 3 or meal == 5:
                x = amount / 180
                if x < 0.45 or x >= 1.4:
                    y = 0
                elif x >= 0.45 and x <= 1:
                    y = 4
                elif x > 1 and x < 1.4:
                    y = (1.4 - x) * 8
                sugarList[meal] = y
            elif meal == 2 or meal == 4:
                x = amount / 120
                if x < 0.6 or x > 1.5:
                    y = 0
                elif x <= 1 and x >= 0.6:
                    y = 4
                elif x > 1 and x <= 1.5:
                    y = (1.5 - x) * 8
                sugarList[meal] = y
            record.sugar_point_list_y = listToStr(sugarList)

            SumSugarList = sum(sugarList)
            record.totalSugarControlPoint = round(min(1, SumSugarList / 30), 2)

            record.save()
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            # record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            hyper = False
            if amount > user.profile.hyper:
                hyper = True
            hypo = False
            if amount < user.profile.hypo:
                hypo = True
            new_log = SugarMeasurement(
                user=user,
                time=dt,
                amount=amount,
                point=totalPoint,
                meal=meal,
                hyper=hyper,
                hypo=hypo,
            )
            new_log.save()
            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "only_total",
                        "format": "^[0-1]$",  # 0 or 1 for true or false
                        "required": False,
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            if request.GET.get("start_date") == None:
                now = datetime.now()
                sd = datetime(now.year, now.month, now.day, 0, 0, 0)
            else:
                sd = datetime.fromtimestamp(int(request.GET.get("start_date")))

            if request.GET.get("end_date") == None:
                ed = datetime.now()
            else:
                ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = SugarMeasurement.objects.filter(user=user, time__range=(sd, ed))
            items = []
            if user.profile.maximum_sugar is None:
                max_sugar = 190
            else:
                max_sugar = user.profile.maximum_sugar

            if user.profile.minimum_sugar is None:
                min_sugar = 80
            else:
                min_sugar = user.profile.minimum_sugar

            if user.profile.hyper is None:
                hyper = 250
            else:
                hyper = user.profile.hyper

            if user.profile.hypo is None:
                hypo = 70
            else:
                hypo = user.profile.hypo

            result = {
                "average": 0,
                "max": 0,
                "min": 0,
                "hypo": 0,
                "hyper": 0,
                "in_range": 0,
                "count": 0,
                "list": [],
                "sdt": sd,
                "edt": ed,
                "last_suger_before_today": 0,
            }

            in_normal_range = 0
            hyper_num = 0
            hypo_num = 0
            max_num = 0
            min_num = 0
            for i in range(logs.count()):
                am = logs[i].amount
                p = False
                if am < hypo:
                    hypo_num += 1
                elif am < min_sugar:
                    min_num += 1
                elif am < max_sugar:
                    in_normal_range += 1
                    p = True
                elif am < hyper:
                    max_num += 1
                elif am >= hyper:
                    hyper_num += 1
                items.append(
                    {
                        "amount": logs[i].amount,
                        "point": logs[i].point,
                        "date_time": int(logs[i].time.timestamp()),
                        "meal": logs[i].meal,
                        "is_in_range": p,
                        "id": logs[i].id,
                    }
                )

            result["count"] = logs.count()
            total_amount_list = []
            x_day = sd
            while x_day < ed:
                temps = logs.filter(
                    time__range=(
                        datetime.combine(date=x_day.date(), time=time(0, 0, 0)),
                        datetime.combine(date=x_day.date(), time=time(23, 59, 59)),
                    )
                )
                if temps.exists():
                    s = 0
                    for item in temps:
                        s += item.amount
                    total_amount_list.append(s / temps.count())
                x_day = x_day + timedelta(days=1)

            if len(total_amount_list) != 0:
                result["average"] = sum(total_amount_list) / len(total_amount_list)
            result["in_range"] = in_normal_range
            result["hyper"] = hyper_num
            result["hypo"] = hypo_num
            result["max"] = max_num
            result["min"] = min_num

            temp = SugarMeasurement.objects.filter(user=user, time__lt=sd).order_by(
                "-time"
            )
            if temp.exists():
                result["last_suger_before_today"] = temp[0].amount
            if (
                request.GET.get("only_total") is None
                or int(request.GET["only_total"]) is 0
            ):
                result["list"] = items
            return myResponse.OK("List of blood sugar in this interval", result)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def blood_pressure(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                    {
                        "name": "over",
                        "format": "^[\d]+$",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST.get("amount"))
            over = int(request.POST.get("over"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            bp = BloodPressure(user=user, amount=amount, over=over, time=dt)
            bp.save()

            # create points record if not created
            temp = Points.objects.filter(user=user, date=date.today())
            if not temp.exists():
                record = Points(user=user, date=date.today())
                record.save()
            data = {}

            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            if request.GET.get("start_date") == None:
                now = datetime.now()
                sd = datetime(now.year, now.month, now.day, 0, 0, 0)
            else:
                sd = datetime.fromtimestamp(int(request.GET.get("start_date")))

            if request.GET.get("end_date") == None:
                ed = datetime.now()
            else:
                ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = BloodPressure.objects.filter(user=user, time__range=(sd, ed))
            data = {}
            items = []
            for item in logs:
                items.append(
                    {
                        "time": item.time.timestamp(),
                        "time_shamsi": str(
                            jdatetime.datetime.fromgregorian(datetime=item.time)
                        ),
                        "amount": item.amount,
                        "over": item.over,
                        "id": item.id,
                    }
                )
            data["items"] = items

            return myResponse.OK("List of blood pressure in this period", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def sleep_report(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "start",
                        "format": "^[0-9]+$",
                        # Accepts timestamp format    "^([01]?[0-9]|2[0-3]):[0-5][0-9]$",  # HH:MM format validation
                        "errorMessage": "Incorrect start time format. Please use timestamp.",
                    },
                    {
                        "name": "end",
                        "format": "^[0-9]+$",  # Accepts timestamp format
                        "errorMessage": "Incorrect end time format. Please use timestamp.",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "is_mid_day_sleep",
                        "format": "^[0-1]$",
                        "errorMessage": "is_mid_day_sleep را به صورت یک عدد طبیعی وارد کنید",
                        "required": False,
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            startSleep = int(request.POST.get("start"))
            endSleep = int(request.POST.get("end"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            is_mid_day_sleep = False

            if request.POST.get("is_mid_day_sleep") is not None:
                is_mid_day_sleep = int(request.POST.get("is_mid_day_sleep"))

            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            now = datetime.now().date()
            today = date.today()
            today_start = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=0,
                minute=0,
                second=0,
            )
            today_end = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=23,
                minute=59,
                second=59,
            )
            amount_challenge = 0

            # Convert timestamps to datetime objects
            start_time = datetime.fromtimestamp(startSleep)
            end_time = datetime.fromtimestamp(endSleep)

            # Calculate time difference
            if end_time >= start_time:
                time_difference = end_time - start_time
            else:
                end_time = end_time.replace(day=end_time.day + 1)
                time_difference = end_time - start_time

            # Get the total hours and minutes of sleep duration
            total_seconds = time_difference.total_seconds()
            hours = int(total_seconds // 3600)
            minutes = int((total_seconds % 3600) // 60)

            # Format the sleep duration
            sleep_duration = f"{hours}:{minutes:02d}"

            # Categorize sleep based on duration
            if 8 >= hours > 6:
                result = "good-sleep"
            elif hours > 8:
                result = "Over-sleep"
            else:
                result = "Little-sleep"

            sp = Sleep(
                user=user,
                start=startSleep,
                end=endSleep,
                time=dt,
                sleeped=sleep_duration,
                is_mid_day_sleep=is_mid_day_sleep,
            )
            sp.save()

            challenges = ChallengeSelection.objects.filter(user=user)
            for c in challenges:
                if c.challenge.category == 4:
                    if c.challenge.sub_category == 0:  # Duration
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            sleep = Sleep.objects.filter(
                                user=user, time__range=(today_start, today_end)
                            )
                            if sleep is not None:
                                if (
                                    c.challenge.sleep_duration - 0.5
                                    < hours
                                    < c.challenge.sleep_duration + 0.5
                                ):
                                    c.day_status["status"][duration] = True
                                    c.save()
                    if c.challenge.sub_category == 1:  # Start
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            sleep = Sleep.objects.filter(
                                user=user, time__range=(today_start, today_end)
                            )
                            if sleep is not None:
                                if (
                                    c.challenge.sleep_start_hour.hour - 0.5
                                    < start_time.hour
                                    < c.challenge.sleep_start_hour.hour + 0.5
                                ):
                                    c.day_status["status"][duration] = True
                                    c.save()
                    if c.challenge.sub_category == 2:  # End
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            sleep = Sleep.objects.filter(
                                user=user, time__range=(today_start, today_end)
                            )
                            if sleep is not None:
                                if (
                                    c.challenge.sleep_end_hour.hour - 0.5
                                    < end_time.hour
                                    < c.challenge.sleep_end_hour.hour + 0.5
                                ):
                                    c.day_status["status"][duration] = True
                                    c.save()
                    if c.challenge.sub_category == 3:  # Start & Duration
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            sleep = Sleep.objects.filter(
                                user=user, time__range=(today_start, today_end)
                            )
                            if sleep is not None:
                                if (
                                    c.challenge.sleep_duration - 0.5
                                    < hours
                                    < c.challenge.sleep_duration + 0.5
                                ) and (
                                    c.challenge.sleep_start_hour.hour - 0.5
                                    < start_time.hour
                                    < c.challenge.sleep_start_hour.hour + 0.5
                                ):
                                    c.day_status["status"][duration] = True
                                    c.save()

            u = updateTotalPointDay(
                user, record, is_Sleep=True, is_Mid_Day_Sleep=is_mid_day_sleep
            )
            # Calculate points gained
            points_awarded = u["points_awarded"]
            sleep_points_gained = points_awarded["Sleep_points_gained"]
            engagement_points_gained = points_awarded["Engagement_points_gained"]

            # Construct the message
            messages = []
            if sleep_points_gained > 0:
                messages.append(
                    f"شما{sleep_points_gained}امتیاز بابت ثبت زمان خواب به دست آوردید!"
                )
            else:
                messages.append(
                    "امروز امتیاز حداکثری خواب رو به دست آوردی! آفرین به تو! 🏆"
                )

            if engagement_points_gained > 0:
                messages.append(
                    f"{engagement_points_gained} امتیاز ثبت فعالیت گرفتی! همیشه عالی پیش میری! 🎉"
                )
            else:
                messages.append(
                    "امروز به حداکثر امتیاز ثبت فعالیت رسیدی! کلی تلاش کردی، احسنت! 💪🏅"
                )

            total_message = " ".join(messages)

            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            data = {
                "TimeSleep": sleep_duration,
                "result": result,
                "total_points": u["DayPoint"],
                "sleep_points": record.total_Sleep_Point,
                "engagement_points": record.this_day_DataEntry_score,
                "message": total_message,
            }

            return myResponse.OK("Information was recorded", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            if request.GET.get("start_date") == None:
                now = datetime.now()
                sd = datetime(now.year, now.month, now.day, 0, 0, 0)
            else:
                sd = datetime.fromtimestamp(int(request.GET.get("start_date")))

            if request.GET.get("end_date") == None:
                ed = datetime.now()
            else:
                ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = Sleep.objects.filter(user=user, time__range=(sd, ed))
            data = {}
            items = []
            for item in logs:
                items.append(
                    {
                        "time": item.time.timestamp(),
                        # "time_shamsi": str(jdatetime.datetime.fromgregorian(datetime=item.time)),
                        "start": item.start,
                        "end": item.end,
                        "timeSlept": item.sleeped,
                        "id": item.id,
                        "is_mid_day_sleep": item.is_mid_day_sleep,
                    }
                )
            data["items"] = items

            return myResponse.OK("List of Sleep Report in this period", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def a_one_c(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "time",
                        "format": "^[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "amount",
                        "format": "^[\d]+$",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            amount = int(request.POST.get("amount"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            a1c = AOneC(user=user, amount=amount, time=dt)
            a1c.save()

            data = {}
            return myResponse.OK("Information was recorded", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date",
                        "format": "^[0-9]{10}$",  # timestamp
                        "required": False,
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                ],
                request,
            )
            token = str(request.GET.get("token"))
            # phone = str(request.GET["phone_number"])
            # u = User.objects.filter(token=token, phone_number=phone)
            u = User.objects.filter(token=token)
            if not u.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = u[0]

            if request.GET.get("start_date") == None:
                now = datetime.now()
                sd = datetime(now.year, now.month, now.day, 0, 0, 0)
            else:
                sd = datetime.fromtimestamp(int(request.GET.get("start_date")))

            if request.GET.get("end_date") == None:
                ed = datetime.now()
            else:
                ed = datetime.fromtimestamp(int(request.GET.get("end_date")))

            logs = AOneC.objects.filter(user=user, time__range=(sd, ed))
            data = {}
            items = []
            for item in logs:
                items.append(
                    {
                        "time": item.time.timestamp(),
                        "time_shamsi": str(
                            jdatetime.datetime.fromgregorian(datetime=item.time)
                        ),
                        "amount": item.amount,
                    }
                )
            data["items"] = items

            return myResponse.OK("List of a1cs in this range", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def points(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                    {
                        "name": "offset",
                        "format": "^[-+]?(\d)+$",
                        "errorMessage": "insert + integer number for offset. (-1 for special date)",
                    },
                    {
                        "name": "date",
                        "format": "^(\d)+$",  # timestamp
                        "required": False,
                        "errorMessage": "insert timestamp for date",
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]
            offset = int(request.POST.get("offset"))
            data = []
            if offset == -1:
                try:
                    d = date.fromtimestamp(int(request.POST.get("date")))
                    record = Points.objects.filter(user=user, date=d)
                    if record.exists():
                        data.append(
                            {
                                "date": str(jdatetime.date.fromgregorian(date=d)),
                                "point": record[0].total_points,
                                "Activity_Point": record[0].total_Activity_Point * 100,
                                "totalHypoHyperControlPoint": record[
                                    0
                                ].totalHypoHyperControlPoint
                                * 100,
                                "total_HEI_Point": record[0].total_HEI_Point * 100,
                                "total_Calories_Point": record[0].total_Calories_Point
                                * 100,
                                "totalSugarControlPoint": record[
                                    0
                                ].totalSugarControlPoint
                                * 100,
                                "totalCarboControlPoint": record[
                                    0
                                ].totalCarboControlPoint
                                * 100,
                            }
                        )
                    else:
                        data.append(
                            {
                                "date": str(jdatetime.date.fromgregorian(date=d)),
                                "point": 0,
                                "Activity_Point": 0,
                                "totalHypoHyperControlPoint": 0,
                                "total_HEI_Point": 0,
                                "total_Calories_Point": 0,
                                "totalSugarControlPoint": 0,
                                "totalCarboControlPoint": 0,
                            }
                        )
                    return myResponse.OK("امتیاز کاربر در این بازه زمانی", data)

                except ValueError as e:
                    return myResponse.Error(str(e.args), -1)

            points = Points.objects.filter(user=user).order_by("date")
            now = date.today()
            j = min(90, offset)

            for i in range(j):
                d = now - timedelta(days=(j - i - 1))
                p = points.filter(date=d)

                if p.exists():
                    data.append(
                        {
                            "date": str(jdatetime.date.fromgregorian(date=d)),
                            "point": p[0].total_points,
                            "Activity_Point": p[0].total_Activity_Point * 100,
                            "totalHypoHyperControlPoint": p[
                                0
                            ].totalHypoHyperControlPoint
                            * 100,
                            "total_HEI_Point": p[0].total_HEI_Point * 100,
                            "total_Calories_Point": p[0].total_Calories_Point * 100,
                            "totalSugarControlPoint": p[0].totalSugarControlPoint * 100,
                            "totalCarboControlPoint": p[0].totalCarboControlPoint * 100,
                        }
                    )
                else:
                    data.append(
                        {
                            "date": str(jdatetime.date.fromgregorian(date=d)),
                            "point": 0,
                            "Activity_Point": 0,
                            "totalHypoHyperControlPoint": 0,
                            "total_HEI_Point": 0,
                            "total_Calories_Point": 0,
                            "totalSugarControlPoint": 0,
                            "totalCarboControlPoint": 0,
                        }
                    )

            return myResponse.OK("User rating in this time period", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def generateReport(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]
            temp = Report.objects.filter(
                user=user, created_at__gte=datetime.now() - timedelta(hours=1)
            )
            if not temp.exists():
                alphabet = string.ascii_letters + string.digits
                code = generateRandomString(alphabet, 100)
                last_reports = Report.objects.filter(code=code)
                while last_reports.exists():
                    code = generateRandomString(alphabet, 100)
                    last_reports = Report.objects.filter(code=code)

                report = Report(
                    user=user,
                    start_time=(date.today() - timedelta(days=30)),
                    end_time=date.today(),
                    code=code,
                )
                report.save()
            else:
                report = temp[0]
                code = report.code

            data = {
                "new_link": "https://i-dia.ir/site/report/" + code + "/",
                "created_at": str(
                    jdatetime.datetime.fromgregorian(datetime=report.created_at)
                ),
                "from": str(jdatetime.date.fromgregorian(date=report.start_time)),
                "until": str(jdatetime.date.fromgregorian(date=report.end_time)),
            }

            return myResponse.OK("Report of the last 30 days", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def last_thirty_days_points(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]

            now = date.today()
            points = Points.objects.filter(
                user=user, date__gte=(now - timedelta(days=30))
            ).order_by("date")

            j = 30

            data = {}
            data["date"] = []
            data["point"] = []
            data["Activity_Point"] = []
            data["totalHypoHyperControlPoint"] = []
            data["total_HEI_Point"] = []
            data["total_Calories_Point"] = []
            data["totalSugarControlPoint"] = []
            data["totalCarboControlPoint"] = []
            for i in range(j):
                d = now - timedelta(days=(j - i - 1))
                p = points.filter(date=d)

                if p.exists():
                    data["date"].append(str(jdatetime.date.fromgregorian(date=d)))
                    data["point"].append(p[0].total_points)
                    data["Activity_Point"].append(p[0].total_Activity_Point * 100)
                    data["totalHypoHyperControlPoint"].append(
                        p[0].totalHypoHyperControlPoint * 100
                    )
                    data["total_HEI_Point"].append(p[0].total_HEI_Point * 100)
                    data["total_Calories_Point"].append(p[0].total_Calories_Point * 100)
                    data["totalSugarControlPoint"].append(
                        p[0].totalSugarControlPoint * 100
                    )
                    data["totalCarboControlPoint"].append(
                        p[0].totalCarboControlPoint * 100
                    )
                else:
                    pass
                    # data["date"].append(str(jdatetime.date.fromgregorian(date=d)))
                    # data["point"].append(0)
                    # data["Activity_Point"].append(0)
                    # data["totalHypoHyperControlPoint"].append(0)
                    # data["total_HEI_Point"].append(0)
                    # data["total_Calories_Point"].append(0)
                    # data["totalSugarControlPoint"].append(0)
                    # data["totalCarboControlPoint"].append(0)
            return myResponse.OK("User score in the last 30 days", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def reports(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                    {
                        "name": "start_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان شروع اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان پایان اشتباه وارد شده اند",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            sdt = datetime.fromtimestamp(int(request.POST.get("start_date_time")))
            edt = datetime.fromtimestamp(int(request.POST.get("end_date_time")))

            records = Points.objects.filter(
                user=user, date__range=(sdt.date(), edt.date())
            ).order_by("date")

            if not records.exists():
                myResponse.OK("اطلاعاتی در این بازه ثبت نشده است", [])
            data = []

            day_range = (edt - sdt).days
            for i in range(day_range):
                day = datetime.fromtimestamp(sdt.timestamp() + (i * 86400)).date()
                temp = records.filter(date=day)
                if temp.exists():
                    record = records[0]
                    d = {}
                    d["sobhaneh"] = {}
                    d["nahar"] = {}
                    d["sham"] = {}
                    d["other"] = {}

                    carbo_list = getList(record.this_day_Carbohydrates_g)
                    d["sobhaneh"]["Carbohydrates_g"] = carbo_list[0] + carbo_list[1]
                    d["nahar"]["Carbohydrates_g"] = carbo_list[2] + carbo_list[3]
                    d["sham"]["Carbohydrates_g"] = carbo_list[4] + carbo_list[5]

                    # d["sobhaneh"]["Carbohydrates_g_0"] = carbo_list[0]
                    # d["sobhaneh"]["Carbohydrates_g_1"] = carbo_list[1]
                    # d["nahar"]["Carbohydrates_g_2"] = carbo_list[2]
                    # d["nahar"]["Carbohydrates_g_3"] = carbo_list[3]
                    # d["sham"]["Carbohydrates_g_4"] = carbo_list[4]
                    # d["sham"]["Carbohydrates_g_5"] = carbo_list[5]
                    d["Carbohydrates_list_g"] = carbo_list
                    d["totalCalorieUsed"] = record.total_Calories_used

                    other_ins = 0
                    logs = InsulinUsage.objects.filter(
                        user=user, time__range=(sdt, edt)
                    )
                    insUsage = []
                    for j in range(6):
                        temp = logs.filter(meal=j)
                        if temp.exists():
                            insUsage.append(temp[0].amount)
                        else:
                            insUsage.append(0)

                    # data[index]["sobhaneh"]["total_insulin"] = sum(insUsage[0:2])
                    # d["sobhaneh"]["insulin_usage_0"] = insUsage[0]
                    # d["sobhaneh"]["insulin_usage_1"] = insUsage[1]

                    # data[index]["nahar"]["total_insulin"] = sum(insUsage[2:4])
                    # data[index]["nahar"]["insulin_usage_2"] = insUsage[2]
                    # data[index]["nahar"]["insulin_usage_3"] = insUsage[3]

                    # data[index]["sham"]["total_insulin"] = sum(insUsage[4:6])
                    # data[index]["sham"]["insulin_usage_4"] = insUsage[4]
                    # data[index]["sham"]["insulin_usage_5"] = insUsage[5]

                    d["insulin_usage_list"] = insUsage

                    other = logs.filter(meal__gt=5)
                    other_ins = 0
                    for x in other:
                        other_ins += x.amount
                    d["insulin_usage_others"] = other_ins

                    logs = SugarMeasurement.objects.filter(
                        user=user, time__range=(sdt, edt)
                    )
                    measurements = []
                    for j in range(6):
                        temp = logs.filter(meal=j)
                        if temp.exists():
                            measurements.append(temp[0].amount)
                        else:
                            measurements.append(0)

                    # data[index]["sobhaneh"]["sugar_0"] = measurements[0]
                    # data[index]["sobhaneh"]["sugar_1"] = measurements[1]
                    #
                    # data[index]["nahar"]["sugar_2"] = measurements[2]
                    # data[index]["nahar"]["sugar_3"] = measurements[3]
                    #
                    # data[index]["sham"]["sugar_4"] = measurements[4]
                    # data[index]["sham"]["sugar_5"] = measurements[5]

                    d["sugar_list_g"] = measurements

                    other = logs.filter(meal__gt=5)

                    sugar_other = 0
                    for j in range(len(other)):
                        sugar_other += other[j].amount
                    d["sugar_others"] = sugar_other
                    # data[index]["points"] = {}
                    d["total_Calories_Point"] = record.total_Calories_Point * 100
                    d["totalCarboControlPoint"] = record.totalCarboControlPoint * 100
                    d["total_HEI_Point"] = record.total_HEI_Point * 100
                    d["total_Activity_Point"] = record.total_Activity_Point * 100
                    d["totalHypoHyperControlPoint"] = (
                        record.totalHypoHyperControlPoint * 100
                    )
                    d["totalSugarControlPoint"] = record.totalSugarControlPoint * 100
                    d["total_point"] = record.total_points

                    d["HypoHyperNumber"] = record.HypoHyperNumber
                    d["Date"] = record.date

                    data.append(d)
                else:
                    d = {}
                    d["sobhaneh"] = {}
                    d["nahar"] = {}
                    d["sham"] = {}
                    d["other"] = {}
                    ziro_6 = getList("&0&0&0&0&0&0&")

                    d["sobhaneh"]["Carbohydrates_g"] = 0
                    d["nahar"]["Carbohydrates_g"] = 0
                    d["sham"]["Carbohydrates_g"] = 0
                    d["Carbohydrates_list_g"] = ziro_6
                    d["totalCalorieUsed"] = 0

                    d["insulin_usage_list"] = ziro_6

                    d["insulin_usage_others"] = 0

                    d["sugar_list_g"] = ziro_6

                    d["sugar_others"] = 0

                    d["total_Calories_Point"] = 0
                    d["totalCarboControlPoint"] = 0
                    d["total_HEI_Point"] = 0
                    d["total_Activity_Point"] = 0
                    d["totalHypoHyperControlPoint"] = 0
                    d["totalSugarControlPoint"] = 0
                    d["total_point"] = 0

                    d["HypoHyperNumber"] = 0
                    d["Date"] = day

                    data.append(d)

            return myResponse.OK(
                "Recorded information for the user sorted by time in this interval",
                data,
            )

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def get_wellness_summary(request):
    try:
        RequsetChecker(
            request.POST, [{"name": "token", "format": "^(\S){30}$"}], request
        )

        token = str(request.POST["token"])
        user_obj = User.objects.filter(token=token)
        if not user_obj.exists():
            return myResponse.Error(
                Errors.InvalidToken.message, Errors.InvalidToken.code
            )

        user = user_obj.first()
        profile = user.profile

        # 1. Get Goal Calories
        patient_cr = profile.CR
        if not patient_cr or patient_cr == 0:
            # Recalculate if not available, similar to other views
            cr_data = user.calculate_cr_macro_nutrients_distribution()
            patient_cr = cr_data.get("CR")
            profile.CR = patient_cr
            profile.save()

        # Find the closest CR to get the calorie distribution
        coach_cr = profile.CR_coach
        selected_cr = 0
        cr_list_from_panel = cr_list
        if coach_cr:
            selected_cr = min(
                cr_list_from_panel, key=lambda cr: (abs(coach_cr - cr), cr)
            )
        else:
            selected_cr = min(
                cr_list_from_panel, key=lambda cr: (abs(patient_cr - cr), cr)
            )

        distribution = calorie_distributions.get(selected_cr, {})

        goal_breakfast_calories = distribution.get("B", 0)
        goal_lunch_calories = distribution.get("L", 0)
        goal_dinner_calories = distribution.get("D", 0)

        # 2. Get Consumed Calories for today
        today_start = datetime.now().replace(hour=0, minute=0, second=0, microsecond=0)
        today_end = datetime.now().replace(
            hour=23, minute=59, second=59, microsecond=999999
        )

        today_eatings = Eating.objects.filter(
            user=user, date_time__range=(today_start, today_end)
        ).select_related("food")

        consumed_breakfast_calories = 0
        consumed_lunch_calories = 0
        consumed_dinner_calories = 0

        for eating in today_eatings:
            food_calories = (eating.food.Calories * eating.amount) / 100
            if eating.meal == 0:  # Breakfast
                consumed_breakfast_calories += food_calories
            elif eating.meal == 1:  # Lunch
                consumed_lunch_calories += food_calories
            elif eating.meal == 2:  # Dinner
                consumed_dinner_calories += food_calories

        # 3. Get User's Current Score for today
        today_points_record = Points.objects.filter(
            user=user, date=datetime.now().date()
        ).first()
        current_score = today_points_record.total_points if today_points_record else 0

        data = {
            "consumed_breakfast_calories": round(consumed_breakfast_calories, 2),
            "consumed_lunch_calories": round(consumed_lunch_calories, 2),
            "consumed_dinner_calories": round(consumed_dinner_calories, 2),
            "goal_breakfast_calories": goal_breakfast_calories,
            "goal_lunch_calories": goal_lunch_calories,
            "goal_dinner_calories": goal_dinner_calories,
            "user_current_score": current_score,
        }

        return myResponse.OK("Wellness summary retrieved successfully.", data)

    except ValueError as e:
        writeErrorToLog("get_wellness_summary ---> POST\n" + str(e.args), request)
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        writeErrorToLog("get_wellness_summary ---> POST\n" + str(e.args), request)
        return myResponse.Error(
            "An unexpected error occurred.", Errors.InternalError.code
        )


@api_view(["POST", "GET"])
def steps(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "steps",
                        "format": "^(\d)+$",
                        "errorMessage": "steps را به صورت عدد صحیح وارد کنید",
                    },
                    {
                        "name": "amount",
                        "format": "^(\d)+$",
                        "errorMessage": "amount را به صورت عدد صحیح وارد کنید",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            date = datetime.now().date()

            now = datetime.now().date()
            today = date.today()
            today_start = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=0,
                minute=0,
                second=0,
            )
            today_end = datetime(
                year=today.year,
                month=today.month,
                day=today.day,
                hour=23,
                minute=59,
                second=59,
            )
            # update walking data ...
            temp = Walking.objects.filter(user=user, date=date)
            if temp.exists():
                walking = temp[0]
            else:
                walking = Walking()
                walking.date = date
                walking.user = user
                walking.save()
            steps = int(request.POST["steps"])
            amount = int(request.POST["amount"])

            walking.steps = steps
            # total_amount = walking.amount + amount
            walking.amount = round(steps / 80)  # every 80 step equals to 1 minutes
            Metz = 3  # constant Metz for steps
            energy = round(amount * user.profile.weight * 0.0175 * Metz, 1)
            walking.energy = energy
            walking.save()

            # update points ...
            p = Points.objects.filter(user=user, date=date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=date)

            A = (Metz - 1) * ((1.15 / 0.9) * amount) / 1440
            BMR = user.profile.BMR
            B = BMR / (0.0175 * 1440 * user.profile.weight)
            PALx = round(A / B, 5)
            walking.PALx += PALx
            walking.save()
            PALX = record.PALX + PALx
            record.PALX = PALX
            y = 0
            if PALX <= 1.1:
                y = 0
            elif PALX > 1.8:
                y = 1
            else:
                y = PALX / 1.8

            # record.total_Activity_Point = y
            record.save()
            u = updateTotalPointDay(user, record, is_Step=True)
            # Calculate points gained
            points_awarded = u["points_awarded"]
            step_points_gained = points_awarded["Step_points_gained"]
            print("step_points_gained", step_points_gained)

            # Construct the message
            messages = []
            if (
                step_points_gained != 0
                and step_points_gained != -1
                and step_points_gained != -2
            ):
                messages.append(
                    f"شما{step_points_gained}امتیاز بابت تعداد قدم هایتان به دست آوردید! "
                )
            elif step_points_gained == 0:
                messages.append(
                    "امروز امتیاز حداکثری راه رفتن رو به دست آوردی! آفرین به تو! 🏆"
                )
            elif step_points_gained == -2:
                messages.append(
                    "امروز امتیاز حداکثری راه رفتن و ورزش کردن رو به دست آوردی! آفرین به تو! 🏆"
                )

            total_message = " ".join(messages)

            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            amount_challenge_3 = 0
            challenges = ChallengeSelection.objects.filter(user=user)
            for c in challenges:
                if c.challenge.category == 2:
                    if c.challenge.sub_category == 0:
                        start_day = c.challenge.start_deadline.date()
                        end_day = c.challenge.end_deadline.date()
                        df = now - start_day
                        duration = df.days
                        if start_day <= now < end_day:
                            logs = Walking.objects.filter(
                                user=user, date__range=(today_start, today_end)
                            )
                            if logs is not None:
                                for w in logs:
                                    amount_challenge_3 = amount_challenge_3 + steps
                                    if amount_challenge_3 > c.challenge.steps * 0.95:
                                        c.day_status["status"][duration] = True
                                        c.save()

            data = {
                "total_steps": walking.steps,
                "total_amount_minutes": walking.amount,
                "DayPoint": totalPoint,
                "step_points": record.total_Steps_Point,
                "message": total_message,
            }
            return myResponse.OK("Walking information", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "start_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "end_date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                ],
                request,
            )

            token = request.GET.get("token")
            # phone = request.GET["phone_number"]
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            steps = 0
            amount = 0
            sdt = datetime.fromtimestamp(int(request.GET.get("start_date_time")))
            edt = datetime.fromtimestamp(int(request.GET.get("end_date_time")))

            step_data = []
            WLogs = Walking.objects.filter(
                user=user, date__range=(sdt.date(), edt.date())
            ).order_by("date")
            for walking in WLogs:
                step_data.append(
                    {
                        "date": walking.date,
                        "amount": walking.amount,
                        "steps": walking.steps,
                    }
                )
                steps += walking.steps
                amount += walking.amount

            data = {"all_data": step_data, "total_steps": steps, "total_amount": amount}
            return myResponse.OK("Walking information", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def bmi(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {
                        "name": "date_time",
                        "format": "^[-+]?[0-9]{10}$",  # timestamp
                        # ex:  "1546270161"
                        "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                    },
                    {
                        "name": "weight",
                        "format": "^[0-9]+\.?[0-9]+$",
                        "errorMessage": "وزن را به صورت یک عدد فلوت وارد کنید",
                        "required": False,
                    },
                    {
                        "name": "height",
                        "format": "^[0-9]+$",
                        "errorMessage": "قد را به صورت یک عدد صحیح وارد کنید",
                        "required": False,
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            dt = datetime.fromtimestamp(int(request.POST["date_time"]))
            if not (request.POST["weight"] is None):
                weight = float(request.POST["weight"])
                user.profile.weight = weight
                user.profile.save()
                user.save()
            else:
                if user.profile.height is None:
                    return myResponse.Error(
                        "You have not specified the weight before",
                        Errors.LogicalError.code,
                    )
                weight = user.profile.weight

            if not (request.POST["height"] is None):
                height = int(request.POST["height"])
                user.profile.height = height
                user.profile.save()
                user.save()
            else:
                if user.profile.height is None:
                    return myResponse.Error(
                        "You have not specified the height before",
                        Errors.LogicalError.code,
                    )
                height = user.profile.weight

            BMI = weight / ((height / 100) ** 2)
            user.profile.save()

            w = Weights(user=user, weight=weight, time=dt, BMI=BMI)
            w.save()
            if BMI > 24.9:
                result = "اضافه وزن"
            elif BMI < 18.5:
                result = "کمبود وزن"
            else:
                result = "وزن مناسب"
            # TODO: calculate sutable result and Goalweight
            data = {
                "BMI": BMI,
                "result": result,
            }
            return myResponse.OK("Height and weight ratio", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            RequsetChecker(
                request.GET,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                ],
                request,
            )

            token = request.GET["token"]
            # phone = request.GET["phone_number"]
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]
            h = float(user.profile.height) / 100  # unit Meter
            w = float(user.profile.weight)
            BMI = w / (h * h)
            if BMI > 24.9:
                result = "اضافه وزن"
            elif BMI < 18.5:
                result = "کمبود وزن"
            else:
                result = "وزن مناسب"
            # TODO: calculate sutable result
            data = {"BMI": BMI, "status": result}
            return myResponse.OK("BMI", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def getHEIParams(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن را درست وارد کنید",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن را درست وارد کنید 0900",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            CR = user.profile.CR
            calorie = round(CR / 100) * 100
            if calorie > 3500:
                calorie = 3500
            elif calorie < 1100:
                calorie = 1100
            GoalHEI = HEI_Table[calorie]

            temp = Points.objects.filter(user=user, date=date.today())
            result = {}
            if temp.exists():
                record = temp[0]
                User_HEI = getList(record.HEI_elements_list)
                result["User_HEI_Grain"] = User_HEI[14]
                result["User_HEI_Protein"] = User_HEI[15]
                result["User_HEI_Dairy"] = User_HEI[16]
                result["User_HEI_Fruit"] = User_HEI[17]
                result["User_HEI_Vegetables"] = User_HEI[18]
                result["User_HEI_Fat"] = User_HEI[19]
            else:
                result["User_HEI_Grain"] = 0
                result["User_HEI_Protein"] = 0
                result["User_HEI_Dairy"] = 0
                result["User_HEI_Fruit"] = 0
                result["User_HEI_Vegetables"] = 0
                result["User_HEI_Fat"] = 0

            result["Goal_HEI_Grain"] = GoalHEI[0]
            result["Goal_HEI_Protein"] = GoalHEI[1]
            result["Goal_HEI_Dairy"] = GoalHEI[2]
            result["Goal_HEI_Fruit"] = GoalHEI[3]
            result["Goal_HEI_Vegetables"] = GoalHEI[4]
            result["Goal_HEI_Fat"] = GoalHEI[5]

            return myResponse.OK("ok", result)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error("Just Post!", [request.method])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def macro_nutrients_distribution(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]

            if user.profile.height is None:
                return myResponse.Error(
                    "You have not specified the height before", Errors.LogicalError.code
                )
            if user.profile.weight is None:
                return myResponse.Error(
                    "You have not specified the weight before", Errors.LogicalError.code
                )
            if user.profile.gender is None:
                return myResponse.Error(
                    "You have not specified the gender before", Errors.LogicalError.code
                )
            if user.profile.activity_level is None:
                return myResponse.Error(
                    "You have not specified the activity level before",
                    Errors.LogicalError.code,
                )
            if user.profile.birth_date is None:
                return myResponse.Error(
                    "You have not already specified the birthdate",
                    Errors.LogicalError.code,
                )

            weight = user.profile.weight

            height = user.profile.height
            isMen = bool(user.profile.gender)
            activityFactor = user.profile.activity_level
            type_of_treatment = user.profile.type_of_treatment
            age = datetime.now().year - user.profile.birth_date.year
            if user.profile.type_of_treatment is None:
                return myResponse(
                    "You have not specified the type of treatment!",
                    Errors.DataNotFound.code,
                )

            data = user.calculate_cr_macro_nutrients_distribution()
            user.profile.CR = data["CR"]
            user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
            user.profile.Carbohydrates_unit = data["macro_nutrients"][
                "carbohydrates_unit"
            ]
            user.profile.Protein_g = data["macro_nutrients"]["carbohydrates_g"]
            user.profile.Protein_unit = data["macro_nutrients"]["carbohydrates_unit"]
            user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
            user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]
            user.profile.Fiber_g = data["macro_nutrients"]["fiber_g"]
            user.profile.Fiber_unit = data["macro_nutrients"]["fiber_unit"]

            Carbohydrates_distribution_str = listToStr(
                data["carbohydrate_distribution_g"]
            )

            user.profile.Carbohydrates_distribution_list_g = (
                Carbohydrates_distribution_str
            )
            user.profile.Protein_distribution_g = data["protein_distribution_g"]
            user.profile.Fat_distribution_g = data["fat_distribution_g"]
            user.profile.Fiber_distribution_g = data["fiber_distribution_g"]
            user.profile.save()

            return myResponse.OK(
                "Sources of energy supply from macronutrients and carbohydrate distribution in meals and...",
                data,
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST", "GET"])
def getFoodstuffs(request):
    if request.method == "POST":
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                    },
                    {"name": "food_code", "format": "^[0-9]+$"},
                    {"name": "amount", "format": "^[0-9]+$"},
                ],
                request,
            )
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            amount = int(request.POST.get("amount"))
            food_code = str(int(request.POST.get("food_code")))
            temp = Food.objects.filter(Data_Base_Number=food_code)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidFoodId.message, Errors.InvalidFoodId.code
                )

            food = temp[0]
            data = {}
            data["Data_Base_Number"] = food.Data_Base_Number
            data["FA_Name"] = food.FA_Name
            data["Protein_g"] = food.Protein_g * amount / 100
            data["Fat_g"] = food.Fat_g * amount / 100
            data["Calories"] = food.Calories * amount / 100
            data["Carbohydrates_g"] = food.Carbohydrates_g * amount / 100
            data["fiber"] = food.Fiber_g * amount / 100

            data["Name_of_home_units"] = getHomeUnitElements(food.Name_of_home_units)
            data["Weight_of_home_units"] = getFloatList(food.Weight_of_home_units)
            data["Index_of_home_units"] = getIntegerList(food.Index_of_home_units)

            # data['Saturated_Fat_g'] =food.Saturated_Fat_g	* amount/100
            # data['dairy_unit'] =food.dairy_unit	* amount/100
            # data['fat_unit'] =food.fat_unit	* amount/100
            # data['For_calculation'] =food.For_calculation	* amount/100
            # data['cereal_unit'] =food.cereal_unit	* amount/100
            # data['meat_unit'] =food.meat_unit	* amount/100
            # data['fruit_unit'] =food.fruit_unit	* amount/100
            # data['vegetables_unit'] =food.vegetables_unit	* amount/100
            # data['Ash_g'] =food.Ash_g	* amount/100
            # data['Calories'] =food.Calories	* amount/100
            # data['Starch_g'] =food.Starch_g	* amount/100
            # data['Sucrose_g'] =food.Sucrose_g	* amount/100
            # data['Glucose_g'] =food.Glucose_g	* amount/100
            # data['Fructose_g'] =food.Fructose_g	* amount/100
            # data['Lactose_g'] =food.Lactose_g	* amount/100
            # data['Maltose_g'] =food.Maltose_g	* amount/100
            # data['Alcohol_g'] =food.Alcohol_g	* amount/100
            # data['Water_g'] =food.Water_g	* amount/100
            # data['Caffeine_mg'] =food.Caffeine_mg	* amount/100
            # data['Theobromine_mg'] =food.Theobromine_mg	* amount/100
            # data['Sugar_g'] =food.Sugar_g	* amount/100
            # data['Galactose_g'] =food.Galactose_g	* amount/100
            # data['Fiber_g'] =food.Fiber_g	* amount/100
            # data['Calcium_mg'] =food.Calcium_mg	* amount/100
            # data['Iron_mg'] =food.Iron_mg	* amount/100
            # data['Magnesium_mg'] =food.Magnesium_mg	* amount/100
            # data['Phosphorus_mg'] =food.Phosphorus_mg	* amount/100
            # data['Potasssium_mg'] =food.Potasssium_mg	* amount/100
            # data['Sodium_mg'] =food.Sodium_mg	* amount/100
            # data['Zinc_mg'] =food.Zinc_mg	* amount/100
            # data['Cupper_mg'] =food.Cupper_mg	* amount/100
            # data['Fluoride_mcg'] =food.Fluoride_mcg	* amount/100
            # data['Manganese_mg'] =food.Manganese_mg	* amount/100
            # data['Selenium_mcg'] =food.Selenium_mcg	* amount/100
            # data['Vitamin_A_IU'] =food.Vitamin_A_IU	* amount/100
            # data['Retinol_mcg'] =food.Retinol_mcg	* amount/100
            # data['Retinol_Equivalents_mcg'] =food.Retinol_Equivalents_mcg	* amount/100
            # data['Beta_Carotene_mcg'] =food.Beta_Carotene_mcg	* amount/100
            # data['Alpha_Carotene_mcg'] =food.Alpha_Carotene_mcg	* amount/100
            # data['Vitamin_E_mg'] =food.Vitamin_E_mg	* amount/100
            # data['Vitamin_D_mcg'] =food.Vitamin_D_mcg	* amount/100
            # data['Vitamin_D2_Ergocalciferol_mcg'] =food.Vitamin_D2_Ergocalciferol_mcg	* amount/100
            # data['Vitamin_D3_Cholecalciferol_mcg'] =food.Vitamin_D3_Cholecalciferol_mcg	* amount/100
            # data['Beta_Cryptoxanthin_mcg'] =food.Beta_Cryptoxanthin_mcg	* amount/100
            # data['Lycopene_mcg'] =food.Lycopene_mcg	* amount/100
            # data['Lutein_and_Zeaxanthin_mcg'] =food.Lutein_and_Zeaxanthin_mcg	* amount/100
            # data['Vitamin_C_mg'] =food.Vitamin_C_mg	* amount/100
            # data['Vitamin_B1_mg'] =food.Vitamin_B1_mg	* amount/100
            # data['Vitamin_B2_mg'] =food.Vitamin_B2_mg	* amount/100
            # data['Vitamin_B3_mg'] =food.Vitamin_B3_mg	* amount/100
            # data['Vitamin_B5_mg'] =food.Vitamin_B5_mg	* amount/100
            # data['Vitamin_B6_mg'] =food.Vitamin_B6_mg	* amount/100
            # data['Vitamin_B9_mg'] =food.Vitamin_B9_mg	* amount/100
            # data['Vitamin_B12'] =food.Vitamin_B12	* amount/100
            # data['Choline_mg'] =food.Choline_mg	* amount/100
            # data['Cholesterol_mg'] =food.Cholesterol_mg	* amount/100
            # data['Saturated_Fat_g'] =food.Saturated_Fat_g	* amount/100
            # data['MUFA'] =food.MUFA	* amount/100
            # data['PUFA'] = food.PUFA	* amount/100
            return myResponse.OK("Food items in this amount of food", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


def get_key_factor(challenge):
    """
    Determine the key success criteria and its value for a challenge.
    :param challenge: Challenge - The Challenge instance.
    :return: dict - Key factor, its value, and description for the challenge.
    """
    if challenge.category == 1:  # Blood Sugar
        if challenge.sub_category == 0:
            return {
                "key": "more_than",
                "value": challenge.more_than,
                "description": "Blood sugar should be more than this value.",
            }
        elif challenge.sub_category == 1:
            return {
                "key": "tedad_sabt",
                "value": challenge.tedad_sabt,
                "description": "Log your blood sugar this many times.",
            }

    elif challenge.category == 2:  # Exercise
        if challenge.sub_category == 0:
            return {
                "key": "steps",
                "value": challenge.steps,
                "description": "Take this many steps daily.",
            }
        elif challenge.sub_category == 1:
            return {
                "key": "calorie_burnt",
                "value": challenge.calorie_burnt,
                "description": "Burn this many calories daily through exercise.",
            }
        elif challenge.sub_category == 2:
            return {
                "key": "exercise_duration",
                "value": challenge.exercise_duration,
                "description": "Exercise for this many minutes daily.",
            }

    elif challenge.category == 3:  # Blood Pressure
        if challenge.sub_category == 0:
            return {
                "key": "more_than",
                "value": challenge.more_than,
                "description": "Blood pressure should be more than this value.",
            }
        elif challenge.sub_category == 1:
            return {
                "key": "tedad_sabt",
                "value": challenge.tedad_sabt,
                "description": "Log your blood pressure this many times.",
            }

    elif challenge.category == 4:  # Sleep
        if challenge.sub_category == 0:
            return {
                "key": "sleep_duration",
                "value": challenge.sleep_duration,
                "description": "Sleep for this many hours daily.",
            }
        elif challenge.sub_category == 1:
            return {
                "key": "sleep_start_hour",
                "value": str(challenge.sleep_start_hour),
                "description": "Start sleeping at this hour.",
            }
        elif challenge.sub_category == 2:
            return {
                "key": "sleep_end_hour",
                "value": str(challenge.sleep_end_hour),
                "description": "Wake up at this hour.",
            }
        elif challenge.sub_category == 3:
            return {
                "key": ["sleep_start_hour", "sleep_duration"],
                "value": {
                    "start_hour": str(challenge.sleep_start_hour),
                    "duration": challenge.sleep_duration,
                },
                "description": "Start sleeping at this hour and sleep for this many hours.",
            }

    elif challenge.category == 5:  # Water Intake
        if challenge.sub_category == 0:
            return {
                "key": "tedad_sabt",
                "value": challenge.tedad_sabt,
                "description": "Log this many glasses of water daily.",
            }

    # Fallback for undefined cases
    return {
        "key": None,
        "value": None,
        "description": "No specific goal defined for this challenge.",
    }


@api_view(["POST"])
def reportToDay(request):
    if request.method == "POST":
        t1 = datetime.now()
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                ],
                request,
            )

            token = str(request.POST["token"])
            # Optimize user query with select_related
            try:
                user = User.objects.select_related("profile", "django_user").get(
                    token=token
                )
            except User.DoesNotExist:
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            now = datetime.now().date()
            sdt = datetime(now.year, now.month, now.day, 0, 0, 0)
            edt = datetime(now.year, now.month, now.day, 23, 59, 59)
            end_date = datetime.now().date()
            yesterday = datetime.now() - timedelta(days=1)

            # Optimize new message query
            new_message = PanelMessage.objects.filter(
                has_been_seen=False, receiver=user.django_user
            )

            # Fix user_challenges query - remove invalid select_related
            user_challenges = user.participated_challenges.all()

            patient_cr = (
                user.profile.CR
            )  # Using patient.profile.CR as the equivalent of calculated_cr

            # Calculate calorie distribution based on patient.profile.CR
            if patient_cr is None:
                print("No CR found in patient profile")
                return Response(
                    {"error": "No calorie requirement found for this patient"},
                    status=500,
                )

            profile = user.profile
            # Find the closest CR to get the calorie distribution
            coach_cr = profile.CR_coach
            selected_cr = 0
            cr_list_from_panel = cr_list
            if coach_cr:
                selected_cr = min(
                    cr_list_from_panel, key=lambda cr: (abs(coach_cr - cr), cr)
                )
            else:
                selected_cr = min(
                    cr_list_from_panel, key=lambda cr: (abs(patient_cr - cr), cr)
                )

            distribution = calorie_distributions.get(selected_cr, {})

            # Optimize challenge processing
            for challenge in user_challenges:
                if challenge.category == 0:
                    dinner_reports = Eating.objects.filter(
                        user=user, meal=4, date_time__gt=yesterday
                    )
                    for dinner in dinner_reports:
                        if 20 >= int(dinner.date_time.hour):
                            print("OK dinner")
                    print(0)
                elif challenge.category == 1:
                    print(1)
                elif challenge.category == 2:
                    step_reports = Walking.objects.filter(user=user, date__gt=yesterday)
                    for step in step_reports:
                        if step.steps > 5000:
                            print("OK Steps")
                elif challenge.category == 3:
                    print(3)
                elif challenge.category == 4:
                    start_date = challenge.start_deadline
                    sleep_reports = Sleep.objects.filter(
                        user=user, time__date__range=(start_date, end_date)
                    )
                    for sleep in sleep_reports:
                        start_sleep = datetime.fromtimestamp(sleep.start)
                        if 21 < int(start_sleep.hour) < 24:
                            print("OK start")
                        duration = sleep.sleeped.split(":")[0]
                        if 7 < int(duration) < 12:
                            print("OK duration")
                elif challenge.category == 5:
                    water_reports = Water.objects.filter(user=user, time__gt=yesterday)
                    amounts = sum(water.amount for water in water_reports)
                    if amounts >= 2000:
                        print("OK Water")
                    print(5)

            # Optimize challenges list creation
            challenges_list = [
                {
                    "challenge_name": challenge.name,
                    "challenge_description": challenge.description,
                }
                for challenge in user_challenges
            ]

            # Fix challenge selection query - remove invalid select_related
            challengeSelection = ChallengeSelection.objects.filter(user=user)
            challenges_data = [
                {
                    "name": challenge.challenge.name,
                    "description": challenge.challenge.description,
                    "category": challenge.challenge.category,
                    "reward": challenge.challenge.reward,
                    "start_time": challenge.challenge.start_deadline.timestamp(),
                    "end_time": challenge.challenge.end_deadline.timestamp(),
                    "status": challenge.day_status["status"],
                    "key_factor": get_key_factor(challenge.challenge),
                }
                for challenge in challengeSelection
            ]

            # Optimize coin calculation
            amount_coin = sum(log.coins for log in Profile.objects.filter(user=user))

            new_data = {
                "Coin": {"amount": amount_coin},
                "Messages": {"new_messages": new_message.count()},
                "Challenges": {
                    "challenge_list_names": challenges_list,
                    "user_challenges_data": challenges_data,
                },
            }

            # Optimize points query
            today_points = Points.objects.filter(user=user, date=now).first()

            # Initialize base data structure
            data = {}
            data_summary = {
                "sobhaneh": {
                    "Carbohydrates_g": 0,
                    "total_insulin": 0,
                    "insulin_usage_0": 0,
                    "insulin_usage_1": 0,
                    "sugar_0": 0,
                    "sugar_1": 0,
                    "calories": 0,  # Added calories field
                    "goal_calories": distribution.get("B", 0),
                },
                "nahar": {
                    "Carbohydrates_g": 0,
                    "total_insulin": 0,
                    "insulin_usage_2": 0,
                    "insulin_usage_3": 0,
                    "sugar_2": 0,
                    "sugar_3": 0,
                    "calories": 0,  # Added calories field
                    "goal_calories": distribution.get("L", 0),
                },
                "sham": {
                    "Carbohydrates_g": 0,
                    "total_insulin": 0,
                    "insulin_usage_4": 0,
                    "insulin_usage_5": 0,
                    "sugar_4": 0,
                    "sugar_5": 0,
                    "calories": 0,  # Added calories field
                    "goal_calories": distribution.get("D", 0),
                },
                "other": {"insulin_usage": 0, "sugar_0": 0},
                "totalCalorieUsed": 0,
                "totalFiberUsed": 0,
                "total_insulin_usage": 0,
                "points": {
                    "total_Calories_Point": 0,
                    "totalCarboControlPoint": 0,
                    "total_HEI_Point": 0,
                    "total_Activity_Point": 0,
                    "totalHypoHyperControlPoint": 0,
                    "totalSugarControlPoint": 0,
                    "totalCooperationPoints": 0,
                    "total": 0,
                    "week_average": 0,
                    "yesterday": 0,
                },
                "BloodPressure": {"last": "-/-"},
                "A1C": {
                    "amount": user.profile.a1c,
                    "state": False,
                    "sugar_average": 0,
                    "default": user.profile.a1c,
                },
                "Water": {"amount": 0},
                "Coin": {"amount": amount_coin},
                "HypoHyperNumber": 0,
                "NewMessagesNumber": new_message.count(),
                "nutritional_requirements": {
                    "calories": user.profile.CR_coach
                    if user.profile.CR_coach
                    else user.profile.CR,
                    "protein": user.profile.Protein_g,
                    "fat": user.profile.Fat_g,
                    "carbohydrate": user.profile.Carbohydrates_g,
                },
            }

            if not today_points:
                # Return empty data structure with requirements
                data = {
                    "summary": data_summary,
                    "All_Logs_Sorted": [],
                    "HEI": [
                        {
                            "User_HEI_Grain": 0,
                            "User_HEI_Protein": 0,
                            "User_HEI_Dairy": 0,
                            "User_HEI_Fruit": 0,
                            "User_HEI_Vegetables": 0,
                            "User_HEI_Fat": 0,
                            "Goal_HEI_Grain": 0,
                            "Goal_HEI_Protein": 0,
                            "Goal_HEI_Dairy": 0,
                            "Goal_HEI_Fruit": 0,
                            "Goal_HEI_Vegetables": 0,
                            "Goal_HEI_Fat": 0,
                        }
                    ],
                    "coins": user.profile.coins,
                    "coins_history": user.profile.coins_history,
                    "Challenges": {
                        "challenge_list_names": challenges_list,
                        "user_challenges_data": challenges_data,
                    },
                    "average_blood_sugar": 0,
                    "weight_trend": [],
                    "weeklyCarbohydrateTrend": [],
                    "weeklyProteinTrend": [],
                    "weeklyFatTrend": [],
                    "weeklyCalorieTrend": [],
                    "weeklyPointsTrend": [],
                }
                return myResponse.OK("No report for today", data)

            # Continue with existing data population if points exist
            carbo_list = getList(today_points.this_day_Carbohydrates_g)
            data_summary["sobhaneh"]["Carbohydrates_g"] = carbo_list[0] + carbo_list[1]
            data_summary["nahar"]["Carbohydrates_g"] = carbo_list[2] + carbo_list[3]
            data_summary["sham"]["Carbohydrates_g"] = carbo_list[4] + carbo_list[5]

            data_summary["totalCalorieUsed"] = today_points.total_Calories_used
            data_summary["totalFiberUsed"] = today_points.total_Fiber_used

            # Get today's eating records
            today_eatings = Eating.objects.filter(
                user=user, date_time__date=datetime.now().date()
            ).select_related("food")

            # Initialize meal calories
            breakfast_calories = 0
            lunch_calories = 0
            dinner_calories = 0

            # Calculate calories for each meal
            for eating in today_eatings:
                # Calculate calories for this food item (calories per 100g * amount / 100)
                food_calories = (eating.food.Calories * eating.amount) / 100

                if eating.meal == 0:  # Breakfast
                    breakfast_calories += food_calories
                elif eating.meal == 1:  # Lunch
                    lunch_calories += food_calories
                elif eating.meal == 2:  # Dinner
                    dinner_calories += food_calories

            # Update data_summary with rounded calorie values
            data_summary["sobhaneh"]["calories"] = round(breakfast_calories, 2)
            data_summary["nahar"]["calories"] = round(lunch_calories, 2)
            data_summary["sham"]["calories"] = round(dinner_calories, 2)

            # Optimize insulin usage calculations
            insulin_logs = InsulinUsage.objects.filter(
                user=user, time__range=(sdt, edt)
            )
            insUsage = [0] * 6
            for i in range(6):
                meal_logs = insulin_logs.filter(meal=i)
                if meal_logs.exists():
                    insUsage[i] = sum(item.amount for item in meal_logs)

            data_summary["sobhaneh"]["total_insulin"] = sum(insUsage[0:2])
            data_summary["sobhaneh"]["insulin_usage_0"] = insUsage[0]
            data_summary["sobhaneh"]["insulin_usage_1"] = insUsage[1]
            data_summary["nahar"]["total_insulin"] = sum(insUsage[2:4])
            data_summary["nahar"]["insulin_usage_2"] = insUsage[2]
            data_summary["nahar"]["insulin_usage_3"] = insUsage[3]
            data_summary["sham"]["total_insulin"] = sum(insUsage[4:6])
            data_summary["sham"]["insulin_usage_4"] = insUsage[4]
            data_summary["sham"]["insulin_usage_5"] = insUsage[5]

            other_ins = sum(x.amount for x in insulin_logs.filter(meal__gt=5))
            data_summary["other"]["insulin_usage"] = sum(insUsage) + other_ins
            data_summary["total_insulin_usage"] = sum(insUsage) + other_ins

            # Optimize sugar measurements
            sugar_logs = SugarMeasurement.objects.filter(
                user=user, time__range=(sdt, edt)
            )
            measurements = [0] * 6
            for i in range(6):
                meal_logs = sugar_logs.filter(meal=i)
                if meal_logs.exists():
                    measurements[i] = meal_logs[0].amount

            data_summary["sobhaneh"]["sugar_0"] = measurements[0]
            data_summary["sobhaneh"]["sugar_1"] = measurements[1]
            data_summary["nahar"]["sugar_2"] = measurements[2]
            data_summary["nahar"]["sugar_3"] = measurements[3]
            data_summary["sham"]["sugar_4"] = measurements[4]
            data_summary["sham"]["sugar_5"] = measurements[5]

            other_sugar = sugar_logs.filter(meal__gt=5)
            for i, sugar in enumerate(other_sugar):
                data_summary["other"]["sugar_" + str(i)] = sugar.amount

            # Optimize weekly points calculation
            points = Points.objects.filter(
                user=user, date__gte=(now - timedelta(days=6))
            )
            week_average = points.aggregate(avg=Avg("total_points"))["avg"] or 0

            # Optimize yesterday points
            yesterday_point = (
                Points.objects.filter(user=user, date=(now - timedelta(days=1)))
                .values_list("total_points", flat=True)
                .first()
                or 0
            )

            # Optimize A1C calculations
            SM = SugarMeasurement.objects.filter(
                user=user, time__gte=(now - timedelta(days=90))
            )
            sm_average = 0
            A1C_state = False
            A1C = user.profile.a1c

            if SM.count() > 2:
                A1C_state = any(
                    item.time < datetime.now() - timedelta(days=3) for item in SM
                )
                if A1C_state:
                    sm_average = SM.aggregate(avg=Avg("amount"))["avg"]
                    A1C = round((sm_average + 46.7) / 28.7, 1)

            # Optimize blood pressure query
            last_BPs = (
                BloodPressure.objects.filter(user=user, time__range=(sdt, edt))
                .order_by("-time")
                .first()
            )
            bp = f"{int(last_BPs.amount)}/{int(last_BPs.over)}" if last_BPs else "-/-"

            # Optimize water calculation
            amount_water = (
                Water.objects.filter(user=user, time__range=(sdt, edt)).aggregate(
                    total=Sum("amount")
                )["total"]
                or 0
            )

            # Optimize points summary
            data_summary["points"] = {
                "total_Calories_Point": today_points.total_Calories_Point * 100,
                "totalCarboControlPoint": today_points.totalCarboControlPoint * 100,
                "total_HEI_Point": today_points.total_HEI_Point * 100,
                "total_Activity_Point": today_points.total_Activity_Point * 100,
                "totalHypoHyperControlPoint": today_points.totalHypoHyperControlPoint
                * 100,
                "totalSugarControlPoint": today_points.totalSugarControlPoint * 100,
                "totalCooperationPoints": today_points.totalCooperationPoints * 100,
                "total": today_points.total_points,
                "week_average": week_average,
                "yesterday": yesterday_point,
            }

            data_summary.update(
                {
                    "BloodPressure": {"last": bp},
                    "A1C": {
                        "amount": A1C,
                        "state": A1C_state,
                        "sugar_average": sm_average,
                        "default": user.profile.a1c,
                    },
                    "Water": {"amount": amount_water},
                    "Coin": {"amount": amount_coin},
                    "HypoHyperNumber": today_points.HypoHyperNumber,
                    "NewMessagesNumber": new_message.count(),
                }
            )

            # Optimize today's logs collection
            un_sorted_data = []

            # Optimize eating logs
            eating_logs = Eating.objects.select_related("food").filter(
                user=user, date_time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "eating",
                        "name": log.food.FA_Name,
                        "calorie": (log.food.Calories * log.amount) / 100,
                        "fat": (log.food.Fat_g * log.amount) / 100,
                        "protein": (log.food.Protein_g * log.amount) / 100,
                        "carbohydrate": (log.food.Carbohydrates_g * log.amount) / 100,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.date_time.timestamp()),
                        "date_time": str(
                            jdatetime.datetime.fromgregorian(datetime=log.date_time)
                        ),
                        "meal": log.meal,
                    }
                    for log in eating_logs
                ]
            )

            # Optimize drug usage logs
            drug_logs = DrugUsage.objects.select_related("drug").filter(
                user=user, time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "drug_usage",
                        "name": log.drug.name,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.time.timestamp()),
                        "meal": log.meal,
                    }
                    for log in drug_logs
                ]
            )

            # Optimize GLP1 usage logs
            glp1_logs = GLP1Usage.objects.select_related("glp1").filter(
                user=user, time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "insulin_usage",
                        "name": log.glp1.name,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.time.timestamp()),
                        "meal": log.meal,
                    }
                    for log in glp1_logs
                ]
            )

            # Optimize activities logs
            activity_logs = Activities_log.objects.select_related("activity").filter(
                user=user, start_date_time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "activity",
                        "name": log.activity.name,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.start_date_time.timestamp()),
                        "end_date_time": int(log.end_date_time.timestamp()),
                        "energy": log.energy,
                    }
                    for log in activity_logs
                ]
            )

            # Optimize insulin usage logs
            insulin_logs = InsulinUsage.objects.select_related("Insulin").filter(
                user=user, time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "insulin_usage",
                        "name": log.Insulin.name,
                        "code": log.Insulin.Data_Base_Number,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.time.timestamp()),
                        "meal": log.meal,
                    }
                    for log in insulin_logs
                ]
            )

            # Optimize feelings logs
            feeling_logs = Feeling.objects.filter(user=user, time__range=(sdt, edt))
            un_sorted_data.extend(
                [
                    {
                        "type": "feel",
                        "name": log.name,
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.time.timestamp()),
                        "description": log.description,
                    }
                    for log in feeling_logs
                ]
            )

            # Optimize sugar measurement logs
            sugar_logs = SugarMeasurement.objects.filter(
                user=user, time__range=(sdt, edt)
            )
            un_sorted_data.extend(
                [
                    {
                        "type": "sugar_measurment",
                        "amount": log.amount,
                        "point": log.point,
                        "time": int(log.time.timestamp()),
                        "meal": log.meal,
                    }
                    for log in sugar_logs
                ]
            )

            sugar_sum = sum(log.amount for log in sugar_logs)
            average_blood_sugar = sugar_sum / len(sugar_logs) if sugar_logs else 0
            sorted_data = sorted(un_sorted_data, key=lambda d: d["time"])

            # Prepare final response
            data = {"summary": data_summary, "All_Logs_Sorted": sorted_data}

            # Calculate HEI data
            CR = user.profile.CR
            calorie = min(max(round(CR / 100) * 100, 1100), 3500)
            GoalHEI = HEI_Table[calorie]

            # Get HEI data
            HEI = {
                "User_HEI_Grain": 0,
                "User_HEI_Protein": 0,
                "User_HEI_Dairy": 0,
                "User_HEI_Fruit": 0,
                "User_HEI_Vegetables": 0,
                "User_HEI_Fat": 0,
            }

            if today_points:
                User_HEI = getList(today_points.HEI_elements_list)
                HEI.update(
                    {
                        "User_HEI_Grain": User_HEI[14],
                        "User_HEI_Protein": User_HEI[15],
                        "User_HEI_Dairy": User_HEI[16],
                        "User_HEI_Fruit": User_HEI[17],
                        "User_HEI_Vegetables": User_HEI[18],
                        "User_HEI_Fat": User_HEI[19],
                    }
                )

            HEI.update(
                {
                    "Goal_HEI_Grain": GoalHEI[0],
                    "Goal_HEI_Protein": GoalHEI[1],
                    "Goal_HEI_Dairy": GoalHEI[2],
                    "Goal_HEI_Fruit": GoalHEI[3],
                    "Goal_HEI_Vegetables": GoalHEI[4],
                    "Goal_HEI_Fat": GoalHEI[5],
                }
            )

            data.update(
                {
                    "HEI": [HEI],
                    "coins": user.profile.coins,
                    "coins_history": user.profile.coins_history,
                    "Challenges": {
                        "challenge_list_names": challenges_list,
                        "user_challenges_data": challenges_data,
                    },
                    "average_blood_sugar": average_blood_sugar,
                }
            )

            # Optimize weight trend data
            weight_records = Weights.objects.filter(user=user).order_by("time")
            data["weight_trend"] = [
                {"value": record.weight, "date": str(int(record.time.timestamp()))}
                for record in weight_records
            ]

            # Optimize weekly trends
            seven_days_ago = datetime.now() - timedelta(days=7)
            weekly_eating_logs = (
                Eating.objects.select_related("food")
                .filter(user=user, date_time__gte=seven_days_ago)
                .order_by("date_time")
            )

            # Initialize daily tracking
            daily_tracking = {
                date: {"calories": 0, "carbs": 0, "protein": 0, "fat": 0}
                for date in [
                    (datetime.now() - timedelta(days=i)).date() for i in range(7)
                ]
            }

            # Calculate daily totals
            for log in weekly_eating_logs:
                date = log.date_time.date()
                if date in daily_tracking:
                    daily_tracking[date]["calories"] += (
                        log.food.Calories * log.amount
                    ) / 100
                    daily_tracking[date]["carbs"] += (
                        log.food.Carbohydrates_g * log.amount
                    ) / 100
                    daily_tracking[date]["protein"] += (
                        log.food.Protein_g * log.amount
                    ) / 100
                    daily_tracking[date]["fat"] += (log.food.Fat_g * log.amount) / 100

            # Convert to response format
            data.update(
                {
                    "weeklyCarbohydrateTrend": [
                        {
                            "date": str(
                                int(
                                    datetime.combine(
                                        date, datetime.min.time()
                                    ).timestamp()
                                )
                            ),
                            "carbohydrates": round(tracking["carbs"], 2),
                        }
                        for date, tracking in sorted(daily_tracking.items())
                    ],
                    "weeklyProteinTrend": [
                        {
                            "date": str(
                                int(
                                    datetime.combine(
                                        date, datetime.min.time()
                                    ).timestamp()
                                )
                            ),
                            "protein": round(tracking["protein"], 2),
                        }
                        for date, tracking in sorted(daily_tracking.items())
                    ],
                    "weeklyFatTrend": [
                        {
                            "date": str(
                                int(
                                    datetime.combine(
                                        date, datetime.min.time()
                                    ).timestamp()
                                )
                            ),
                            "fat": round(tracking["fat"], 2),
                        }
                        for date, tracking in sorted(daily_tracking.items())
                    ],
                    "weeklyCalorieTrend": [
                        {
                            "date": str(
                                int(
                                    datetime.combine(
                                        date, datetime.min.time()
                                    ).timestamp()
                                )
                            ),
                            "calories": round(tracking["calories"], 2),
                        }
                        for date, tracking in sorted(daily_tracking.items())
                    ],
                }
            )

            # Optimize weekly points trend
            weekly_points = Points.objects.filter(
                user=user, date__gte=seven_days_ago
            ).order_by("date")

            daily_points = {date: 0 for date in daily_tracking.keys()}
            for point_log in weekly_points:
                if point_log.date in daily_points:
                    daily_points[point_log.date] = point_log.total_points

            data["weeklyPointsTrend"] = [
                {
                    "date": str(
                        int(datetime.combine(date, datetime.min.time()).timestamp())
                    ),
                    "points": points,
                }
                for date, points in sorted(daily_points.items())
            ]

            t2 = datetime.now()
            print(
                f"delay on: reportToDay, user id: {user.id} time: {jdatetime.datetime.fromgregorian(datetime=t2)} ---> {t2 - t1}"
            )
            return myResponse.OK(
                "Summary of registered information for the user today", data
            )

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def reportWeekly(request):
    if request.method == "POST":
        t1 = datetime.now()
        try:
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "start_date",
                        "required": False,
                        "format": "^\d+$",  # Expecting a timestamp (integer)
                        "errorMessage": "تاریخ شروع نامعتبر است",
                    },
                    {
                        "name": "end_date",
                        "required": False,
                        "format": "^\d+$",  # Expecting a timestamp (integer)
                        "errorMessage": "تاریخ پایان نامعتبر است",
                    },
                ],
            )

            token = str(request.POST["token"])
            start_date = request.POST.get("start_date", None)
            end_date = request.POST.get("end_date", None)

            # Validate and parse dates
            if start_date:
                start_date = datetime.fromtimestamp(int(start_date)).date()
            else:
                start_date = datetime.now().date() - timedelta(
                    days=datetime.now().weekday()
                )

            if end_date:
                end_date = datetime.fromtimestamp(int(end_date)).date()
            else:
                end_date = start_date + timedelta(days=6)

            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            now = datetime.now().date()
            # Week start and end ...
            start_of_week = now - timedelta(
                days=now.weekday()
            )  # Monday of the current week
            end_of_week = start_of_week + timedelta(days=6)  # Sunday of the same week
            sdt = datetime(start_date.year, start_date.month, start_date.day, 0, 0, 0)
            edt = datetime(end_date.year, end_date.month, end_date.day, 23, 59, 59)

            # Initialize data structures for results
            weekly_breakdown = []

            # number_of_new_message
            new_message = PanelMessage.objects.filter(
                has_been_seen=False, receiver=user.django_user
            )
            # challenges
            user_challenges = user.participated_challenges.all()
            for challenge in user_challenges:
                if challenge.category == 0:
                    dinner_reports = Eating.objects.filter(
                        user=user, meal=4, date_time__range=(sdt, edt)
                    )
                    for dinner in dinner_reports:
                        if 20 >= int(dinner.date_time.hour):
                            print("OK dinner")
                    print(0)
                elif challenge.category == 1:
                    print(1)
                elif challenge.category == 2:
                    # print(2)
                    step_reports = Walking.objects.filter(
                        user=user, date_time__range=(sdt, edt)
                    )
                    for step in step_reports:
                        if step.steps > 5000:
                            print("OK Steps")
                elif challenge.category == 3:
                    print(3)
                elif challenge.category == 4:
                    # print(4)
                    start_date = challenge.start_deadline
                    sleep_reports = Sleep.objects.filter(
                        user=user, time__date__range=(start_date, end_of_week)
                    )
                    for sleep in sleep_reports:
                        start_sleep = datetime.fromtimestamp(sleep.start)
                        # print(start_sleep.hour)
                        if 21 < int(start_sleep.hour) < 24:
                            print("OK start")
                        duration = sleep.sleeped.split(":")[0]
                        if 7 < int(duration) < 12:
                            print("OK duration")
                elif challenge.category == 5:
                    water_reports = Water.objects.filter(
                        user=user, date_time__range=(sdt, edt)
                    )
                    amounts = 0
                    for water in water_reports:
                        amounts = amounts + water.amount
                        # print(amounts)
                    if amounts >= 2000:
                        print("OK Water")
                    print(5)

            amount_coin = 0
            # Coin
            logs = Profile.objects.filter(user=user)
            for i in range(logs.count()):
                amount = logs[i].coins
                amount_coin = amount_coin + amount

            challenges_list = []
            for challenges in user_challenges:
                challenges_list.append(
                    {
                        "challenge_name": challenges.name,
                        "challenge_description": challenges.description,
                    }
                )
            new_data = {}
            new_data["Coin"] = {}
            new_data["Messages"] = {}
            new_data["Challenges"] = {}
            new_data["Coin"]["amount"] = amount_coin
            new_data["Messages"]["new_messages"] = new_message.count()
            new_data["Challenges"]["challenge_list_names"] = challenges_list
            # check if points is saved for today
            temp = Points.objects.filter(user=user, date=now)
            if not temp.exists():
                return myResponse.OK(
                    "No report for today. This is the coin : ", new_data
                )
            record = temp[0]
            data = {}
            data_summary = {}
            amount_water = 0

            data_summary["totalCalorieUsed"] = record.total_Calories_used
            data_summary["totalFiberUsed"] = record.total_Fiber_used

            # week average
            points = Points.objects.filter(
                user=user, date__gte=(now - timedelta(days=6))
            )
            week_average = 0
            week_num = points.count()
            week_sum = 0
            if week_num > 0:
                for item in points:
                    week_sum = week_sum + (item.total_points)
                week_average = week_sum / week_num

            # yesterday
            yesterday_point = 0
            yp = points.filter(date=(now - timedelta(days=1)))
            if yp.exists():
                yesterday_point = yp[0].total_points

            # A one C
            SM = SugarMeasurement.objects.filter(
                user=user, time__gte=(now - timedelta(days=90))
            )
            sm_average = 0
            sm_sum = 0
            sm_num = SM.count()
            A1C_state = False
            A1C = user.profile.a1c  # default
            if sm_num > 2:
                for item in SM:
                    if item.time < datetime.now() - timedelta(days=3):
                        A1C_state = True

            if A1C_state is True:
                for sm in SM:
                    sm_sum += sm.amount
                sm_average = sm_sum / sm_num
                A1C = round((sm_average + 46.7) / 28.7, 1)

            # blood blood pressure
            last_BPs = BloodPressure.objects.filter(
                user=user, time__range=(sdt, edt)
            ).order_by("-time")
            bp = "-/-"
            if last_BPs.exists():
                bp = str(int(last_BPs[0].amount)) + "/" + str(int(last_BPs[0].over))

            # Water
            logs = Water.objects.filter(user=user, time__range=(sdt, edt))
            for i in range(logs.count()):
                amount = logs[i].amount
                amount_water = amount_water + amount

            data_summary["points"] = {}
            data_summary["points"]["week_average"] = week_average
            data_summary["BloodPressure"] = {}
            data_summary["BloodPressure"]["last"] = bp
            data_summary["A1C"] = {}
            data_summary["A1C"]["amount"] = A1C
            data_summary["A1C"]["state"] = A1C_state
            data_summary["A1C"]["sugar_average"] = sm_average
            data_summary["A1C"]["default"] = user.profile.a1c
            data_summary["Water"] = {}
            data_summary["Water"]["amount"] = amount_water
            data_summary["Coin"] = {}
            data_summary["Coin"]["amount"] = amount_coin

            data_summary["HypoHyperNumber"] = record.HypoHyperNumber
            data_summary["NewMessagesNumber"] = new_message.count()

            ####
            ####
            ####
            ####
            ####
            ####

            # all logs of today
            un_sorted_data = []
            logs = Eating.objects.filter(user=user, date_time__range=(sdt, edt))
            for i in range(logs.count()):
                amount = logs[i].amount
                un_sorted_data.append(
                    {
                        "type": "eating",
                        "name": logs[i].food.FA_Name,
                        "calorie": (logs[i].food.Calories * amount) / 100,
                        "fat": (logs[i].food.Fat_g * amount) / 100,
                        "protein": (logs[i].food.Protein_g * amount) / 100,
                        "carbohydrate": (logs[i].food.Carbohydrates_g * amount) / 100,
                        "amount": amount,
                        "point": logs[i].point,
                        "time": int(logs[i].date_time.timestamp()),
                        "date_time": str(
                            jdatetime.datetime.fromgregorian(datetime=logs[i].date_time)
                        ),
                        "meal": logs[i].meal,
                    }
                )

            logs = Activities_log.objects.filter(
                user=user, start_date_time__range=(sdt, edt)
            )
            for k in range(logs.count()):
                un_sorted_data.append(
                    {
                        "type": "activity",
                        "name": logs[k].activity.name,
                        "amount": logs[k].amount,
                        "point": logs[k].point,
                        "time": int(logs[k].start_date_time.timestamp()),
                        "end_date_time": int(logs[k].end_date_time.timestamp()),
                        "energy": logs[k].energy,
                    }
                )

            logs = SugarMeasurement.objects.filter(user=user, time__range=(sdt, edt))
            sugar_sum = 0
            for z in range(logs.count()):
                un_sorted_data.append(
                    {
                        "type": "sugar_measurment",
                        "amount": logs[z].amount,
                        "point": logs[z].point,
                        "time": int(logs[z].time.timestamp()),
                        "meal": logs[z].meal,
                    }
                )
                sugar_sum += logs[z].amount

            if logs.exists():
                average_blood_sugar = sugar_sum / logs.count()
            else:
                average_blood_sugar = 0
            sorted_data = sorted(un_sorted_data, key=lambda d: d["time"])

            # Loop through each day in the date range
            for day in range((end_date - start_date).days + 1):
                current_date = start_date + timedelta(days=day)
                day_summary = {
                    "date": str(current_date),
                    "breakfast": {},
                    "morning_snack": {},
                    "lunch": {},
                    "evening_snack": {},
                    "dinner": {},
                    "night_snack": {},
                    "points": {},
                }
                # breakfast ********************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=0
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=0
                )
                # return myResponse.OK("0",str(temp))
                day_summary["breakfast"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["breakfast"]["sugar"] = (
                    logs[0].amount if logs.exists() else 0
                )

                for i in range(temp.count()):  # meal=0 --> breakfast
                    day_summary["breakfast"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["breakfast"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["breakfast"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["breakfast"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["breakfast"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["breakfast"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["breakfast"]["microbiome_score"] = round(
                        day_summary["breakfast"]["microbiome_score"] / temp.count(), 2
                    )

                # morning_snack ****************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=3
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=3
                )
                # return myResponse.OK("1", str(temp))
                day_summary["morning_snack"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["morning_snack"]["sugar"] = (
                    logs[0].amount if logs.exists() else 0
                )

                for i in range(temp.count()):  # meal=1 --> morning_snack
                    day_summary["morning_snack"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["morning_snack"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["morning_snack"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["morning_snack"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["morning_snack"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["morning_snack"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["morning_snack"]["microbiome_score"] = round(
                        day_summary["morning_snack"]["microbiome_score"] / temp.count(),
                        2,
                    )

                # lunch ************************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=1
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=1
                )
                # return myResponse.OK("2", str(temp))
                day_summary["lunch"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["lunch"]["sugar"] = logs[0].amount if logs.exists() else 0

                for i in range(temp.count()):  # meal=2 --> lunch
                    day_summary["lunch"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["lunch"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["lunch"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["lunch"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["lunch"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["lunch"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["lunch"]["microbiome_score"] = round(
                        day_summary["lunch"]["microbiome_score"] / temp.count(), 2
                    )

                # evening_snack ****************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=4
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=4
                )
                # return myResponse.OK("3", str(temp))
                day_summary["evening_snack"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["evening_snack"]["sugar"] = (
                    logs[0].amount if logs.exists() else 0
                )

                for i in range(temp.count()):  # meal=3 --> evening_snack
                    day_summary["evening_snack"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["evening_snack"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["evening_snack"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["evening_snack"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["evening_snack"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["evening_snack"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["evening_snack"]["microbiome_score"] = round(
                        day_summary["evening_snack"]["microbiome_score"] / temp.count(),
                        2,
                    )

                # dinner ***********************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=2
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=2
                )
                # return myResponse.OK("4", str(temp))
                day_summary["dinner"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["dinner"]["sugar"] = logs[0].amount if logs.exists() else 0

                for i in range(temp.count()):  # meal=4 --> dinner
                    day_summary["dinner"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["dinner"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["dinner"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["dinner"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["dinner"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["dinner"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["dinner"]["microbiome_score"] = round(
                        day_summary["dinner"]["microbiome_score"] / temp.count(), 2
                    )

                # night_snack ******************************************
                temp = Eating.objects.filter(
                    user=user, date_time__date=current_date, meal=5
                )
                logs = SugarMeasurement.objects.filter(
                    user=user, time__date=current_date, meal=5
                )
                # return myResponse.OK("5", str(temp))
                day_summary["night_snack"] = {
                    "calorie": 0,
                    "fat": 0,
                    "protein": 0,
                    "carbohydrate": 0,
                    "fiber": 0,
                    "microbiome_score": 0,
                    "sugar": 0,
                }
                day_summary["night_snack"]["sugar"] = (
                    logs[0].amount if logs.exists() else 0
                )

                for i in range(temp.count()):  # meal=5 --> night_snack
                    day_summary["night_snack"]["calorie"] += round(
                        (temp[i].food.Calories * temp[i].amount) / 100, 2
                    )
                    day_summary["night_snack"]["fat"] += round(
                        (temp[i].food.Fat_g * temp[i].amount) / 100, 2
                    )
                    day_summary["night_snack"]["protein"] += round(
                        (temp[i].food.Protein_g * temp[i].amount) / 100, 2
                    )
                    day_summary["night_snack"]["carbohydrate"] += round(
                        (temp[i].food.Carbohydrates_g * temp[i].amount) / 100, 2
                    )
                    day_summary["night_snack"]["fiber"] += round(
                        (temp[i].food.Fiber_g * temp[i].amount) / 100, 2
                    )
                    day_summary["night_snack"]["microbiome_score"] += temp[
                        i
                    ].food.microbiome_score
                if temp.count() > 0:
                    day_summary["night_snack"]["microbiome_score"] = round(
                        day_summary["night_snack"]["microbiome_score"] / temp.count(), 2
                    )

                temp_points = Points.objects.filter(
                    user=user, date=current_date
                ).first()
                if temp_points:
                    day_summary["points"] = {
                        "total_Calories_Point": temp_points.total_Calories_Point * 100,
                        "totalCarboControlPoint": temp_points.totalCarboControlPoint
                        * 100,
                        "total_HEI_Point": temp_points.total_HEI_Point * 100,
                        "total_Activity_Point": temp_points.total_Activity_Point * 100,
                        "totalHypoHyperControlPoint": temp_points.totalHypoHyperControlPoint
                        * 100,
                        "totalSugarControlPoint": temp_points.totalSugarControlPoint
                        * 100,
                        "totalCooperationPoints": temp_points.totalCooperationPoints
                        * 100,
                        "total": temp_points.total_points,
                    }

                # Append to weekly breakdown
                weekly_breakdown.append(day_summary)

            # Final response data
            response_data = {
                "start_date": str(start_date),
                "end_date": str(end_date),
                "weekly_breakdown": weekly_breakdown,
                # Include any other summary data if needed
            }

            # summary and All_Logs_Sorted
            data["response_data"] = response_data
            data["summary"] = data_summary
            data["All_Logs_Sorted"] = sorted_data

            # HEI_Table is saved in veiw file of APIs
            CR = user.profile.CR
            calorie = round(CR / 100) * 100
            if calorie > 3500:
                calorie = 3500
            elif calorie < 1100:
                calorie = 1100
            GoalHEI = HEI_Table[calorie]

            # User_HEI for today
            temp = Points.objects.filter(user=user, date=date.today())
            HEI = {}
            if temp.exists():
                record = temp[0]
                User_HEI = getList(record.HEI_elements_list)
                HEI["User_HEI_Grain"] = User_HEI[14]
                HEI["User_HEI_Protein"] = User_HEI[15]
                HEI["User_HEI_Dairy"] = User_HEI[16]
                HEI["User_HEI_Fruit"] = User_HEI[17]
                HEI["User_HEI_Vegetables"] = User_HEI[18]
                HEI["User_HEI_Fat"] = User_HEI[19]
            else:
                HEI["User_HEI_Grain"] = 0
                HEI["User_HEI_Protein"] = 0
                HEI["User_HEI_Dairy"] = 0
                HEI["User_HEI_Fruit"] = 0
                HEI["User_HEI_Vegetables"] = 0
                HEI["User_HEI_Fat"] = 0

            HEI["Goal_HEI_Grain"] = GoalHEI[0]
            HEI["Goal_HEI_Protein"] = GoalHEI[1]
            HEI["Goal_HEI_Dairy"] = GoalHEI[2]
            HEI["Goal_HEI_Fruit"] = GoalHEI[3]
            HEI["Goal_HEI_Vegetables"] = GoalHEI[4]
            HEI["Goal_HEI_Fat"] = GoalHEI[5]

            data["HEI"] = [HEI]
            data["coins"] = user.profile.coins
            data["coins_history"] = user.profile.coins_history
            data["Challenges"] = challenges_list

            data["average_blood_sugar"] = average_blood_sugar
            t2 = datetime.now()
            print(
                "delay on: reportToDay, user id: "
                + str(user.id)
                + " time: "
                + str(jdatetime.datetime.fromgregorian(datetime=t2))
                + " ---> ",
                str(t2 - t1),
            )
            return myResponse.OK(
                "Summary of registered information for the user today", data
            )

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            return myResponse.Error(
                Errors.InvalidRequest.message, Errors.InvalidRequest.code
            )
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST"])
def Top_scores(request):
    if request.method == "POST":
        try:
            # Check input format
            RequsetChecker(
                request.POST,
                [
                    {
                        "name": "token",
                        "format": "^(\S){30}$",
                        "errorMessage": "توکن نامعتبر است",
                    },
                    {
                        "name": "phone_number",
                        "required": False,
                        "format": "^09[0-9]{9}$",
                        "errorMessage": "شماره تلفن نامعتبر است",
                    },
                ],
                request,
            )

            # Verify user authentication
            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )
            user = temp[0]

            mode = (datetime.today().day % 7) + 1

            fakeUserSet = [
                [
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرهاد",
                        "avatar": 2,
                        "picture": "male",
                        "point": 10 + 3 * (30 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "منصور",
                        "avatar": 4,
                        "picture": "male",
                        "point": 10 + 3 * (12 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "حامد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 10 + 3 * (11 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "امین",
                        "avatar": 2,
                        "picture": "male",
                        "point": 10 + 3 * (8 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "شبنم",
                        "avatar": 5,
                        "picture": "female",
                        "point": 10 + 3 * (9 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مریم",
                        "avatar": 8,
                        "picture": "female",
                        "point": 10 + 3 * (18 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "محمد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 10 + 3 * (20 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "نسترن",
                        "avatar": 5,
                        "picture": "female",
                        "point": 10 + 3 * (33 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مهناز",
                        "avatar": 6,
                        "picture": "female",
                        "point": 10 + 3 * (17 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "پارسا",
                        "avatar": 2,
                        "picture": "male",
                        "point": 10 + 3 * (19 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "همایون",
                        "avatar": 3,
                        "picture": "male",
                        "point": 10 + 3 * (27 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سحر",
                        "avatar": 7,
                        "picture": "female",
                        "point": 10 + 3 * (16 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مهدیه",
                        "avatar": 7,
                        "picture": "female",
                        "point": 10 + 3 * (13 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سپیده",
                        "avatar": 8,
                        "picture": "female",
                        "point": 10 + 4 * (30 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سمیه",
                        "avatar": 8,
                        "picture": "female",
                        "point": 10 + 3 * (14 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرشته",
                        "avatar": 5,
                        "picture": "female",
                        "point": 10 + 3 * (11 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرناز",
                        "avatar": 6,
                        "picture": "female",
                        "point": 10 + 3 * (14 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "باربد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 10 + 4 * (13 % mode) + 2 * mode,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مسعود",
                        "avatar": 8,
                        "picture": "male",
                        "point": 10 + 3 * (11 % mode) + 2 * mode,
                    },
                ],
                [
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرهاد",
                        "avatar": 2,
                        "picture": "male",
                        "point": 14,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "منصور",
                        "avatar": 4,
                        "picture": "male",
                        "point": 11,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "حامد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 15,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "امین",
                        "avatar": 2,
                        "picture": "male",
                        "point": 13,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "شبنم",
                        "avatar": 5,
                        "picture": "female",
                        "point": 13,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مریم",
                        "avatar": 8,
                        "picture": "female",
                        "point": 19,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "محمد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 15,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "نسترن",
                        "avatar": 5,
                        "picture": "female",
                        "point": 19,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مهناز",
                        "avatar": 6,
                        "picture": "female",
                        "point": 21,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "پارسا",
                        "avatar": 2,
                        "picture": "male",
                        "point": 13,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "همایون",
                        "avatar": 3,
                        "picture": "male",
                        "point": 20,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سحر",
                        "avatar": 7,
                        "picture": "female",
                        "point": 25,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مهدیه",
                        "avatar": 7,
                        "picture": "female",
                        "point": 21,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سپیده",
                        "avatar": 8,
                        "picture": "female",
                        "point": 26,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "سمیه",
                        "avatar": 8,
                        "picture": "female",
                        "point": 27,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرشته",
                        "avatar": 5,
                        "picture": "female",
                        "point": 28,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "فرناز",
                        "avatar": 6,
                        "picture": "female",
                        "point": 29,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "باربد",
                        "avatar": 3,
                        "picture": "male",
                        "point": 11,
                    },
                    {
                        "is_this": False,
                        "rank": None,
                        "first_name": "مسعود",
                        "avatar": 8,
                        "picture": "male",
                        "point": 15,
                    },
                ],
            ]

            # 5) "Tops" for today, "HighTops" for yesterday
            Tops = fakeUserSet[0]
            HighTops = []

            now = datetime.now()
            nowDate = now.date()
            yesterday = now - timedelta(days=1)
            yesterdayDate = yesterday.date()

            # Scale the "fake" users' points based on current hour
            for i in range(len(Tops)):
                Tops[i]["point"] = round(
                    Tops[i]["point"] * (0.3 + (0.7 * (now.hour / 23)))
                )

            # 6) Real Points from DB (today and yesterday)
            points = Points.objects.filter(date=nowDate)
            high_points = Points.objects.filter(date=yesterdayDate)

            # Append today's real Points to Tops
            for item in points:
                is_this = item.user == user
                if item.user.profile.image != "":
                    picture = item.user.profile.image.url
                elif item.user.profile.gender == 0:
                    picture = "male"
                else:
                    picture = "female"

                Tops.append(
                    {
                        "rank": None,
                        "first_name": item.user.profile.first_name,
                        "avatar": item.user.profile.avatar,
                        "picture": picture,
                        "point": round(item.total_points),
                        "is_this": is_this,
                        "user_id": item.user.id,
                    }
                )

            # Append yesterday's real points to HighTops
            for item in high_points:
                is_this = item.user == user
                if item.user.profile.image != "":
                    picture = item.user.profile.image.url
                elif item.user.profile.gender == 0:
                    picture = "male"
                else:
                    picture = "female"

                HighTops.append(
                    {
                        "rank": None,
                        "first_name": item.user.profile.first_name,
                        "avatar": item.user.profile.avatar,
                        "picture": picture,
                        "point": round(item.total_points),
                        "is_this": is_this,
                        "user_id": item.user.id,
                    }
                )

            # 7) Sort daily (Tops) and yesterday (HighTops) by 'point' descending
            sortedTops = sorted(Tops, key=lambda d: d["point"], reverse=True)
            sortedHighTops = sorted(HighTops, key=lambda d: d["point"], reverse=True)

            # 8) Assign daily ranks
            for i, user_obj in enumerate(sortedTops):
                user_obj["rank"] = i + 1

            # 9) LIMIT daily list to top 50
            #    We'll figure out if the current user is in that top 50
            slicedTops = sortedTops[:50]
            user_in_top_50 = any(obj.get("is_this") for obj in slicedTops)

            # 10) Find the user in the full daily list to get their rank
            user_daily_object = None
            for obj in sortedTops:
                if obj.get("is_this"):
                    user_daily_object = obj
                    break

            # 11) If user is not present at all, they must have 0 points.
            #     => We'll set their rank to the total # of users in Profile
            if not user_daily_object:
                total_profiles = Profile.objects.count()
                user_daily_object = {
                    "rank": total_profiles,  # because user has 0 points => rank = total number of profiles
                    "first_name": user.profile.first_name,
                    "avatar": user.profile.avatar,
                    "picture": "male" if user.profile.gender == 0 else "female",
                    "point": 0,
                    "is_this": True,
                    "user_id": user.id,
                }
            user_actual_rank = user_daily_object["rank"]

            # 12) If user not in top 50 but they have a rank, we append them at the bottom
            if not user_in_top_50:
                slicedTops.append(user_daily_object)

            # 13) Yesterday's top 50
            # rank them
            for i, obj in enumerate(sortedHighTops):
                obj["rank"] = i + 1
            sortedHighTops = sortedHighTops[:50]

            # 14) Weekly logic
            one_week_ago = nowDate - timedelta(days=7)
            weekly_scores = (
                Points.objects.filter(date__gte=one_week_ago)
                .values(
                    "user",
                    "user__profile__first_name",
                    "user__profile__avatar",
                    "user__profile__image",
                    "user__profile__gender",
                )
                .annotate(weekly_score=Sum("total_points"))
                .order_by("-weekly_score")
            )
            weekly_ranks = []
            for i, entry in enumerate(weekly_scores, start=1):
                if i > 50:
                    break
                user_image = entry["user__profile__image"]
                if user_image:
                    picture = user_image.url
                elif entry["user__profile__gender"] == 0:
                    picture = "male"
                else:
                    picture = "female"

                is_this = entry["user"] == user.id

                weekly_ranks.append(
                    {
                        "rank": i,
                        "first_name": entry["user__profile__first_name"],
                        "avatar": entry["user__profile__avatar"],
                        "picture": picture,
                        "weekly_score": entry["weekly_score"],
                        "is_this": is_this,
                    }
                )

            # see if user is in top 50 weekly
            user_weekly_score = 0
            user_weekly_rank = "Not ranked"
            for item in weekly_ranks:
                if item["is_this"]:
                    user_weekly_score = item["weekly_score"]
                    user_weekly_rank = item["rank"]
                    break

            # 15) Build data result
            data = {}
            if sortedHighTops:
                data["top_rank"] = sortedHighTops[0]
            else:
                data["top_rank"] = "No Ranking Data"

            data["user_weekly_score"] = user_weekly_score
            data["user_weekly_rank"] = user_weekly_rank
            data["this_user_rank"] = user_actual_rank

            # If we want the daily average among the full set, not just top 50
            sum_of_points = sum(obj["point"] for obj in sortedTops)
            data["average"] = (
                (sum_of_points / len(sortedTops)) if len(sortedTops) > 0 else 0
            )

            data["ranks"] = slicedTops  # top 50 daily + user if not in top 50
            data["weekly_ranks"] = weekly_ranks

            return myResponse.OK("The top list for today", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def glocometer_with_image(request):
    try:
        # RequsetChecker(request.POST, [
        #     {
        #         "name": "token",
        #         "format": "^(\S){30}$",
        #         "errorMessage": "توکن نامعتبر است"
        #     },
        #     {
        #         "name": "phone_number",
        #         "format": "^09[0-9]{9}$",
        #         "errorMessage": "شماره تلفن نامعتبر است"
        #     },
        # ], request)
        #
        # token = str(request.POST["token"])
        # # phone = str(request.POST["phone_number"])
        # # temp = User.objects.filter(token=token, phone_number=phone)
        # temp = User.objects.filter(token=token)
        # if not temp.exists():
        #     return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        #
        # user = temp[0]

        time = str(int(datetime.now().timestamp()))

        if request.FILES == {}:
            return myResponse.Error(Errors.InsertPic.message, Errors.InsertPic.code)
        f = request.FILES["image"]

        # now save Food.jpg file in the server...
        path = "/assets/glocometer/" + "glocometer_" + time + "_" + ".jpg"

        newFile = STATIC_ROOT + path
        with open(newFile, "wb+") as destination:
            for chunk in f.chunks():
                destination.write(chunk)
        destination.close()

        if os.path.getsize(newFile) < 1:  # temp file!
            os.remove(newFile)
            return myResponse.Error("empty file!!", -1)

        # Initiate Constants
        addr = "https://213.233.180.123:12996"
        test_url = addr + "/api/med_digits"

        # Headers for HTTP request
        content_type = "application/json"
        headers = {"content-type": content_type}

        # Prepare parameters
        # ============================ #
        threshold = 0.5

        # Load an image from file
        photo = cv2.imread(newFile)

        # Set return_photo: False if you don't need to get the photo with bboxes.
        return_photo = False
        # ============================ #

        # Send a request to server and get the result
        response = requests.post(
            test_url,
            data=jsonpickle.dumps(
                {"threshold": threshold, "photo": photo, "return_photo": return_photo}
            ),
        )

        # Check if response is OK 200
        if response.status_code == 200:
            # Decode response
            response = jsonpickle.loads(response.text)

            # Extract response
            number = response["data"]["number"]
            response_time = response["data"]["inference_time"]
            returned_photo = response["data"][
                "photo"
            ]  # Comment this line if return_photo was False

            # Print the result
            # print("Predicted Number: ", number)
            # print("Response Time: {:.0f}(ms)".format(response_time * 1000))
            data = {"Predicted_Number": number}
            return myResponse.OK("Processing was done correctly", data)

        return myResponse.Error(Errors.InternalError.message, Errors.InternalError.code)

    except ValueError as e:
        return myResponse.Error(e.args, Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args, Errors.InternalError.code)


@api_view(["POST"])
def report_api(request):
    if request.method == "POST":
        t1 = datetime.now()
        try:
            RequsetChecker(
                request.POST,
                [
                    {"name": "token", "format": "^(\S){30}$"},
                ],
                request,
            )

            token = str(request.POST["token"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(
                    Errors.InvalidToken.message, Errors.InvalidToken.code
                )

            user = temp[0]
            # Get the date range for the past 7 days
            end_date = datetime.now().date()
            start_date = end_date - timedelta(
                days=6
            )  # Calculate 6 days back for a total of 7 days

            now = datetime.now().date()

            # today start and end ...
            sdt = datetime(now.year, now.month, now.day, 0, 0, 0)
            edt = datetime(now.year, now.month, now.day, 23, 59, 59)
            d1 = sdt.date()
            d2 = edt.date()
            days = (d2 - d1).days + 1

            # Sleep Report ---------------------------------------------------------------------
            sleep = Sleep.objects.filter(
                user=user, time__date__range=(start_date, end_date)
            ).order_by("-start")

            # Define the function to convert sleep duration to minutes

            def convert_sleep_duration_to_minutes(sleep_duration_str):
                hours, minutes = map(int, sleep_duration_str.split(":"))
                total_minutes = hours * 60 + minutes
                return total_minutes

            sleep_list = []
            if sleep.exists():
                for item in sleep:
                    sleep_duration_minutes = convert_sleep_duration_to_minutes(
                        item.sleeped
                    )
                    sleep_list.append(
                        {
                            "start_hour": round(item.start),
                            "minuets": sleep_duration_minutes,
                        }
                    )
            # microbiome Report ---------------------------------------------------------------------
            microbiome = 2

            # nutrition Report ---------------------------------------------------------------------
            eaten_list = []
            total_protein = 0
            total_fat = 0
            total_calorie = 0
            total_carbohydrate = 0
            # time__range=(sd, ed)
            data = user.calculate_cr_macro_nutrients_distribution()

            def getList(strList):
                S = strList.split("&")
                last = len(S) - 1
                F = []
                for i in range(1, last):
                    if not S[i] == "":
                        F.append(float(S[i]))
                return F

            def listToStr(list):
                S = "&"
                for item in list:
                    S += str(item) + "&"
                return S

            nutrition = Eating.objects.filter(user=user, date_time__range=(sdt, edt))

            Protein_to_use = user.profile.Protein_distribution_g * days
            Fat_to_use = user.profile.Fat_distribution_g * days

            Carbohydrates_distribution_str = listToStr(
                data["carbohydrate_distribution_g"]
            )
            user.profile.Carbohydrates_distribution_list_g = (
                Carbohydrates_distribution_str
            )
            Carbohydrates_list_to_use = getList(
                user.profile.Carbohydrates_distribution_list_g
            )
            Carbohydrates_list_to_use = list(
                map(
                    lambda x: days * x,
                    getList(user.profile.Carbohydrates_distribution_list_g),
                )
            )
            Carbohydrates = sum(Carbohydrates_list_to_use)
            totalcarb = 0

            for i in range(5):
                temp = Eating.objects.filter(
                    user=user, date_time__range=(sdt, edt), meal=i
                )

                for ii in range(temp.count()):
                    totalcarb += round(
                        (temp[ii].food.Carbohydrates_g * temp[ii].amount) / 100, 2
                    )

            for i in range(len(nutrition)):
                # Calculate the protein, fat, and calorie for each food item
                protein = (nutrition[i].food.Protein_g * nutrition[i].amount) / 100
                fat = (nutrition[i].food.Fat_g * nutrition[i].amount) / 100
                calorie = (nutrition[i].food.Calories * nutrition[i].amount) / 100

                # Add the calculated values to the totals
                total_protein += protein
                total_fat += fat
                total_calorie += calorie

                # Append information about each food item to the list
                eaten_list.append(
                    {
                        "protein": round(protein, 2),
                        "fat": round(fat, 2),
                        "calorie": round(calorie, 2),
                    }
                )

            # weight status Report ---------------------------------------------------------------------
            weight = user.profile.weight
            goal_weight = user.profile.goal_weight

            data = {
                "totalcarb": totalcarb,
                "total_protein": total_protein,
                "total_fat": total_fat,
                "total_calorie": total_calorie,
                "Carbohydrates_to_use": round(Carbohydrates),
                "Protein_to_use": round(Protein_to_use),
                "Fat_to_use": round(Fat_to_use),
                "weight": weight,
                "goal_weight": goal_weight,
                "microbiome": microbiome,
                "sleep_report": sleep_list,
            }
            return myResponse.OK("Summary of api reports", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def add_water(request):
    try:
        RequsetChecker(
            request.POST,
            [
                {"name": "token", "format": "^(\S){30}$"},
                {
                    "name": "time",
                    "format": "^[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                },
                {
                    "name": "amount",
                    "format": "^[\d]+$",
                },
            ],
            request,
        )

        token = str(request.POST["token"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(
                Errors.InvalidToken.message, Errors.InvalidToken.code
            )

        user = temp[0]
        amount = int(request.POST.get("amount"))
        dt = datetime.fromtimestamp(int(request.POST.get("time")))

        # now = datetime.now().date()
        now = date.fromtimestamp(int(request.POST.get("time")))
        today = now
        today_start = datetime(
            year=today.year,
            month=today.month,
            day=today.day,
            hour=0,
            minute=0,
            second=0,
        )
        today_end = datetime(
            year=today.year,
            month=today.month,
            day=today.day,
            hour=23,
            minute=59,
            second=59,
        )
        amount_challenge = 0

        new_log = Water(user=user, time=dt, amount=amount)
        new_log.save()

        challenges = ChallengeSelection.objects.filter(user=user)
        for c in challenges:
            amount_challenge = 0
            if c.challenge.category == 5 and c.challenge.end_deadline.date() > now:
                if c.challenge.sub_category == 0:  # tedad_sabt
                    start_day = c.challenge.start_deadline.date()
                    end_day = c.challenge.end_deadline.date()
                    df = now - start_day
                    duration = df.days
                    if start_day <= now < end_day:
                        water = Water.objects.filter(
                            user=user, time__range=(today_start, today_end)
                        )
                        if water is not None:
                            for w in water:
                                amount_challenge = amount_challenge + w.amount
                                if c.challenge.tedad_sabt <= amount_challenge:
                                    c.day_status["status"][duration] = True
                                    c.save()
                        # Check if this is the last day of the challenge
                        total_days = (end_day - start_day).days
                        if duration == total_days - 1:  # Check if it's the last day
                            # Check if all statuses are True
                            if all(c.day_status["status"]):
                                user.profile.coins = (
                                    user.profile.coins + c.challenge.reward
                                )
                                user.profile.save()

        record_date = dt.date()
        p = Points.objects.filter(user=user, date=record_date)
        if p.exists():
            record = p[0]
        else:
            record = Points(user=user, date=record_date)

        u = updateTotalPointDay(user, record, is_Water=True)
        # Calculate points gained
        points_awarded = u["points_awarded"]
        water_points_gained = points_awarded["Water_points_gained"]
        engagement_points_gained = points_awarded["Engagement_points_gained"]

        # Construct the message
        messages = []
        if water_points_gained > 0:
            messages.append(
                f"شما{water_points_gained}امتیاز بابت ثبت میزان آب دریافتی به دست آوردید! 🌊"
            )
        else:
            messages.append(
                "امروز امتیاز حداکثری آب‌ خوردن رو به دست آوردی! آفرین به تو! 💧🏆"
            )

        if engagement_points_gained > 0:
            messages.append(
                f"{engagement_points_gained} امتیاز ثبت فعالیت گرفتی! همیشه عالی پیش میری! 🎉"
            )
        else:
            messages.append(
                "امروز به حداکثر امتیاز ثبت فعالیت رسیدی! کلی تلاش کردی، احسنت! 💪🏅"
            )

        total_message = " ".join(messages)

        totalPoint = u["DayPoint"]
        record.total_points = totalPoint
        record.totalCooperationPoints = u["totalCooperate"]
        record.save()
        data = {
            "total_points": u["DayPoint"],
            "water_points": record.total_Water_Point,
            "engagement_points": record.this_day_DataEntry_score,
            "message": total_message,
        }
        return myResponse.OK("Information was recorded", data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def get_water(request):
    try:
        RequsetChecker(
            request.POST,
            [
                {"name": "token", "format": "^(\S){30}$"},
            ],
            request,
        )

        token = str(request.POST["token"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(
                Errors.InvalidToken.message, Errors.InvalidToken.code
            )

        user = temp[0]

        result = Water.objects.filter(user=user).order_by("-time")
        water_result = []
        for water in result:
            item = {
                "time": int(water.time.timestamp()),
                "amount": water.amount,
            }
            water_result.append(item)

        data = {
            "water_result": water_result,
        }
        return myResponse.OK("Information was recorded", data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def add_weight(request):
    try:
        RequsetChecker(
            request.POST,
            [
                {"name": "token", "format": "^(\S){30}$"},
                {
                    "name": "time",
                    "format": "^[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند",
                },
                {
                    "name": "weight",
                    "format": "^[\d]+$",
                },
            ],
            request,
        )

        token = str(request.POST["token"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(
                Errors.InvalidToken.message, Errors.InvalidToken.code
            )

        user = temp[0]
        weight = int(request.POST.get("weight"))
        dt = datetime.fromtimestamp(int(request.POST.get("time")))
        BMI = weight / ((user.profile.height / 100) * (user.profile.height / 100))

        new_log = Weights(user=user, time=dt, weight=weight, BMI=BMI)
        new_log.save()
        data = {}
        return myResponse.OK("Information was recorded", data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def get_weight(request):
    try:
        RequsetChecker(
            request.POST,
            [
                {"name": "token", "format": "^(\S){30}$"},
            ],
            request,
        )

        token = str(request.POST["token"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(
                Errors.InvalidToken.message, Errors.InvalidToken.code
            )

        user = temp[0]

        result = Weights.objects.filter(user=user).order_by("-time")
        weight_result = []
        for weight in result:
            item = {
                "time": int(weight.time.timestamp()),
                "weight": weight.weight,
                "BMI": round(weight.BMI, 2),
            }
            weight_result.append(item)

        data = {
            "weight_result": weight_result,
        }
        return myResponse.OK("Information was recorded", data)

    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def set_main_dish_codes_for_chesse_peanut_butter_oatmeal(request):
    try:
        # Get all food cards containing "پنیر" in FA_Name and main_dish_code = -1
        food_cards = FoodCard.objects.filter(
            FA_Name__contains="پنیر", main_dish_code=-1, is_breakfast=True
        )

        for card in food_cards:
            # Check if food parameter exists and contains food_code=1042
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=1042 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 1042:
                        # Update main_dish_code to 1042 for this food card
                        food_cards.update(main_dish_code=1042)
                        break

        oatmeal_food_cards = FoodCard.objects.filter(
            FA_Name__contains="اوتمیل", main_dish_code=-1, is_breakfast=True
        )

        for card in oatmeal_food_cards:
            # Check if food parameter exists and contains food_code=20038
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=20038 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 20038:
                        # Update main_dish_code to 20038 for this food card
                        oatmeal_food_cards.update(main_dish_code=20038)
                        break

        peanut_butter_food_cards = FoodCard.objects.filter(
            FA_Name__contains="کره بادام زمینی", main_dish_code=-1, is_breakfast=True
        )

        for card in peanut_butter_food_cards:
            # Check if food parameter exists and contains food_code=16150
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=16150 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 16150:
                        # Update main_dish_code to 16150 for this food card
                        peanut_butter_food_cards.update(main_dish_code=16150)
                        break

        tahini_food_cards = FoodCard.objects.filter(
            FA_Name__contains="ارده", main_dish_code=-1, is_breakfast=True
        )

        for card in tahini_food_cards:
            # Check if food parameter exists and contains food_code=12166
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=12166 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 12166:
                        # Update main_dish_code to 12166 for this food card
                        tahini_food_cards.update(main_dish_code=12166)
                        break

        tahini_food_cards = FoodCard.objects.filter(
            FA_Name__contains="ارده", main_dish_code=-1, is_breakfast=True
        )

        for card in tahini_food_cards:
            # Check if food parameter exists and contains food_code=12166
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=12166 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 12166:
                        # Update main_dish_code to 12166 for this food card
                        tahini_food_cards.update(main_dish_code=12166)
                        break

        khagineh_food_cards = FoodCard.objects.filter(
            FA_Name__contains="خاگینه", main_dish_code=-1
        )

        for card in khagineh_food_cards:
            # Check if food parameter exists and contains food_code=9980080
            card_foods = card.foods
            # Check if card_foods is a list
            if isinstance(card_foods, list):
                # Look for food_code=9980080 in any of the food objects
                for food in card_foods:
                    if isinstance(food, dict) and food.get("food_code") == 9980080:
                        # Update main_dish_code to 9980080 for this food card
                        khagineh_food_cards.update(main_dish_code=9980080)
                        break

        # Serialize the food cards
        cards_data = []
        for card in food_cards:
            card_data = {
                "id": card.id,
                "FA_Name": card.FA_Name,
                "EN_Name": card.EN_Name,
                "main_dish_code": card.main_dish_code,
                "foods": card.foods,
            }
            cards_data.append(card_data)

        return myResponse.OK("Food cards retrieved successfully", {"cards": cards_data})

    except Exception as e:
        return myResponse.Error(str(e), Errors.InternalError.code)


@api_view(["POST"])
def generate_blood_test_report(request):
    
    # """
    # API endpoint to generate blood test report from PDF or image files.

    # Expected parameters:
    # - token: User authentication token
    # - file: PDF or image file of the blood test report

    # Returns:
    # - structured_data: JSON structured data from the report
    # - report_markdown: Markdown formatted health report
    # - analysis: Test range analysis
    # """

    if request.method == "POST":
        try:
            # Validate token
            token = request.POST.get("token")
            if not token:
                return myResponse.Error("توکن الزامی است", Errors.InvalidToken.code)

            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]

            # Check required dependencies
            print("[API] Checking dependencies...")
            missing_deps = []
            try:
                import fitz
                print("[API] ✓ PyMuPDF is available")
            except ImportError as e:
                print(f"[API] ✗ PyMuPDF not available: {e}")
                missing_deps.append("PyMuPDF")
            
            try:
                from PIL import Image
                print("[API] ✓ Pillow is available")
            except ImportError as e:
                print(f"[API] ✗ Pillow not available: {e}")
                missing_deps.append("Pillow")
            
            try:
                from google.cloud import vision
                print("[API] ✓ google-cloud-vision is available")
            except ImportError as e:
                print(f"[API] ✗ google-cloud-vision not available: {e}")
                missing_deps.append("google-cloud-vision")
            
            if missing_deps:
                error_msg = f"کتابخانه‌های زیر روی سرور نصب نشده‌اند: {', '.join(missing_deps)}"
                print(f"[API] ERROR: Missing dependencies: {missing_deps}")
                return myResponse.Error(error_msg, -1)
            
            print("[API] All dependencies available")

            # Debug: Log what we received
            print(f"[API] Request method: {request.method}")
            print(f"[API] Content type: {request.content_type}")
            print(f"[API] POST keys: {list(request.POST.keys())}")
            print(f"[API] FILES keys: {list(request.FILES.keys())}")
            
            # Check if file was uploaded
            if 'file' not in request.FILES:
                print("[API] ERROR: 'file' field not found in request.FILES")
                print(f"[API] Available fields in FILES: {list(request.FILES.keys())}")
                return myResponse.Error("فایل آزمایش خون الزامی است. لطفا فایل را با نام 'file' ارسال کنید", -1)

            uploaded_file = request.FILES['file']
            file_extension = os.path.splitext(uploaded_file.name)[1].lower()

            # Validate file type
            if file_extension not in ['.pdf', '.png', '.jpg', '.jpeg']:
                return myResponse.Error("فرمت فایل باید PDF یا تصویر باشد", -1)

            # Create temporary directory for processing
            temp_dir = tempfile.mkdtemp(prefix='blood_test_')

            try:
                # Save uploaded file
                input_path = os.path.join(temp_dir, f"input{file_extension}")
                with open(input_path, 'wb+') as destination:
                    for chunk in uploaded_file.chunks():
                        destination.write(chunk)

                print(f"[API] Processing file: {uploaded_file.name}")
                print(f"[API] File size: {os.path.getsize(input_path)} bytes")

                # Process based on file type
                image_paths = []

                if file_extension == '.pdf':
                    print("[API] Converting PDF to images...")
                    images_dir = os.path.join(temp_dir, "images")
                    image_paths = convert_pdf_to_images(input_path, images_dir)
                else:
                    # Single image file
                    image_paths = [input_path]

                if not image_paths:
                    return myResponse.Error("خطا در پردازش فایل", -1)

                # Stage 1: OCR
                print("[API] Running OCR...")
                full_text = run_ocr_on_images(image_paths)
                if not full_text:
                    return myResponse.Error("متن قابل خواندنی در فایل یافت نشد", -1)

                # Stage 2: Structure data with LLM
                print("[API] Structuring data with LLM...")
                structured_data = process_text_with_llm(full_text)
                if not structured_data:
                    return myResponse.Error("خطا در تجزیه و تحلیل داده‌ها", -1)

                # Stage 3: Analyze test ranges
                print("[API] Analyzing test ranges...")
                range_analysis = analyze_test_ranges(structured_data)

                # Stage 4: Generate health report
                print("[API] Generating health report...")
                report_prompt = build_lacto_report_prompt(structured_data)
                report_markdown = generate_report_with_llm(report_prompt)

                if report_markdown:
                    report_markdown = clean_markdown_report(report_markdown)
                else:
                    report_markdown = ""

                # Prepare response
                response_data = {
                    'structured_data': structured_data,
                    'test_analysis': range_analysis,
                    'health_report_markdown': report_markdown,
                    'user_id': user.id,
                    'processed_at': datetime.now().isoformat()
                }

                print("[API] Blood test report generated successfully")
                return myResponse.OK("گزارش با موفقیت ایجاد شد", response_data)

            finally:
                # Clean up temporary files
                try:
                    shutil.rmtree(temp_dir)
                    print(f"[API] Cleaned up temporary directory: {temp_dir}")
                except Exception as cleanup_error:
                    print(f"[API] Warning: Could not clean up temp directory: {cleanup_error}")

        except Exception as e:
            print(f"[API] Error in generate_blood_test_report: {str(e)}")
            import traceback
            traceback.print_exc()
            return myResponse.Error(f"خطا در پردازش گزارش: {str(e)}", Errors.InternalError.code)

    return myResponse.Error("روش درخواست باید POST باشد", -1)
    

@api_view(["POST"])
def get_food_recommendations_by_disease(request):
    """
    API endpoint to get food recommendations based on diseases and lab results.

    Expected parameters:
    - token: User authentication token
    - diseases_string: String of diseases separated by '&&' (e.g., "PCOS (سندروم تخمدان پلی‌کیستیک)&&دیابت")
    - lab_results: JSON array of lab test results with test_name and status
      Example: [{"test_name": "MCHC", "status": "low"}, {"test_name": "Alanine Aminotransferase", "status": "high"}]

    Returns:
    - recommendations: List of foods with their colors (Red/Yellow/Green) and nutritional info
    """
    from APIs.modules.getting_FoodNodes_Color import process_recommendations
    import json

    if request.method == "POST":
        try:
            # Validate token
            token = request.POST.get("token")
            if not token:
                return myResponse.Error("توکن الزامی است", Errors.InvalidToken.code)

            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]

            # Get diseases string
            diseases_string = request.POST.get("diseases_string", "")

            # Get lab results (should be JSON string)
            lab_results_str = request.POST.get("lab_results", "[]")
            try:
                lab_results = json.loads(lab_results_str)
            except json.JSONDecodeError:
                return myResponse.Error("فرمت lab_results باید JSON معتبر باشد", -1)

            # Validate lab_results format
            if not isinstance(lab_results, list):
                return myResponse.Error("lab_results باید یک آرایه باشد", -1)

            # Process recommendations
            print(f"[API] Processing recommendations for user {user.id}")
            print(f"[API] Diseases: {diseases_string}")
            print(f"[API] Lab results count: {len(lab_results)}")

            recommendations = process_recommendations(diseases_string, lab_results)

            # Save recommendations to cache for fast retrieval
            try:
                FoodRecommendationsCache.objects.update_or_create(
                    user=user,
                    defaults={
                        'recommendations': recommendations,
                        'diseases_string': diseases_string,
                        'lab_results': lab_results,
                        'total_foods': len(recommendations)
                    }
                )
                print(f"[API] Saved {len(recommendations)} recommendations to cache")
            except Exception as e:
                print(f"[API] Error saving to cache: {str(e)}")
                # Continue even if cache save fails

            # Prepare response
            response_data = {
                'recommendations': recommendations,
                'total_foods': len(recommendations),
                'user_id': user.id,
                'diseases_processed': diseases_string,
                'lab_tests_processed': len(lab_results)
            }
            
            try:
                FirebaseNotification(user).send_notification_to(user.profile.firebase_token, "توصیه‌های غذایی با موفقیت ایجاد شد", response_data)
            except Exception as e:
                print(f"[API] Error in sending notification: {str(e)}")
                pass
            
            PushNotification(user).send_notification_to(user.profile.firebase_token, "نقشه راه غذایی شما آماده شد!", response_data)

            print(f"[API] Generated {len(recommendations)} food recommendations")
            return myResponse.OK("توصیه‌های غذایی با موفقیت ایجاد شد", response_data)

        except Exception as e:
            print(f"[API] Error in get_food_recommendations_by_disease: {str(e)}")
            import traceback
            traceback.print_exc()
            return myResponse.Error(f"خطا در ایجاد توصیه‌ها: {str(e)}", Errors.InternalError.code)
        

    return myResponse.Error("روش درخواست باید POST باشد", -1)


@api_view(["POST"])
def get_cached_food_recommendations(request):
    """
    API endpoint to get cached food recommendations for a user.
    Returns recommendations from cache if they exist, extremely fast (< 1 second).
    This API only returns cached data - it does not generate new recommendations.

    Expected parameters:
    - token: User authentication token

    Returns:
    - recommendations: List of cached food recommendations (if available)
    - Returns error if no cached recommendations exist
    """
    from APIs.models import FoodRecommendationsCache
    import json

    if request.method == "POST":
        try:
            # Validate token
            token = request.POST.get("token")
            if not token:
                return myResponse.Error("توکن الزامی است", Errors.InvalidToken.code)

            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]

            # Check if cached recommendations exist
            try:
                cache_obj = FoodRecommendationsCache.objects.get(user=user)
                print(f"[API] Found cached recommendations for user {user.id}")
                
                # Return cached recommendations immediately (extremely fast)
                response_data = {
                    'recommendations': cache_obj.recommendations,
                    'total_foods': cache_obj.total_foods,
                    'user_id': user.id,
                    'diseases_processed': cache_obj.diseases_string,
                    'lab_tests_processed': len(cache_obj.lab_results) if cache_obj.lab_results else 0,
                    'cache_created_at': cache_obj.created_at.isoformat() if cache_obj.created_at else None,
                    'cache_updated_at': cache_obj.updated_at.isoformat() if cache_obj.updated_at else None
                }
                
                print(f"[API] Returning {cache_obj.total_foods} cached food recommendations")
                return myResponse.OK("توصیه‌های غذایی با موفقیت دریافت شد", response_data)
                
            except FoodRecommendationsCache.DoesNotExist:
                # No cache exists
                print(f"[API] No cached recommendations found for user {user.id}")
                return myResponse.Error("هیچ توصیه غذایی ذخیره‌شده‌ای یافت نشد. لطفا ابتدا توصیه‌ها را ایجاد کنید.", -1)

        except Exception as e:
            print(f"[API] Error in get_cached_food_recommendations: {str(e)}")
            import traceback
            traceback.print_exc()
            return myResponse.Error(f"خطا در دریافت توصیه‌ها: {str(e)}", Errors.InternalError.code)
        

    return myResponse.Error("روش درخواست باید POST باشد", -1)


@api_view(["POST"])
def get_food_suggestions_by_mc(request):
    """
    API endpoint to get food suggestions based on FoodCode and user's diseases from profile.
    Uses AssignedMC to find similar foods and computes FINAL_TAG based on user's diseases.

    Expected parameters:
    - token: User authentication token
    - food_code: Integer food code to get suggestions for

    Returns:
    - two_finaltag: List of foods with FINAL_TAG = 2
    - one_finaltag: List of foods with FINAL_TAG = 1
    - final_list: Combined and shuffled list (two_finaltag first, then one_finaltag)
    - assigned_mc: The AssignedMC value used for the query
    - total_foods: Total number of foods found
    """
    # from APIs.modules.get_suggestion import (
    #     FoodMCExplorer,
    #     NEO4J_URI,
    #     NEO4J_USER,
    #     NEO4J_PASSWORD,
    #     split_and_shuffle_foods
    # )

    # try:
        # Validate request parameters
        # RequsetChecker(request.POST, [
        #     {
        #         "name": "token",
        #         "format": "^(\S){30}$",
        #         "errorMessage": "توکن اشتباه وارد شده است"
        #     },
        #     {
        #         "name": "food_code",
        #         "format": "^[0-9]+$",
        #         "errorMessage": "food_code باید عدد باشد"
        #     }
        # ], request)

        # token = str(request.POST["token"])
        # food_code = int(request.POST["food_code"])

        # # Authenticate user
        # user_query = User.objects.filter(token=token)
        # if not user_query.exists():
        #     return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        
        # user = user_query[0]
        # profile = user.profile

        # if profile is None:
        #     return myResponse.Error("User profile not found", Errors.LogicalError.code)

        # # Extract diseases from profile._diseases field (stored as "&2&5&" format)
        # # Map disease codes to get_suggestion format
        # disease_code_mapping = {
        #     0: "Diabetes",           # 'دیابت/پیش دیابت'
        #     2: "NAFLD",              # 'کبد چرب'
        #     3: "Hypertension",       # 'فشار خون'
        #     4: "HighCholesterol",    # 'هایپرلیپیدمی/چربی خون'
        #     5: "PCOS",               # 'PCOS'
        #     6: "IBS",                # 'IBS'
        #     9: "IBD",                # 'IBD'
        #     10: "Gout",              # 'Gout'
        #     11: "Kidney",            # 'Kidney Disease'
        #     12: "Celiac",            # 'Celiac'
        #     13: "Anemia",            # 'Anemia'
        #     14: "Hypothyroidism",    # 'Hypothyroidism'
        #     15: "MS",                # 'MS'
        # }

        # disease_list = []
        # if profile._diseases:
        #     # Parse diseases from format "&2&5&" to list of integers
        #     try:
        #         disease_codes = []
        #         for d in profile._diseases.split('&'):
        #             d = d.strip()
        #             if d:
        #                 try:
        #                     disease_codes.append(int(d))
        #                 except ValueError:
        #                     print(f"[API] Invalid disease code in profile._diseases: '{d}'")
        #                     continue
                
        #         for code in disease_codes:
        #             if code in disease_code_mapping:
        #                 disease_list.append(disease_code_mapping[code])
        #     except Exception as e:
        #         print(f"[API] Error parsing diseases from profile: {str(e)}")
        #         # Continue with empty disease list

        # if len(disease_list) == 0:
        #     print(f"[API] No diseases found in user profile for user {user.id}")
        #     # Continue with empty disease list - will only use Healthy_level

        # print(f"[API] Getting food suggestions for food_code: {food_code}, user_id: {user.id}, diseases: {disease_list}")

        # # Create explorer instance
        # explorer = FoodMCExplorer(NEO4J_URI, NEO4J_USER, NEO4J_PASSWORD)

        # try:
        #     # Get AssignedMC for the food code
        #     print(f"[API] Fetching AssignedMC for food_code: {food_code}")
        #     assigned_mc = explorer.get_assigned_mc(food_code)
        #     print(f"[API] AssignedMC: {assigned_mc}")

        #     # Get all foods with same AssignedMC
        #     print(f"[API] Fetching foods with AssignedMC: {assigned_mc}")
        #     foods = explorer.get_foods_by_assigned_mc(assigned_mc)
        #     print(f"[API] Total foods found: {len(foods)}")

        #     # Split and shuffle foods by FINAL_TAG
        #     two_final, one_final, final_list = split_and_shuffle_foods(foods, disease_list)

        #     # Prepare response data
        #     response_data = {
        #         'final_list': final_list,
        #         'assigned_mc': assigned_mc,
        #         'total_foods': len(foods),
        #         'final_list_count': len(final_list),
        #         'input_food_code': food_code,
        #         'disease_list': disease_list,
        #         'user_id': user.id
        #     }

        #     print(f"[API] Returning {len(two_final)} foods with FINAL_TAG=2, {len(one_final)} with FINAL_TAG=1")
        #     return myResponse.OK("توصیه‌های غذایی با موفقیت دریافت شد", response_data)

        # finally:
        #     explorer.close()

    return myResponse.Error("روش درخواست باید POST باشد", -1)


@api_view(["POST"])
def food_list_dislike(request):
    try:
        # Validate request parameters
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "توکن اشتباه وارد شده است"
            },
            {
                "name": "food_code",
                "format": "^[0-9]+$",
                "errorMessage": "food_code باید عدد باشد"
            },
            {
                "name": "action",
                "format": "^(like|dislike)$",
                "errorMessage": "مقدار action باید 'like' یا 'dislike' باشد"
            }
        ], request)

        token = str(request.POST["token"])
        food_code = int(request.POST["food_code"])
        action = str(request.POST["action"])
        
        # Authenticate user
        user_query = User.objects.filter(token=token)
        if not user_query.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        
        
        update_foods(token, [food_code], action)
        return myResponse.OK("غذا با موفقیت ثبت شد", [])
        
    except ValueError as e:
        error_msg = str(e)
        print(f"[API] ValueError in get_food_suggestions_by_mc: {error_msg}")
        return myResponse.Error(f"خطا در دریافت اطلاعات: {error_msg}", Errors.InvalidArgument.code)
    
    except Exception as e:
        error_msg = str(e)
        print(f"[API] Error in get_food_suggestions_by_mc: {error_msg}")
        import traceback
        traceback.print_exc()
        return myResponse.Error(f"خطا در ایجاد توصیه‌ها: {error_msg}", Errors.InternalError.code)
