from .views import *
from django.db.models import Q


# Foods List Apis *******************************************/
@api_view(["POST", "GET"])
def checkFoodUpdate(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "version",
                    "format": "^[-+]?[0-9]{10}$",
                    "errorMessage": "تاریخ یا زمان ورژن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]

            # version_time_stamp = int(request.POST["version"])
            # version = datetime.fromtimestamp(version_time_stamp)
            foods_version = datetime(2000, 1, 1)
            if user.profile.foods_version is None:
                foods_version = datetime(2000, 1, 1)
                user.profile.foods_version = foods_version
                user.profile.save()
            else:
                foods_version = user.profile.foods_version


            data = {}
            last = UpdateTable.objects.filter(Type="foods")[0]

            if foods_version < last.DateTime:
                user.profile.foods_version = last.DateTime
                user.profile.save()
                result = True
                message = "شما باید لیست غذا ها را آپدیت کنید"
            else:
                result = False
                message = "نیازی نیست لیست غذا ها را آپدیت کنید"

            data["result"] = result
            data["version"] = int(last.DateTime.timestamp()) + 10  # 10 is offset to update

            return myResponse.OK(message,  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def foodList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            allFood = Food.objects.all()
            data = []
            for i in range(allFood.count()):
                data.append({
                    "food_name": limitString(allFood[i].FA_Name, 100),
                    "arabic_name": limitString(allFood[i].arabic_Name, 100),
                    "english_name": limitString(allFood[i].english_Name, 100),
                    "food_code": allFood[i].Data_Base_Number,
                    "Name_of_home_units": getHomeUnitElements(allFood[i].Name_of_home_units),
                    # "Weight_of_home_units": getHomeUnitElements(allFood[i].Weight_of_home_units),
                    "Index_of_home_units": getHomeUnitElements(allFood[i].Index_of_home_units),
                    "microbiome_score": allFood[i].microbiome_score,
                    "priority": allFood[i].priority,
                })
            return myResponse.OK("لیست تمام غذا ها",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def addToFavoritFoods(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "food_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست ورزش ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            foods_code_str = str(request.POST["food_code_list"])
            foods_code_list = getList(foods_code_str)
            favorits = user.profile.FavoritFoods
            for code in foods_code_list:
                if not favorits.__contains__("&" + str(int(code))+"&"):
                    favorits += str(int(code)) + "&"
            user.profile.FavoritFoods = favorits
            user.profile.save()
            user.save()
            return myResponse.OK("لیست غذا ها منتخب به روز رسانی شد",  [])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def deleteFromFavoritFoods(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "food_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست ورزش ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            foods_code_str = str(request.POST["food_code_list"])
            foods_code_list = getList(foods_code_str)
            favorits = user.profile.FavoritFoods
            for code in foods_code_list:
                if favorits.__contains__(str(int(code)) + "&"):
                    favorits = favorits.replace(str(int(code)) + "&", "")
                    favorits.replace("&&", "&")
            user.profile.FavoritFoods = favorits
            user.profile.save()
            user.save()
            return myResponse.OK("لیست غذا ها منتخب به روز رسانی شد",  [])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                 Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def FavoritFoods(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            foods_code_str = user.profile.FavoritFoods
            foods_code_list = getList(foods_code_str)
            foods = []
            for i in range(len(foods_code_list)):
                dbNumber = str(foods_code_list[i]).replace(".0", "")

                temp = Food.objects.filter(Data_Base_Number=dbNumber)
                if temp.exists():
                    food = temp[0]
                    foods.append({
                        "name": food.FA_Name,
                        "code": food.Data_Base_Number,
                        "Name_of_home_units": getHomeUnitElements(food.Name_of_home_units),
                        # "Weight_of_home_units": getHomeUnitElements(allFood[i].Weight_of_home_units),
                        "Index_of_home_units": getHomeUnitElements(food.Index_of_home_units),
                    })
            return myResponse.OK("لیست غذاهای منتخب", foods)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidRequest.code)

# Activities List Apis *******************************************/
@api_view(["POST", "GET"])
def activities(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST,[
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            acs = Activity.objects.all()
            data = []
            for i in range(acs.count()):
                data.append({
                    "activity_name": acs[i].name,
                    "activity_code": acs[i].id,
                    "Mets": acs[i].Metz
                })
            return myResponse.OK("لیست تمام فعالیت ها", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def addToFavoritActivities(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "activity_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست فعالیت ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            activity_code_str = str(request.POST["activity_code_list"])
            activities_code_list = getList(activity_code_str)
            favorits = user.profile.FavoritActivities
            for i in range(len(activities_code_list)):
                if not favorits.__contains__("&" + str(int(activities_code_list[i])) + "&"):
                    favorits += str(int(activities_code_list[i])) + "&"
            user.profile.FavoritActivities = favorits
            user.profile.save()
            return myResponse.OK("لیست فعالیت های منتخب به روز رسانی شد",  [])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def deleteFromFavoritActivities(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "activity_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست فعالیت ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            activity_code_str = str(request.POST["activity_code_list"])
            activities_code_list = getList(activity_code_str)
            favorits = user.profile.FavoritActivities
            for i in range(len(activities_code_list)):
                if favorits.__contains__("&" + str(int(activities_code_list[i])) + "&"):
                    favorits = favorits.replace(str(int(activities_code_list[i])) + "&", "")
                    favorits.replace("&&", "&")
            user.profile.FavoritActivities = favorits
            user.profile.save()
            return myResponse.OK("لیست فعالیت های منتخب به روز رسانی شد",  [])
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def favoritActivities(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            activity_code_str = user.profile.FavoritActivities
            activity_code_list = getList(activity_code_str)
            activities = []
            for i in range(len(activity_code_list)):
                if not activity_code_list[i] == "":
                    code = int(activity_code_list[i])
                    temp = Activity.objects.filter(id=code)  # todo : use database number
                    if temp.exists():
                        act = temp[0]
                        activities.append({
                            "name": act.name,
                            "code": act.id,
                            "Mets": act.Metz
                        })
            return myResponse.OK("لیست فعالیت های منتخب کاربر", activities)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)

# Drugs List Apis **************************************************/
@api_view(["POST", "GET"])
def drugList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST,[
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message,Errors.InvalidToken.code)
            allDrug = Drug.objects.all()
            data = []
            for i in range(allDrug.count()):
                data.append({
                    "drug_name": allDrug[i].name,
                    "drug_code": allDrug[i].DataBaseNumber
                })
            return myResponse.OK("لیست تمام داروها",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def FavoritDrugs(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            drug_code_str = user.profile.FavoritDrugs
            drug_code_list = getList(drug_code_str)
            drugs = []
            for i in range(len(drug_code_list)):
                if not drug_code_list[i] == "":
                    code = int(drug_code_list[i])
                    temp = Drug.objects.filter(DataBaseNumber=code)
                    if temp.exists():
                        drug = temp[0]
                        drugs.append({
                            "name": drug.name,
                            "EN_Name": drug.EN_Name,
                            "code": drug.DataBaseNumber,
                        })
            return myResponse.OK("لیست دارو های منتخب کاربر", drugs)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def addToFavoritDrugs(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "drugs_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست دارو ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            drugs_code_str = str(request.POST["drugs_code_list"])
            drugs_code_list = getList(drugs_code_str)
            favorits = user.profile.FavoritDrugs
            for i in range(len(drugs_code_list)):
                if not favorits.__contains__("&" + str(int(drugs_code_list[i])) + "&"):
                    favorits += str(int(drugs_code_list[i])) + "&"
            user.profile.FavoritDrugs = favorits
            user.profile.save()
            return myResponse.OK("لیست دارو های منتخب به روز رسانی شد",  favorits)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def deleteFromFavoritDrugs(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "drugs_code_list",
                    "format": "^(\S)+$",
                    "errorMessage": "لیست فعالیت ها را با فرمت مناسب وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            drugs_code_str = str(request.POST["drugs_code_list"])
            drugs_code_list = getList(drugs_code_str)
            favorits = user.profile.FavoritDrugs
            for i in range(len(drugs_code_list)):
                if favorits.__contains__("&" + str(int(drugs_code_list[i])) + "&"):
                    favorits = favorits.replace("&" + str(int(drugs_code_list[i])) + "&", "&")
                    favorits.replace("&&", "&")
            user.profile.FavoritDrugs = favorits
            user.profile.save()
            return myResponse.OK("لیست دارو های منتخب به روز رسانی شد",  favorits)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message,
                                Errors.InvalidArgument.code)


# insulin List Apis *******************************************/
@api_view(["POST", "GET"])
def insulinList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST,[
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            allInsulin = Insulin.objects.filter(Company="v_98_06_03")
            data = []
            for i in range(allInsulin.count()):
                d = {
                    "insulin_code": allInsulin[i].Data_Base_Number,
                    "insulin_name": allInsulin[i].name
                }
                if allInsulin[i].EffectType == 2:
                    d["insulin_type"] = 'long'
                elif allInsulin[i].EffectType == 1:
                    d["insulin_type"] = 'short'
                else:
                    d["insulin_type"] = 'short/long'
                data.append(d)
            return myResponse.OK("لیست تمام انسولین ها",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.OK(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def short_effect_insulinList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST,[
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            allInsulin = Insulin.objects.filter(EffectType=1, Company="v_98_06_03")
            data = []
            for i in range(allInsulin.count()):
                data.append({
                    "insulin_name": allInsulin[i].name,
                    "insulin_code": allInsulin[i].Data_Base_Number
                })
            return myResponse.OK("لیست انسولین های کوتاه اثر",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST", "GET"])
def long_effect_insulinList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            allInsulin = Insulin.objects.filter(EffectType=2, Company="v_98_06_03")
            data = []
            for i in range(allInsulin.count()):
                data.append({
                    "insulin_name": allInsulin[i].name,
                    "insulin_code": allInsulin[i].Data_Base_Number
                })
            return myResponse.OK("لیست انسولین های بلند اثر",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


@api_view(["POST", "GET"])
def mixed_effect_insulinList(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            allInsulin = Insulin.objects.filter(EffectType=3, Company="v_98_06_03")
            data = []
            for i in range(allInsulin.count()):
                data.append({
                    "insulin_name": allInsulin[i].name,
                    "insulin_code": allInsulin[i].Data_Base_Number
                })
            return myResponse.OK("لیست انسولین های کوتاه/بلند اثر",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


# insulin List Apis *******************************************/
@api_view(["POST", "GET"])
def glp1List(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST,[
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            gpl1s = GLP1.objects.all()
            data = []
            for i in range(gpl1s.count()):
                d = {
                    "GPL1_code": gpl1s[i].DataBaseNumber,
                    "GPL1_name": gpl1s[i].name
                }
                data.append(d)
            return myResponse.OK("لیست تمام GLP1 ها",  data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.OK(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


@api_view(["GET"])
def doctorsList(request):
    if request.method == "GET":
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                }
            ], request)

            token = str(request.GET["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            allDoctors = Doctor.objects.all().order_by("last_name")
            data = []
            for i in range(allDoctors.count()):
                data.append({
                    "name": allDoctors[i].first_name + " " + allDoctors[i].last_name,
                    "id": allDoctors[i].id
                })
            return myResponse.OK("لیست تمام دکتر ها به ترتیب حروف الفبا",  data)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


@api_view(["POST"])
def notifications(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "number",
                    "format": "^[\d]+$",
                    "errorMessage": "تعداد را وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            number = int(request.POST["number"])

            temp = Notification.objects.all().order_by("-datetime")
            data = []
            limitation = min(temp.count(), number)
            for i in range(limitation):
                data.append({
                    "id": temp[i].id,
                    "title": temp[i].Title,
                    "Link": temp[i].Link,
                    "summary": temp[i].Summary,
                    "datetime": temp[i].datetime.timestamp()
                })
            return myResponse.OK("لیست پیام ها", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)

@api_view(["POST"])
def getRandomInfo(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن اشتباه وارد شده است"
                },
                {
                    "name": "type",
                    "format": ".",
                    "errorMessage": "type اشتباه وارد شده است"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            tag = str(request.POST["type"])
            DIs = DiabetesInfo.objects.filter(is_Conditional=False, Tags__icontains=tag)  # Tags__icontains to filter like records
            if DIs.exists():
                rand = int(datetime.now().timestamp()) % int(DIs.count())
                dinfo = DIs[rand]
            else:
                DIs = DiabetesInfo.objects.filter(is_Conditional=False, Tags__icontains="Food")
                rand = int(datetime.now().timestamp()) % int(DIs.count())
                dinfo = DIs[rand]

            dinfo.NumberOfFetched += 1
            dinfo.save()

            data = {
                "info": dinfo.info,
                "Number": dinfo.NumberOfFetched,
            }
            return myResponse.OK("اطلاعات دیابتی رندوم", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


@api_view(["POST", "GET"])
def get_drugstore_list(request):
    if request.method == "GET":
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن نامعتبر است"
                },
                {
                    "name": "phone_number",
                    "required": False,
                    "format": "^09[0-9]{9}$",
                    "errorMessage": "شماره تلفن نامعتبر است"
                },

            ], request)

            token = str(request.GET["token"])
            # phone = str(request.POST["phone_number"])
            # temp = User.objects.filter(token=token, phone_number=phone)
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            drugstores = Drugstore.objects.all()
            data = []
            for drugstore in drugstores:
                data.append({
                    "Name": drugstore.Name,
                    "Province_fa": drugstore.Province_fa,
                    "City_fa": drugstore.City_fa,
                    "Phone": drugstore.Phone,
                    "Address": drugstore.Address,
                })
            return myResponse.OK("drugstore list", data=data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(Errors.DrugstoreListProblem.message, Errors.DrugstoreListProblem.code)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


