# USAGE
# python find_screen.py --query queries/query_marowak.jpg

# import the necessary packages
from skimage import exposure
import numpy as np
import argparse
import imutils
import cv2
from .views import *
from ziluck_project.settings import BASE_DIR, STATIC_ROOT
from APIs.models import models
import json


def default(o):
    if isinstance(o, (date, datetime)):
        return o.isoformat()

def getAverage(area):
    s = 0
    counter = 0
    r = float(len(area[0]) / 2) + 1
    # r2 = r ** 2
    for i in range(len(area)):
        line = area[i]
        for j in range(len(line)):
            # if i ** 2 + j ** 2 < r2:
            if (i < r) and (j < r):
                s += line[j]
                counter += 1
    if counter > 0:
        return int(s / counter)
    else:
        return -1


def filter(img):
    s = 0
    counter = 0
    for i in range(int(len(img) * 0.73), int(len(img) * 0.83), 1):
        line = img[i]
        for j in range(len(line)):
            rgb = line[j]
            srgb = 1 * int(rgb[0]) + 1 * int(rgb[1]) + 1 * int(rgb[2])
            s += srgb / 3
            counter += 1

    avr = s / counter
    limit = 3 * avr / 4
    for i in range(int(len(img) / 2), int(len(img) * 0.87), 1):
        line = img[i]
        for j in range(int(len(line) * 0.145), len(line), 1):
            rgb = line[j]
            # if (rgb[2] > limit) and (rgb[0] > limit) and (rgb[1] > limit):
            if ((rgb[0] ** 2) + (rgb[1] ** 2) + (rgb[2] ** 2)) > (limit) ** 2:
                img[i, j] = [255, 255, 255]
    return img


@api_view(["POST", "GET"])
def freeStyle(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "توکن را درست وارد کنید"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$",
            #     "errorMessage": "شماره تلفن را درست وارد کنید 0900"
            # }
        ], request)

        token = str(request.POST["token"])
        # phone = str(request.POST["phone_number"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        user = temp[0]

        if request.FILES == {}:
            return myResponse.Error(Errors.InsertPic.message, Errors.InsertPic.code)
        f = request.FILES["image"]

        # now save image.jpg file in the server...
        extention = ".jpg"
        freeStylePath = BASE_DIR + '/static/assets/freeStyle'
        name = str(user.phone_number) + "_" + datetime.now().strftime("%Y_%m_%d_%H_%M_%S")
        newFile = freeStylePath + "/original/" + name + extention

        with open(newFile, 'wb+') as destination:
            for chunk in f.chunks():
                destination.write(chunk)
        destination.close()

        if os.path.getsize(newFile) < 1:  # temp file!
            os.remove(newFile)
            return myResponse.Error("empty file!!", -1)

        image = cv2.imread(newFile)
        ratio = image.shape[0] / 300.0

        orig = image.copy()
        image = imutils.resize(image, height=300)

        # convert the image to grayscale, blur it, and find edges
        # in the image
        gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)
        # hsv = cv2.cvtColor(image, cv2.COLOR_BGR2HSV)
        gray = cv2.bilateralFilter(gray, 11, 17, 17)
        edged = cv2.Canny(gray, 30, 200)

        # find contours in the edged image, keep only the largest
        # ones, and initialize our screen contour
        cnts = cv2.findContours(edged.copy(), cv2.RETR_TREE, cv2.CHAIN_APPROX_SIMPLE)
        cnts = imutils.grab_contours(cnts)

        cnts = sorted(cnts, key=cv2.contourArea, reverse=True)[:10]
        screenCnt = None

        # loop over our contours
        for c in cnts:
            # approximate the contour
            peri = cv2.arcLength(c, True)
            approx = cv2.approxPolyDP(c, 0.015 * peri, True)

            # if our approximated contour has four points, then
            # we can assume that we have found our screen
            if len(approx) == 4:
                screenCnt = approx
                break

        # now that we have our screen contour, we need to determine
        # the top-left, top-right, bottom-right, and bottom-left
        # points so that we can later warp the image -- we'll start
        # by reshaping our contour to be our finals and initializing
        # our output rectangle in top-left, top-right, bottom-right,
        # and bottom-left order
        pts = screenCnt.reshape(4, 2)
        rect = np.zeros((4, 2), dtype="float32")

        # the top-left point has the smallest sum whereas the
        # bottom-right has the largest sum
        s = pts.sum(axis=1)
        rect[0] = pts[np.argmin(s)]
        rect[2] = pts[np.argmax(s)]

        # compute the difference between the points -- the top-right
        # will have the minumum difference and the bottom-left will
        # have the maximum difference
        diff = np.diff(pts, axis=1)
        rect[1] = pts[np.argmin(diff)]
        rect[3] = pts[np.argmax(diff)]

        # multiply the rectangle by the original ratio
        rect *= ratio

        # now that we have our rectangle of points, let's compute
        # the width of our new image
        (tl, tr, br, bl) = rect
        widthA = np.sqrt(((br[0] - bl[0]) ** 2) + ((br[1] - bl[1]) ** 2))
        widthB = np.sqrt(((tr[0] - tl[0]) ** 2) + ((tr[1] - tl[1]) ** 2))

        # ...and now for the height of our new image
        heightA = np.sqrt(((tr[0] - br[0]) ** 2) + ((tr[1] - br[1]) ** 2))
        heightB = np.sqrt(((tl[0] - bl[0]) ** 2) + ((tl[1] - bl[1]) ** 2))

        # take the maximum of the width and height values to reach
        # our final dimensions
        maxWidth = max(int(widthA), int(widthB))
        maxHeight = max(int(heightA), int(heightB))

        # construct our destination points which will be used to
        # map the screen to a top-down, "birds eye" view
        dst = np.array([
            [0, 0],
            [maxWidth - 1, 0],
            [maxWidth - 1, maxHeight - 1],
            [0, maxHeight - 1]], dtype="float32")

        # calculate the perspective transform matrix and warp
        # the perspective to grab the screen
        M = cv2.getPerspectiveTransform(rect, dst)
        warp = cv2.warpPerspective(orig, M, (maxWidth, maxHeight))

        # remove blue color from image
        warp = filter(warp)

        # convert the warped image to grayscale and then adjust
        # the intensity of the pixels to have minimum and maximum
        # values of 0 and 255, respectively
        warp = cv2.cvtColor(warp, cv2.COLOR_BGR2GRAY)
        warp = exposure.rescale_intensity(warp, out_range=(0, 255))

        # the pokemon we want to identify will be in the top-right
        # corner of the warped image -- let's crop this region out
        (h, w) = warp.shape
        # (dX, dY) = (int(w * 1), int(h * 0.5))
        # crop = warp[dY:2 * dY, w - dX:w]
        crop = warp[int(0.545 * h): int(0.87 * h), int(0.145 * w):w]

        detectionArray = []
        margin = 2
        for i in range(0, len(crop) - margin, margin):
            for j in range(0, len(crop[0]) - margin, margin):

                av = getAverage(crop[i:i + margin, j: j + margin])
                if av < 190:
                    x = round(((j + margin / 2) / len(crop[0])) * 10.2, 1)
                    y = int(((len(crop) - i - (margin / 2)) / len(crop)) * 300 + 60)
                    # print("dot in ({i},{j})".format(i=x, j=y))
                    detectionArray.append({
                        "x": x,
                        "y": y
                    })

        SortedDetectionArray = sorted(detectionArray, key=lambda d: d["x"])
        XX = []
        YY = []
        for item in SortedDetectionArray:
            XX.append(item["x"])
            YY.append(item["y"])

        FineX = []
        FineY = []
        window = 0.1  # be care full on change this.
        for i in range(0, 200, 1):
            l = i / 20
            r = l + window
            data = []
            for item in SortedDetectionArray:
                if l <= item["x"] <= r:
                    data.append(item["y"])
            if len(data) > 0:
                m = np.mean(data)
                FineX.append(round((l + r) / 2, 2))
                FineY.append(int(m))

        # print("fin x:", FineX)
        # print("fin y:", FineY)

        SM = []
        # y2 = []
        # x2 = []
        minute = int((datetime.now().minute / 60) * 4) * 15
        now = datetime.now()
        lastTime = datetime.combine(now.date(), time(hour=now.hour, minute=minute, second=0))
        quarters = 0

        for i in range(40):
            left = (i / 4) - (window / 2)
            right = (i / 4) + (window / 2)

            counter = 0
            s = 0
            for j in range(len(FineX)):
                if left <= FineX[j] <= right:
                    s += FineY[j]
                    counter += 1
            if counter > 0:
                amount = round(s / counter)
                quarters = i  # maximum time
                SM.append({
                    "amount": amount,
                    "i": i,
                    "time": None,
                })

                # x2 = x2 + [i/4]
                # y2 = y2 + [amount]

        # save SM to database
        for item in SM:
            t = lastTime - timedelta(minutes=15 * (quarters - item.get("i")))
            item.update(time=t)
            su = SugarMeasurement(user=user)
            amount = item.get("amount")
            su.amount = amount
            su.time = t
            if amount < user.profile.hypo:
                su.hypo = True
            elif amount > user.profile.hyper:
                su.hyper = True
            su.meal = MEAL[t.hour]
            su.save()




        cv2.imwrite(freeStylePath + "/croped/" + name + extention, crop)
        cv2.imwrite(freeStylePath + "/warp/" + name + extention, warp)
        f = open(freeStylePath + "/detection/" + name + ".log", 'a+')
        json.dump(SM, fp=f, default=default)
        f.close()

        return myResponse.OK("عملیات با موفقیت انجام شد", SM)

    except Exception as e:
        return myResponse.Error(e.args, Errors.FreeStyleProblem.code)
    except ValueError as e:
        return myResponse.Error(e.args, Errors.FreeStyleProblem.code)


