from panel.PushNotification import PushNotification
from panel.models import FirebaseNotification
from ziluck_project import settings
from APIs.views.views import myResponse
from datetime import timedelta
from APIs.models import *
import firebase_admin
from firebase_admin import messaging
from firebase_admin import credentials
from pyfcm import FCMNotification
from APIs.views.views import send_sms
from django.db.models import Q
from django.views.decorators.csrf import csrf_exempt
from rest_framework.decorators import api_view
import requests
from ziluck_project.constants import FIREBASE_API_KEY, SMS_API_URL, FIREBASE_PROJECT_ID_ziluck, FIREBASE_SERVICE_ACCOUNT_FILE_ziluck, FIREBASE_SERVICE_ACCOUNT_FILE_Lacto, FIREBASE_PROJECT_ID_Lacto
import logging


def testFireBase(request):
    path_to_serviceAccountKey = settings.BASE_DIR + "/static/fire_base/mmmmm-13a45-firebase-adminsdk-1t5ew-7b9e4bf9ef.json"
    # return myResponse.OK(path_to_serviceAccountKey,[])
    cred = credentials.Certificate(path_to_serviceAccountKey)
    a = firebase_admin.initialize_app(cred)
    registration_token = 'cENhy-0rRkKqkzOjfuqNZ-:APA91bGC8Db3KC-X3jQh2GpJhSvro39ncVQ9k-S2iFZPVLxzvolVzZ1eiCtQvuZxrt29uahUKPVlus_FPv-kpAlTjqdojPm7LJ6DkvNE1Bh50-JLRBzkfJ__SCHD64BEzwNmAdcACBGA'
    message = messaging.Message(data={
        'score': '850',
        'time': '2:45',
    }, token=registration_token)
    response = messaging.send(message)
    return myResponse.OK("ok", str('Successfully sent message: ' + str(response)))


def test2(request):
    push_service = FCMNotification(
        api_key=FIREBASE_API_KEY)
    # registration_id = "cENhy-0rRkKqkzOjfuqNZ-:APA91bGC8Db3KC-X3jQh2GpJhSvro39ncVQ9k-S2iFZPVLxzvolVzZ1eiCtQvuZxrt29uahUKPVlus_FPv-kpAlTjqdojPm7LJ6DkvNE1Bh50-JLRBzkfJ__SCHD64BEzwNmAdcACBGA"
    u = User.objects.filter(phone_number="09217761645")[0]
    p = u.profile
    registration_id = p.firebase_token
    # registration_id = "12"
    message_title = "سلام " + p.first_name + "!"
    message_body = "یک هفته هست که هیچ فعالیتی در آیدیا نداشتی! برای این که آیدیا بتونه بهت کمک کنه به اطلاعاتی که ثبت میکنی احتیاج داره!"
    extra_notification_kwargs = {
        'image': "https://idia.app/wp-content/uploads/2020/03/idia-Leaderboard-1.png",
        # paste your notification image url here
        'click_action': "https://idia.app"
    }
    result = push_service.notify_single_device(registration_id=registration_id, message_title=message_title,
                                               message_body=message_body,
                                               extra_notification_kwargs=extra_notification_kwargs,
                                               click_action="https://idia.app")

    return myResponse.OK("ok", str('Successfully sent message: ' + str(result)))


@csrf_exempt
def send_notification_to_not_active_last_week(request):
    t0 = datetime.now()
    user = str(request.POST["user"])
    password = str(request.POST["password"])
    temp = Admins.objects.filter(UserName=user, PassWord=password)
    if temp.count() == 0:
        return myResponse.OK("auth failed!", [])

    sending_list = []
    users = User.objects.filter(
        (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True))
    data = {
        "counter": 0
    }
    for u in users:
        # if u.isRegistered:
        # if len(str(u.profile.firebase_token)) > 10:
        temp = Points.objects.filter(user=u, date__gt=(date.today() - timedelta(days=7)))
        if temp.count() == 0:
            sending_list.append(u.profile.firebase_token)
            data["counter"] += 1

    push_service = FCMNotification(
        api_key=FIREBASE_API_KEY)

    message_title = "سلام " + "!"
    message_body = "یک هفته هست که هیچ فعالیتی در لاکتو نداشتی! برای این که لاکتو بتونه بهت کمک کنه به اطلاعاتی که ثبت میکنی احتیاج داره!"

    # sending_list = []  # Comment out this line to disable message sending.

    # add admin token
    temp = User.objects.filter(phone_number="09217761645")
    if temp.exists():
        hossein = temp[0]
        sending_list.append(str(hossein.profile.firebase_token))

    result = push_service.notify_multiple_devices(registration_ids=sending_list, message_title=message_title,
                                                  message_body=message_body)

    # send message to admin ...
    url = SMS_API_URL
    querystring = {"receptor": "09910412375",
                   "message": "The following message was sent to " + str(
                       len(sending_list)) + " people via notification:\n\n" + message_body}
    sms = requests.request("POST", url, params=querystring)

    t1 = datetime.now()
    data["execution_time"] = t1.timestamp() - t0.timestamp()
    data["result"] = result
    data["sms"] = sms
    return myResponse.OK("ok", data)


def send_notification_note(user, message):
    try:
        registration_id = user.profile.firebase_token
        if not registration_id:
            logging.error("User does not have a valid Firebase token.")
            return

        message_title = f"{user.profile.first_name} پیام جدید از مربی"

        # Using the `send_notification_to` method to send notifications
        result = PushNotification(user).send_notification_to(registration_id, message_title, message)
        logging.info(f"Firebase result: {result}")

        # Check for error details in the result
        if 'error' in result:
            logging.error(f"Notification failed. Error details: {result['error']}")
        else:
            # No error, assume success
            logging.info("Notification sent successfully.")
            notification = FirebaseNotification(
                title=message_title,
                body=message,
                datetime=datetime.now(),
                user=user
            )
            notification.save()

    except Exception as e:
        logging.error(f"Error sending notification: {str(e)}")


def send_notification(user, message):
    try:
        # Determine which Firebase project to use based on user profile version
        if user.profile.version:
            push_service = FCMNotification(
                project_id=FIREBASE_PROJECT_ID_ziluck,
                service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_ziluck
            )
        else:
            push_service = FCMNotification(
                project_id=FIREBASE_PROJECT_ID_Lacto,
                service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_Lacto
            )

        registration_id = user.profile.firebase_token
        message_title = "سلام " + user.profile.first_name + "!"

        result = push_service.notify(
            fcm_token=registration_id,
            notification_title=message_title,
            notification_body=message
        )
        logging.info(f"Notification sent: {result}")

    except Exception as e:
        logging.error(f"Error sending notification: {str(e)}")


@api_view(["POST"])
def send_notification_with_link_to_all(request):
    user = str(request.POST["user"])
    password = str(request.POST["password"])
    temp = Admins.objects.filter(UserName=user, PassWord=password)
    if temp.count() == 0:
        return myResponse.OK("auth failed!", [])

    push_service = FCMNotification(
        api_key=FIREBASE_API_KEY)  # ziluck api_key

    profiles = Profile.objects.filter(~Q(firebase_token=None))

    registration_ids = []
    for p in profiles:
        if len(p.firebase_token) > 10:
            registration_ids.append(p.firebase_token)

    if request.POST["title"] == "" or request.POST["message"] == "" or request.POST["link"] == "":
        return myResponse.Error("title/message/link is empty!", [])
    data_message = {
        "title": request.POST["title"],
        "body": request.POST["message"],
        "link": request.POST["link"]
    }
    result = push_service.multiple_devices_data_message(registration_ids=registration_ids, data_message=data_message)
    data = {}
    data["result"] = result
    data["length"] = len(registration_ids)
    return myResponse.OK("data", data)
