from .views import *
from APIs.models import Diet
import requests


@api_view(["POST", "GET"])
def diet(request):
    """
    GET: If you specify a date, it will return the diet for the week
         that starts with this date. Otherwise, it returns the last
         diet and if there is no diet, it returns an empty dictionary.
    :param request:
    :return:
    """
    if request.method == "GET":
        try:
            RequsetChecker(request.GET, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                {
                    "name": "start_date",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    "required": False,
                    "errorMessage": "زمان شروع اشتباه وارد شده است"
                }

            ])
        except Exception as e:
            return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

        token = str(request.GET["token"])
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        user = temp[0]

        if "start_date" in request.GET:
            dt = datetime.fromtimestamp(int(request.GET["start_date"]))
            diets = Diet.objects.filter(user=user, from_date=dt.date())
        else:
            diets = Diet.objects.filter(user=user).order_by("-from_date")

        if diets.exists():
            data = {
                "diets": diets[0].diet_json
            }
            return myResponse.OK("diet", data)
        else:
            return myResponse.OK("no diets found", {})

    elif request.method == "POST":
        pass
