class Errors:
    class InvalidToken:
        message = 'The token or phone number is not valid.'
        code = 1003

    class InvalidActivationCode:
        message = 'The activation code is not valid. Be careful when entering the code!'
        code = 1003.1

    class ErrorInSMS:
        message = 'Problem sending SMS'
        code = 1003.2

    class RegisteredLast:
        message = 'You are already registered, just log in!'
        code = 1003.3

    class TempTokenNotExist:
        message = 'Your activation code has expired. You must receive the activation code again'
        code = 1003.4

    class Try_a_few_seconds_later:
        message = 'You have recently received an activation code. Use the same code, or if you haven not received the code, try again one minute later'
        code = 1003.5

    class ErrorInEmail:
        message = 'Problem sending email'
        code = 1003.6

    class InvalidRequest:
        message = 'The request is unauthorized'
        code = 1004

    class InvalidArgument:
        message = "Invalid input, not authorized"
        code = 1005

    class DataNotFound:
        message = ''
        code = 1006

    class InternalError:
        message = 'Internal server error'
        code = 1007

    class InvalidFoodId:
        message = "The food code entered is not valid"
        code = 1008

    class InvalidInsulinId:
        message = "There are no short-acting or long-acting insulins"
        code = 1009

    class InvalidDrugId:
        message = 'The drug code is invalid'
        code = 1010

    class InvalidGLP1Id:
        message = 'The GLP1 code is invalid'
        code = 1010.1

    class NotSellectedGLP1:
        message = "You have not selected your GLP1"
        code = 1010.2

    class InvalidActivity:
        message = "There is no activity with this code"
        code = 1011

    class LogicalError:
        message = "Inconsistency in the data sent"
        code = 1012

    class NoDataSavedForThisDay:
        message = "No information has been recorded for this day"
        code = 1013

    class WrongUserPassWord:
        message = "The username or password is incorrect"
        code = 1014

    class NoAccessToEdit:
        message = "You are not allowed to change"
        code = 1015

    class ErrorInExcelFile:
        message = "Error in Excel file"
        code = 1016

    class NotFoundProfile:
        message = "Since you have not completed the file before, you must register from the beginning"
        code = 1017

    class InvalidMealId:
        message = "The promise code entered is not valid"
        code = 1018

    class NotFoundUser:
        message = "There is no such user or the profile information is incomplete"
        code = 1019

    class CommentsPerDayLimit:
        message = "You can post 10 comments every day"
        code = 1020

    class BadMessageText:
        message = "The text of the message is not correct!"
        code = 1021

    class BadMessageTitle:
        message = "The topic is wrong"
        code = 1022

    class HaveNotMessage:
        message = "You have no new messages"
        code = 1024

    class NotAnsweredMessage:
        message = "You will be answered soon. Thank you for your patience. iDia"
        code = 1025

    class NotFoundDoctor:
        message = "The doctor was not found"
        code = 1026

    class InsertPic:
        message = "No photo has been selected!"
        code = 1027

    class InvalidFirstName:
        message = "The name is not entered correctly"
        code = 1028

    class InvalidLastName:
        message = "The last name is not entered correctly"
        code = 1029

    class InvalidDevice_type:
        message = "The device type is not entered correctly"
        code = 1030

    class Already_Selected:
        message = "You have already selected the reagent and it is not possible to change it"
        code = 1031

    class No_Such_Intro_User:
        message = "There is no such introduction. Modify the identification code"
        code = 1032

    class InvalidVersion:
        message = "The prescription was not entered correctly"
        code = 1033

    class NotFoundItem:
        message = "There is no such item!"
        code = 1034

        def create(self):
            return (self.message, self.code)

    class BadTiltle:
        message = "Please enter a suitable title"
        code = 1050
    class BadLink:
        message = "Please enter a suitable link"
        code = 1051
    class DrugstoreListProblem:
        message = "There was a problem getting the list of pharmacies"
        code = 1052

    class FreeStyleProblem:
        message = "Freestyle device image processing operation encountered, please try again"
        code = 1090

    class UnselectedTherapist:
        message = "The healer has not been selected"
        code = 1201

    class UnselectedAttachment:
        message = "Attachment is not selected"
        code = 1202

    class InvalidDoctor:
        message = "The doctor ID is not selected correctly"
        code = 1203

    class CreditLeft:
        message = "Your account is over and you need to top up your account again."
        code = 1204

    class FeatureNotAvailable:
        message = "ارسال پیام در پلن شما امکان‌پذیر نمی‌باشد."
        code = 1205

    # payment
    class InvalidNationalCode:
        message = 'The entered national code is not correct!'
        code = 1301

    class IsPaid:
        message = 'You have already paid!'
        code = 1302

    class DietExpired:
        message = 'the diet is expired!'
        code = 1303

    class InvalidUser:
        message = 'This username or passowrd is invalid!'
        code = 1304

    class ItemAlreadyPurchased:
        message = 'You have already purchased this item.'
        code = 1305

    class InsufficientCoins:
        message = 'You do not have enough coins to buy the item.'
        code = 1306

    class Unauthorized:  # Add this
        message = "Unauthorized action"
        code = 1307  # Choose a unique code (e.g., 1003)
    
    class InvalidHospitalAPIKey:
        message = 'The hospital API key is not valid.'
        code = 1308

    class InvalidPlanID:
        message = 'The plan ID is not valid.'
        code = 1309
        
    class DiscountCodeNotDefinedForHospital:
        message = 'The discount code is not defined for this hospital.'
        code = 1310