from .views import *
from django.db.models import Q


@api_view(["POST"])
def delete_eating(request):
    if request.method == "POST":
        try:
            # Check input format
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن نامعتبر است"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$",
                #     "errorMessage": "شماره تلفن نامعتبر است"
                # },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            # Verify user authentication
            token = str(request.POST.get("token"))
            # phone = request.POST["phone_number"]
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            id = int(request.POST.get("id"))

            temp = Eating.objects.filter(id=id, user=user)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)

            # now remove effect
            item = temp[0]

            record_date = item.date_time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            meal = item.meal
            Carbohydrates_used = (item.amount / 100) * item.food.Carbohydrates_g
            Protein_used = (item.amount / 100) * item.food.Protein_g
            Fat_used = (item.amount / 100) * item.food.Fat_g
            Calorie_used = (item.amount / 100) * item.food.Calories
            HEI_elements_i = getHEI_List(item.food, item.amount)

            # toggle the list  x ----> -x
            HEI_elements_i = list(map(lambda x: -x, HEI_elements_i))

            Carbohydrates_list_to_use = getList(user.profile.Carbohydrates_distribution_list_g)
            Fat_to_use = user.profile.Fat_distribution_g
            Protein_to_use = user.profile.Protein_distribution_g

            # Carbohydrates calculations
            this_day_Carbohydrates_point = getList(record.this_day_Carbohydrates_point)
            this_day_Carbohydrates_g = getList(record.this_day_Carbohydrates_g)
            this_day_Carbohydrates_g[meal] -= Carbohydrates_used
            if this_day_Carbohydrates_g[meal] < 0:
                this_day_Carbohydrates_g[meal] = 0
            record.this_day_Carbohydrates_g = listToStr(this_day_Carbohydrates_g)
            this_day_Carbohydrates_point[meal] = normalize(
                this_day_Carbohydrates_g[meal] / Carbohydrates_list_to_use[meal])
            record.this_day_Carbohydrates_point = listToStr(this_day_Carbohydrates_point)
            totalCarboControl = myListSum(this_day_Carbohydrates_point) / len(this_day_Carbohydrates_point)
            record.totalCarboControlPoint = totalCarboControl

            # Fat calculations
            this_day_Fat_g = getList(record.this_day_Fat_list_g)
            this_day_Fat_g[meal] -= Fat_used
            if this_day_Fat_g[meal] < 0:
                this_day_Fat_g[meal] = 0
            record.this_day_Fat_list_g = listToStr(this_day_Fat_g)
            this_day_Fat_list_point = getList(record.this_day_Fat_list_point)
            this_day_Fat_list_point[meal] = normalize(this_day_Fat_g[meal] / Fat_to_use)
            record.this_day_Fat_list_point = listToStr(this_day_Fat_list_point)

            # Protein calculations
            this_day_Protein_list_g = getList(record.this_day_Protein_list_g)
            this_day_Protein_list_g[meal] -= Protein_used
            if this_day_Protein_list_g[meal] < 0:
                this_day_Protein_list_g[meal] = 0
            record.this_day_Protein_list_g = listToStr(this_day_Protein_list_g)
            this_day_Protein_list_point = getList(record.this_day_Protein_list_point)
            this_day_Protein_list_point[meal] = normalize(this_day_Protein_list_g[meal] / Protein_to_use)
            record.this_day_Protein_list_point = listToStr(this_day_Protein_list_point)

            # Calorie Calculations
            total_Calories_used = record.total_Calories_used - Calorie_used
            if total_Calories_used < 0:
                total_Calories_used = 0
            record.total_Calories_used = total_Calories_used
            record.total_Calories_Point = normalize(total_Calories_used / user.profile.CR)
            record.save()

            # HEI elements used and calculations ...
            # HEI_elements_used = getHEI_List(food, amount)  #
            Last_HEI_elements = getList(record.HEI_elements_list)
            sum_Of_HEI_elements = myListAdder(Last_HEI_elements, HEI_elements_i)
            for i in range(len(sum_Of_HEI_elements)):
                if sum_Of_HEI_elements[i] < 0:
                    sum_Of_HEI_elements[i] = 0
            total_HEI_Point = HEI_Point_Calculator(sum_Of_HEI_elements,
                                                   record.total_Calories_used)
            record.HEI_elements_list = listToStr(sum_Of_HEI_elements)
            record.total_HEI_Point = total_HEI_Point

            # now delete the item
            Eating.objects.filter(id=id).delete()

            # update and save changes
            record.save()
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            data = {
                "DayPoint": totalPoint,
            }

            # Send the result
            return myResponse.OK("حذف با موفقیت انجام شد", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def delete_sugar(request):
    if request.method == "POST":
        try:
            # Check input format
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن نامعتبر است"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$",
                #     "errorMessage": "شماره تلفن نامعتبر است"
                # },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            # Verify user authentication
            token = str(request.POST.get("token"))
            # phone = request.POST["phone_number"]
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            id = int(request.POST.get("id"))

            temp = SugarMeasurement.objects.filter(id=id, user=user)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)

            # now remove effect
            item = temp[0]

            record_date = item.time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            if record.HypoHyperNumber == 0:
                record.totalHypoHyperControlPoint = 1

            if (item.amount > user.profile.hyper) or (item.amount < user.profile.hypo):
                HPs = record.HypoHyperNumber - 1  # may be zero
                record.HypoHyperNumber = HPs
                if HPs == 0:  # may be zero
                    record.totalHypoHyperControlPoint = 0.6
                if HPs == 1:
                    record.totalHypoHyperControlPoint = 0.6
                elif HPs == 2:
                    record.totalHypoHyperControlPoint = 0.2
                else:
                    record.totalHypoHyperControlPoint = 0

            sugarList = getList(record.sugar_point_list_y)
            sugarList[item.meal] = 0
            record.sugar_point_list_y = listToStr(sugarList)

            SumSugarList = sum(sugarList)
            record.totalSugarControlPoint = round(min(1, SumSugarList / 30), 2)

            record.save()
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            # now delete the item
            SugarMeasurement.objects.filter(id=id).delete()

            data = []
            # Send the result
            return myResponse.OK("حذف با موفقیت انجام شد", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def edit_sugar(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "time",
                    "format": "^[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند"
                },
                {
                    "name": "amount",
                    "format": "^[\d]+$",
                },
                {
                    "name": "meal",
                    "format": "^[\d]+$",
                    "required": False
                },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            token = str(request.POST.get("token"))
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            id = int(request.POST.get("id"))
            temp = SugarMeasurement.objects.filter(user=user, id=id)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            item = temp[0]

            amount = int(request.POST.get("amount"))
            dt = datetime.fromtimestamp(int(request.POST.get("time")))

            if not (request.POST.get("meal") is None):
                meal = int(request.POST.get("meal"))
            else:
                meal = MEAL[dt.hour]

            record_date = dt.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            if record.HypoHyperNumber == 0:
                record.totalHypoHyperControlPoint = 1

            if ((amount > user.profile.hyper) or (amount < user.profile.hypo)) and (not (item.hyper or item.hypo)):
                HPs = record.HypoHyperNumber + 1
                record.HypoHyperNumber = HPs
                if HPs == 1:
                    record.totalHypoHyperControlPoint = 0.6
                elif HPs == 2:
                    record.totalHypoHyperControlPoint = 0.2
                else:
                    record.totalHypoHyperControlPoint = 0

            sugarList = getList(record.sugar_point_list_y)
            y = 0
            if meal == 0:
                x = amount / 120
                if x < 0.6 or x > 1.5:
                    y = 0
                elif x <= 1 and x >= 0.6:
                    y = 10
                elif x > 1 and x < 1.5:
                    y = (1.5 - x) * 20
                sugarList[meal] = y
            elif meal == 1 or meal == 3 or meal == 5:
                x = amount / 180
                if x < 0.45 or x >= 1.4:
                    y = 0
                elif x >= 0.45 and x <= 1:
                    y = 4
                elif x > 1 and x < 1.4:
                    y = (1.4 - x) * 8
                sugarList[meal] = y
            elif meal == 2 or meal == 4:
                x = amount / 120
                if x < 0.6 or x > 1.5:
                    y = 0
                elif x <= 1 and x >= 0.6:
                    y = 4
                elif x > 1 and x <= 1.5:
                    y = (1.5 - x) * 8
                sugarList[meal] = y
            record.sugar_point_list_y = listToStr(sugarList)

            SumSugarList = sum(sugarList)
            record.totalSugarControlPoint = round(min(1, SumSugarList / 30), 2)

            record.save()
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            hyper = False
            if amount > user.profile.hyper:
                hyper = True
            hypo = False
            if amount < user.profile.hypo:
                hypo = True

            # edit and save item
            item.hyper = hyper
            item.hypo = hypo
            item.time = dt
            item.amount = amount
            item.meal = meal
            item.point = totalPoint
            item.save()

            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("بروزرسانی انجام شد", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def delete_actiity(request):
    try:
        RequsetChecker(request.POST, [
            {
                "name": "token",
                "format": "^(\S){30}$",
                "errorMessage": "توکن نامعتبر است"
            },
            # {
            #     "name": "phone_number",
            #     "format": "^09[0-9]{9}$",
            #     "errorMessage": "شماره تلفن نامعتبر است"
            # },
            {
                "name": "id",
                "format": "^[0-9]+$",
                "errorMessage": "id معتبر نیست"
            },
        ]
                       , request)

        # Verify user authentication
        token = str(request.POST.get("token"))
        # phone = request.POST["phone_number"]
        temp = User.objects.filter(token=token)
        if not temp.exists():
            return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
        user = temp[0]
        id = int(request.POST.get("id"))

        acts = Activities_log.objects.filter(id=id, user=user)
        if not acts.exists():
            return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)

        # now remove side effects
        item = acts[0]

        amount = item.amount
        activity = item.activity

        record_date = item.start_date_time.date()
        p = Points.objects.filter(user=user, date=record_date)
        if p.exists():
            record = p[0]
        else:
            return myResponse.OK("فعالیت حذف شد", [])

        Metz = activity.Metz
        A = (Metz - 1) * ((1.15 / 0.9) * amount) / 1440
        BMR = user.profile.BMR
        B = BMR / (0.0175 * 1440 * user.profile.weight)
        PALx = round(A / B, 5)
        PALX = record.PALX - PALx
        if PALX < 0:
            PALX = 0
        record.PALX = PALX
        y = 0
        if PALX <= 1.1:
            y = 0
        elif PALX > 1.8:
            y = 1
        else:
            y = PALX / 1.8

        record.total_Activity_Point = y
        record.save()
        # now delete the activity
        Activities_log.objects.filter(id=id).delete()

        # update points after delete the activity
        u = updateTotalPointDay(user, record)
        totalPoint = u["DayPoint"]
        record.total_points = totalPoint
        record.totalCooperationPoints = u["totalCooperate"]
        record.save()
        data = {}
        return myResponse.OK("فعالیت حذف شد", data)

    except ValueError as e:
        return myResponse.Error(e.args, Errors.InvalidArgument.code)
    except Exception as e:
        return myResponse.Error(e.args, Errors.InternalError.code)


@api_view(["POST"])
def edit_activity(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن اشتباه وارد شده است"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$",
                #     "errorMessage": "شماره تلفن اشتباه وارد شده است"
                # },
                {
                    "name": "start_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "زمان شروع اشتباه وارد شده است"
                },
                {
                    "name": "end_date_time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "زمان پایان اشتباه وارد شده است"
                },
                {
                    "name": "amount",
                    "format": "^[\d]+$",
                    "errorMessage": "مقدار اشتباه وارد شده است"
                },
                {
                    "name": "activity_code",
                    "format": "^[\d]+$",
                    "errorMessage": "فیلد activity_code را به صورت یک عدد طبیعی وارد کنید"
                },
                {
                    "name": "id",
                    "format": "^[\d]+$",
                    "errorMessage": "فیلد id را به صورت یک عدد طبیعی وارد کنید"
                }
            ], request)

            token = str(request.POST["token"])
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            id = int(request.POST.get("id"))
            temp = Activities_log.objects.filter(user=user, id=id)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            item = temp[0]

            activity_code = int(request.POST.get("activity_code"))

            temp = Activity.objects.filter(id=activity_code)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidActivity.message, Errors.InvalidActivity.code)
            new_activity = temp[0]

            sdt = int(request.POST["start_date_time"])
            edt = int(request.POST["end_date_time"])

            new_start_date_time = datetime.fromtimestamp(sdt)
            new_end_date_time = datetime.fromtimestamp(edt)
            new_amount = int((new_end_date_time - new_start_date_time).seconds / 60)

            record_date = item.start_date_time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)

            PALx = item.PALx

            # remove effect of last activity
            PALX = record.PALX - PALx

            # add effect of new activity
            Metz = new_activity.Metz
            A = (Metz - 1) * ((1.15 / 0.9) * new_amount) / 1440
            BMR = user.profile.BMR
            B = BMR / (0.0175 * 1440 * user.profile.weight)
            newPALx = round(A / B, 5)
            PALX = PALX + newPALx
            record.PALX = PALX

            y = 0
            if PALX <= 1.1:
                y = 0
            elif PALX > 1.8:
                y = 1
            else:
                y = PALX / 1.8

            record.total_Activity_Point = y
            record.save()

            # update activity log
            new_energy = round(new_amount * user.profile.weight * 0.0175 * Metz, 1)
            item.PALx = newPALx
            item.start_date_time = new_start_date_time
            item.end_date_time = new_end_date_time
            item.activity = new_activity
            item.amount = new_amount
            item.energy = new_energy
            item.save()

            # update points
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            data = {
            }
            return myResponse.OK("بروزرسانی انجام شد", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def edit_blood_pressure(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "time",
                    "format": "^[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند"
                },
                {
                    "name": "amount",
                    "format": "^[\d]+$",
                },
                {
                    "name": "over",
                    "format": "^[\d]+$",
                },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            token = str(request.POST.get("token"))
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            id = int(request.POST.get("id"))
            temp = BloodPressure.objects.filter(user=user, id=id)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            item = temp[0]

            new_amount = int(request.POST.get("amount"))
            new_over = int(request.POST.get("over"))
            new_dt = datetime.fromtimestamp(int(request.POST.get("time")))

            # edit and save item
            item.time = new_dt
            item.amount = new_amount
            item.over = new_over
            item.save()

            data = {
            }
            return myResponse.OK("بروزرسانی انجام شد", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def delete_blood_pressure(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            token = str(request.POST.get("token"))
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            id = int(request.POST.get("id"))
            temp = BloodPressure.objects.filter(user=user, id=id)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            temp[0].delete()
            data = {
            }
            return myResponse.OK("حذف انجام شد", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def delete_insulin(request):
    if request.method == "POST":
        try:
            # Check input format
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$",
                    "errorMessage": "توکن نامعتبر است"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$",
                #     "errorMessage": "شماره تلفن نامعتبر است"
                # },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            # Verify user authentication
            token = str(request.POST.get("token"))
            # phone = request.POST["phone_number"]
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
            user = temp[0]
            id = int(request.POST.get("id"))

            temp = InsulinUsage.objects.filter(id=id, user=user)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)

            # now remove effect
            item = temp[0]

            record_date = item.time.date()
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # now delete the item
            InsulinUsage.objects.filter(id=id).delete()

            # update values
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            data = []
            # Send the result
            return myResponse.OK("حذف با موفقیت انجام شد", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def edit_insulin(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "time",
                    "format": "^[-+]?[0-9]{10}$",  # timestamp
                    # ex:  "1546270161"
                    "errorMessage": "تاریخ یا زمان اشتباه وارد شده اند"
                },
                {
                    "name": "amount",
                    "format": "^[\d]+$",

                },
                {
                    "name": "insulin_code",
                    "format": "^[\d]+$",
                    # "errorMessage": ""
                },
                {
                    "name": "id",
                    "format": "^[\d]+$",
                },
                {
                    "name": "meal",
                    "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S
                    "required": False
                }
            ], request)
            token = str(request.POST.get("token"))
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            new_amount = int(request.POST["amount"])
            new_insulin_code = int(request.POST["insulin_code"])
            i = Insulin.objects.filter(Data_Base_Number=new_insulin_code)
            if not i.exists():
                return myResponse.Error(Errors.InvalidInsulinId.message, Errors.InvalidInsulinId.code)
            new_insulin = i[0]

            new_dt = datetime.fromtimestamp(int(request.POST.get("time")))

            if not (request.POST.get("meal") is None):
                new_meal = int((request.POST.get("meal")))
            else:
                new_meal = MEAL[new_dt.hour]

            # get and edit item
            id = request.POST.get("id")
            temp = InsulinUsage.objects.filter(id=id, user=user)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            item = temp[0]
            last_time = item.time

            item.time = new_dt
            item.amount = new_amount
            item.meal = new_meal
            item.Insulin = new_insulin

            # get record of day
            record_date = item.time.date()  # last time
            p = Points.objects.filter(user=user, date=record_date)
            if p.exists():
                record = p[0]
            else:
                record = Points(user=user, date=record_date)

            # update and save changes
            u = updateTotalPointDay(user, record)
            totalPoint = u["DayPoint"]
            record.total_points = totalPoint
            record.totalCooperationPoints = u["totalCooperate"]
            record.save()

            # save total point after updateTotalPointDay() call
            item.point = totalPoint
            item.save()
            data = {
                "DayPoint": totalPoint,
            }
            return myResponse.OK("اطلاعات بروزرسانی شد", data)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)


@api_view(["POST"])
def delete_sleep(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "token",
                    "format": "^(\S){30}$"
                },
                # {
                #     "name": "phone_number",
                #     "format": "^09[0-9]{9}$"
                # },
                {
                    "name": "id",
                    "format": "^[0-9]+$",
                    "errorMessage": "id معتبر نیست"
                },
            ], request)

            token = str(request.POST.get("token"))
            # phone = str(request.POST["phone_number"])
            temp = User.objects.filter(token=token)
            if not temp.exists():
                return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

            user = temp[0]
            id = int(request.POST.get("id"))
            temp = Sleep.objects.filter(user=user, id=id)
            if not temp.exists():
                return myResponse.Error(Errors.NotFoundItem.message, Errors.NotFoundItem.code)
            temp[0].delete()
            data = {
            }
            return myResponse.OK("حذف انجام شد", data)

        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
        except Exception as e:
            return myResponse.Error(e.args[0], Errors.InternalError.code)
