from .views import *
from django.core import serializers
import json
import pandas as pd
from django.contrib.auth.decorators import login_required
from django.views.decorators.csrf import csrf_exempt
from django.core.signing import JSONSerializer
from django.utils import timezone
from django.contrib.auth.models import Group
import requests
from django.db.models import Q
from APIs.views import firebase

# from APIs.predict import *
model_dir = settings.BASE_DIR + '/static/AImodels/saved_model'

# instantiate it only once!
# pred = Predict(model_dir=str(model_dir))



# from APIs import predict
from panel.models import Message


@api_view(["POST", "GET"])
def activity(request):
    if request.method == "POST":
        try:
            name = str(request.POST.get("name"))
            metz = float(request.POST.get("Metz"))
            last = Activity.objects.filter(name=name)
            if last.exists():
                return myResponse.Error("قبلا فعالیتی با این نام ثبت شده است.", Errors.InvalidRequest.code)
            act = Activity(name=name, Metz=metz)
            act.save()
            return myResponse.OK("فعالیت اضافه شد.", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            activities = Activity.objects.all();
            return myResponse.OK("", json.loads(serializers.serialize("json", activities)))
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def food(request):
    if request.method == "POST":
        try:
            name = str(request.POST["name"])
            coefficient = int(request.POST["coefficient"])
            fat = int(request.POST["fat"])
            calorie = int(request.POST["calorie"])
            protein = int(request.POST["protein"])
            carbohydrate = int(request.POST["carbohydrate"])
            last = Food.objects.filter(name=name)
            if last.exists():
                return myResponse.Error("قبلا غذایی با این نام ثبت شده است.", Errors.LogicalError.code)

            food = Food(name=name , coefficient=coefficient, fat=fat,
                        calorie=calorie, protein=protein, carbohydrate=carbohydrate)
            food.save()
            return myResponse.OK("غذا اضافه شد.",{})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            foods = Food.objects.all();
            return myResponse.OK("", json.loads(serializers.serialize("json", foods)))
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def insulin(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "name",
                    "format": "^(\S)+$"
                },
                {
                    "name": "Company",
                    "format": "^(\S)+$"  # date time format "%Y-%m-%d %H:%M:%S
                    # "errorMessage": ""
                },
                {
                    "name": "coefficient",
                    "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S"
                    # "errorMessage": ""
                },

                {
                    "name": "EffectType",
                    "format": "^[\d]+$"  # date time format "%Y-%m-%d %H:%M:%S
                    # "errorMessage": ""
                }
            ], request)
            name = str(request.POST.get("name"))
            Company = str(request.POST.get("Company"))
            coefficient = int(request.POST.get("coefficient"))
            EffectType = int(request.POST.get("EffectType"))

            last = Insulin.objects.filter(name=name)
            if last.exists():
                return myResponse.Error("قبلا انسولینی با این نام ثبت شده است.", Errors.LogicalError.code)
            insulin = Insulin(name=name, coefficient=coefficient, Company=Company,
                           EffectType=EffectType)
            insulin.save()
            return myResponse.OK("انسولین اضافه شد.", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            # RequsetChecker(request.POST, [
            #     {
            #         "name": "name",
            #         "format": "^(\S)+$"
            #     },
            #     {
            #         "name": "Company",
            #         "format": "^(\S)+$"  # date time format "%Y-%m-%d %H:%M:%S
            #         # "errorMessage": ""
            #     },
            #     {
            #         "name": "coefficient",
            #         "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S"
            #         # "errorMessage": ""
            #     },
            #
            #     {
            #         "name": "description",
            #         "format": "^[\S]+$"  # date time format "%Y-%m-%d %H:%M:%S
            #         # "errorMessage": ""
            #     }
            # ], request)
            # name = str(request.POST.get("name"))
            # Company = str(request.POST.get("Company"))
            # coefficient = int(request.POST.get("coefficient"))
            # description = int(request.POST.get("description"))

            insulins = Insulin.objects.all();

            return myResponse.OK("", json.loads(serializers.serialize("json", insulins)))
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)

@api_view(["POST", "GET"])
def drug(request):
    if request.method == "POST":
        try:
            RequsetChecker(request.POST, [
                {
                    "name": "name",
                    "format": "^(\S)+$"
                },
                {
                    "name": "Company",
                    "format": "^(\S)+$"  # date time format "%Y-%m-%d %H:%M:%S
                    # "errorMessage": ""
                },
                {
                    "name": "coefficient",
                    "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S"
                    # "errorMessage": ""
                },

                {
                    "name": "description",
                    "format": "^[\S]+$"  # date time format "%Y-%m-%d %H:%M:%S
                    # "errorMessage": ""
                }
            ], request)
            name = str(request.POST.get("name"))
            Company = str(request.POST.get("Company"))
            coefficient = int(request.POST.get("coefficient"))
            description = str(request.POST.get("description"))

            last = Drug.objects.filter(name=name)
            if last.exists():
                return myResponse.Error("قبلا دارویی با این نام ثبت شده است.", Errors.LogicalError.code)
            insulin = Drug(name=name, coefficient=coefficient, Company=Company,
                           description=description)
            insulin.save()
            return myResponse.OK("دارو اضافه شد.", {})
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        try:
            # RequsetChecker(request.POST, [
            #     {
            #         "name": "name",
            #         "format": "^(\S)+$"
            #     },
            #     {
            #         "name": "Company",
            #         "format": "^(\S)+$"  # date time format "%Y-%m-%d %H:%M:%S
            #         # "errorMessage": ""
            #     },
            #     {
            #         "name": "coefficient",
            #         "format": "^[\d]+$",  # date time format "%Y-%m-%d %H:%M:%S"
            #         # "errorMessage": ""
            #     },
            #
            #     {
            #         "name": "description",
            #         "format": "^[\S]+$"  # date time format "%Y-%m-%d %H:%M:%S
            #         # "errorMessage": ""
            #     }
            # ], request)
            # name = str(request.POST.get("name"))
            # Company = str(request.POST.get("Company"))
            # coefficient = int(request.POST.get("coefficient"))
            # description = int(request.POST.get("description"))

            drugs = Drug.objects.all()

            return myResponse.OK("", json.loads(serializers.serialize("json", drugs)))
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


@api_view(["POST", "GET"])
def AddingActivityFromExcel(request):
    if request.method == 'POST':
        try:
            #print(str(request.POST))
            # return myResponse.OK(str(request.POST),request.POST)

            # RequsetChecker(request.POST,
            #                [
            #                    {
            #                        "name": "userName",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "نام کاربری نا معتبر"
            #                    },
            #                    {
            #                        "name": "password",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "پسورد نامعتبر"
            #                    },
            #                ], request)
            # userName = request.POST["userName"]
            # password = request.POST["password"]

            # temp = Admins.objects.filter(UserName=userName, PassWord=password)

            #check user pass ...
            # if not temp.exists():
            #     return myResponse.Error(Errors.WrongUserPassWord.message,
            #                             Errors.WrongUserPassWord.code)
            # # check that has Access ...
            # admin = temp[0]
            # if admin.foodsEdit is False:
            #     return myResponse.Error(Errors.NoAccessToEdit.message,
            #                             Errors.NoAccessToEdit.code)

            # now save activities.xlsx file in the server...
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.",name)
            newFileName = settings.BASE_DIR + '/static/assets/activities/activities_' + str(datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Foods...
            df = pandas.read_excel(newFileName)

            newActivitiesAdded = 0
            ActivitiesSaved = 0
            ActivitiesInProccess = 0
            for value in df.values:
                try:
                    if not str(value[0]) == "nan":
                        temp = Activity.objects.filter(name=value[0])
                        if temp.exists():
                            act = temp[0]
                        else:
                            act = Activity()
                            newActivitiesAdded += 1
                        ActivitiesInProccess += 1
                        act.name = value[0]
                        act.Metz = NaNtoInt(value[1])
                        act.save()
                        ActivitiesSaved += 1
                    else:
                        return myResponse.Error("saved Activities= " + str(ActivitiesSaved) +
                                                "\nadded Activities= " + str(newActivitiesAdded) +
                                                "\nError in record: " + str(ActivitiesInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except MemoryError:
                    return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

            temp = {
                "NumberOfActivities": len(df.values),
                "newActivitiesAdded": newActivitiesAdded,
                "saved_Activities": ActivitiesSaved
            }
            return myResponse.OK("اطلاعات ورزش ها ثبت شد.", temp)
        except ValueError:
            return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)
    else:
        return render(request, "")


@api_view(["POST", "GET"])
def AddingDrugFromExcel(request):
    if request.method == 'POST':
        try:
            #print(str(request.POST))
            # return myResponse.OK(str(request.POST),request.POST)

            # RequsetChecker(request.POST,
            #                [
            #                    {
            #                        "name": "userName",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "نام کاربری نا معتبر"
            #                    },
            #                    {
            #                        "name": "password",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "پسورد نامعتبر"
            #                    },
            #                ], request)
            # userName = request.POST["userName"]
            # password = request.POST["password"]

            # temp = Admins.objects.filter(UserName=userName, PassWord=password)

            #check user pass ...
            # if not temp.exists():
            #     return myResponse.Error(Errors.WrongUserPassWord.message,
            #                             Errors.WrongUserPassWord.code)
            # # check that has Access ...
            # admin = temp[0]
            # if admin.foodsEdit is False:
            #     return myResponse.Error(Errors.NoAccessToEdit.message,
            #                             Errors.NoAccessToEdit.code)

            # now save activities.xlsx file in the server...
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            newFileName = settings.BASE_DIR + '/static/assets/Drugs/drugs_' + str(datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Drugs...
            df = pandas.read_excel(newFileName)

            newDrugsAdded = 0
            DrugsSaved = 0
            DrugsInProccess = 0
            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        temp = Drug.objects.filter(DataBaseNumber=value[3])
                        if temp.exists():
                            drug = temp[0]
                        else:
                            drug = Drug()
                            newDrugsAdded += 1
                            DrugsInProccess += 1
                        drug.name = str(value[0])
                        drug.EN_Name = str(value[1])
                        drug.description = str(value[2])
                        drug.DataBaseNumber = str(value[3])
                        drug.save()
                        DrugsSaved += 1
                    else:
                        return myResponse.Error("saved Drugs= " + str(DrugsSaved) +
                                                "\nadded Drugs= " + str(newDrugsAdded) +
                                                "\nError in record: " + str(DrugsInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except ValueError as e:
                    return myResponse.Error(str(e.args[0]), Errors.InvalidArgument.code)

            temp = {
                "NumberOfDrugs": len(df.get_values()),
                "newDrugsAdded": newDrugsAdded,
                "saved_Drugs": DrugsSaved
            }
            return myResponse.OK("اطلاعات دارو ها ثبت شد.", temp)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return render(request, "")


@api_view(["POST", "GET"])
def AddingGLP1FromExcel(request):
    if request.method == 'POST':
        try:
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            newFileName = settings.BASE_DIR + '/static/assets/GLP1/GLP1_' + str(datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Drugs...
            df = pandas.read_excel(newFileName)

            newGLP1sAdded = 0
            GLP1sSaved = 0
            GLP1sInProccess = 0
            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        temp = GLP1.objects.filter(DataBaseNumber=value[3])
                        if temp.exists():
                            glp1 = temp[0]
                        else:
                            glp1 = GLP1()
                            newGLP1sAdded += 1
                            GLP1sInProccess += 1
                        glp1.name = str(value[0])
                        glp1.EN_Name = str(value[1])
                        glp1.description = str(value[2])
                        glp1.DataBaseNumber = str(value[3])
                        glp1.coefficient = int(value[4])
                        glp1.save()
                        GLP1sSaved += 1
                    else:
                        return myResponse.Error("saved Drugs= " + str(GLP1sSaved) +
                                                "\nadded Drugs= " + str(newGLP1sAdded) +
                                                "\nError in record: " + str(GLP1sInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except ValueError as e:
                    return myResponse.Error(str(e.args[0]), Errors.InvalidArgument.code)

            temp = {
                "NumberOfGLP1s": len(df.get_values()),
                "newGLP1sAdded": newGLP1sAdded,
                "saved_GLP1s": GLP1sSaved
            }
            return myResponse.OK("اطلاعات GLP1 ها ثبت شد.", temp)
        except ValueError as e:
            return myResponse.Error(e.args[0], Errors.InvalidArgument.code)
    else:
        return render(request, "")


@api_view(["POST", "GET"])
def AddingInsulinsFromExcel(request):
    if request.method == 'POST':
        try:
            #print(str(request.POST))
            # return myResponse.OK(str(request.POST),request.POST)

            # RequsetChecker(request.POST,
            #                [
            #                    {
            #                        "name": "userName",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "نام کاربری نا معتبر"
            #                    },
            #                    {
            #                        "name": "password",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "پسورد نامعتبر"
            #                    },
            #                ], request)
            # userName = request.POST["userName"]
            # password = request.POST["password"]

            # temp = Admins.objects.filter(UserName=userName, PassWord=password)

            #check user pass ...
            # if not temp.exists():
            #     return myResponse.Error(Errors.WrongUserPassWord.message,
            #                             Errors.WrongUserPassWord.code)
            # # check that has Access ...
            # admin = temp[0]
            # if admin.foodsEdit is False:
            #     return myResponse.Error(Errors.NoAccessToEdit.message,
            #                             Errors.NoAccessToEdit.code)

            # now save activities.xlsx file in the server...
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            newFileName = settings.BASE_DIR + '/static/assets/Insulins/insulins_' + str(datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Insulins ...
            df = pandas.read_excel(newFileName)

            newInsulinsAdded = 0
            InsulinsSaved = 0
            InsulinsInProccess = 0
            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        temp = Insulin.objects.filter(Data_Base_Number=value[0])
                        if temp.exists():
                            ins = temp[0]
                        else:
                            ins = Insulin()
                            newInsulinsAdded += 1
                            InsulinsInProccess += 1
                        #ins.name = NaNtoInt("")
                        ins.Data_Base_Number = str(int(NaNtoInt(value[0])))
                        ins.name = str(value[1])
                        #ins.description = NaNtoInt(value[2])
                        ins.EffectType = int(NaNtoInt(value[2]))
                        ins.Company = value[3]
                        ins.save()
                        InsulinsSaved += 1
                    else:
                        return myResponse.Error("saved Drugs= " + str(InsulinsSaved) +
                                                "\nadded Drugs= " + str(newInsulinsAdded) +
                                                "\nError in record: " + str(InsulinsInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except ValueError as e:
                    return myResponse.Error(e.args[0], -1)

            temp = {
                "NumberOfDrugs": len(df.get_values()),
                "newDrugsAdded": newInsulinsAdded,
                "saved_Drugs": InsulinsSaved
            }
            return myResponse.OK("اطلاعات انسولین ها ثبت شد.", temp)
        except ValueError:
            return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)
    else:
        return render(request, "")


@api_view(["POST", "GET"])
def AddingDiabetesInfoFromExcel(request):
    if request.method == 'POST':
        try:
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not(name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            newFileName = settings.BASE_DIR + '/static/assets/DiabetesInfo/DiabetesInfo_' + str(datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Insulins ...
            df = pandas.read_excel(newFileName)

            newInfoAdded = 0
            InfoSaved = 0
            InfoInProccess = 0
            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        temp = DiabetesInfo.objects.filter(DBNumber=value[3])
                        if temp.exists():
                            DI = temp[0]
                        else:
                            DI = DiabetesInfo()
                            newInfoAdded += 1
                            InfoInProccess += 1

                        DI.DBNumber = int(str(value[3]))
                        DI.info = str(value[0])

                        DI.Audience = str(value[1])
                        DI.Tags = str(value[4])
                        DI.is_Conditional = bool(int(str(value[2])))
                        DI.save()

                        InfoSaved += 1
                    else:
                        return myResponse.Error("saved Info= " + str(InfoSaved) +
                                                "\nadded Infos= " + str(newInfoAdded) +
                                                "\nError in record: " + str(InfoInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except ValueError as e:
                    return myResponse.Error(e.args[0], -1)

            temp = {
                "NumberOfInfos": len(df.get_values()),
                "newInfosAdded": newInfoAdded,
                "saved_Info": InfoSaved
            }
            return myResponse.OK("اطلاعات دیابتی ثبت شد.", temp)
        except ValueError:
            return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)
    else:
        return render(request, "")


def update_drugstore_list_from_excel(request):
    if request.method == "POST":
        try:
            # Authentication in script
            # now save drugstore.xlsx file in the server...
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not (name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            newFileName = settings.BASE_DIR + '/static/assets/drugstore/drugstore_list_' + str(
                datetime.now().date()) + '.xlsx'
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Foods...
            df = pandas.read_excel(newFileName)

            newDrugStoreAdded = 0
            DrugStoresSaved = 0
            DrugStoresInProccess = 0

            # delete last list
            ds = Drugstore.objects.all()
            for item in ds:
                item.delete()

            for value in df.get_values():
                try:
                    if not str(value[0]) == "nan":
                        newDrugStoreAdded += 1
                        DrugStoresInProccess += 1
                        ds = Drugstore(Name=value[0], Province_en="", Province_fa=value[1],
                                       City_en="", City_fa=value[2], Phone=value[3], Address=value[4])
                        ds.save()
                        DrugStoresSaved += 1
                    else:
                        return myResponse.Error("saved DrugStore= " + str(DrugStoresSaved) +
                                                "\nadded DrugStore= " + str(newDrugStoreAdded) +
                                                "\nError in DrugStore: " + str(DrugStoresInProccess + 2),
                                                Errors.ErrorInExcelFile.code)
                except(ValueError):
                    return myResponse.Error(Errors.InvalidArgument.message, Errors.InvalidArgument.code)

            data = {
                "NumberOfDrugStores": len(df.get_values()),
                "newDrugStoreAdded": newDrugStoreAdded,
                "saved_DrugStores": DrugStoresSaved
            }
            return myResponse.OK("اطلاعات داروخانه ها ثبت شد.", data=data)
        except Exception as e:
            return myResponse.Error(e.args, -1)
    else:
        return myResponse.Error(Errors.InvalidRequest.message, Errors.InvalidRequest.code)


@api_view(["POST"])
def deleteUser(request):
    try:
        RequsetChecker(request.POST,
                       [
                           {
                               "name": "phone_number",
                               "format": "^09[0-9]{9}$",
                               "required": False
                           },
                           {
                               "name": "email",
                               "format": "",
                               "required": False
                           },
                           {
                               "name": "userName",
                               "format": "^(\S)+$",
                               "errorMessage": "نام کاربری نا معتبر"
                           },
                           {
                               "name": "password",
                               "format": "^(\S)+$",
                               "errorMessage": "پسورد نامعتبر"
                           },
                       ], request)
        userName = request.POST["userName"]
        password = request.POST["password"]
        if not (userName == "UserCanDelete" and password == "fegrdhtfyguhijolkujhbgvcsdfgdxth575@#$%^&dflknv"):
            return myResponse.Error("رمز یا نام کاربری اشتباه است", -1)

        # token = str(request.POST.get("token"))
        phone = str(request.POST.get("phone_number"))
        email = str(request.POST.get("email"))

        if not phone == None:
            temp = User.objects.filter(phone_number=phone)
        elif not email == None:
            temp = User.objects.filter(profile__email=email)
        # if not temp.exists():
        #     return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)

        for user in temp:
            p = user.profile
            p.delete()
            du = user.django_user
            du.delete()
            user.delete()

        temp = DjangoUser.objects.filter(username=phone)
        for u in temp:
            u.delete()

        temp = DjangoUser.objects.filter(username=email)
        for u in temp:
            u.delete()

        return myResponse.OK("کاربر حذف کامل شد", [])
    except ValueError:
        return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)


def create_analisys():
    BASE_DIR = "/home/idiair/.sjdbchsjkidia/static/assets/reports_data/"
    file = "all_data_" + str(datetime.today())

    data = []
    index = []
    columns = ['birth date', 'gender', 'diabetes type', 'registry date',
               'height', 'weight', 'BMI', 'food', 'sport', 'insulin usage',
               'Blood glucose measurement', 'step/walking',
               'last activity date']

    users = User.objects.all()

    for u in users:
        if not(u.profile == None):
            index.append(str(u.phone_number)[0:11] + "")

            temp = []

            temp.append(u.profile.birth_date.year)

            if u.profile.gender == 0:
                temp.append("مرد")
            else:
                temp.append("زن")

            temp.append(u.profile.diabetes_type)

            temp.append(u.created_at.strftime("%x"))

            temp.append(u.profile.height)

            temp.append(u.profile.weight)
            if u.profile.height > 0:
                temp.append(u.profile.weight / ((u.profile.height/100)**2))
            else:
                temp.append("-")

            temp.append(Eating.objects.filter(user=u).count())

            temp.append(Activities_log.objects.filter(user=u).count())

            temp.append(InsulinUsage.objects.filter(user=u).count())

            temp.append(SugarMeasurement.objects.filter(user=u).count())

            temp.append(Walking.objects.filter(user=u).count())

            p = Points.objects.filter(user=u).order_by("date")
            if p.exists():
                temp.append(p[p.count() - 1].date.strftime("%x"))
            else:
                temp.append("-")

            data.append(temp)

    df = pd.DataFrame(data,
                      index=index,
                      columns=columns)
    df.to_excel(BASE_DIR + file + ".xlsx")

def fix_django_users():
    from django.contrib.auth.models import User as DjangoUser
    from APIs.models import User as AppUser
    users = AppUser.objects.filter(profile__email__contains='.comm')
    i = 1
    updated = []
    for user in users:
        app_users_assigned = AppUser.objects.filter(django_user=user.django_user)
        for u in app_users_assigned:
            updated.append("django_id:{}, username:{}".format(u.django_user.id, u.profile.email))
            du = DjangoUser(username="updated_user{}".format(i))
            du.set_password("1234@Abc")

            du.save()
            my_group = Group.objects.get(name='Patient')
            my_group.user_set.add(du)
            u.django_user = du
            u.save()

            i += 1
    return myResponse.OK(str(len(users)), updated)

def add_credit_to_all(group_id, days):
    from panel.models import TherapistSelection
    from APIs.models import ZiLuckGroup
    therapist_selections = TherapistSelection.objects.all().order_by("-created_at")
    updated_users = []
    selected_group = ZiLuckGroup.objects.filter(group_id=group_id)[0]
    selected_group_users = selected_group.user_set.all()
    changed_user = 0
    for ts in therapist_selections:
        if ts.user is not None:
            if ts.user.id not in updated_users:
                updated_users.append(ts.user.id)
                if ts.remaining_credit() < days and ts.user in selected_group_users:
                    ts.add_credit(days)
                    changed_user += 1
    result = {
        "updated_users": updated_users,
        "len therapist selections": len(therapist_selections),
        "len user changed": changed_user
    }
    return myResponse.OK("updated users", [result])

def send_message_to_ziluck_not_payed():
    from panel.models import TherapistSelection
    message_to_users = []
    users = User.objects.filter(isRegistered=True)
    for user in users:
        trp = TherapistSelection.objects.filter(user=user.django_user)
        if not trp.exists():
            if len(str(user.phone_number)) > 5:
                message_to_users.append(str(user.phone_number))

    result = {
        "message_to_users": message_to_users
    }
    return myResponse.OK("updated users", [result])



def generate_discount_codes(number, percentage, credit):

    discount_codes = set()
    expire_date = datetime.now() + timedelta(days=credit)
    import random as rd

    from payment.models import Discount

    # diss = Discount.objects.filter(created_at__in=(datetime.now() - timedelta(minutes=20), datetime.now()))
    # for item in diss:
    #     item.delete()

    while len(discount_codes) < number:
        code = ''.join(rd.choices(string.ascii_uppercase + string.digits, k=6))
        if code not in discount_codes:
            discount_codes.add(code)
            discount = Discount(code=code, expire_date=expire_date, percentage=percentage, number_of_discounts=2)
            discount.save()
    return myResponse.OK("discount_codes:", list(discount_codes))

def tag_fix_script():
    from APIs.models import FoodCard
    dietary_tags = [
        'is_keto', 'is_med', 'is_conditional_med', 'is_lowcarb',
        'is_mediumcarb', 'is_highcarb', 'is_highprotein', 'is_mediumprotein', 'is_lowprotein', 'is_mind',
        'is_low_fodmap', 'is_lowfat', 'is_mediumfat', 'is_highfat'
    ]
    FoodCard.objects.all().update(**{tag: False for tag in dietary_tags})

    card = FoodCard.objects.all()
    for cards in card:
        total_carbohydrates = sum(item.get("Carbohydrates", 0) for item in cards.foods)
        total_proteins = sum(item.get("Protein", 0) for item in cards.foods)
        total_fat = sum(item.get("Fat", 0) for item in cards.foods)
        if cards.Calories > 0:
            carb_ratio = (total_carbohydrates * 4) / cards.Calories
            protein_ratio = (total_proteins * 4) / cards.Calories
            Fat_ratio = (total_fat * 9) / cards.Calories
            cards.carb_ratio = round(carb_ratio, 2)
            cards.protein_ratio = round(protein_ratio, 2)
            cards.fat_ratio = round(Fat_ratio, 2)

            # carbohydrate
            if 0.4 <= carb_ratio <= 0.55:
                cards.is_mediumcarb = True
            elif carb_ratio > 0.55:
                cards.is_highcarb = True
            elif carb_ratio < 0.4:
                cards.is_lowcarb = True
            else:
                cards.is_mediumcarb = False
                # protein
            if protein_ratio > 0.25:
                cards.is_highprotein = True
            elif 0.15 <= protein_ratio <= 0.25:
                cards.is_mediumprotein = True
            elif protein_ratio < 0.15:
                cards.is_lowprotein = True
                # fat
            if Fat_ratio > 0.35:
                cards.is_highfat = True
            elif 0.25 <= Fat_ratio <= 0.35:
                cards.is_mediumfat = True
        elif Fat_ratio < 0.25:
            cards.is_lowfat = True

        cards.save()
    return myResponse.OK("tag fixed!", [len(card)])

def send_message_to_lacto_user():
    try:
        from pyfcm import FCMNotification
        # Firebase constants for Lacto
        FIREBASE_PROJECT_ID_Lacto = 'lacto-7b6dc'
        FIREBASE_SERVICE_ACCOUNT_FILE_Lacto = '../../ziluck_project/lacto-7b6dc-firebase-adminsdk-kd4cw-0b86d80825.json'
        push_service = FCMNotification(
            project_id=FIREBASE_PROJECT_ID_Lacto,
            service_account_file=FIREBASE_SERVICE_ACCOUNT_FILE_Lacto
        )
        result = push_service.notify(
            fcm_token="d1zghqg3X0FsrztUZWaQJd:APA91bFyWE-e1q1t1DCKWZ9lzrSWwLxO9F7k1nbdWc9t9RCpe6L_hcX_-_rPb3tznDsevRHNS5MRRuDp9fUEQRX_93azFANV8zLvgBIFIlK5orqhKU8b4V8",
            notification_title="Test message",
            notification_body="Test message body")
        print("test notification : True")
        return myResponse.OK("lacto true notification", [str(result)])
    except Exception as e:
        print("test notification : False")
        print(e)
        return myResponse.OK("lacto false notification", [])


@api_view(["POST", "GET"])
def runScripts(request):
    if request.method == 'POST':
        userName = request.POST["userName"]
        password = request.POST["password"]
    if request.method == 'GET':
        userName = request.GET["userName"]
        password = request.GET["password"]
    if not (userName == "UserCanRunScript" and password == "fegrdhtfyguhijolkujhbgvcsdfgdxth575@#$%^&dflknv"):
        return myResponse.Error("رمز یا نام کاربری اشتباه است", -1)
    try:
        data = {}

        return send_message_to_lacto_user()

        # return tag_fix_script()

        # return generate_discount_codes(1000, 20, 70)

        # return send_message_to_ziluck_not_payed()

        # return add_credit_to_all(group_id="amn_afzar", days=30)

        # return fix_django_users()


        # from panel.models import Message
        # messages = Message.objects.filter(time__gt=(datetime.now() - timedelta(days=1)))
        # for message in messages:
        #     if '"' in message.text:
        #         message.text = message.text.replace('"', '')
        #         message.save()
        # return myResponse.OK("from linux!", 1)

        # from panel.models import Message
        # messages = Message.objects.all()
        # for message in messages:
        #     message.text = message.text.replace("\n", "")
        #     message.save()
        #
        # return HttpResponse("ok")

        # create_analisys()

        # send_To_Actives()

        # create_random_data()

        # delete_my_today_data()

        # data = user_average_activity()

        # data = getUserOfDay()

        # getUserDataInExcel()

        # send_To_last_install_with_problems()

        # create_user_code_for_last_users()

        # send_update_to_server()

        # data = ClearingFoods(request)

        # return getDuplicatedFood(request)

        # fixMinMaxSugar()

        # setRandomAvatar()

        # data = test_send_sms_norooz(request)
        # toSend = data["tosend"]
        # data2 = send_sms_norooz(toSend)

        # data = telegram_test(request)

        # writeErrorToLog("حسین سجودی")

        # data = get_list_of_not_registerd()

        # data = ProvincesAnalize()

        # return copyUserToUser()

        # return updateFoodsOffline("Food-99-02-07.xlsx")

        # return update_drugstore_list_from_excel(request)

        # return read_gl()

        # user = User.objects.filter(phone_number="09217761645")[0]
        # temp = BloodPressure()
        # temp.user = user
        # temp.amount = 123
        # temp.time = datetime.now()
        # temp.save()

        # return sanofiData()

        # return danesh_bonyan_data()

        # return dayly_report()

        # return max_sugarMeasurement_users()

        # return active_users()

        # return firebase.testFireBase(request)

        # return firebase.test2(request)

        # return firebase.send_notification_to_not_active_last_week(request)

        # return sendEmail(code="1234", recip="hsojoodi374@yahoo.com")

        # insulin_selections()

        # insulin_selections_date_repair()

        # amin_analysis()

        # data = all_users_list()


        return myResponse.OK("script done!", [str(request.POST), str(request.GET), str(datetime.now()), data])
    except ValueError as e:
        return myResponse.Error(e.args[0], Errors.InvalidArgument.code)


def send_update_to_server():
    # new version release
    apv = AppVersion()
    apv.version = "1399.01.10"
    apv.site_link = "https://idiapp.app.link"
    apv.bazar_link = "https://idiapp.app.link"
    apv.google_play_link = "https://idiapp.app.link"
    apv.description = "بهبود رابط کاربری صفحه امتیاز ها" + "\n" + \
    "محاسبه میزان a1c" + "\n" + \
    "رفع باگ های عمومی"
    apv.save()


def create_sugar_data_analisys():
    BASE_DIR = "/home/idiair/idia/static/assets/reports_data/"
    file = "data_" + str(date.today())

    data = []
    index = []
    columns = ['Blood glucose record number', 'min (minutes)', 'Average (minutes)', 'max (minutes)']

    users = User.objects.all()

    for u in users:
        index.append(str(u.phone_number)[0:9] + "**")
        sms = SugarMeasurement.objects.filter(user=u).order_by("time")
        sumation = 0
        minimun = 9999999999
        maximum = 0

        if sms.count() > 1:
            for i in range(sms.count() - 1):
                t1 = int(sms[i].time.timestamp())
                t2 = int(sms[i + 1].time.timestamp())
                d = (t2 - t1) / 60
                sumation += d

                if d > maximum:
                    maximum = d
                if d < minimun:
                    minimun = d
            average = sumation / (sms.count() - 1)
            temp = [sms.count(), minimun, average, maximum]
            data.append(temp)
        else:
            temp = [-1, -1, -1, -1]
            data.append(temp)

    df = pd.DataFrame(data,
                      index=index,
                      columns=columns)
    df.to_excel(BASE_DIR + file + ".xlsx")


def send_To_Actives():
    url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"

    users = User.objects.all()
    counter = 0
    notsend = 0
    for u in users:
        if Points.objects.filter(user=u).exists():
            message = "سلام دوست عزیز\n" + "اپلیکیشن آیدیا از هم اکنون در دسترس شماست"
            counter += 1
            receptor = u.phone_number
            querystring = {"receptor": receptor,
                           "message": message}
            response = requests.request("POST", url, params=querystring)
            jresp = response.json()
            if jresp.get("return").get("status") == 200:
                print(str(counter) + ": sent to " + receptor)
            else:
                notsend += 1
                print(str(counter) + ": not sent. to " + receptor)


def send_To_last_install_with_problems():
    url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"

    counter = 0
    notsend = 0
    receptors = ["09124058841", "09172037332", "09158815612", "09122370269", "09113441386", "09337932649", "09181734158", "09334140348", "09171009794", "09334140348" , "09360225728" , "09124068535", "09121213813", "09928803992" ,"09141007200", "09371420259", "09144060020"]
    for i in range(len(receptors)):
        message = "سلام دوست عزیز\n" + "با عرض پوزش بابت اختلال در نصب اپلیکیشن کنترل دیابت و قند خون آیدیا، این اپلیکیشن هم اکنون قابل نصب می باشد." + "\n" + "با تشکر از صبوری شما، آیدیا"
        counter += 1
        receptor = receptors[i]
        querystring = {"receptor": receptor,
                       "message": message}
        response = requests.request("POST", url, params=querystring)
        jresp = response.json()
        if jresp.get("return").get("status") == 200:
            print(str(counter) + ": sent to " + receptor)
        else:
            notsend += 1
            print(str(counter) + ": not sent. to " + receptor)


def create_random_data():
    user = User.objects.filter(phone_number="09217761645")[0]
    # lastSU = SugarMeasurement.objects.filter(user=user)
    # for item in lastSU:
    #     item.delete()

    dt = datetime.now()
    for i in range(30):
        insulin = Insulin.objects.all()[0]
        iu = InsulinUsage(user=user, amount=np.random.randint(12, 25), time=dt, Insulin=insulin)
        iu.save()

        amount1 = np.random.randint(130, 140)
        amount2 = amount1 + 20 + np.random.randint(0, 10)
        su1 = SugarMeasurement(user=user, time=dt, amount=amount1, meal=np.random.randint(0, 5))
        su1.save()
        if su1.amount > user.profile.hyper:
            su1.hyper = True
            su1.save()
        if su1.amount < user.profile.hypo:
            su1.hypo = True
            su1.save()
        su2 = SugarMeasurement(user=user, time=dt, amount=amount2, meal=np.random.randint(0,5))
        su2.save()
        if su2.amount > user.profile.hyper:
            su2.hyper = True
            su2.save()
        if su2.amount < user.profile.hypo:
            su2.hypo = True
            su2.save()



        food_codes = ["9880062", "5042"]
        amounts = [5 * amount1, 1 * amount2]
        data = user.calculate_cr_macro_nutrients_distribution()

        user.profile.CR = data["CR"]
        user.profile.Carbohydrates_g = data["macro_nutrients"]["carbohydrates_g"]
        user.profile.Carbohydrates_unit = data["macro_nutrients"]["carbohydrates_unit"]
        user.profile.Protein_g = data["macro_nutrients"]["protein_g"]
        user.profile.Protein_unit = data["macro_nutrients"]["protein_unit"]
        user.profile.Fat_g = data["macro_nutrients"]["fat_g"]
        user.profile.Fat_unit = data["macro_nutrients"]["fat_unit"]

        Carbohydrates_distribution_str = listToStr(data["carbohydrate_distribution_g"])

        user.profile.Carbohydrates_distribution_list_g = Carbohydrates_distribution_str
        user.profile.Protein_distribution_g = data["protein_distribution_g"]
        user.profile.Fat_distribution_g = data["fat_distribution_g"]
        user.profile.save()

        Carbohydrates_list_to_use = getList(user.profile.Carbohydrates_distribution_list_g)
        Fat_to_use = user.profile.Fat_distribution_g
        Protein_to_use = user.profile.Protein_distribution_g

        record_date = dt.date()
        p = Points.objects.filter(user=user, date=record_date)
        if p.exists():
            record = p[0]
        else:
            record = Points(user=user, date=record_date)
        # this meal used:
        HEI_elements_sum = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0]

        Carbohydrates_used = 0
        Protein_used = 0
        Fat_used = 0
        Calorie_used = 0
        meal = np.random.randint(0, 5)

        for i in range(min(len(amounts), len(food_codes))):
            f = Food.objects.filter(Data_Base_Number=str(int(food_codes[i])))
            if not f.exists():
                return myResponse.Error(Errors.InvalidFoodId.message, Errors.InvalidFoodId.code)
            food = f[0]
            Carbohydrates_used += (amounts[i] / 100) * food.Carbohydrates_g
            Protein_used += (amounts[i] / 100) * food.Protein_g
            Fat_used += (amounts[i] / 100) * food.Fat_g
            Calorie_used += (amounts[i] / 100) * food.Calories
            HEI_elements_i = getHEI_List(food, amounts[i])
            HEI_elements_sum = myListAdder(HEI_elements_sum, HEI_elements_i)
            # save eating log in it's table..
            new_log = Eating(user=user,
                             food=food,
                             date_time=dt,
                             amount=amounts[i],
                             meal=meal)
            new_log.save()

        # Carbohydrates calculations
        this_day_Carbohydrates_point = getList(record.this_day_Carbohydrates_point)
        this_day_Carbohydrates_g = getList(record.this_day_Carbohydrates_g)
        this_day_Carbohydrates_g[meal] += Carbohydrates_used
        record.this_day_Carbohydrates_g = listToStr(this_day_Carbohydrates_g)
        this_day_Carbohydrates_point[meal] = normalize(this_day_Carbohydrates_g[meal] / Carbohydrates_list_to_use[meal])
        record.this_day_Carbohydrates_point = listToStr(this_day_Carbohydrates_point)
        totalCarboControl = myListSum(this_day_Carbohydrates_point) / len(this_day_Carbohydrates_point)
        record.totalCarboControlPoint = totalCarboControl

        # Fat calculations
        this_day_Fat_g = getList(record.this_day_Fat_list_g)
        this_day_Fat_g[meal] += Fat_used
        record.this_day_Fat_list_g = listToStr(this_day_Fat_g)
        this_day_Fat_list_point = getList(record.this_day_Fat_list_point)
        this_day_Fat_list_point[meal] = normalize(this_day_Fat_g[meal] / Fat_to_use)
        record.this_day_Fat_list_point = listToStr(this_day_Fat_list_point)

        # Protein calculations
        this_day_Protein_list_g = getList(record.this_day_Protein_list_g)
        this_day_Protein_list_g[meal] += Protein_used
        record.this_day_Protein_list_g = listToStr(this_day_Protein_list_g)
        this_day_Protein_list_point = getList(record.this_day_Protein_list_point)
        this_day_Protein_list_point[meal] = normalize(this_day_Protein_list_g[meal] / Protein_to_use)
        record.this_day_Protein_list_point = listToStr(this_day_Protein_list_point)

        # Calorie Calculations
        total_Calories_used = Calorie_used + record.total_Calories_used
        record.total_Calories_used = total_Calories_used
        record.total_Calories_Point = normalize(total_Calories_used / user.profile.CR)
        record.save()

        # HEI elements used and calculations ...
        # HEI_elements_used = getHEI_List(food, amount)  #
        Last_HEI_elements = getList(record.HEI_elements_list)
        sum_Of_HEI_elements = myListAdder(Last_HEI_elements, HEI_elements_sum)
        total_HEI_Point = HEI_Point_Calculator(sum_Of_HEI_elements,
                                               record.total_Calories_used)
        record.HEI_elements_list = listToStr(sum_Of_HEI_elements)
        record.total_HEI_Point = total_HEI_Point

        # update and save changes
        record.save()
        u = updateTotalPointDay(user, record)
        totalPoint = u["DayPoint"]
        record.total_points = totalPoint
        record.totalCooperationPoints = u["totalCooperate"]
        record.save()

        dt = dt - timedelta(days=1)


def delete_my_today_data():
    user = User.objects.filter(phone_number="09217761645")[0]

    dt = datetime.now()
    start = datetime.combine(dt.date(), time=time(0, 0, 0))
    temp = Eating.objects.filter(user=user, date_time__range=(start, dt))
    for item in temp:
        item.delete()
    temp = Activities_log.objects.filter(user=user, start_date_time__range=(start, dt))
    for item in temp:
        item.delete()

    temp = InsulinUsage.objects.filter(user=user, time__range=(start, dt))
    for item in temp:
        item.delete()

    point = Points.objects.filter(user=user, date=dt.date())
    if point.exists():
        point[0].delete()


def user_average_activity():
    users = User.objects.filter(isRegistered=True)
    act = []
    max_actives = []
    decade = [
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
    ]
    for user in users:
        points = Points.objects.filter(user=user).order_by("date")
        for i in range(10):
            if points.count() > i:
                decade[i] += 1

        if points.count() > 5:
            max_actives.append(user.phone_number)
            # user.profile.doctor_id = 8
            # user.profile.save()
        if points.count() > 2:
            element = []
            for i in range(len(points) - 1):
                delta = (points[i + 1].date - points[i].date).days
                element.append(delta)
            act.append(element)
    return {"act": act, "max_actives": max_actives, "numberOfGT2": len(act), "decade": decade}


def max_sugarMeasurement_users():
    users = User.objects.filter(isRegistered=True)
    act = []
    max_actives = []
    decade = [
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
    ]
    for user in users:
        sugars = SugarMeasurement.objects.filter(user=user)
        for i in range(10):
            if sugars.count() > i * 10:
                decade[i] += 1
        if sugars.count() >= 50:
            act.append(user.profile.first_name + " " + user.profile.last_name)

    return myResponse.OK("OK", {"act": act, "decade": decade})


def getUserOfDay():
    d = date(year=2019, month=11, day=22)
    users = User.objects.filter(created_at=d)
    list = []
    for u in users:
        list.append(u.phone_number)
    return list


def getUserDataInExcel():
    BASE_DIR = "/home2/idiair/idia/static/assets/reports_data/"
    file = "user_data_" + str(date.today())

    data = []
    index = []
    columns = ['جنسیت', 'سن', 'سال تشخیص']

    d = date(2019,11,22)
    users = User.objects.filter(created_at=d)

    for u in users:
        temp = ["", "", ""]
        index.append(u.phone_number)
        if u.profile.gender:
            temp[0] = "زن"
        else:
            temp[0] = "مرد"
        temp[1] = date.today().year -  u.profile.birth_date.year
        temp[2] = u.profile.detection_year
        data.append(temp)

    df = pd.DataFrame(data,
                      index=index,
                      columns=columns)
    df.to_excel(BASE_DIR + file + ".xlsx")


def create_user_code_for_last_users():
    users = User.objects.filter(isRegistered=True).order_by("created_at")


    code = "baaaa"
    alphabet = '0123456789' + 'abcdefghijklmnopqrstuvwxyz'  # radix 36 ---> 0 ... 35
    for ui in range(len(users)):
        arr = []

        if code == "zzzzz":
            code = "1" + "zzzzz"

        for i in range(len(code)):
            arr.append(alphabet.find(code[i]))
        arr[len(arr) - 1] += 1

        for i in range(len(arr)):
            if arr[len(arr) - i - 1] > 35:
                arr[len(arr) - i - 1] -= 36
                arr[len(arr) - i - 2] += 1

        result = ""
        for j in range(len(arr)):
            result += alphabet[arr[j]]
        code = result
        users[ui].profile.user_code = result
        users[ui].profile.register_time = users[ui].created_at
        users[ui].profile.save()


def getMatchIndex(item, l):
    for i in range(len(l)):
        if str(item) == str(l[i]):
            return i
    return -1


def getMatchIndex2(item, l, element):
    for i in range(len(l)):
        if str(item) == str(l[i].get(element)):
            return i
    return -1


def getDuplicatedFood(request):
    # # now save foods.xlsx file in the server...
    if request.FILES == {}:
        return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
    f = request.FILES["file"]
    name = str(request.FILES["file"]).split('.')
    if not (name[len(name) - 1] == "xlsx"):
        return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
    pathFromStatic = '/static/assets/foods/clearing/foods_' + str(datetime.now().date()) + '.xlsx'
    newFileName = settings.BASE_DIR + pathFromStatic
    with open(newFileName, 'wb+') as destination:
        for chunk in f.chunks():
            destination.write(chunk)
    destination.close()
    #
    # # create Foods...
    df = pandas.read_excel(newFileName)
    # # return myResponse.OK("df is: ", df.values()[0])
    # newFoodsAdded = 0
    # foodSaved = 0
    # foodInProccess = 0
    # daleteFood = []
    realFoods = []
    doubleCode = []
    for value in df.get_values():
        try:
            if not str(value[0]) == "nan":
                if getMatchIndex(str(int(value[0])), realFoods) > -1:
                    doubleCode.append(str(int(value[0])))
                realFoods.append(str(int(value[0])))

            else:
                pass
        except Exception as e:
            print(e)
    #
    # foods = Food.objects.all()
    #
    # data = {
    #     "todelete": todelete,
    #     "daleteFood": daleteFood,
    #     "absoloteFoodsIds": absoloteFoodsIds,
    #     "absoloteFoodsIdsNum": len(absoloteFoodsIds),
    #     "toDeleteFoodsIdsNum": len(toDeleteFoodsIds),
    # }

    foods = Food.objects.all()
    candelete = []
    candeleteName = []
    candeleteDBName = []
    for f in foods:
        temp = Food.objects.filter(FA_Name__exact=f.FA_Name)
        if temp.count() > 1:
            for foo in temp:
                eatings = Eating.objects.filter(food=foo)
                if not eatings.exists():
                    candelete.append(foo.id)
                    candeleteDBName.append(foo.Data_Base_Number)
                    candeleteName.append(foo.FA_Name + " " + foo.Data_Base_Number + " " +  str(foo.id))
    exactCode = []
    for id in candelete:
        if getMatchIndex2(id, exactCode, "id") == -1:
            food = Food.objects.filter(id=id)[0]
            temp = Eating.objects.filter(food=food)
            exactCode.append({
                "id": food.id,
                "dbnumber": food.Data_Base_Number,
                "name": food.FA_Name,
                "used": temp.exists()
            })
    ExactCanDeleteDBName = []
    for item in candeleteDBName:
        if getMatchIndex(item, realFoods) == -1:
            ExactCanDeleteDBName.append(item)


    for code in ExactCanDeleteDBName:
        foods = Food.objects.filter(Data_Base_Number=code)
        for f in foods:
            f.delete()

    SortedexactCode = sorted(exactCode, key=lambda d: d["name"])


    data = {
        "exactCode": SortedexactCode,
        "ExactCanDeleteDBName": ExactCanDeleteDBName,
        "doubleCode": doubleCode,
        "candelete": candelete,
        "candelete num": len(candelete),
        "candelete Name": sorted(candeleteName),
        "candelete Name num": len(candeleteName),
    }
    return myResponse.OK("to delete foods", data=data)


def ClearingFoods(request):
    try:
        # now save foods.xlsx file in the server...
        if request.FILES == {}:
            return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
        f = request.FILES["file"]
        name = str(request.FILES["file"]).split('.')
        if not (name[len(name) - 1] == "xlsx"):
            return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
        pathFromStatic = '/static/assets/foods/clearing/foods_' + str(datetime.now().date()) + '.xlsx'
        newFileName = settings.BASE_DIR + pathFromStatic
        with open(newFileName, 'wb+') as destination:
            for chunk in f.chunks():
                destination.write(chunk)
        destination.close()

        # create Foods...
        df = pandas.read_excel(newFileName)
        # return myResponse.OK("df is: ", df.values()[0])
        newFoodsAdded = 0
        foodSaved = 0
        foodInProccess = 0
        daleteFood = []
        realFoods = []
        for value in df.get_values():
            try:
                if not str(value[0]) == "nan":
                    realFoods.append(str(int(value[0])))

                else:
                    pass
            except Exception as e:
                print(e)

        foods = Food.objects.all()
        todelete = 0
        for food in foods:
            if getMatchIndex(food.Data_Base_Number, realFoods) == -1:
                todelete += 1
                daleteFood.append(food.FA_Name)
                food.delete()

        foods = Food.objects.all()

        absoloteFoodsIds = []
        toDeleteFoodsIds = []
        for food in foods:
            if getMatchIndex(str(food.Data_Base_Number), absoloteFoodsIds) == -1:
                absoloteFoodsIds.append(str(food.Data_Base_Number))
            else:
                toDeleteFoodsIds.append(food.Data_Base_Number)
                food.delete()

        data = {
            "todelete": todelete,
            "daleteFood": daleteFood,
            "absoloteFoodsIds": absoloteFoodsIds,
            "absoloteFoodsIdsNum": len(absoloteFoodsIds),
            "toDeleteFoodsIdsNum": len(toDeleteFoodsIds),
        }
        return data

    except ValueError:
        return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)


def fixMinMaxSugar():
    profiles = Profile.objects.filter(minimum_sugar=0, maximum_sugar=0)
    for pro in profiles:
        if not(pro.user_code == ""):
            pro.minimum_sugar = 70
            pro.maximum_sugar = 180
            pro.hyper = 240
            pro.hypo = 70
            pro.save()


def setRandomAvatar():
    profiles = Profile.objects.filter(avatar=0, weight__gt=1)
    for pro in profiles:
        if pro.gender == 0:
            pro.avatar = np.random.randint(1, 5)  # 1 to 4
        else:
            pro.avatar = np.random.randint(5, 9)  # 5 to 8
        pro.save()


def send_sms_norooz(toSend):
    print("sending norooz99 sms:")
    url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"

    counter = 0
    notsend = 0
    message = "نوروز ۹۹ را با آیدیا همراه باشید تا به بهترین شکل دیابت و قندخون خود را کنترل کنید." + "\n\n" + \
              "نصب و بروزرسانی در لینک زیر:\n" + "https://idiapp.app.link/norooz99"

    receptors = toSend
    # users = User.objects.all()
    try:
        for i in range(len(receptors)):
            counter += 1
            querystring = {"receptor": receptors[i],
                           "message": message}
            response = requests.request("POST", url, params=querystring)
            jresp = response.json()
            if jresp.get("return").get("status") == 200:
                pass
                # print(str(counter) + ": sent to " + receptor)
            else:
                notsend += 1
                # print(str(counter) + ": not sent. to " + receptor)
        return {
            "counter": counter,
            "not send": notsend
        }
    except Exception as e:
        print(e.args)
        return {
            "counter": counter,
            "not send": notsend
        }


def test_send_sms_norooz(request):
    f = request.FILES["file"]
    pathFromStatic = '/static/assets/sms/sms_' + str(datetime.now().date()) + '.xlsx'
    newFileName = settings.BASE_DIR + pathFromStatic
    with open(newFileName, 'wb+') as destination:
        for chunk in f.chunks():
            destination.write(chunk)
    destination.close()

    # create Foods...
    df = pandas.read_excel(newFileName)
    sent = []
    for value in df.get_values():
        if getMatchIndex("0" + str(value[0]), sent) == -1:
            sent.append("0" + str(value[0]))


    users = User.objects.all()
    tosend = []
    for u in users:
        if getMatchIndex(u.phone_number, sent) == -1:
            tosend.append(str(u.phone_number))

    return {
        "sent": sent,
        "sent_number": len(sent),
        "tosend": tosend,
        "to_send_number": len(tosend)
    }

    url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"

    counter = 0
    notsend = 0
    users = User.objects.all()
    message = "نوروز ۹۹ را با آیدیا همراه باشید تا به بهترین شکل دیابت و قندخون خود را کنترل کنید." + "\n\n" + \
              "نصب و بروزرسانی در لینک زیر:\n" + "https://idiapp.app.link/norooz99"


    counter += 1
    user = User.objects.filter(phone_number="09217761645")[0]
    receptor = user.phone_number
    querystring = {"receptor": receptor,
                   "message": message}
    if not (user.profile == None):
        response = requests.request("POST", url, params=querystring)
        jresp = response.json()
        if jresp.get("return").get("status") == 200:
            print(str(counter) + ": sent to " + receptor)
        else:
            notsend += 1
            print(str(counter) + ": not sent. to " + receptor)


def telegram_test(request):
    import telegram
    bot_token = '1087727284:AAGupztcvoXvj2xADgekty1U5oh_dNT7o3Y'

    BOT_TOKEN = bot_token
    bot = telegram.Bot(token=BOT_TOKEN)
    t = bot.get_chat_member("@idia_app", "163915331")
    return str(t)


def get_list_of_not_registerd():
    users = User.objects.filter(id__range=(7825, 7918))
    to_send = []
    for i in range(users.count()):
        if users[i].isRegistered == False:
            to_send.append(users[i].phone_number)
    return to_send


def ProvincesAnalize():
    Provinces = {
        "irancel": ["0901", "0902", "0930", "0933", "0935", "0936", "0937", "0938", "0939"],
        "hamrah_aval": ["0910", "0919"],
        "golestan_gilan_mazandaran": ["0911"],
        "tehran_alborz_zanjan_semnan_gom_gazvin": ["0912"],
        "esfahan_kerman_yazd_4mahal": ["0913"],
        "azarbayjanha": ["0914"],
        "khorasan_sistan": ["0915"],
        "khoozestan_lorestan": ["0916"],
        "fars_boierAhmad_hormozgan_booshehr": ["0917"],
        "hamedan_ilam_kordestan_kermanshah": ["0918"],
        "rightel": ["0921", "0920"],
        "other": [],
    }

    data = {
        "irancel": 0,
        "hamrah_aval": 0,
        "golestan_gilan_mazandaran": 0,
        "tehran_alborz_zanjan_semnan_gom_gazvin": 0,
        "esfahan_kerman_yazd_4mahal": 0,
        "azarbayjanha": 0,
        "khorasan_sistan": 0,
        "khoozestan_lorestan": 0,
        "fars_boierAhmad_hormozgan_booshehr": 0,
        "hamedan_ilam_kordestan_kermanshah": 0,
        "rightel": 0,
        "other": 0,
    }


    users = User.objects.all()
    for user in users:
        ph = user.phone_number[0:4]
        isInSet = False
        for idx in Provinces:
            if getMatchIndex(ph, Provinces[idx]) > -1:
                data[idx] += 1
                isInSet = True
        if isInSet is False:
            data["other"] += 1
    return data


def copyUserToUser():
    try:
        # copy u1 to u2
        u1 = User.objects.filter(phone_number="09922492918")[0]
        u2 = User.objects.filter(phone_number="09999999990")[0]
        u2.profile.insulin_long_effect = u1.profile.insulin_long_effect
        u2.profile.insulin_short_effect = u1.profile.insulin_short_effect
        u2.profile.hypo = u1.profile.hypo
        u2.profile.hyper = u1.profile.hyper
        u2.profile.save()

        sd = datetime(2020, 3, 20, 0, 0, 0)
        ed = datetime(2020, 4, 19, 0, 0, 0)

        insulins = InsulinUsage.objects.filter(user=u1, time__range=(sd, ed))
        for i1 in insulins:
            i2 = InsulinUsage(user=u2, time=i1.time, Insulin=i1.Insulin, amount=i1.amount, meal=i1.meal)
            i2.save()

        eating = Eating.objects.filter(date_time__range=(sd, ed), user=u1)
        for e1 in eating:
            e2 = Eating(user=u2, date_time=e1.date_time, food=e1.food, meal=e1.meal, amount=e1.amount)
            e2.save()

        sugars = SugarMeasurement.objects.filter(user=u1, time__range=(sd, ed))
        for s1 in sugars:
            s2 = SugarMeasurement(user=u2, time=s1.time, meal=s1.meal, amount=s1.amount, hypo=s1.hypo, hyper=s1.hyper)
            s2.save()

        acts = Activities_log.objects.filter(user=u1, start_date_time__range=(sd, ed))
        for a1 in acts:
            a2 = Activities_log(user=u2, start_date_time=a1.start_date_time, end_date_time=a1.end_date_time, amount=a1.amount, PALx=a1.PALx, energy=a1.energy)
            a2.save()

        poins = Points.objects.filter(date__range=(sd.date(), ed.date()), user=u1)
        for p1 in poins:
            p2 = Points(user=u2, date=p1.date)
            p2.save()

        return myResponse.OK("به درستی کپی شد", [])
    except Exception as e:
        return myResponse.Error(e.args, -1)


def updateFoodsOffline(foodFileName):
    try:
        pathFromStatic = '/static/assets/foods/' + foodFileName
        newFileName = settings.BASE_DIR + pathFromStatic

        # create Foods...
        df = pandas.read_excel(newFileName)
        # return myResponse.OK("df is: ", df.values()[0])
        newFoodsAdded = 0
        foodSaved = 0
        foodInProccess = 0
        # return myResponse.OK("ok", [])
        for value in df.get_values():
            try:
                if not str(value[0]) == "nan":
                    temp = Food.objects.filter(Data_Base_Number=str(int(value[0])))
                    if temp.exists():
                        f = temp[0]
                    else:
                        f = Food()
                        newFoodsAdded += 1
                    foodInProccess += 1
                    column_state = "0"
                    f.Data_Base_Number = str(int(value[0]))
                    column_state = "1"
                    f.FA_Name = str(value[1])
                    column_state = "2"
                    f.Protein_g = NaNtoInt(value[2])
                    column_state = "3"
                    f.Fat_g = NaNtoInt(value[3])
                    f.Carbohydrates_g = NaNtoInt(value[4])
                    f.HEI_1_Fruit = NaNtoInt(value[5])
                    f.HEI_2_Fruit = NaNtoInt(value[6])
                    f.HEI_1_Vegetables = NaNtoInt(value[7])
                    f.HEI_2_Vegetables = NaNtoInt(value[8])
                    f.HEI_Whole_Grain_Grains = NaNtoInt(value[9])
                    column_state = "10 to 20"
                    f.HEI_Dairy = NaNtoInt(value[10])
                    f.HEI_Protein_Foods = NaNtoInt(value[11])
                    f.HEI_Seafood_and_Plant_Proteins = NaNtoInt(value[12])
                    f.HEI_Refined_Grains = NaNtoInt(value[13])
                    f.HEI_Sodium = NaNtoInt(value[14])
                    f.HEI_Sugar = NaNtoInt(value[15])
                    f.Saturated_Fat_g = NaNtoInt(value[16])
                    f.dairy_unit = NaNtoInt(value[17])
                    f.fat_unit = NaNtoInt(value[18])
                    f.For_calculation = NaNtoInt(value[19])
                    column_state = "20 to 30"
                    f.cereal_unit = NaNtoInt(value[20])
                    f.meat_unit = NaNtoInt(value[21])
                    f.fruit_unit = NaNtoInt(value[22])
                    f.vegetables_unit = NaNtoInt(value[23])
                    f.Ash_g = NaNtoInt(value[24])
                    f.Calories = NaNtoInt(value[25])
                    f.Starch_g = NaNtoInt(value[26])
                    f.Sucrose_g = NaNtoInt(value[27])
                    f.Glucose_g = NaNtoInt(value[28])
                    f.Fructose_g = NaNtoInt(value[29])
                    column_state = "30 to 40"
                    f.Lactose_g = NaNtoInt(value[30])
                    f.Maltose_g = NaNtoInt(value[31])
                    f.Alcohol_g = NaNtoInt(value[32])
                    f.Water_g = NaNtoInt(value[33])
                    f.Caffeine_mg = NaNtoInt(value[34])
                    f.Theobromine_mg = NaNtoInt(value[35])
                    f.Sugar_g = NaNtoInt(value[36])
                    f.Galactose_g = NaNtoInt(value[37])
                    f.Fiber_g = NaNtoInt(value[38])
                    f.Calcium_mg = NaNtoInt(value[39])
                    column_state = "40 to 50"
                    f.Iron_mg = NaNtoInt(value[40])
                    f.Magnesium_mg = NaNtoInt(value[41])
                    f.Phosphorus_mg = NaNtoInt(value[42])
                    f.Potasssium_mg = NaNtoInt(value[43])
                    f.Sodium_mg = NaNtoInt(value[44])
                    f.Zinc_mg = NaNtoInt(value[45])
                    f.Cupper_mg = NaNtoInt(value[46])
                    f.Fluoride_mcg = NaNtoInt(value[47])
                    f.Manganese_mg = NaNtoInt(value[48])
                    f.Selenium_mcg = NaNtoInt(value[49])
                    column_state = "50 to 60"
                    f.Vitamin_A_IU = NaNtoInt(value[50])
                    f.Retinol_mcg = NaNtoInt(value[51])
                    f.Retinol_Equivalents_mcg = NaNtoInt(value[52])
                    f.Beta_Carotene_mcg = NaNtoInt(value[53])
                    f.Alpha_Carotene_mcg = NaNtoInt(value[54])
                    f.Vitamin_E_mg = NaNtoInt(value[55])
                    f.Vitamin_D_mcg = NaNtoInt(value[56])
                    f.Vitamin_D2_Ergocalciferol_mcg = NaNtoInt(value[57])
                    f.Vitamin_D3_Cholecalciferol_mcg = NaNtoInt(value[58])
                    f.Beta_Cryptoxanthin_mcg = NaNtoInt(value[59])
                    column_state = "60 to 70"
                    f.Lycopene_mcg = NaNtoInt(value[60])
                    f.Lutein_and_Zeaxanthin_mcg = NaNtoInt(value[61])
                    f.Vitamin_C_mg = NaNtoInt(value[62])
                    f.Vitamin_B1_mg = NaNtoInt(value[63])
                    f.Vitamin_B2_mg = NaNtoInt(value[64])
                    f.Vitamin_B3_mg = NaNtoInt(value[65])
                    f.Vitamin_B5_mg = NaNtoInt(value[66])
                    f.Vitamin_B6_mg = NaNtoInt(value[67])
                    f.Vitamin_B9_mg = NaNtoInt(value[68])
                    f.Vitamin_B12 = NaNtoInt(value[69])
                    column_state = "70 to 74"
                    f.Choline_mg = NaNtoInt(value[70])
                    f.Cholesterol_mg = NaNtoInt(value[71])
                    f.Saturated_Fat_g = NaNtoInt(value[72])
                    f.PUFA = NaNtoInt(value[73])
                    f.MUFA = NaNtoInt(value[74])
                    # return myResponse.OK("ok", [])
                    f.save()
                    foodSaved += 1
                else:
                    return myResponse.Error("saved foods= " + str(foodSaved) +
                                            "\nadded Foods= " + str(newFoodsAdded) +
                                            "\nError in record: " + str(foodInProccess + 2),
                                            Errors.ErrorInExcelFile.code)
            except ValueError as e:
                return myResponse.Error(str(e.args[0]) +
                                        "\nError occurred on line " + str(
                    foodInProccess + 1) + "  and column: " + column_state
                                        + "\nsaved foods= " + str(foodSaved) +
                                        "\nadded Foods= " + str(newFoodsAdded) +
                                        "\nError in record: " + str(foodInProccess + 1),
                                        Errors.InvalidArgument.code)

        temp = {
            "NumberOfFoods": len(df.get_values()),
            "newFoodsAdded": newFoodsAdded,
            "saved_foods": foodSaved
        }

        # Save to Update Tabe
        UTable = UpdateTable.objects.filter(Type="foods")
        if UTable.exists():
            ut = UTable[0]
        else:
            ut = UpdateTable(Type="foods")
        ut.FileUpdateName = pathFromStatic
        ut.DateTime = datetime.fromtimestamp(int(datetime.now().timestamp()))
        ut.save()

        return myResponse.OK("اطلاعات غذا ها ثبت شد.", temp)
    except Exception as e:
        return myResponse.Error(e.args, -1)


def generateTimes():
    for i in range(40):
        d = (i % 2 == 0)
        if d:
            t1 = datetime(1, 1, 1, hour=np.random.randint(0, 3),
                          minute=np.random.randint(0, 59))
            t2 = t1 + timedelta(minutes=np.random.randint(200, 250))
            ti1 = t1.time()
            ti2 = t2.time()
        else:
            t1 = datetime(1, 1, 1, hour=np.random.randint(15, 18),
                          minute=np.random.randint(0, 59))
            t2 = t1 + timedelta(minutes=np.random.randint(200, 300))
            ti1 = t1.time()
            ti2 = t2.time()
        waste = np.random.randint(0, 5) * 10
        print(ti1, " ", ti2, " ", timedelta(minutes=waste))


def aiTest(request):
    # do the last four lines for each image
    image_path = settings.BASE_DIR + '/static/AImodels/image.jpg'

    # tensor = pred.load_image(str(image_path))
    #
    # output = pred.infer(tensor)
    #
    # output_str_num = pred.get_number(output)
    #
    # return myResponse.OK("output_str_num", output_str_num)

    try:
        # import tensorflow as tf
        # c = tf.reduce_sum(tf.random.normal([1000, 1000]))
        # a = tf.constant([1.0, 2.0, 3.0, 4.0, 5.0, 6.0], shape=[2, 3], name='a')
        #
        # b = tf.constant([1.0, 2.0, 3.0, 4.0, 5.0, 6.0], shape=[3, 2], name='b')
        #
        # c = tf.matmul(a, b)
        # c = 10
        c = 10
        return myResponse.OK(str(c), str(c))
    except Exception as e:
        return myResponse.Error(e.args, -1)


def sanofiData():
    data = []
    tms = [
        # datetime(2019, 6, 1, 0, 0, 0),
        # datetime(2019, 7, 1, 0, 0, 0),
        # datetime(2019, 8, 1, 0, 0, 0),
        # datetime(2019, 9, 1, 0, 0, 0),
        # datetime(2019, 10, 1, 0, 0, 0),
        # datetime(2019, 11, 1, 0, 0, 0),
        # datetime(2019, 12, 1, 0, 0, 0),
        # datetime(2020, 1, 1, 0, 0, 0),
        # datetime(2020, 2, 1, 0, 0, 0),
        # datetime(2020, 3, 1, 0, 0, 0),
        # datetime(2020, 4, 1, 0, 0, 0),
        # datetime(2020, 5, 1, 0, 0, 0),
        # datetime(2020, 6, 1, 0, 0, 0),
        # datetime(2020, 6, 1, 0, 0, 0),
        # datetime(2020, 7, 1, 0, 0, 0),
        datetime(2020, 8, 1, 0, 0, 0),
        datetime(2020, 9, 1, 0, 0, 0),
        datetime(2020, 10, 1, 0, 0, 0),
        datetime(2020, 11, 1, 0, 0, 0),
        datetime(2020, 12, 1, 0, 0, 0),
        datetime(2021, 1, 1, 0, 0, 0),
        datetime(2021, 2, 1, 0, 0, 0),
        datetime(2021, 3, 1, 0, 0, 0),
        datetime(2021, 4, 1, 0, 0, 0),
        datetime(2021, 4, 19, 0, 0, 0),
    ]

    for i in range(len(tms)):
        type1 = 0
        type2 = 0
        othertype = 0

        drug = 0
        insulin = 0
        otherdrug = 0

        t = tms[i]
        users = User.objects.filter(created_at__lte=t.date())
        real_user = users.filter(isRegistered=True)
        for u in real_user:
            if u.profile.diabetes_type == 1:
                type1 += 1
            if u.profile.diabetes_type == 2:
                type2 += 1
            if u.profile.diabetes_type == 0:
                othertype += 1

            if str(u.profile.type_of_treatment).count("1") > 0:
                insulin += 1
            if str(u.profile.type_of_treatment).count("0") > 0:
                drug += 1
            if str(u.profile.type_of_treatment).count("2") > 0:
                otherdrug += 1

        am = users.count()
        type11 = type1 + round((am - type1 - type2) * 0.4)
        type22 = type2 + round((am - type1 - type2) * 0.6)
        # othertype2 = othertype + round((am - type1 - type2) * 0.05)

        drug2 = round((drug / real_user.count()) * am)
        insulin2 = round((insulin / real_user.count()) * am)
        otherdrug2 = round((otherdrug / real_user.count()) * am)

        data.append({
            "date": t.date(),
            "am": users.count(),
            "real_am": real_user.count(),
            "type1": type1,
            "type2": type2,
            "other_type": othertype,
            "type11": int(type11),
            "type22": int(type22),
            # "other_type2": int(othertype2),
            "insulin": insulin,
            "drug": drug,
            "otherdrug": otherdrug,
            "insulin2": insulin2,
            "drug2": drug2,
            "otherdrug2": otherdrug2,
        })

    result = {}
    result["data"] = data
    insulinFrequency = []
    insulinSelected = 0
    insulins = Insulin.objects.all().order_by("id")
    d = users.count() / real_user.count()
    insulin_not_selected = real_user.filter(Q(profile__type_of_treatment="1") & Q(profile__insulin_long_effect=None) & Q(profile__insulin_short_effect=None)).count()

    # return myResponse.OK("d={d}, ins2={ins2}, ins1={ins1}, notselect={ns}, slect={select}".format(d=d, ins2=insulin2, ins1=insulin, ns=insulin_not_selected, select=(insulin - insulin_not_selected)), [])
    for ins in insulins:
        number = Profile.objects.filter(Q(insulin_long_effect=ins) | Q(insulin_short_effect=ins)).count()
        insulinSelected += number
        insulinFrequency.append({
            "name": ins.name,
            "frequency": number,
            "scaled_frequency": 0,
            "percentage": 0,
        })

    d = 2 * (insulin2 * 0.95) / insulinSelected  # 93 % of user with insulin treatment has selected insulin
    for item in insulinFrequency:
        item["scaled_frequency"] = int(item["frequency"] * d)
        item["percentage"] = round((item["frequency"] / insulinSelected) * 100, 2)
    result["insulinFrequency"] = insulinFrequency
    result["real_insulinSelected"] = insulinSelected
    result["scaled_insulinSelected"] = int(insulinSelected * d)
    result["scaler d"] = d
    result["linkReport"] = Report.objects.all().count()


    return myResponse.OK("ok", result)


def danesh_bonyan_data():
    weeks = 25
    weekly_actives = []
    weekly_active_time = []
    dx = datetime.now()
    for i in range(weeks):
        d0 = dx - timedelta(days=7)
        n = Points.objects.filter(date__range=(d0.date(), dx.date())).count()
        weekly_actives.append({
            "date": dx.date(),
            "number": n
        })

        m = 0
        m += Activities_log.objects.filter(start_date_time__range=(d0, dx)).count()
        m += SugarMeasurement.objects.filter(time__range=(d0, dx)).count()
        m += Eating.objects.filter(date_time__range=(d0, dx)).count()
        m += Feeling.objects.filter(time__range=(d0, dx)).count()
        m += InsulinUsage.objects.filter(time__range=(d0, dx)).count()
        m += BloodPressure.objects.filter(time__range=(d0, dx)).count()
        m += DrugUsage.objects.filter(time__range=(d0, dx)).count()
        m += Weights.objects.filter(time__range=(d0.date(), dx.date())).count()
        m += Walking.objects.filter(date__range=(d0.date(), dx.date())).count()

        weekly_active_time.append({
            "date": dx.date(),
            "number": round((m / n) * 2) * 7
        })
        dx = dx - timedelta(days=7)

    data = {}
    data["weekly_actives"] = weekly_actives[::-1]
    data["weekly_active_time"] = weekly_active_time[::-1]



    return myResponse.OK("ok", data)

def dayly_report():
    # for i in range(1000):
    #     d = date.today() - timedelta(days=(999 - i))
    #     analysis = Analysis(date=d)
    #     analysis.save()

    # analysiss = Analysis.objects.all().order_by("date")
    # for an in analysiss:
    #     d = an.date
    #     t = datetime.combine(date=d, time=time(23, 59, 59))
    #     users = User.objects.filter(created_at__lte=t)
    #     an.user_counter = users.count()
    #     reg_users = users.filter(isRegistered=True)
    #     an.registered_user_counter = reg_users.count()
    #     an.save()

    for i in range(1000):
        d = date.today() - timedelta(days=(999 - i))
        an = Analysis.objects.filter(date=d)[0]
        ds = datetime.combine(date=d, time=time(0, 0, 0))
        de = datetime.combine(date=d, time=time(23, 59, 59, 999))
        temp = 0

        sumation = 0
        temp = DrugUsage.objects.filter(time__range=(ds, de)).count()
        sumation += temp
        an.drug_logs = temp

        temp = SugarMeasurement.objects.filter(time__range=(ds, de)).count()
        an.sugar_logs = temp
        sumation += temp

        temp = Activities_log.objects.filter(start_date_time__range=(ds, de)).count()
        an.activities_logs = temp
        sumation += temp

        temp = Eating.objects.filter(date_time__range=(ds, de)).count()
        an.eating_logs = temp
        sumation += temp

        temp = InsulinUsage.objects.filter(time__range=(ds, de)).count()
        an.insulin_logs = temp
        sumation += temp

        temp = Feeling.objects.filter(time__range=(ds, de)).count()
        an.feeling_logs = temp
        sumation += temp

        temp = Message.objects.filter(time__range=(ds, de)).count()
        an.message_logs = temp
        sumation += temp

        temp = Walking.objects.filter(date=d).count()
        an.walking_logs = temp
        sumation += temp

        temp = BloodPressure.objects.filter(time__range=(ds, de)).count()
        an.pressure_logs = temp
        sumation += temp

        an.sumation_logs = sumation

        an.active_user_counter = Points.objects.filter(date=d).count()
        an.save()
        return myResponse.OK("ok", [])


def active_users():
    users = User.objects.filter(isRegistered=True)

    data = []
    index = []
    for user in users:
        points = Points.objects.filter(user=user).order_by("date")

        if points.count() > 10:
            temp = [user.profile.first_name, user.profile.last_name, points.count(), points[points.count() -1].date]
            index.append(user.phone_number)
            data.append(temp)

    BASE_DIR = settings.BASE_DIR + "/static/assets/reports_data/"
    file = "active_user_data_" + str(date.today())

    columns = ['نام', 'نام خانوادگی', 'روز های فعالیت', 'تاریخ آخرین تراکنش']

    df = pd.DataFrame(data,
                      index=index,
                      columns=columns)
    df.to_excel(BASE_DIR + file + ".xlsx")
    return myResponse.OK("file " + file + " created!", [])

def sendEmail(code, recip):
    from django.core.mail import send_mail
    html_message = '''
                <h4>
                    با سلام، کد فعالسازی شما جهت ورود به برنامه آیدیا
                </h4>
                <br>
                <h1>
                    {code}
                </h1>
                <br>
                <h4>
                     این کد تنها تا 4 دقیقه دیگر اعتبار خواهد داشت.
                </h4>
                <br>
                <h5>
                    <a href="https://idia.app">اپلیکیشن کنترل دیابت و قندخون آیدیا</a>
                <h5>
            '''.format(code=code)
    result = send_mail(
        subject='کد فعالسازی برنامه آیدیا',
        from_email='activation@idia.app',
        message="",
        recipient_list=[recip],
        fail_silently=False,
        html_message=html_message
    )
    return myResponse.OK("email sending", result)


@api_view(["POST"])
def parallel(request):
    t0 = datetime.now()
    z = 0
    for i in range(9000000):
        z = i
        pass
    t1 = datetime.now()
    return myResponse.OK("ok", {"t0":t0.ctime(), "t1":t1.ctime(), "duration":t1.timestamp() - t0.timestamp()})


def insulin_selections():
    users = User.objects.filter(isRegistered=True)
    selectons = InsulinTypeSelection.objects.all()
    for sel in selectons:
        sel.delete()

    for user in users:
        if user.profile is not None:
            try:
                if user.profile.insulin_short_effect is not None:
                    insulin_selection = InsulinTypeSelection(user=user, insulin=user.profile.insulin_short_effect, start=user.created_at)
                    insulin_selection.save()
                if user.profile.insulin_long_effect is not None:
                    insulin_selection = InsulinTypeSelection(user=user, insulin=user.profile.insulin_long_effect, start=user.created_at)
                    insulin_selection.save()
            except:
                pass


# def insulin_selections_date_repair():
#     users = User.objects.filter(isRegistered=True)
#     for user in users:
#         if user.profile is not None:
#             temp = InsulinTypeSelection.objects.filter(user=user)
#             for item in temp:
#                 item.start = user.created_at
#                 item.save()


def amin_analysis():
    import threading
    def run():
        users = User.objects.filter(isRegistered=True)
        data = [['a1c', 'estimated a1c', 'age', 'gender', 'time interval', 'diabetes types', 'average score']]
        now = datetime.now()

        for user in users:
            row = [user.profile.a1c]

            # A one C
            SM = SugarMeasurement.objects.filter(user=user, time__gte=(now - timedelta(days=24*30)))
            sm_average = 0
            sm_sum = 0
            sm_num = SM.count()
            # A1C_state = False
            A1C = None  # default
            # if sm_num > 2:
            #     for item in SM:
            #         if item.time < datetime.now() - timedelta(days=3):
            #             A1C_state = True

            if sm_num > 2:
                for sm in SM:
                    sm_sum += sm.amount
                sm_average = sm_sum / sm_num
                A1C = round((sm_average + 46.7) / 28.7, 1)

            row.append(A1C)

            row.append(user.profile.age)
            if user.profile.gender == 0:
                row.append('male')
            else:
                row.append('female')

            points = Points.objects.filter(user=user).order_by('date')
            number = points.count()
            if number >= 2:
                time_interval = points[number-1].date - points[0].date
                row.append(time_interval.days)
            else:
                row.append(None)

            row.append(user.profile.diabetes_type)


            # average score
            score_summation = 0
            for p in points:
                score_summation += p.total_points
            if score_summation > 0:
                average_score = score_summation / len(points)
            else:
                average_score = None
            row.append(average_score)

            data.append(row)

        report_dir = settings.BASE_DIR + '/static/assets/reports_data/amin_analysis/{}.csv'.format(str(now))
        file = open(report_dir, 'w')
        for row in data:
            file.write('{},{},{},{},{},{},{}\n'.format(row[0], row[1], row[2], row[3], row[4], row[5], row[6]))

        file.close()


    t = threading.Thread(target=run)
    t.start()


def all_users_list():
    data = []
    users = User.objects.filter(isRegistered=True)
    for u in users:
        try:
            item = [u.phone_number, ""]
            if u.isRegistered != None:
                item[1] = u.profile.first_name + " " + u.profile.last_name
            data.append(item)
        except Exception as e:
            print(e)

    return data
    # now = datetime.now()
    # report_dir = settings.BASE_DIR + '/static/assets/reports_data/hamid_analysis/{}.csv'.format(str(now))
    # file = open(report_dir, 'w')
    # file.write("phone,name\n")
    # for row in data:
    #     file.write('{},{}\n'.format(row[0], row[1]))
    #
    # file.close()
