from .views import *
from jdatetime import datetime as jdatetime
import requests
from django.db.models import Q

def getDoctor():
    temp = Doctor.objects.filter(isActive=True)
    if temp.exists():
        random = np.random.randint(temp.count())
        return temp[random]

@api_view(["POST"])
def sendMessage(request):
    RequsetChecker(request.POST, [
        {
            "name": "token",
            "format": "^(\S){30}$"
        },
        {
            "name": "phone_number",
            "format": "^09[0-9]{9}$"
        },
        {
            "name": "text",
            "format": "."
        },
        {
            "name": "title",
            "format": "."
        }
    ], request)

    token = str(request.POST["token"])
    phone = str(request.POST["phone_number"])

    u = User.objects.filter(token=token, phone_number=phone)
    if not u.exists():
        return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
    user = u[0]

    text = str(request.POST["text"])
    if len(text) < 5:
        return myResponse.Error(Errors.BadMessageText.message, Errors.BadMessageText.code)

    title = str(request.POST["title"])
    if len(title) < 3:
        return myResponse.Error(Errors.BadMessageTitle.message, Errors.BadMessageTitle.code)

    message = Message(user=user, request_text=text, title=title, user_seen=True)
    if title == "doctor":
        if user.profile.doctor is None:
            user.profile.doctor = getDoctor()  # todo ----> This id belongs to Dr.Tabesh
            user.profile.save()
        message.employee = user.profile.doctor.django_user

    else:
        #todo: Implement the message distribution algorithm here
        message.employee_id = 325
    message.save()

    record_date = date.today()
    p = Points.objects.filter(user=user, date=record_date)
    if not p.exists():
        record = Points(user=user, date=record_date)
        record.save()


    # send message to admin ...
    try:
        url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"
        # if len(text) < 20:
        #     summary = text.
        # else:
        #     summary = text[0:20] + "..."
        # print(summary)
        querystring = {"receptor": "09217761645", "message": "کاربر:\n" + str(user.profile.first_name) + " " + str(user.profile.last_name) + "\n" + str(text)[0:10]}
        response = requests.request("POST", url, params=querystring)
    except Exception as e:
        return myResponse.Error(str(e), [])

    return myResponse.OK("پیغام شما ثبت شد، همکاران ما به زودی پاسخگوی شما خواهند بود. باتشکر، آیدیا", [])


@api_view(["POST"])
def getRecentMessage(request):
    RequsetChecker(request.POST, [
        {
            "name": "token",
            "format": "^(\S){30}$"
        },
        {
            "name": "phone_number",
            "format": "^09[0-9]{9}$"
        },
        {
            "name": "num",
            "format": "^[0-9]+$",
            "errorMessage": "num ،در این فیلد تعداد پیام های اخیر را مشخص کنید. ماکزیمم 10 پیام"
        },
        {
            "name": "title",
            "format": ".",
            "errorMessage": "num ،در این فیلد تعداد پیام های اخیر را مشخص کنید. ماکزیمم 10 پیام",
            "required": False
        }
    ], request)

    token = str(request.POST["token"])
    phone = str(request.POST["phone_number"])

    u = User.objects.filter(token=token, phone_number=phone)
    if not u.exists():
        return myResponse.Error(Errors.InvalidToken.message, Errors.InvalidToken.code)
    user = u[0]

    title = request.POST.get("title")
    if title is None:
        temp = Message.objects.filter(user=user).order_by("-time")
        if not temp.exists():
            return myResponse.Error(Errors.HaveNotMessage.message, Errors.HaveNotMessage.code)
    else:
        if title == "doctor":  # doctor
            temp = Message.objects.filter(user=user, title=title).order_by("-time")
            if not temp.exists():
                return myResponse.Error(Errors.HaveNotMessage.message, Errors.HaveNotMessage.code)
        elif title == "support":
            # all message - doctor
            temp = Message.objects.filter(Q(user=user) & (~Q(title="doctor"))).order_by("-time")
            if not temp.exists():
                return myResponse.Error(Errors.HaveNotMessage.message, Errors.HaveNotMessage.code)
        else:
            temp = Message.objects.filter(user=user).order_by("-time")
            if not temp.exists():
                return myResponse.Error(Errors.HaveNotMessage.message, Errors.HaveNotMessage.code)
    num = int(request.POST["num"])
    temp_len = len(temp)
    max_number_message = min(30, temp_len, num)
    data = []
    for i in range(max_number_message):
        item = {
            "time": str(jdatetime.fromgregorian(datetime=temp[i].time)),
            "response_time": None,
            "title": temp[i].title,
            "request_text": temp[i].request_text,
            "response_text": temp[i].response_text,
            "is_Answered": temp[i].is_answered,
            "direction": temp[i].direction
        }
        if temp[i].response_time is None:
            item["response_time"] = None
        else:
            item["response_time"] = str(jdatetime.fromgregorian(datetime=temp[i].response_time))
        data.append(item)
        if temp[i].is_answered:  # number of fetch after answering
            temp[i].number_of_fetchs += 1
        temp[i].user_seen = True
        temp[i].save()
    return myResponse.OK("گفت و گو های اخیر", data)
