from .views import *
import jdatetime
from django.contrib.auth.decorators import login_required
from django.views.decorators.csrf import csrf_exempt
from django.db import transaction
import pandas as pd
from django.core.exceptions import ObjectDoesNotExist
import ast
import os
from panel.models import Doctor

# The simple, raw way to limit access to pages is to check request.user.is_authenticated and either redirect to a login page:

ADMIN_NAME = 'hypo'


@csrf_exempt
@login_required(login_url='/{admin}/login'.format(admin=ADMIN_NAME))
@api_view(["GET"])
def home(request):
    if request.method == 'POST':
        return myResponse.Error("no Post", -1)
    else:
        try:
            return render(request, "Support/index.html")
        except Exception as e:
            return myResponse.Error(e.args, -1)


@csrf_exempt
@login_required(login_url='/{admin}/login'.format(admin=ADMIN_NAME))
# @api_view(["POST", "GET"])
def charts(request):
    if request.method == 'POST':
        title = request.POST["title"]
        link = request.POST["link"]
        summary = request.POST["summary"]
        if len(title) < 4:
            return myResponse.Error(Errors.BadTiltle.message, Errors.BadTiltle.code)
        if len(link) < 5:
            return myResponse.Error(Errors.BadLink.message, Errors.BadLink.code)
        notif = Notification()
        notif.Title = title
        notif.Link = link
        notif.Summary = summary
        notif.datetime = datetime.now()
        notif.save()
        return myResponse.OK("پیغام ذخیره شد", [])
    else:
        try:
            t0 = datetime.now()

            durations = 30
            dt = date.today() - timedelta(days=durations)
            dt_2 = date.today() - timedelta(days=30)
            dt_end = date.today()
            p = datetime.now()
            p_start = datetime.combine(p.date(), time(0, 0, 0))
            p_end = datetime.combine(p.date(), time(23, 59, 59))
            active_in_30_days_ago = []
            AllUsers = User.objects.all()
            today_active_user = []
            today_active_user_transaction = []
            points = Points.objects.filter(date=p.date())

            for i in range(durations + 1):
                x = durations - i
                t_start = dt_2 - timedelta(days=x)
                t_stop = dt_end - timedelta(days=x)
                actives = 0

                for u in AllUsers:
                    temp = 0
                    temp += Eating.objects.filter(user=u, date_time__range=(t_start, t_stop)).count()
                    temp += InsulinUsage.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Activities_log.objects.filter(user=u, start_date_time__range=(t_start, t_stop)).count()
                    temp += DrugUsage.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Feeling.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Walking.objects.filter(user=u, date__range=(t_start, t_stop)).count()
                    temp += SugarMeasurement.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Message.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    if temp > 0:
                        actives += 1
                active_in_30_days_ago.append(actives)

            for i in range(points.count()):
                temp = 0
                temp += Eating.objects.filter(user=points[i].user, date_time__range=(p_start, p_end)).count()
                temp += InsulinUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Activities_log.objects.filter(user=points[i].user,
                                                      start_date_time__range=(p_start, p_end)).count()
                temp += DrugUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Feeling.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Walking.objects.filter(user=points[i].user, date=p.date()).count()
                temp += SugarMeasurement.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Message.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()

                # Since the rating is registered, then the user is definitely active
                today_active_user.append(points[i].user.phone_number)
                today_active_user_transaction.append(temp)

            users = User.objects.filter(created_at__gte=dt)
            user_counter = []
            registered_user_counter = []
            active_user_counter = []
            date_array = []
            insulin_logs_list = []
            activities_logs_list = []
            drug_logs_list = []
            feeling_logs_list = []
            message_logs_list = []
            eating_logs_list = []
            sumation_list = []
            sugar_logs_list = []
            walking_logs_list = []

            number_of_last_users = User.objects.filter(created_at__lt=dt).count()
            number_of_last_registered_users = User.objects.filter(created_at__lt=dt, isRegistered=True).count()

            for i in range(durations + 1):
                try:
                    sumation = 0
                    number_of_last_users = users.filter(created_at=dt).count() + number_of_last_users
                    user_counter.append(number_of_last_users)
                    number_of_last_registered_users = users.filter(created_at=dt,
                                                                   isRegistered=True).count() + number_of_last_registered_users
                    registered_user_counter.append(number_of_last_registered_users)

                    active_user_counter.append(Points.objects.filter(date=dt).count())

                    temp = InsulinUsage.objects.filter(time__year=dt.year,
                                                       time__month=dt.month,
                                                       time__day=dt.day).count()
                    sumation += temp
                    insulin_logs_list.append(temp)

                    temp = Activities_log.objects.filter(start_date_time__year=dt.year,
                                                         start_date_time__month=dt.month,
                                                         start_date_time__day=dt.day).count()
                    sumation += temp
                    activities_logs_list.append(temp)

                    temp = DrugUsage.objects.filter(time__year=dt.year,
                                                    time__month=dt.month,
                                                    time__day=dt.day).count()
                    sumation += temp
                    drug_logs_list.append(temp)

                    temp = SugarMeasurement.objects.filter(time__year=dt.year,
                                                           time__month=dt.month,
                                                           time__day=dt.day).count()
                    sumation += temp
                    sugar_logs_list.append(temp)

                    temp = Walking.objects.filter(date=dt).count()
                    sumation += temp
                    walking_logs_list.append(temp)

                    temp = Feeling.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    feeling_logs_list.append(temp)

                    temp = Message.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    message_logs_list.append(temp)

                    temp = Eating.objects.filter(date_time__year=dt.year,
                                                 date_time__month=dt.month,
                                                 date_time__day=dt.day).count()
                    sumation += temp
                    sumation_list.append(sumation)
                    eating_logs_list.append(temp)
                    date_array.append(str(dt))
                    # date_array.append(str(jdatetime.date.fromgregorian(date=dt)))
                    dt = dt + timedelta(days=1)

                except Exception as e:
                    return myResponse.Error(str(e), [])
            t1 = datetime.now()
            context = {
                "user_counter": user_counter,
                "registered_user_counter": registered_user_counter,
                "date": date_array,
                "active_user_counter": active_user_counter,
                "insulin_logs_list": insulin_logs_list,
                "activities_logs_list": activities_logs_list,
                "drug_logs_list": drug_logs_list,
                "sugar_logs_list": sugar_logs_list,
                "walking_logs_list": walking_logs_list,
                "feeling_logs_list": feeling_logs_list,
                "message_logs_list": message_logs_list,
                "eating_logs_list": eating_logs_list,
                "sumation_logs_list": sumation_list,
                "active_in_30_days_ago": active_in_30_days_ago,
                "today_active_user": today_active_user,
                "today_active_user_transaction": today_active_user_transaction,
                "range": range(len(today_active_user)),
                "time": str(jdatetime.datetime.fromgregorian(datetime=datetime.now())),
                "exe_time": t1 - t0,
            }

            return render(request, "admin/test/AdminDashboard.html", context=context)

        except Exception as e:
            return myResponse.Error(e.args, -1)


@csrf_exempt
@login_required(login_url='/{admin}/login'.format(admin=ADMIN_NAME))
@api_view(["POST", "GET"])
def home_ofline(request):
    if request.method == 'POST':
        return myResponse.Error("no post", [])
    else:
        try:
            report_file = open(STATIC_ROOT + "/logs/DailyReportsData.txt", "r")

            t = str(report_file.readline())

            exe_time = str(report_file.readline())

            date_array = []
            d_array = str(report_file.readline()).split("&")
            for item in d_array:
                if item.count("-") > 0:
                    date_array.append(item)

            user_counter = getList(str(report_file.readline()))

            registered_user_counter = getList(str(report_file.readline()))

            new_user_per_day = []
            for i in range(len(registered_user_counter)):
                if i == 0:
                    new_user_per_day.append(0)
                else:
                    new_user_per_day.append(registered_user_counter[i] - registered_user_counter[i - 1])
            new_user_per_day[0] = new_user_per_day[1]

            correct_installation_rate = [0.3]  # 0.3 for first day!
            for i in range(1, len(new_user_per_day), 1):
                all = user_counter[i] - user_counter[i - 1]
                percentage = (new_user_per_day[i] / all) * 100
                if percentage > 100:
                    percentage = 100
                correct_installation_rate.append(percentage)
            correct_installation_rate[0] = correct_installation_rate[1]

            active_user_counter = getList(str(report_file.readline()))

            insulin_logs_list = getList(str(report_file.readline()))

            activities_logs_list = getList(str(report_file.readline()))

            drug_logs_list = getList(str(report_file.readline()))

            sugar_logs_list = getList(str(report_file.readline()))

            walking_logs_list = getList(str(report_file.readline()))

            feeling_logs_list = getList(str(report_file.readline()))

            message_logs_list = getList(str(report_file.readline()))

            eating_logs_list = getList(str(report_file.readline()))

            sumation_logs_list = getList(str(report_file.readline()))

            active_in_30_days_ago = getList(str(report_file.readline()))

            today_active_user = getList(str(report_file.readline()))

            today_active_user_transaction = getList(str(report_file.readline()))

            # user list to add them in telegram channel
            last_day = date.today() - timedelta(days=1)
            newUsers = User.objects.filter(created_at=last_day)
            context = {
                "user_counter": user_counter,
                "registered_user_counter": registered_user_counter,
                "new_user_per_day": new_user_per_day,
                "correct_installation_rate": correct_installation_rate,
                "date": date_array,
                "active_user_counter": active_user_counter,
                "insulin_logs_list": insulin_logs_list,
                "activities_logs_list": activities_logs_list,
                "drug_logs_list": drug_logs_list,
                "sugar_logs_list": sugar_logs_list,
                "walking_logs_list": walking_logs_list,
                "feeling_logs_list": feeling_logs_list,
                "message_logs_list": message_logs_list,
                "eating_logs_list": eating_logs_list,
                "sumation_logs_list": sumation_logs_list,
                "active_in_30_days_ago": active_in_30_days_ago,
                "today_active_user": today_active_user,
                "today_active_user_transaction": today_active_user_transaction,
                "range": range(len(today_active_user)),
                "time": t,
                "exe_time": exe_time,
                "newUsers": newUsers
            }

            return render(request, "admin/test/AdminDashboard.html", context=context)

        except Exception as e:
            return myResponse.Error(e.args, -1)


@api_view(["POST"])
def recent_data(request):
    user = request.POST.get("user")
    password = request.POST.get("password")
    if user == "User_Update_Report_Data" and password == "%easwdVYTY@#$%^(&$9sd8u(*Y&$^%ef&^*sdeG&(Hd*)J(K":
        durations = int(request.POST.get("durations"))
        try:
            t0 = datetime.now()

            dt = date.today() - timedelta(days=durations)
            dt_2 = date.today() - timedelta(days=30)
            dt_end = date.today()
            p = datetime.now()
            p_start = datetime.combine(p.date(), time(0, 0, 0))
            p_end = datetime.combine(p.date(), time(23, 59, 59))
            active_in_30_days_ago = []
            AllUsers = User.objects.all()
            today_active_user = []
            today_active_user_transaction = []
            points = Points.objects.filter(date=p.date())

            for i in range(durations + 1):
                x = durations - i
                t_start = dt_2 - timedelta(days=x)
                t_stop = dt_end - timedelta(days=x)
                actives = 0

                for u in AllUsers:
                    temp = 0
                    temp += Eating.objects.filter(user=u, date_time__range=(t_start, t_stop)).count()
                    temp += InsulinUsage.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Activities_log.objects.filter(user=u, start_date_time__range=(t_start, t_stop)).count()
                    temp += DrugUsage.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Feeling.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Walking.objects.filter(user=u, date__range=(t_start, t_stop)).count()
                    temp += SugarMeasurement.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    temp += Message.objects.filter(user=u, time__range=(t_start, t_stop)).count()
                    if temp > 0:
                        actives += 1
                active_in_30_days_ago.append(actives)

            for i in range(points.count()):
                temp = 0
                temp += Eating.objects.filter(user=points[i].user, date_time__range=(p_start, p_end)).count()
                temp += InsulinUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Activities_log.objects.filter(user=points[i].user,
                                                      start_date_time__range=(p_start, p_end)).count()
                temp += DrugUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Feeling.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Walking.objects.filter(user=points[i].user, date=p.date()).count()
                temp += SugarMeasurement.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Message.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()

                # Since the rating is registered, then the user is definitely active
                today_active_user.append(points[i].user.phone_number)
                today_active_user_transaction.append(temp)

            users = User.objects.filter(created_at__gte=dt)
            user_counter = []
            registered_user_counter = []
            active_user_counter = []
            date_array = []
            insulin_logs_list = []
            activities_logs_list = []
            drug_logs_list = []
            feeling_logs_list = []
            message_logs_list = []
            eating_logs_list = []
            sumation_list = []
            sugar_logs_list = []
            walking_logs_list = []

            number_of_last_users = User.objects.filter(created_at__lt=dt).count()
            number_of_last_registered_users = User.objects.filter(created_at__lt=dt, isRegistered=True).count()

            for i in range(durations + 1):
                try:
                    sumation = 0
                    number_of_last_users = users.filter(created_at=dt).count() + number_of_last_users
                    user_counter.append(number_of_last_users)
                    number_of_last_registered_users = users.filter(created_at=dt,
                                                                   isRegistered=True).count() + number_of_last_registered_users
                    registered_user_counter.append(number_of_last_registered_users)

                    active_user_counter.append(Points.objects.filter(date=dt).count())

                    temp = InsulinUsage.objects.filter(time__year=dt.year,
                                                       time__month=dt.month,
                                                       time__day=dt.day).count()
                    sumation += temp
                    insulin_logs_list.append(temp)

                    temp = Activities_log.objects.filter(start_date_time__year=dt.year,
                                                         start_date_time__month=dt.month,
                                                         start_date_time__day=dt.day).count()
                    sumation += temp
                    activities_logs_list.append(temp)

                    temp = DrugUsage.objects.filter(time__year=dt.year,
                                                    time__month=dt.month,
                                                    time__day=dt.day).count()
                    sumation += temp
                    drug_logs_list.append(temp)

                    temp = SugarMeasurement.objects.filter(time__year=dt.year,
                                                           time__month=dt.month,
                                                           time__day=dt.day).count()
                    sumation += temp
                    sugar_logs_list.append(temp)

                    temp = Walking.objects.filter(date=dt).count()
                    sumation += temp
                    walking_logs_list.append(temp)

                    temp = Feeling.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    feeling_logs_list.append(temp)

                    temp = Message.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    message_logs_list.append(temp)

                    temp = Eating.objects.filter(date_time__year=dt.year,
                                                 date_time__month=dt.month,
                                                 date_time__day=dt.day).count()
                    sumation += temp
                    sumation_list.append(sumation)
                    eating_logs_list.append(temp)
                    date_array.append(str(dt))
                    # date_array.append(str(jdatetime.date.fromgregorian(date=dt)))
                    dt = dt + timedelta(days=1)

                except Exception as e:
                    return myResponse.Error(str(e), [])

            new_users = User.objects.filter(created_at=date.today())
            new_users_list = []
            for u in new_users:
                new_users_list.append(u.phone_number)

            t1 = datetime.now()
            context = {
                "user_counter": user_counter,
                "registered_user_counter": registered_user_counter,
                "date": date_array,
                "active_user_counter": active_user_counter,
                "insulin_logs_list": insulin_logs_list,
                "activities_logs_list": activities_logs_list,
                "drug_logs_list": drug_logs_list,
                "sugar_logs_list": sugar_logs_list,
                "walking_logs_list": walking_logs_list,
                "feeling_logs_list": feeling_logs_list,
                "message_logs_list": message_logs_list,
                "eating_logs_list": eating_logs_list,
                "sumation_logs_list": sumation_list,
                "active_in_30_days_ago": active_in_30_days_ago,
                "today_active_user": today_active_user,
                "today_active_user_transaction": today_active_user_transaction,
                "time": str(jdatetime.datetime.fromgregorian(datetime=datetime.now())),
                "new_users_list": new_users_list,
                "exe_time": (t1 - t0).seconds,
                "durations": durations,
            }
            # create Analysis
            d = date.today()
            tt = Analysis.objects.filter(date=d)
            if tt.exists():
                an = tt[0]
            else:
                an = Analysis(date=d)
            last = len(user_counter) - 1
            an.user_counter = user_counter[last]
            an.registered_user_counter = registered_user_counter[last]
            an.active_user_counter = active_user_counter[last]
            an.insulin_logs = insulin_logs_list[last]
            an.activities_logs = activities_logs_list[last]
            an.drug_logs = drug_logs_list[last]
            an.sugar_logs = sugar_logs_list[last]
            an.walking_logs = walking_logs_list[last]
            an.feeling_logs = feeling_logs_list[last]
            an.message_logs = message_logs_list[last]
            an.eating_logs = eating_logs_list[last]
            an.sumation_logs = sumation_list[last]
            an.active_in_30_days_ago = active_in_30_days_ago[last]
            an.today_active_user_list = today_active_user
            an.today_active_user_transaction_list = today_active_user_transaction
            an.save()

            return myResponse.OK("success", context)
        except Exception as e:
            return myResponse.Error(e.args, -1)
    else:
        return myResponse.Error("u have not access", [])


@csrf_exempt
# @login_required(login_url='/{admin}/login'.format(admin=ADMIN_NAME))
# @api_view(["POST", "GET"])
def AddingFoodFromExcel(request):
    if request.method == 'POST':
        try:
            # print(str(request.POST))
            # return myResponse.OK(str(request.POST),request.POST)

            RequsetChecker(request.POST,
                           [
                               {
                                   "name": "userName",
                                   "format": "^(\S)+$",
                                   "errorMessage": "نام کاربری نا معتبر"
                               },
                               {
                                   "name": "password",
                                   "format": "^(\S)+$",
                                   "errorMessage": "پسورد نامعتبر"
                               },
                           ])
            userName = request.POST["userName"]
            password = request.POST["password"]
            temp = Admins.objects.filter(UserName=userName, PassWord=password)

            # check user pass ...
            if not temp.exists():
                return myResponse.Error(Errors.WrongUserPassWord.message,
                                        Errors.WrongUserPassWord.code)
            # check that has Access ...
            admin = temp[0]
            if admin.foodsEdit is False:
                return myResponse.Error(Errors.NoAccessToEdit.message,
                                        Errors.NoAccessToEdit.code)

            # now save foods.xlsx file in the server...
            if request.FILES == {}:
                return myResponse.Error("فایلی با فرمت .xlsx را انتخاب کنید", [])
            f = request.FILES["file"]
            name = str(request.FILES["file"]).split('.')
            if not (name[len(name) - 1] == "xlsx"):
                return myResponse.Error("حتما باید فرمت فایل xlsx باشد.", name)
            pathFromStatic = '/static/assets/foods/foods_' + str(datetime.now().date()) + '.xlsx'
            newFileName = settings.BASE_DIR + pathFromStatic
            with open(newFileName, 'wb+') as destination:
                for chunk in f.chunks():
                    destination.write(chunk)
            destination.close()

            # create Foods...
            df = pandas.read_excel(newFileName)

            newDBNameSet = set()
            for value in df.values:
                if not str(value[0]) == "nan":
                    newDBNameSet.add(str(int(float(str(value[0])))))

            allFoods = Food.objects.all()
            oldDBNameSet = set()
            for food in allFoods:
                oldDBNameSet.add(food.Data_Base_Number)

            toDeleteSet = oldDBNameSet - newDBNameSet

            # delete the deleted foods
            for code in toDeleteSet:
                food = Food.objects.filter(Data_Base_Number=code)[0]
                food.delete()

            # return myResponse.OK(str(toDeleteSet), str(toDeleteSet))

            newFoodsAdded = 0
            foodSaved = 0
            foodInProccess = 0
            for value in df.values:
                try:
                    if not str(value[0]) == "nan":
                        temp = Food.objects.filter(Data_Base_Number=str(int(value[0])))
                        if temp.exists():
                            f = temp[0]
                        else:
                            f = Food()
                            newFoodsAdded += 1
                        foodInProccess += 1
                        column_state = "0"
                        f.Data_Base_Number = str(int(value[0]))
                        column_state = "1"
                        f.FA_Name = str(value[1])
                        column_state = "2"
                        f.Protein_g = NaNtoInt(value[2])
                        column_state = "3"
                        f.Fat_g = NaNtoInt(value[3])
                        f.Carbohydrates_g = NaNtoInt(value[4])
                        f.HEI_1_Fruit = NaNtoInt(value[5])
                        f.HEI_2_Fruit = NaNtoInt(value[6])
                        f.HEI_1_Vegetables = NaNtoInt(value[7])
                        f.HEI_2_Vegetables = NaNtoInt(value[8])
                        f.HEI_Whole_Grain_Grains = NaNtoInt(value[9])
                        column_state = "10 to 20"
                        f.HEI_Dairy = NaNtoInt(value[10])
                        f.HEI_Protein_Foods = NaNtoInt(value[11])
                        f.HEI_Seafood_and_Plant_Proteins = NaNtoInt(value[12])
                        f.HEI_Refined_Grains = NaNtoInt(value[13])
                        f.HEI_Sodium = NaNtoInt(value[14])
                        f.HEI_Sugar = NaNtoInt(value[15])
                        f.Saturated_Fat_g = NaNtoInt(value[16])
                        f.dairy_unit = NaNtoInt(value[17])
                        f.fat_unit = NaNtoInt(value[18])
                        f.For_calculation = NaNtoInt(value[19])
                        column_state = "20 to 30"
                        f.cereal_unit = NaNtoInt(value[20])
                        f.meat_unit = NaNtoInt(value[21])
                        f.fruit_unit = NaNtoInt(value[22])
                        f.vegetables_unit = NaNtoInt(value[23])
                        f.Ash_g = NaNtoInt(value[24])
                        f.Calories = NaNtoInt(value[25])
                        f.Starch_g = NaNtoInt(value[26])
                        f.Sucrose_g = NaNtoInt(value[27])
                        f.Glucose_g = NaNtoInt(value[28])
                        f.Fructose_g = NaNtoInt(value[29])
                        column_state = "30 to 40"
                        f.Lactose_g = NaNtoInt(value[30])
                        f.Maltose_g = NaNtoInt(value[31])
                        f.Alcohol_g = NaNtoInt(value[32])
                        f.Water_g = NaNtoInt(value[33])
                        f.Caffeine_mg = NaNtoInt(value[34])
                        f.Theobromine_mg = NaNtoInt(value[35])
                        f.Sugar_g = NaNtoInt(value[36])
                        f.Galactose_g = NaNtoInt(value[37])
                        f.Fiber_g = NaNtoInt(value[38])
                        f.Calcium_mg = NaNtoInt(value[39])
                        column_state = "40 to 50"
                        f.Iron_mg = NaNtoInt(value[40])
                        f.Magnesium_mg = NaNtoInt(value[41])
                        f.Phosphorus_mg = NaNtoInt(value[42])
                        f.Potasssium_mg = NaNtoInt(value[43])
                        f.Sodium_mg = NaNtoInt(value[44])
                        f.Zinc_mg = NaNtoInt(value[45])
                        f.Cupper_mg = NaNtoInt(value[46])
                        f.Fluoride_mcg = NaNtoInt(value[47])
                        f.Manganese_mg = NaNtoInt(value[48])
                        f.Selenium_mcg = NaNtoInt(value[49])
                        column_state = "50 to 60"
                        f.Vitamin_A_IU = NaNtoInt(value[50])
                        f.Retinol_mcg = NaNtoInt(value[51])
                        f.Retinol_Equivalents_mcg = NaNtoInt(value[52])
                        f.Beta_Carotene_mcg = NaNtoInt(value[53])
                        f.Alpha_Carotene_mcg = NaNtoInt(value[54])
                        f.Vitamin_E_mg = NaNtoInt(value[55])
                        f.Vitamin_D_mcg = NaNtoInt(value[56])
                        f.Vitamin_D2_Ergocalciferol_mcg = NaNtoInt(value[57])
                        f.Vitamin_D3_Cholecalciferol_mcg = NaNtoInt(value[58])
                        f.Beta_Cryptoxanthin_mcg = NaNtoInt(value[59])
                        column_state = "60 to 70"
                        f.Lycopene_mcg = NaNtoInt(value[60])
                        f.Lutein_and_Zeaxanthin_mcg = NaNtoInt(value[61])
                        f.Vitamin_C_mg = NaNtoInt(value[62])
                        f.Vitamin_B1_mg = NaNtoInt(value[63])
                        f.Vitamin_B2_mg = NaNtoInt(value[64])
                        f.Vitamin_B3_mg = NaNtoInt(value[65])
                        f.Vitamin_B5_mg = NaNtoInt(value[66])
                        f.Vitamin_B6_mg = NaNtoInt(value[67])
                        f.Vitamin_B9_mg = NaNtoInt(value[68])
                        f.Vitamin_B12 = NaNtoInt(value[69])
                        column_state = "70 to 74"
                        f.Choline_mg = NaNtoInt(value[70])
                        f.Cholesterol_mg = NaNtoInt(value[71])
                        f.Saturated_Fat_g = NaNtoInt(value[72])
                        f.PUFA = NaNtoInt(value[73])
                        f.MUFA = NaNtoInt(value[74])

                        # home units
                        home = str(value[75])
                        if not (home == "nan"):
                            length = len(str(value[76]).split("&"))
                            indexes = "&{}&".format("&".join(list(map(lambda a: str(a), range(length + 1)))))
                            f.Weight_of_home_units = "&1&" + str(value[75]) + "&"
                            f.Name_of_home_units = "&گرم&" + str(value[76]) + "&"
                            f.Index_of_home_units = indexes
                        else:
                            f.Weight_of_home_units = "&1&"
                            f.Name_of_home_units = "&گرم&"
                            f.Index_of_home_units = "&0&"
                        f.english_Name = str(value[77])
                        f.arabic_Name = str(value[78])
                        f.microbiome_score = NaNtoInt(value[81])
                        f.priority = NaNtoInt(value[85])

                        # return myResponse.OK("ok", [])
                        f.save()
                        foodSaved += 1
                    else:
                        continue
                        # return myResponse.Error("saved foods= " + str(foodSaved) +
                        #                         "\nadded Foods= " + str(newFoodsAdded) +
                        #                         "\nError in record: " + str(foodInProccess + 2),
                        #                         Errors.ErrorInExcelFile.code)
                except ValueError as e:
                    return myResponse.Error(str(e.args[0]) +
                                            "\nError occurred on line " + str(
                        foodInProccess + 1) + "  and column: " + column_state
                                            + "\nsaved foods= " + str(foodSaved) +
                                            "\nadded Foods= " + str(newFoodsAdded) +
                                            "\nError in record: " + str(foodInProccess + 1),
                                            Errors.InvalidArgument.code)

            temp = {
                "NumberOfFoods": len(df.values),
                "newFoodsAdded": newFoodsAdded,
                "saved_foods": foodSaved
            }

            # Save to Update Tabe
            UTable = UpdateTable.objects.filter(Type="foods")
            if UTable.exists():
                ut = UTable[0]
            else:
                ut = UpdateTable(Type="foods")
            ut.FileUpdateName = pathFromStatic
            ut.DateTime = datetime.fromtimestamp(int(datetime.now().timestamp()))
            ut.save()

            return myResponse.OK("اطلاعات غذا ها ثبت شد.", temp)
        except ValueError:
            return myResponse.Error(Errors.InvalidArgument, Errors.InvalidArgument.code)
    else:
        return render(request, "Support/update_foods_list.html")


@csrf_exempt
def update_food_cards_from_excel(request):
    """
    Update existing FoodCard objects with specified fields from an Excel file.
    The Excel file must contain an 'id' column matching FoodCard IDs.
    """
    if request.method == 'POST':
        try:
            # Read from existing Excel file
            file_path = settings.BASE_DIR + f'/static/cleaned_data_2.xlsx'
            
            # Check if file exists
            if not os.path.exists(file_path):
                return JsonResponse({"error": "Excel file not found at specified path"}, status=400)

            # Read Excel file
            try:
                df = pd.read_excel(file_path, engine="openpyxl")
            except Exception as e:
                df = pd.read_excel(file_path, engine="xlrd")


            updated_count = 0
            skipped_count = 0
            skipped_rows = []


            # Fields to update
            fields_to_update = [
                'AL_Dairy_Butter', 'AL_Dairy_Cheese', 'AL_Dairy_Coconut', 'AL_Dairy_CoconutMilk',
                'AL_Dairy_Cream', 'AL_Dairy_CreamCheese', 'AL_Dairy_IceCream', 'AL_Dairy_Mayonnaise',
                'AL_Dairy_Milk', 'AL_Dairy_Milk_Chocolate', 'AL_Dairy_Whey', 'AL_Dairy_Yogurt',
                'AL_Egg', 'AL_Eggs_Egg', 'AL_Eggs_Mayonnaise', 'AL_Fish_Crab', 'AL_Fish_Fish',
                'AL_Fish_Shrimp', 'AL_Fish_Tuna', 'AL_Grain_Barley', 'AL_Grain_Bean',
                'AL_Grain_Buckwheat', 'AL_Grain_Chickpea', 'AL_Grain_Corn', 'AL_Grain_Lentil',
                'AL_Grain_Mung', 'AL_Grain_Oat', 'AL_Grain_Oats', 'AL_Grain_Quinoa',
                'AL_Grain_Rice', 'AL_Grain_Rye', 'AL_Grain_Soy', 'AL_Grain_Unspecified',
                'AL_Grain_Wheat', 'AL_Grains_Wheat', 'AL_Legume_Beans', 'AL_Legume_Lentil',
                'AL_Legume_Pea', 'AL_Legume_RedBean', 'AL_Legume_Soy', 'AL_Legume_Split_Peas',
                'AL_Legume_SplitPea', 'AL_Meat_Bacon', 'AL_Meat_Beef', 'AL_Meat_Chicken',
                'AL_Meat_Ham', 'AL_Meat_Lamb', 'AL_Meat_Pepperoni', 'AL_Meat_Pork',
                'AL_Meat_Processed', 'AL_Meat_Sausage', 'AL_Meat_Turkey', 'AL_Meat_Unspecified',
                'AL_Meat_Varies', 'AL_Meat_Various', 'AL_Nuts_Almond', 'AL_Nuts_Coconut',
                'AL_Nuts_Hazelnut', 'AL_Nuts_Nuts', 'AL_Nuts_Peanut', 'AL_Nuts_Pine_Nuts',
                'AL_Nuts_Pistachio', 'AL_Nuts_Sesame', 'AL_Nuts_Unspecified', 'AL_Nuts_Varies',
                'AL_Nuts_Various', 'AL_Nuts_Walnut', 'AL_Poultry_Chicken', 'AL_Seeds_Chia',
                'AL_Shellfish_Shrimp', 'AL_Dairy_Cream_Cheese', 'AL_Dairy_Creamer',
                'AL_Dairy_Goat_Milk', 'AL_Dairy_Kashk', 'AL_Dairy_Kefir', 'AL_Eggs_Whole',
                'AL_Eggs_Whole_Eggs', 'AL_Eggs_Yolk', 'AL_Fish_Anchovy', 'AL_Fish_Carp',
                'AL_Fish_Catfish', 'AL_Fish_Caviar', 'AL_Fish_Croaker', 'AL_Fish_Flatfish',
                'AL_Fish_Flounder', 'AL_Fish_Grouper', 'AL_Fish_Herring', 'AL_Fish_KingMackerel',
                'AL_Fish_Mackerel', 'AL_Fish_Mullet', 'AL_Fish_Pike', 'AL_Fish_Porgy',
                'AL_Fish_Roe', 'AL_Fish_Salmon', 'AL_Fish_Sardine', 'AL_Fish_Shark',
                'AL_Fish_Snapper', 'AL_Fish_Swordfish', 'AL_Fish_Tilapia', 'AL_Fish_Trout',
                'AL_Fish_Unspecified', 'AL_Fish_Whitefish', 'AL_Grain_Bulgur', 'AL_Grain_Cereal',
                'AL_Grain_Millet', 'AL_Grain_Pea', 'AL_Grain_SplitPea', 'AL_Grains_Barley',
                'AL_Grains_Brown_Rice', 'AL_Grains_Bulgur', 'AL_Grains_Chickpea', 'AL_Grains_Corn',
                'AL_Grains_Millet', 'AL_Grains_Oats', 'AL_Grains_Rice', 'AL_Legume_Bean',
                'AL_Legume_Chickpea', 'AL_Legume_Fava', 'AL_Legume_FavaBean', 'AL_Legume_Peas',
                'AL_Legume_Unspecified', 'AL_Meat_Camel', 'AL_Meat_Duck', 'AL_Meat_Fat',
                'AL_Meat_Fish', 'AL_Meat_Goose', 'AL_Meat_Ground', 'AL_Meat_Kidney',
                'AL_Meat_Offal', 'AL_Meat_Organ', 'AL_Meat_Ostrich', 'AL_Meat_Pigeon',
                'AL_Meat_Quail', 'AL_Meat_Sheep', 'AL_Meat_Veal', 'AL_Nuts_Acorn',
                'AL_Nuts_Almonds', 'AL_Nuts_Cashew', 'AL_Nuts_Chestnut', 'AL_Nuts_Hazelnuts',
                'AL_Nuts_Hemp', 'AL_Nuts_Mixed', 'AL_Nuts_Nutmeg', 'AL_Nuts_Peanuts',
                'AL_Nuts_Pecan', 'AL_Other_Sesame', 'AL_Poultry_Duck', 'AL_Poultry_Offal',
                'AL_Seafood_Fish', 'AL_Seeds_Cottonseed', 'AL_Seeds_Flax', 'AL_Seeds_Flaxseed',
                'AL_Seeds_Poppy', 'AL_Seeds_Pumpkin', 'AL_Seeds_Safflower', 'AL_Seeds_Sesame',
                'AL_Seeds_Sunflower', 'AL_Seeds_Watermelon', 'AL_Sesame_Sesame', 'AL_Soy_Soy',
                'AL_Soy_SoySauce', 'AL_Soy_Soybean', 'AL_Soy_Soybeans', 'main_dish_code'
            ]

            for _, row in df.iterrows():
                foodcard_id = row.get('id')
                if pd.isna(foodcard_id):
                    skipped_count += 1
                    continue

                try:
                    # Retrieve the FoodCard by ID
                    foodcard = FoodCard.objects.get(id=str(int(float(foodcard_id))))

                    # Update specified fields
                    for field in fields_to_update:
                        if field in df.columns:
                            value = row.get(field)
                            if not pd.isna(value):
                                if field == 'main_dish_code':
                                    # Assuming main_dish_code is a string or integer field
                                    try:
                                        setattr(foodcard, field, str(value))
                                    except (ValueError, TypeError):
                                        setattr(foodcard, field, "")
                                else:
                                    # Assuming all AL_ fields are Boolean
                                    setattr(foodcard, field, bool(value))

                    # Save the updated FoodCard
                    foodcard.save()
                    updated_count += 1

                except ObjectDoesNotExist:
                    skipped_count += 1
                    skipped_rows.append(foodcard_id)

            # Return a success response
            response_data = {
                "Updated FoodCards": updated_count,
                "Skipped Rows": skipped_count,
                "Skipped IDs": skipped_rows
            }
            return JsonResponse({"message": "FoodCards updated successfully", "data": response_data}, status=200)

        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)

    # If not POST, return an error
    return JsonResponse({"error": "Method not allowed"}, status=405)


@csrf_exempt
def UpdateFoodTagsFromExcel(request):
    """
    Update existing Food objects with new tags (boolean, integer, text)
    from an Excel file.
    """
    if request.method == 'POST':
        try:
            # Authentication and permission check
            # RequsetChecker(request.POST,
            #                [
            #                    {
            #                        "name": "userName",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "نام کاربری نا معتبر"
            #                    },
            #                    {
            #                        "name": "password",
            #                        "format": "^(\S)+$",
            #                        "errorMessage": "پسورد نامعتبر"
            #                    },
            #                ])
            #
            # userName = request.POST["userName"]
            # password = request.POST["password"]
            # admin_qs = Admins.objects.filter(UserName=userName, PassWord=password)
            #
            # if not admin_qs.exists():
            #     return myResponse.Error("Invalid username or password", 401)
            #
            # admin = admin_qs.first()
            # if not admin.foodsEdit:
            #     return myResponse.Error("No permission to edit foods", 403)

            # Check file upload
            if not request.FILES:
                return myResponse.Error("Please upload an Excel (.xlsx) file", 400)

            uploaded_file = request.FILES["file"]
            if not uploaded_file.name.endswith('.xlsx'):
                return myResponse.Error("File must be in .xlsx format", 400)

            # Save the file locally
            file_path = settings.BASE_DIR + f'/static/assets/foods/tags_{datetime.now().date()}.xlsx'
            with open(file_path, 'wb+') as destination:
                for chunk in uploaded_file.chunks():
                    destination.write(chunk)

            # Read Excel file
            df = pd.read_excel(file_path)

            updated_count = 0
            skipped_count = 0
            Skipped_rows = []

            for _, row in df.iterrows():
                food_code = row.get('foodcode')
                if pd.isna(food_code):
                    skipped_count += 1
                    continue

                # Mappings
                map_fodmap = {
                    'low': 1,
                    'Variable': 2,
                    'high': 3
                }

                map_gl_category = {
                    'low': 1,
                    'medium': 2,
                    'high': 3
                }

                try:
                    food = Food.objects.get(Data_Base_Number=str(int(float(food_code))))

                    # Update Boolean Fields
                    food.Dessert = bool(row.get('Dessert', 0))
                    food.Added_Meat = bool(row.get('Added_Meat', 0))
                    food.Ing_Main = bool(row.get('Ing_Main', 0))
                    food.Beverage = bool(row.get('Beverage', 0))
                    food.Sandwich = bool(row.get('Sandwich', 0))
                    food.Condiment = bool(row.get('Condiment', 0))
                    food.Lunch = bool(row.get('Lunch', 0))
                    food.Snack = bool(row.get('Snack', 0))
                    food.Bread = bool(row.get('Bread', 0))
                    food.Entree = bool(row.get('Entree', 0))
                    food.Soup = bool(row.get('Soup', 0))
                    food.Side_Dish = bool(row.get('Side_Dish', 0))
                    food.Appetizer = bool(row.get('Appetizer', 0))
                    food.Dinner = bool(row.get('Dinner', 0))
                    food.Pasta = bool(row.get('Pasta', 0))
                    food.Breakfast = bool(row.get('Breakfast', 0))
                    food.Salad = bool(row.get('Salad', 0))
                    food.Ingredient = bool(row.get('Ingredient', 0))
                    food.Vegan = bool(row.get('Vegan', 0))
                    food.Umami = bool(row.get('Umami', 0))
                    food.Slow_cooked = bool(row.get('Slow_cooked', 0))
                    food.Spicy = bool(row.get('Spicy', 0))
                    food.Baked = bool(row.get('Baked', 0))
                    food.Pickled = bool(row.get('Pickled', 0))
                    food.Low_calorie = bool(row.get('Low_calorie', 0))
                    food.Grilled = bool(row.get('Grilled', 0))
                    food.Roasted = bool(row.get('Roasted', 0))
                    food.High_protein = bool(row.get('High_protein', 0))
                    food.Fried = bool(row.get('Fried', 0))
                    food.Sweet = bool(row.get('Sweet', 0))
                    food.Salty = bool(row.get('Salty', 0))
                    food.Lactose_free = bool(row.get('Lactose_free', 0))
                    food.Low_carb = bool(row.get('Low_carb', 0))
                    food.Cold = bool(row.get('Cold', 0))
                    food.Vegetarian = bool(row.get('Vegetarian', 0))
                    food.Sour = bool(row.get('Sour', 0))
                    food.Sweet_Sour = bool(row.get('Sweet_Sour', 0))
                    food.Raw = bool(row.get('Raw', 0))
                    food.Gluten_free = bool(row.get('Gluten_free', 0))
                    # food.Sweet_and_Sour = bool(row.get('Sweet_and_Sour', 0))
                    food.Boiled = bool(row.get('Boiled', 0))
                    food.Steamed = bool(row.get('Steamed', 0))
                    food.Low_fat = bool(row.get('Low_fat', 0))
                    food.Prepared_Meals = bool(row.get('Prepared_Meals', 0))
                    food.Meats = bool(row.get('Meats', 0))
                    food.Sweets = bool(row.get('Sweets', 0))
                    food.Beans_and_Lentils = bool(row.get('Beans_and_Lentils', 0))
                    food.Snacks = bool(row.get('Snacks', 0))
                    food.Grains_and_Pasta = bool(row.get('Grains_and_Pasta', 0))
                    food.Nuts_and_Seeds = bool(row.get('Nuts_and_Seeds', 0))
                    food.Fruits = bool(row.get('Fruits', 0))
                    food.Beverages = bool(row.get('Beverages', 0))
                    food.Fish = bool(row.get('Fish', 0))
                    food.Baked_Foods = bool(row.get('Baked_Foods', 0))
                    food.Breakfast_Cereals = bool(row.get('Breakfast_Cereals', 0))
                    food.Vegetables = bool(row.get('Vegetables', 0))
                    food.Spices_and_Herbs = bool(row.get('Spices_and_Herbs', 0))
                    food.Soups_and_Sauces = bool(row.get('Soups_and_Sauces', 0))
                    food.Dairy_and_Egg_Products = bool(row.get('Dairy_and_Egg_Products', 0))
                    food.Fats_and_Oils = bool(row.get('Fats_and_Oils', 0))
                    food.Lactose_Intolerance = bool(row.get('Lactose_Intolerance', 0))
                    food.stones = bool(row.get('stones', 0))
                    food.reflux = bool(row.get('reflux', 0))
                    food.cooked_rice = bool(row.get('cooked_rice', 0))
                    food.main_dish = bool(row.get('main_dish', 0))
                    food.Spices = bool(row.get('Spices', 0))
                    food.Seafood = bool(row.get('Seafood', 0))
                    food.Poultry = bool(row.get('Poultry', 0))
                    food.Herbs = bool(row.get('Herbs', 0))
                    food.Processed_Meats = bool(row.get('Processed_Meats', 0))
                    food.Legumes = bool(row.get('Legumes', 0))
                    food.Dairy = bool(row.get('Dairy', 0))
                    food.Nuts = bool(row.get('Nuts', 0))
                    food.Mixed_Dishes = bool(row.get('Mixed_Dishes', 0))
                    food.Sauces = bool(row.get('Sauces', 0))
                    food.Oils = bool(row.get('Oils', 0))
                    food.Grains = bool(row.get('Grains', 0))
                    food.Seeds = bool(row.get('Seeds', 0))
                    food.Pastries = bool(row.get('Pastries', 0))
                    food.Spreads = bool(row.get('Spreads', 0))
                    food.Eggs = bool(row.get('Eggs', 0))
                    food.Prebiotic = bool(row.get('Prebiotic', 0))
                    food.Probiotic = bool(row.get('Probiotic', 0))
                    food.Low_Inflammatory = bool(row.get('Low_Inflammatory', 0))
                    food.Diverse = bool(row.get('Diverse', 0))
                    food.Polyphenol_Rich = bool(row.get('Polyphenol_Rich', 0))
                    food.Stews = bool(row.get('Stews', 0))
                    food.Mixed_Rice = bool(row.get('Mixed_Rice', 0))
                    food.Soups_and_Aashes = bool(row.get('Soups_and_Aashes', 0))
                    food.Traditional_Foods = bool(row.get('Traditional_Foods', 0))
                    food.International_Foods = bool(row.get('International_Foods', 0))
                    food.Vegetarian_Foods = bool(row.get('Vegetarian_Foods', 0))
                    food.Simple_Dishes = bool(row.get('Simple_Dishes', 0))
                    food.Main_Salads = bool(row.get('Main_Salads', 0))
                    food.Fast_Foods = bool(row.get('Fast_Foods', 0))

                    # Update Allergens
                    food.Allergens_Shrimp = bool(row.get('Allergens_Shrimp', 0))
                    food.Allergens_Mushroom = bool(row.get('Allergens_Mushroom', 0))
                    food.Allergens_Eggplant = bool(row.get('Allergens_Eggplant', 0))
                    food.Allergens_Dried_fruits = bool(row.get('Allergens_Dried_fruits', 0))
                    food.Allergens_Gluten = bool(row.get('Allergens_Gluten', 0))
                    food.Allergens_Fish = bool(row.get('Allergens_Fish', 0))
                    food.Allergens_Sesame = bool(row.get('Allergens_Sesame', 0))
                    food.Allergens_Shellfish = bool(row.get('Allergens_Shellfish', 0))
                    food.Allergens_Nuts = bool(row.get('Allergens_Nuts', 0))
                    food.Allergens_Soy = bool(row.get('Allergens_Soy', 0))
                    food.Allergens_Eggs = bool(row.get('Allergens_Eggs', 0))
                    food.Allergens_Peanuts = bool(row.get('Allergens_Peanuts', 0))
                    food.Allergens_Dairy = bool(row.get('Allergens_Dairy', 0))
                    food.Allergens_Legumes = bool(row.get('Allergens_Legumes', 0))
                    food.Allergens_Depends_on_filling_ingredients = bool(
                        row.get('Allergens_Depends_on_filling_ingredients', 0))
                    food.Allergens_Milk = bool(row.get('Allergens_Milk', 0))

                    # Update Diets
                    food.Diet_Low_Sugar = bool(row.get('Diet_Low_Sugar', 0))
                    food.Diet_Mediterranean = bool(row.get('Diet_Mediterranean', 0))
                    food.Diet_High_Protein = bool(row.get('Diet_High_Protein', 0))
                    food.Whole_Foods = bool(row.get('Whole_Foods', 0))
                    food.Diet_Low_Fat = bool(row.get('Diet_Low_Fat', 0))
                    food.Diet_Low_Calorie = bool(row.get('Diet_Low_Calorie', 0))
                    food.Diet_Anti_Inflammatory = bool(row.get('Diet_Anti_Inflammatory', 0))
                    food.Diet_Paleo = bool(row.get('Diet_Paleo', 0))
                    food.Diet_Diabetic = bool(row.get('Diet_Diabetic', 0))
                    food.Diet_Low_Carb = bool(row.get('Diet_Low_Carb', 0))
                    food.Diet_Bodybuilding = bool(row.get('Diet_Bodybuilding', 0))
                    food.Diet_Vegan = bool(row.get('Diet_Vegan', 0))
                    food.Diet_Vegetarian = bool(row.get('Diet_Vegetarian', 0))
                    food.Diet_Plant_Based = bool(row.get('Diet_Plant_Based', 0))
                    food.Diet_Gluten_Free = bool(row.get('Diet_Gluten_Free', 0))
                    food.Diet_Keto = bool(row.get('Diet_Keto', 0))

                    # Update Diseases
                    food.Disease_Kidney = bool(row.get('Disease_Kidney', 0))
                    food.Disease_Kidney_stones = bool(row.get('Disease_Kidney_stones', 0))
                    food.Disease_Acid_reflux = bool(row.get('Disease_Acid_reflux', 0))
                    food.Disease_Gout = bool(row.get('Disease_Gout', 0))
                    food.Disease_Celiac = bool(row.get('Disease_Celiac', 0))
                    food.Disease_IBS = bool(row.get('Disease_IBS', 0))
                    food.Disease_Diverticulitis = bool(row.get('Disease_Diverticulitis', 0))
                    food.Disease_Hypothyroidism = bool(row.get('Disease_Hypothyroidism', 0))
                    food.Disease_Gastroesophageal_Reflux = bool(row.get('Disease_Gastroesophageal_Reflux', 0))
                    food.Disease_Foodborne_Illness = bool(row.get('Disease_Foodborne_Illness', 0))
                    food.Disease_High_blood_pressure = bool(row.get('Disease_High_blood_pressure', 0))
                    food.Disease_High_cholesterol = bool(row.get('Disease_High_cholesterol', 0))
                    food.Disease_Diabetes = bool(row.get('Disease_Diabetes', 0))
                    food.Disease_Hypercholesterolemia = bool(row.get('Disease_Hypercholesterolemia', 0))
                    food.Disease_G6PD_Deficiency = bool(row.get('Disease_G6PD_Deficiency', 0))
                    food.Disease_Constipation = bool(row.get('Disease_Constipation', 0))
                    food.Disease_Gallbladder = bool(row.get('Disease_Gallbladder', 0))
                    food.Disease_Latex_Fruit_Syndrome = bool(row.get('Disease_Latex_Fruit_Syndrome', 0))
                    food.Disease_Obesity = bool(row.get('Disease_Obesity', 0))

                    # Update Bacteria fields
                    food.Bacteria_Acidaminococcus = bool(row.get('Bacteria_Acidaminococcus', 0))
                    food.Bacteria_Bacteroidetes = bool(row.get('Bacteria_Bacteroidetes', 0))
                    food.Bacteria_Alistipes = bool(row.get('Bacteria_Alistipes', 0))
                    food.Bacteria_Bifidobacterium = bool(row.get('Bacteria_Bifidobacterium', 0))
                    food.Bacteria_Akkermansia = bool(row.get('Bacteria_Akkermansia', 0))
                    food.Bacteria_Blautia = bool(row.get('Bacteria_Blautia', 0))
                    food.Bacteria_Fecalibacterium = bool(row.get('Bacteria_Fecalibacterium', 0))
                    food.Bacteria_Lawsonibacter_asaccharolyticus = bool(
                        row.get('Bacteria_Lawsonibacter_asaccharolyticus', 0))
                    food.Bacteria_Lactobacillus = bool(row.get('Bacteria_Lactobacillus', 0))

                    # Update fields from Excel
                    if 'FODMAP_Classification' in row and not pd.isna(row['FODMAP_Classification']):
                        fodmap_value = str(row['FODMAP_Classification']).strip().lower()
                        food.FODMAP_Classification = map_fodmap.get(fodmap_value, 0)

                    if 'bread_rice_tag' in row and not pd.isna(row['bread_rice_tag']):
                        try:
                            food.bread_rice_tag = str(int(row['bread_rice_tag']))  # Ensure it's stored as a string
                        except ValueError:
                            food.bread_rice_tag = ""  # Default to empty if invalid

                    if 'GL_category' in row and not pd.isna(row['GL_category']):
                        gl_category_value = str(row['GL_category']).strip().lower()
                        food.GL_category = map_gl_category.get(gl_category_value, 0)

                    if 'GL_value' in row and not pd.isna(row['GL_value']):
                        try:
                            food.GL_value = int(row['GL_value'])
                        except ValueError:
                            food.GL_value = 0  # Default to 0 if invalid

                    if 'GI_category' in row and not pd.isna(row['GI_category']):
                        gi_category_value = str(row['GI_category']).strip().lower()
                        food.GI_category = map_gl_category.get(gi_category_value, 0)  # Reuse same mapping

                    if 'GI_value' in row and not pd.isna(row['GI_value']):
                        try:
                            food.GI_value = int(row['GI_value'])
                        except ValueError:
                            food.GI_value = 0  # Default to 0 if invalid

                    # Save updated food object
                    food.save()
                    updated_count += 1

                except ObjectDoesNotExist:
                    skipped_count += 1
                    Skipped_rows.append(row['foodcode'])

            # Return a success response
            response_data = {
                "Updated Foods": updated_count,
                "Skipped Rows": skipped_count,
                "food codes are :": Skipped_rows
            }
            return myResponse.OK("Tags updated successfully", response_data)

        except Exception as e:
            return myResponse.Error(f"Error occurred: {str(e)}", 500)

    # If GET request, render the upload form (optional)
    return render(request, "Support/update_foods_list.html")


@csrf_exempt
def add_food_cards_from_excel(request):
    print("A")
    if request.method == 'POST':
        try:

            if 'file' not in request.FILES:
                return JsonResponse({'error': 'No file uploaded'}, status=400)
            print("B")

            # Read the Excel file
            excel_file = request.FILES['file']
            data = pd.read_excel(excel_file)

            # Define a helper function to get column value
            def get_column_value(row, primary_col, secondary_col=None):
                if primary_col in data.columns and pd.notna(row[primary_col]):
                    return row[primary_col]
                elif secondary_col and secondary_col in data.columns and pd.notna(row[secondary_col]):
                    return row[secondary_col]
                return None

            print("C")
            # FoodCard.objects.all().delete()

            # Initialize tracking variables
            current_card_number = None
            current_card_title = None
            current_card = None
            print("D")
            # Use transaction to ensure atomicity
            with transaction.atomic():
                for index, row in data.iterrows():
                    card_title = get_column_value(row, 'نام کارت', 'Q')
                    card_number = get_column_value(row, 'شماره کارت', 'R')
                    meal_type = get_column_value(row, 'وعده', 'F')
                    calories = get_column_value(row, 'انرژی', 'P')
                    amount = get_column_value(row, 'وزن (گرم)', 'L')
                    protein = get_column_value(row, 'پروتیین(g)', 'M')
                    fat = get_column_value(row, 'چربی (g)', 'N')
                    carbohydrates = get_column_value(row, 'کربوهیدرات (g)', 'O')
                    energy = get_column_value(row, 'انرژی', 'P')
                    home_unit_name = get_column_value(row, 'مقیاس', 'J')
                    home_unit_amount = get_column_value(row, 'تعداد', 'K')
                    food_name = get_column_value(row, 'نام غذا', 'H')
                    is_med = get_column_value(row, 'Med', 'X')
                    is_mind = get_column_value(row, 'MIND', 'Z')
                    is_low_fodmap = get_column_value(row, 'Low FODMAP', 'AA')
                    # is_lowgi = get_column_value(row, 'Low GI', 'Y')
                    is_breakfast = get_column_value(row, 'Breakfast', 'T')
                    is_lunch = get_column_value(row, 'Lunch', 'U')
                    is_dinner = get_column_value(row, 'Dinner', 'V')
                    is_snack = get_column_value(row, 'Snack', 'W')

                    # is_dash = get_column_value(row, 'نام غذا', 'H')
                    # is_lowcarb = get_column_value(row, 'نام غذا', 'H')
                    # is_mediumcarb = get_column_value(row, 'نام غذا', 'H')
                    # is_highprotein = get_column_value(row, 'نام غذا', 'H')
                    # is_lowprotein = get_column_value(row, 'نام غذا', 'H')
                    # is_keto_med = get_column_value(row, 'نام غذا', 'H')
                    # is_keto = get_column_value(row, 'نام غذا', 'H')

                    try:
                        food_code = int(get_column_value(row, 'Code', 'G'))  # Convert to integer
                    except (ValueError, TypeError):
                        continue  # Skip if Code is not a valid number

                    # Check if new card starts
                    if card_title != current_card_title or card_number != current_card_number:
                        current_card_title = card_title
                        current_card_number = card_number

                        # Create a unique identifier for the card
                        unique_identifier = f"{card_title}-{card_number}"

                        # Create or get FoodCard
                        current_card, created = FoodCard.objects.get_or_create(
                            FA_Name=card_title,
                            Calories=0,  # Initialize Calories to 0
                            defaults={'FA_Name': card_title}
                        )

                        # Reset the calories for the new card
                        current_card.Calories = 0
                        current_card.foods = []  # Reset the foods JSON

                    # Get existing Food item by Data_Base_Number
                    try:
                        food = Food.objects.get(Data_Base_Number=food_code)
                    except Food.DoesNotExist:
                        return JsonResponse({'error': f'Food with Data_Base_Number {food_code} does not exist'},
                                            status=400)

                    # Calculate nutritional values based on amount
                    protein_g = (protein * 100) / amount
                    fat_g = (fat * 100) / amount
                    carbs_g = (carbohydrates * 100) / amount
                    calories_g = (energy * 100) / amount

                    # Create food item entry
                    food_item = {
                        'food_code': food_code,
                        'food_name': food_name,
                        'amount': amount,
                        'home_unit_name': home_unit_name,
                        'home_unit_amount': home_unit_amount,
                        'Protein_g': round(protein_g, 2),
                        'Fat_g': round(fat_g, 2),
                        'Carbohydrates_g': round(carbs_g, 2),
                        'Calories': round(calories_g, 2),
                        'Protein': round(protein, 2),
                        'Fat': round(fat, 2),
                        'Carbohydrates': round(carbohydrates, 2),
                        'Energy': round(energy, 2),
                    }

                    # Append food item to the current card's foods JSON
                    current_card.foods.append(food_item)

                    # Update Calories by summing up
                    if pd.notna(calories):
                        rounded_calories = round(calories, 2)
                        current_card.Calories = round(current_card.Calories + rounded_calories, 2)

                    # Set meal types
                    # if meal_type == 'صبحانه':
                    #     current_card.is_breakfast = True
                    # elif meal_type == 'ناهار' or meal_type == 'نهار':
                    #     current_card.is_lunch = True
                    # elif meal_type == 'شام':
                    #     current_card.is_dinner = True
                    # elif meal_type == 'میان وعده':
                    #     current_card.is_snack = True

                    if is_breakfast == 1:
                        current_card.is_breakfast = True
                    if is_lunch == 1:
                        current_card.is_lunch = True
                    if is_dinner == 1:
                        current_card.is_dinner = True
                    if is_snack == 1:
                        current_card.is_snack = True

                    if is_med == 1:
                        current_card.is_med = True
                    if is_mind == 1:
                        current_card.is_mind = True
                    if is_low_fodmap == 1:
                        current_card.is_low_fodmap = True
                    # if is_lowgi == 1:
                    #     current_card.is_lowgi = True

                    # Save current card state
                    current_card.save()
            print("E")
            return JsonResponse({'status': 'success'})
        except Exception as e:
            return JsonResponse({'error': str(e)}, status=500)
    else:
        return JsonResponse({'error': 'Invalid request method'}, status=400)


@csrf_exempt
def UpdateCardTagAmin(request):
    if request.method == "POST":
        if 'file' not in request.FILES:
            return JsonResponse({'error': 'No file uploaded'}, status=400)

        # Read the Excel file
        excel_file = request.FILES['file']
        data = pd.read_excel(excel_file)
        allergies_model_name = ["AL_Dairy_Butter",
                                "AL_Dairy_Cheese",
                                "AL_Dairy_Coconut",
                                "AL_Dairy_CoconutMilk",
                                "AL_Dairy_Cream",
                                "AL_Dairy_CreamCheese",
                                "AL_Dairy_IceCream",
                                "AL_Dairy_Mayonnaise",
                                "AL_Dairy_Milk",
                                "AL_Dairy_Milk",
                                "Chocolate",
                                "AL_Dairy_Whey",
                                "AL_Dairy_Yogurt",
                                "AL_Egg",
                                "AL_Eggs_Egg",
                                "AL_Eggs_Mayonnaise",
                                "AL_Fish_Crab",
                                "AL_Fish_Fish",
                                "AL_Fish_Shrimp",
                                "AL_Fish_Tuna",
                                "AL_Grain_Barley",
                                "AL_Grain_Bean",
                                "AL_Grain_Buckwheat",
                                "AL_Grain_Chickpea",
                                "AL_Grain_Corn",
                                "AL_Grain_Lentil",
                                "AL_Grain_Mung",
                                "AL_Grain_Oat",
                                "AL_Grain_Oats",
                                "AL_Grain_Quinoa",
                                "AL_Grain_Rice",
                                "AL_Grain_Rye",
                                "AL_Grain_Soy",
                                "AL_Grain_Unspecified",
                                "AL_Grain_Wheat",
                                "AL_Grains_Wheat",
                                "AL_Legume_Beans",
                                "AL_Legume_Lentil",
                                "AL_Legume_Pea",
                                "AL_Legume_RedBean",
                                "AL_Legume_Soy",
                                "AL_Legume_Split",
                                "Peas",
                                "AL_Legume_SplitPea",
                                "AL_Meat_Bacon",
                                "AL_Meat_Beef",
                                "AL_Meat_Chicken",
                                "AL_Meat_Ham",
                                "AL_Meat_Lamb",
                                "AL_Meat_Pepperoni",
                                "AL_Meat_Pork",
                                "AL_Meat_Processed",
                                "AL_Meat_Sausage",
                                "AL_Meat_Turkey",
                                "AL_Meat_Unspecified",
                                "AL_Meat_Varies",
                                "AL_Meat_Various",
                                "AL_Nuts_Almond",
                                "AL_Nuts_Coconut",
                                "AL_Nuts_Hazelnut",
                                "AL_Nuts_Nuts",
                                "AL_Nuts_Peanut",
                                "AL_Nuts_Pine",
                                "Nuts",
                                "AL_Nuts_Pistachio",
                                "AL_Nuts_Sesame",
                                "AL_Nuts_Unspecified",
                                "AL_Nuts_Varies",
                                "AL_Nuts_Various",
                                "AL_Nuts_Walnut",
                                "AL_Poultry_Chicken",
                                "AL_Seeds_Chia",
                                "AL_Shellfish_Shrimp",
                                "AL_Dairy_Butter",
                                "AL_Dairy_Cheese",
                                "AL_Dairy_Cream",
                                "AL_Dairy_Cream",
                                "Cheese",
                                "AL_Dairy_Creamer",
                                "AL_Dairy_Goat",
                                "Milk",
                                "AL_Dairy_Kashk",
                                "AL_Dairy_Kefir",
                                "AL_Dairy_Mayonnaise",
                                "AL_Dairy_Milk",
                                "AL_Dairy_Whey",
                                "AL_Dairy_Yogurt",
                                "AL_Egg",
                                "AL_Eggs_Egg",
                                "AL_Eggs_Mayonnaise",
                                "AL_Eggs_Whole",
                                "AL_Eggs_Whole",
                                "Eggs",
                                "AL_Eggs_Yolk",
                                "AL_Fish_Anchovy",
                                "AL_Fish_Carp",
                                "AL_Fish_Catfish",
                                "AL_Fish_Caviar",
                                "AL_Fish_Crab",
                                "AL_Fish_Croaker",
                                "AL_Fish_Fish",
                                "AL_Fish_Flatfish",
                                "AL_Fish_Flounder",
                                "AL_Fish_Grouper",
                                "AL_Fish_Herring",
                                "AL_Fish_KingMackerel",
                                "AL_Fish_Mackerel",
                                "AL_Fish_Mullet",
                                "AL_Fish_Pike",
                                "AL_Fish_Porgy",
                                "AL_Fish_Roe",
                                "AL_Fish_Salmon",
                                "AL_Fish_Sardine",
                                "AL_Fish_Shark",
                                "AL_Fish_Shrimp",
                                "AL_Fish_Snapper",
                                "AL_Fish_Swordfish",
                                "AL_Fish_Tilapia",
                                "AL_Fish_Trout",
                                "AL_Fish_Tuna",
                                "AL_Fish_Unspecified",
                                "AL_Fish_Whitefish",
                                "AL_Grain_Barley",
                                "AL_Grain_Bean",
                                "AL_Grain_Buckwheat",
                                "AL_Grain_Bulgur",
                                "AL_Grain_Cereal",
                                "AL_Grain_Chickpea",
                                "AL_Grain_Corn",
                                "AL_Grain_Lentil",
                                "AL_Grain_Millet",
                                "AL_Grain_Oat",
                                "AL_Grain_Oats",
                                "AL_Grain_Pea",
                                "AL_Grain_Quinoa",
                                "AL_Grain_Rice",
                                "AL_Grain_Rye",
                                "AL_Grain_Soy",
                                "AL_Grain_SplitPea",
                                "AL_Grain_Unspecified",
                                "AL_Grain_Wheat",
                                "AL_Grains_Barley",
                                "AL_Grains_Brown",
                                "Rice",
                                "AL_Grains_Bulgur",
                                "AL_Grains_Chickpea",
                                "AL_Grains_Corn",
                                "AL_Grains_Millet",
                                "AL_Grains_Oats",
                                "AL_Grains_Rice",
                                "AL_Legume_Bean",
                                "AL_Legume_Beans",
                                "AL_Legume_Chickpea",
                                "AL_Legume_Fava",
                                "AL_Legume_FavaBean",
                                "AL_Legume_Lentil",
                                "AL_Legume_Pea",
                                "AL_Legume_Peas",
                                "AL_Legume_Soy",
                                "AL_Legume_Unspecified",
                                "AL_Meat_Bacon",
                                "AL_Meat_Beef",
                                "AL_Meat_Camel",
                                "AL_Meat_Chicken",
                                "AL_Meat_Duck",
                                "AL_Meat_Fat",
                                "AL_Meat_Fish",
                                "AL_Meat_Goose",
                                "AL_Meat_Ground",
                                "AL_Meat_Kidney",
                                "AL_Meat_Lamb",
                                "AL_Meat_Offal",
                                "AL_Meat_Organ",
                                "AL_Meat_Ostrich",
                                "AL_Meat_Pigeon",
                                "AL_Meat_Pork",
                                "AL_Meat_Quail",
                                "AL_Meat_Sheep",
                                "AL_Meat_Turkey",
                                "AL_Meat_Unspecified",
                                "AL_Meat_Varies",
                                "AL_Meat_Veal",
                                "AL_None",
                                "AL_Nuts_Acorn",
                                "AL_Nuts_Almond",
                                "AL_Nuts_Almonds",
                                "AL_Nuts_Cashew",
                                "AL_Nuts_Chestnut",
                                "AL_Nuts_Coconut",
                                "AL_Nuts_Hazelnut",
                                "AL_Nuts_Hazelnuts",
                                "AL_Nuts_Hemp",
                                "AL_Nuts_Mixed",
                                "AL_Nuts_Nutmeg",
                                "AL_Nuts_Nuts",
                                "AL_Nuts_Peanut",
                                "AL_Nuts_Peanuts",
                                "AL_Nuts_Pecan",
                                "AL_Nuts_Pistachio",
                                "AL_Nuts_Sesame",
                                "AL_Nuts_Unspecified",
                                "AL_Nuts_Varies",
                                "AL_Nuts_Walnut",
                                "AL_Other_Sesame",
                                "AL_Poultry_Chicken",
                                "AL_Poultry_Duck",
                                "AL_Poultry_Offal",
                                "AL_Seafood_Fish",
                                "AL_Seeds_Cottonseed",
                                "AL_Seeds_Flax",
                                "AL_Seeds_Flaxseed",
                                "AL_Seeds_Poppy",
                                "AL_Seeds_Pumpkin",
                                "AL_Seeds_Safflower",
                                "AL_Seeds_Sesame",
                                "AL_Seeds_Sunflower",
                                "AL_Seeds_Watermelon",
                                "AL_Sesame_Sesame",
                                "AL_Shellfish_Shrimp",
                                "AL_Soy_Soy",
                                "AL_Soy_SoySauce",
                                "AL_Soy_Soybean",
                                "AL_Soy_Soybeans"]
        allergies_table_name = [
            "AL-Dairy-Butter", "AL-Dairy-Cheese", "AL-Dairy-Coconut", "AL-Dairy-CoconutMilk",
            "AL-Dairy-Cream", "AL-Dairy-CreamCheese", "AL-Dairy-IceCream", "AL-Dairy-Mayonnaise",
            "AL-Dairy-Milk", "AL-Dairy-Milk Chocolate", "AL-Dairy-Whey", "AL-Dairy-Yogurt",
            "AL-Egg", "AL-Eggs-Egg", "AL-Eggs-Mayonnaise", "AL-Fish-Crab", "AL-Fish-Fish",
            "AL-Fish-Shrimp", "AL-Fish-Tuna", "AL-Grain-Barley", "AL-Grain-Bean", "AL-Grain-Buckwheat",
            "AL-Grain-Chickpea", "AL-Grain-Corn", "AL-Grain-Lentil", "AL-Grain-Mung", "AL-Grain-Oat",
            "AL-Grain-Oats", "AL-Grain-Quinoa", "AL-Grain-Rice", "AL-Grain-Rye", "AL-Grain-Soy",
            "AL-Grain-Unspecified", "AL-Grain-Wheat", "AL-Grains-Wheat", "AL-Legume-Beans",
            "AL-Legume-Lentil", "AL-Legume-Pea", "AL-Legume-RedBean", "AL-Legume-Soy",
            "AL-Legume-Split Peas", "AL-Legume-SplitPea", "AL-Meat-Bacon", "AL-Meat-Beef",
            "AL-Meat-Chicken", "AL-Meat-Ham", "AL-Meat-Lamb", "AL-Meat-Pepperoni", "AL-Meat-Pork",
            "AL-Meat-Processed", "AL-Meat-Sausage", "AL-Meat-Turkey", "AL-Meat-Unspecified",
            "AL-Meat-Varies", "AL-Meat-Various", "AL-Nuts-Almond", "AL-Nuts-Coconut", "AL-Nuts-Hazelnut",
            "AL-Nuts-Nuts", "AL-Nuts-Peanut", "AL-Nuts-Pine Nuts", "AL-Nuts-Pistachio",
            "AL-Nuts-Sesame", "AL-Nuts-Unspecified", "AL-Nuts-Varies", "AL-Nuts-Various",
            "AL-Nuts-Walnut", "AL-Poultry-Chicken", "AL-Seeds-Chia", "AL-Shellfish-Shrimp",
            "AL-Dairy-Butter", "AL-Dairy-Cheese", "AL-Dairy-Cream", "AL-Dairy-Cream Cheese",
            "AL-Dairy-Creamer", "AL-Dairy-Goat Milk", "AL-Dairy-Kashk", "AL-Dairy-Kefir",
            "AL-Dairy-Mayonnaise", "AL-Dairy-Milk", "AL-Dairy-Whey", "AL-Dairy-Yogurt", "AL-Egg",
            "AL-Eggs-Egg", "AL-Eggs-Mayonnaise", "AL-Eggs-Whole", "AL-Eggs-Whole Eggs", "AL-Eggs-Yolk",
            "AL-Fish-Anchovy", "AL-Fish-Carp", "AL-Fish-Catfish", "AL-Fish-Caviar", "AL-Fish-Crab",
            "AL-Fish-Croaker", "AL-Fish-Fish", "AL-Fish-Flatfish", "AL-Fish-Flounder", "AL-Fish-Grouper",
            "AL-Fish-Herring", "AL-Fish-KingMackerel", "AL-Fish-Mackerel", "AL-Fish-Mullet",
            "AL-Fish-Pike", "AL-Fish-Porgy", "AL-Fish-Roe", "AL-Fish-Salmon", "AL-Fish-Sardine",
            "AL-Fish-Shark", "AL-Fish-Shrimp", "AL-Fish-Snapper", "AL-Fish-Swordfish", "AL-Fish-Tilapia",
            "AL-Fish-Trout", "AL-Fish-Tuna", "AL-Fish-Unspecified", "AL-Fish-Whitefish", "AL-Grain-Barley",
            "AL-Grain-Bean", "AL-Grain-Buckwheat", "AL-Grain-Bulgur", "AL-Grain-Cereal",
            "AL-Grain-Chickpea", "AL-Grain-Corn", "AL-Grain-Lentil", "AL-Grain-Millet", "AL-Grain-Oat",
            "AL-Grain-Oats", "AL-Grain-Pea", "AL-Grain-Quinoa", "AL-Grain-Rice", "AL-Grain-Rye",
            "AL-Grain-Soy", "AL-Grain-SplitPea", "AL-Grain-Unspecified", "AL-Grain-Wheat",
            "AL-Grains-Barley", "AL-Grains-Brown Rice", "AL-Grains-Bulgur", "AL-Grains-Chickpea",
            "AL-Grains-Corn", "AL-Grains-Millet", "AL-Grains-Oats", "AL-Grains-Rice", "AL-Grains-Wheat",
            "AL-Legume-Bean", "AL-Legume-Beans", "AL-Legume-Chickpea", "AL-Legume-Fava",
            "AL-Legume-FavaBean", "AL-Legume-Lentil", "AL-Legume-Pea", "AL-Legume-Peas", "AL-Legume-Soy",
            "AL-Legume-Unspecified", "AL-Meat-Bacon", "AL-Meat-Beef", "AL-Meat-Camel", "AL-Meat-Chicken",
            "AL-Meat-Duck", "AL-Meat-Fat", "AL-Meat-Fish", "AL-Meat-Goose", "AL-Meat-Ground",
            "AL-Meat-Kidney", "AL-Meat-Lamb", "AL-Meat-Offal", "AL-Meat-Organ", "AL-Meat-Ostrich",
            "AL-Meat-Pigeon", "AL-Meat-Pork", "AL-Meat-Quail", "AL-Meat-Sheep", "AL-Meat-Turkey",
            "AL-Meat-Unspecified", "AL-Meat-Varies", "AL-Meat-Veal", "AL-Nuts-Acorn",
            "AL-Nuts-Almond", "AL-Nuts-Almonds", "AL-Nuts-Cashew", "AL-Nuts-Chestnut", "AL-Nuts-Coconut",
            "AL-Nuts-Hazelnut", "AL-Nuts-Hazelnuts", "AL-Nuts-Hemp", "AL-Nuts-Mixed", "AL-Nuts-Nutmeg",
            "AL-Nuts-Nuts", "AL-Nuts-Peanut", "AL-Nuts-Peanuts", "AL-Nuts-Pecan", "AL-Nuts-Pistachio",
            "AL-Nuts-Sesame", "AL-Nuts-Unspecified", "AL-Nuts-Varies", "AL-Nuts-Walnut", "AL-Other-Sesame",
            "AL-Poultry-Chicken", "AL-Poultry-Duck", "AL-Poultry-Offal", "AL-Seafood-Fish",
            "AL-Seeds-Chia", "AL-Seeds-Cottonseed", "AL-Seeds-Flax", "AL-Seeds-Flaxseed", "AL-Seeds-Poppy",
            "AL-Seeds-Pumpkin", "AL-Seeds-Safflower", "AL-Seeds-Sesame", "AL-Seeds-Sunflower",
            "AL-Seeds-Watermelon", "AL-Sesame-Sesame", "AL-Shellfish-Shrimp", "AL-Soy-Soy",
            "AL-Soy-SoySauce", "AL-Soy-Soybean", "AL-Soy-Soybeans",
        ]

        with transaction.atomic():
            i = 0
            for index, row in data.iterrows():
                # try :
                    # Use row instead of data for individual values
                card = FoodCard.objects.filter(FA_Name=row["FA_Name"], Calories=row["Calories"])[0]

                card.AL_Dairy_Butter = True if pd.isna(row[9]) else False
                card.AL_Dairy_Cheese = True if pd.isna(row[10]) else False
                card.AL_Dairy_Coconut = True if pd.isna(row[11]) else False
                card.AL_Dairy_CoconutMilk = True if pd.isna(row[12]) else False
                card.AL_Dairy_Cream = True if pd.isna(row[13]) else False
                card.AL_Dairy_CreamCheese = True if pd.isna(row[14]) else False
                card.AL_Dairy_IceCream = True if pd.isna(row[15]) else False
                card.AL_Dairy_Mayonnaise = True if pd.isna(row[16]) else False
                card.AL_Dairy_Milk = True if pd.isna(row[17]) else False
                card.AL_Dairy_Milk_Chocolate = True if pd.isna(row[18]) else False
                card.AL_Dairy_Whey = True if pd.isna(row[19]) else False
                card.AL_Dairy_Yogurt = True if pd.isna(row[20]) else False
                card.AL_Egg = True if pd.isna(row[21]) else False
                card.AL_Eggs_Egg = True if pd.isna(row[22]) else False
                card.AL_Eggs_Mayonnaise = True if pd.isna(row[23]) else False
                card.AL_Fish_Crab = True if pd.isna(row[24]) else False
                card.AL_Fish_Fish = True if pd.isna(row[25]) else False
                card.AL_Fish_Shrimp = True if pd.isna(row[26]) else False
                card.AL_Fish_Tuna = True if pd.isna(row[27]) else False
                card.AL_Grain_Barley = True if pd.isna(row[28]) else False
                card.AL_Grain_Bean = True if pd.isna(row[29]) else False
                card.AL_Grain_Buckwheat = True if pd.isna(row[30]) else False
                card.AL_Grain_Chickpea = True if pd.isna(row[31]) else False
                card.AL_Grain_Corn = True if pd.isna(row[32]) else False
                card.AL_Grain_Lentil = True if pd.isna(row[33]) else False
                card.AL_Grain_Mung = True if pd.isna(row[34]) else False
                card.AL_Grain_Oat = True if pd.isna(row[35]) else False
                card.AL_Grain_Oats = True if pd.isna(row[36]) else False
                card.AL_Grain_Quinoa = True if pd.isna(row[37]) else False
                card.AL_Grain_Rice = True if pd.isna(row[38]) else False
                card.AL_Grain_Rye = True if pd.isna(row[39]) else False
                card.AL_Grain_Soy = True if pd.isna(row[40]) else False
                card.AL_Grain_Unspecified = True if pd.isna(row[41]) else False
                card.AL_Grain_Wheat = True if pd.isna(row[42]) else False
                card.AL_Grains_Wheat = True if pd.isna(row[43]) else False
                card.AL_Legume_Beans = True if pd.isna(row[44]) else False
                card.AL_Legume_Lentil = True if pd.isna(row[45]) else False
                card.AL_Legume_Pea = True if pd.isna(row[46]) else False
                card.AL_Legume_RedBean = True if pd.isna(row[47]) else False
                card.AL_Legume_Soy = True if pd.isna(row[48]) else False
                card.AL_Legume_Split_Peas = True if pd.isna(row[49]) else False
                card.AL_Legume_SplitPea = True if pd.isna(row[50]) else False
                card.AL_Meat_Bacon = True if pd.isna(row[51]) else False
                card.AL_Meat_Beef = True if pd.isna(row[52]) else False
                card.AL_Meat_Chicken = True if pd.isna(row[53]) else False
                card.AL_Meat_Ham = True if pd.isna(row[54]) else False
                card.AL_Meat_Lamb = True if pd.isna(row[55]) else False
                card.AL_Meat_Pepperoni = True if pd.isna(row[56]) else False
                card.AL_Meat_Pork = True if pd.isna(row[57]) else False
                card.AL_Meat_Processed = True if pd.isna(row[58]) else False
                card.AL_Meat_Sausage = True if pd.isna(row[59]) else False
                card.AL_Meat_Turkey = True if pd.isna(row[60]) else False
                card.AL_Meat_Unspecified = True if pd.isna(row[61]) else False
                card.AL_Meat_Varies = True if pd.isna(row[62]) else False
                card.AL_Meat_Various = True if pd.isna(row[63]) else False
                card.AL_Nuts_Almond = True if pd.isna(row[64]) else False
                card.AL_Nuts_Coconut = True if pd.isna(row[65]) else False
                card.AL_Nuts_Hazelnut = True if pd.isna(row[66]) else False
                card.AL_Nuts_Nuts = True if pd.isna(row[67]) else False
                card.AL_Nuts_Peanut = True if pd.isna(row[68]) else False
                card.AL_Nuts_Pine_Nuts = True if pd.isna(row[69]) else False
                card.AL_Nuts_Pistachio = True if pd.isna(row[70]) else False
                card.AL_Nuts_Sesame = True if pd.isna(row[71]) else False
                card.AL_Nuts_Unspecified = True if pd.isna(row[72]) else False
                card.AL_Nuts_Varies = True if pd.isna(row[73]) else False
                card.AL_Nuts_Various = True if pd.isna(row[74]) else False
                card.AL_Nuts_Walnut = True if pd.isna(row[75]) else False
                card.AL_Poultry_Chicken = True if pd.isna(row[76]) else False
                card.AL_Seeds_Chia = True if pd.isna(row[77]) else False
                card.AL_Shellfish_Shrimp = True if pd.isna(row[78]) else False
                card.AL_Dairy_Butter = True if pd.isna(row[79]) else False
                card.AL_Dairy_Cheese = True if pd.isna(row[80]) else False
                card.AL_Dairy_Cream = True if pd.isna(row[81]) else False
                card.AL_Dairy_Cream_Cheese = True if pd.isna(row[82]) else False
                card.AL_Dairy_Creamer = True if pd.isna(row[83]) else False
                card.AL_Dairy_Goat_Milk = True if pd.isna(row[84]) else False
                card.AL_Dairy_Kashk = True if pd.isna(row[85]) else False
                card.AL_Dairy_Kefir = True if pd.isna(row[86]) else False
                card.AL_Dairy_Mayonnaise = True if pd.isna(row[87]) else False
                card.AL_Dairy_Milk = True if pd.isna(row[88]) else False
                card.AL_Dairy_Whey = True if pd.isna(row[89]) else False
                card.AL_Dairy_Yogurt = True if pd.isna(row[90]) else False
                card.AL_Egg = True if pd.isna(row[91]) else False
                card.AL_Eggs_Egg = True if pd.isna(row[92]) else False
                card.AL_Eggs_Mayonnaise = True if pd.isna(row[93]) else False
                card.AL_Eggs_Whole = True if pd.isna(row[94]) else False
                card.AL_Eggs_Whole_Eggs = True if pd.isna(row[95]) else False
                card.AL_Eggs_Yolk = True if pd.isna(row[96]) else False
                card.AL_Fish_Anchovy = True if pd.isna(row[97]) else False
                card.AL_Fish_Carp = True if pd.isna(row[98]) else False
                card.AL_Fish_Catfish = True if pd.isna(row[99]) else False
                card.AL_Fish_Caviar = True if pd.isna(row[100]) else False
                card.AL_Fish_Crab = True if pd.isna(row[101]) else False
                card.AL_Fish_Croaker = True if pd.isna(row[102]) else False
                card.AL_Fish_Fish = True if pd.isna(row[103]) else False
                card.AL_Fish_Flatfish = True if pd.isna(row[104]) else False
                card.AL_Fish_Flounder = True if pd.isna(row[105]) else False
                card.AL_Fish_Grouper = True if pd.isna(row[106]) else False
                card.AL_Fish_Herring = True if pd.isna(row[107]) else False
                card.AL_Fish_KingMackerel = True if pd.isna(row[108]) else False
                card.AL_Fish_Mackerel = True if pd.isna(row[109]) else False
                card.AL_Fish_Mullet = True if pd.isna(row[110]) else False
                card.AL_Fish_Pike = True if pd.isna(row[111]) else False
                card.AL_Fish_Porgy = True if pd.isna(row[112]) else False
                card.AL_Fish_Roe = True if pd.isna(row[113]) else False
                card.AL_Fish_Salmon = True if pd.isna(row[114]) else False
                card.AL_Fish_Sardine = True if pd.isna(row[115]) else False
                card.AL_Fish_Shark = True if pd.isna(row[116]) else False
                card.AL_Fish_Shrimp = True if pd.isna(row[117]) else False
                card.AL_Fish_Snapper = True if pd.isna(row[118]) else False
                card.AL_Fish_Swordfish = True if pd.isna(row[119]) else False
                card.AL_Fish_Tilapia = True if pd.isna(row[120]) else False
                card.AL_Fish_Trout = True if pd.isna(row[121]) else False
                card.AL_Fish_Tuna = True if pd.isna(row[122]) else False
                card.AL_Fish_Unspecified = True if pd.isna(row[123]) else False
                card.AL_Fish_Whitefish = True if pd.isna(row[124]) else False
                card.AL_Grain_Barley = True if pd.isna(row[125]) else False
                card.AL_Grain_Bean = True if pd.isna(row[126]) else False
                card.AL_Grain_Buckwheat = True if pd.isna(row[127]) else False
                card.AL_Grain_Bulgur = True if pd.isna(row[128]) else False
                card.AL_Grain_Cereal = True if pd.isna(row[129]) else False
                card.AL_Grain_Chickpea = True if pd.isna(row[130]) else False
                card.AL_Grain_Corn = True if pd.isna(row[131]) else False
                card.AL_Grain_Lentil = True if pd.isna(row[132]) else False
                card.AL_Grain_Millet = True if pd.isna(row[133]) else False
                card.AL_Grain_Oat = True if pd.isna(row[134]) else False
                card.AL_Grain_Oats = True if pd.isna(row[135]) else False
                card.AL_Grain_Pea = True if pd.isna(row[136]) else False
                card.AL_Grain_Quinoa = True if pd.isna(row[137]) else False
                card.AL_Grain_Rice = True if pd.isna(row[138]) else False
                card.AL_Grain_Rye = True if pd.isna(row[139]) else False
                card.AL_Grain_Soy = True if pd.isna(row[140]) else False
                card.AL_Grain_SplitPea = True if pd.isna(row[141]) else False
                card.AL_Grain_Unspecified = True if pd.isna(row[142]) else False
                card.AL_Grain_Wheat = True if pd.isna(row[143]) else False
                card.AL_Grains_Barley = True if pd.isna(row[144]) else False
                card.AL_Grains_Brown_Rice = True if pd.isna(row[145]) else False
                card.AL_Grains_Bulgur = True if pd.isna(row[146]) else False
                card.AL_Grains_Chickpea = True if pd.isna(row[147]) else False
                card.AL_Grains_Corn = True if pd.isna(row[148]) else False
                card.AL_Grains_Millet = True if pd.isna(row[149]) else False
                card.AL_Grains_Oats = True if pd.isna(row[150]) else False
                card.AL_Grains_Rice = True if pd.isna(row[151]) else False
                card.AL_Grains_Wheat = True if pd.isna(row[152]) else False
                card.AL_Legume_Bean = True if pd.isna(row[153]) else False
                card.AL_Legume_Beans = True if pd.isna(row[154]) else False
                card.AL_Legume_Chickpea = True if pd.isna(row[155]) else False
                card.AL_Legume_Fava = True if pd.isna(row[156]) else False
                card.AL_Legume_FavaBean = True if pd.isna(row[157]) else False
                card.AL_Legume_Lentil = True if pd.isna(row[158]) else False
                card.AL_Legume_Pea = True if pd.isna(row[159]) else False
                card.AL_Legume_Peas = True if pd.isna(row[160]) else False
                card.AL_Legume_Soy = True if pd.isna(row[161]) else False
                card.AL_Legume_Unspecified = True if pd.isna(row[162]) else False
                card.AL_Meat_Bacon = True if pd.isna(row[163]) else False
                card.AL_Meat_Beef = True if pd.isna(row[164]) else False
                card.AL_Meat_Camel = True if pd.isna(row[165]) else False
                card.AL_Meat_Chicken = True if pd.isna(row[166]) else False
                card.AL_Meat_Duck = True if pd.isna(row[167]) else False
                card.AL_Meat_Fat = True if pd.isna(row[168]) else False
                card.AL_Meat_Fish = True if pd.isna(row[169]) else False
                card.AL_Meat_Goose = True if pd.isna(row[170]) else False
                card.AL_Meat_Ground = True if pd.isna(row[171]) else False
                card.AL_Meat_Kidney = True if pd.isna(row[172]) else False
                card.AL_Meat_Lamb = True if pd.isna(row[173]) else False
                card.AL_Meat_Offal = True if pd.isna(row[174]) else False
                card.AL_Meat_Organ = True if pd.isna(row[175]) else False
                card.AL_Meat_Ostrich = True if pd.isna(row[176]) else False
                card.AL_Meat_Pigeon = True if pd.isna(row[177]) else False
                card.AL_Meat_Pork = True if pd.isna(row[178]) else False
                card.AL_Meat_Quail = True if pd.isna(row[179]) else False
                card.AL_Meat_Sheep = True if pd.isna(row[180]) else False
                card.AL_Meat_Turkey = True if pd.isna(row[181]) else False
                card.AL_Meat_Unspecified = True if pd.isna(row[182]) else False
                card.AL_Meat_Varies = True if pd.isna(row[183]) else False
                card.AL_Meat_Veal = True if pd.isna(row[184]) else False
                card.AL_Nuts_Acorn = True if pd.isna(row[186]) else False
                card.AL_Nuts_Almond = True if pd.isna(row[187]) else False
                card.AL_Nuts_Almonds = True if pd.isna(row[188]) else False
                card.AL_Nuts_Cashew = True if pd.isna(row[189]) else False
                card.AL_Nuts_Chestnut = True if pd.isna(row[190]) else False
                card.AL_Nuts_Coconut = True if pd.isna(row[191]) else False
                card.AL_Nuts_Hazelnut = True if pd.isna(row[192]) else False
                card.AL_Nuts_Hazelnuts = True if pd.isna(row[193]) else False
                card.AL_Nuts_Hemp = True if pd.isna(row[194]) else False
                card.AL_Nuts_Mixed = True if pd.isna(row[195]) else False
                card.AL_Nuts_Nutmeg = True if pd.isna(row[196]) else False
                card.AL_Nuts_Nuts = True if pd.isna(row[197]) else False
                card.AL_Nuts_Peanut = True if pd.isna(row[198]) else False
                card.AL_Nuts_Peanuts = True if pd.isna(row[199]) else False
                card.AL_Nuts_Pecan = True if pd.isna(row[200]) else False
                card.AL_Nuts_Pistachio = True if pd.isna(row[201]) else False
                card.AL_Nuts_Sesame = True if pd.isna(row[202]) else False
                card.AL_Nuts_Unspecified = True if pd.isna(row[203]) else False
                card.AL_Nuts_Varies = True if pd.isna(row[204]) else False
                card.AL_Nuts_Walnut = True if pd.isna(row[205]) else False
                card.AL_Other_Sesame = True if pd.isna(row[206]) else False
                card.AL_Poultry_Chicken = True if pd.isna(row[207]) else False
                card.AL_Poultry_Duck = True if pd.isna(row[208]) else False
                card.AL_Poultry_Offal = True if pd.isna(row[209]) else False
                card.AL_Seafood_Fish = True if pd.isna(row[210]) else False
                card.AL_Seeds_Chia = True if pd.isna(row[211]) else False
                card.AL_Seeds_Cottonseed = True if pd.isna(row[212]) else False
                card.AL_Seeds_Flax = True if pd.isna(row[213]) else False
                card.AL_Seeds_Flaxseed = True if pd.isna(row[214]) else False
                card.AL_Seeds_Poppy = True if pd.isna(row[215]) else False
                card.AL_Seeds_Pumpkin = True if pd.isna(row[216]) else False
                card.AL_Seeds_Safflower = True if pd.isna(row[217]) else False
                card.AL_Seeds_Sesame = True if pd.isna(row[218]) else False
                card.AL_Seeds_Sunflower = True if pd.isna(row[219]) else False
                card.AL_Seeds_Watermelon = True if pd.isna(row[220]) else False
                card.AL_Sesame_Sesame = True if pd.isna(row[221]) else False
                card.AL_Shellfish_Shrimp = True if pd.isna(row[222]) else False
                card.AL_Soy_Soy = True if pd.isna(row[223]) else False
                card.AL_Soy_SoySauce = True if pd.isna(row[224]) else False
                card.AL_Soy_Soybean = True if pd.isna(row[225]) else False
                card.AL_Soy_Soybeans = True if pd.isna(row[226]) else False

                # Handle main_dish_code more safely
                main_dish_code_raw = row["main_dish_code"]

                # Check if the value is not NaN/null
                if pd.notna(main_dish_code_raw):
                    # If it's already a string that looks like a list
                    if isinstance(main_dish_code_raw, str):
                        try:
                            main_dish_code = ast.literal_eval(main_dish_code_raw)
                            if isinstance(main_dish_code, (list, tuple)) and len(main_dish_code) > 0:
                                card.main_dish_code = main_dish_code[0]
                        except (ValueError, SyntaxError):
                            # If parsing fails, treat it as a single value
                            card.main_dish_code = main_dish_code_raw
                    else:
                        # If it's a number or other type, use it directly
                        card.main_dish_code = main_dish_code_raw


                card.save()

                i += 1
                # except:
                #     print(f"Error processing row")
                #     continue

            print(f" {i} cards has been updated")

        return JsonResponse({'status': 'success'})
    else:
        return JsonResponse({'error': 'Invalid request method'}, status=400)


@csrf_exempt
def UpdateCardDiseaseTagsAmin(request):
    if request.method == "POST":
        if 'file' not in request.FILES:
            return JsonResponse({'error': 'No file uploaded'}, status=400)

        # Read the Excel file
        excel_file = request.FILES['file']
        data = pd.read_excel(excel_file)

        with transaction.atomic():
            i = 0
            for index, row in data.iterrows():
                # try :
                    # Use row instead of data for individual values
                card = FoodCard.objects.filter(FA_Name=row["FA_Name"], Calories=row["Calories"])[0]

                card.Disease_Anemia = True if row[228] > 0 else False
                card.Disease_Arthritis = True if row[229] > 0 else False
                card.Disease_Autoimmune = True if row[230] > 0 else False
                card.Disease_CVD = True if row[231] > 0 else False
                card.Disease_CancerPrevention = True if row[232] > 0 else False
                card.Disease_Celiac = True if row[233] > 0 else False
                card.Disease_Diabetes = True if row[234] > 0 else False
                card.Disease_Gout = True if row[235] > 0 else False
                card.Disease_High_cholesterol = True if row[236] > 0 else False
                card.Disease_High_blood_pressure = True if row[237] > 0 else False
                card.Disease_IBD = True if row[238] > 0 else False
                card.Disease_IBS = True if row[239] > 0 else False
                card.Disease_Kidney = True if row[240] > 0 else False
                card.Disease_Lactose_Intolerance = True if row[241] > 0 else False
                card.Disease_MentalHealth = True if row[242] > 0 else False
                card.Disease_NAFLD = True if row[243] > 0 else False
                card.Disease_Osteoporosis = True if row[244] > 0 else False
                card.Disease_Hypothyroidism = True if row[245] > 0 else False

                card.save()

                i += 1
                # except:
                #     print(f"Error processing row")
                #     continue

            print(f" {i} cards has been updated")

        return JsonResponse({'status': 'success'})
    else:
        return JsonResponse({'error': 'Invalid request method'}, status=400)


@csrf_exempt
def amin_import_food_cards_from_excel(request):
    if request.method != 'POST':
        return JsonResponse({'error': 'Invalid request method'}, status=400)

    if 'file' not in request.FILES:
        return JsonResponse({'error': 'No file uploaded'}, status=400)

    # Read the Excel file
    excel_file = request.FILES['file']
    if not excel_file.name.endswith('.xlsx'):
        return JsonResponse({'error': 'File must be in .xlsx format'}, status=400)

    try:
        data = pd.read_excel(excel_file)
    except Exception as e:
        return JsonResponse({'error': f'Error reading Excel file: {str(e)}'}, status=400)

    def convert_to_json_string(foods_str):
        if pd.isna(foods_str) or not str(foods_str).strip():
            return '[]'  # Return empty list as JSON string if NaN or empty
        try:
            # Parse the Python literal string to a Python object
            foods_list = ast.literal_eval(str(foods_str))
            # Convert to JSON string with double quotes
            return json.dumps(foods_list, ensure_ascii=False)
        except (ValueError, SyntaxError) as e:
            print(f"Error parsing foods string: {foods_str} - {e}")
            return '[]'  # Fallback to empty list if parsing fails

    # Apply the conversion to the 'foods' column
    data['foods'] = data['foods'].apply(convert_to_json_string)

    # Optional: Clear existing FoodCard objects (remove if you want to update instead of replace)
    FoodCard.objects.all().delete()

    created_count = 0
    updated_count = 0
    skipped_count = 0
    skipped_rows = []

    with transaction.atomic():
        for index, row in data.iterrows():
            # Skip rows with missing or invalid 'id'
            if pd.isna(row.get('id')):
                skipped_count += 1
                skipped_rows.append(f"Row {index}: Missing or invalid 'id'")
                continue

            try:
                # Parse the 'foods' field
                foods_str = row.get('foods', '[]')  # Default to empty list string if missing
                if pd.notna(foods_str):
                    try:
                        # Try parsing as JSON
                        foods = json.loads(str(foods_str))
                    except json.JSONDecodeError as e:
                        skipped_count += 1
                        skipped_rows.append(f"Row {index}: Invalid foods format - {str(e)} (got: {foods_str})")
                        foods = []
                else:
                    foods = []

                # Create or update the FoodCard object
                card, created = FoodCard.objects.get_or_create(
                    id=int(row["id"]),
                    defaults={
                        'FA_Name': row.get("FA_Name", ""),
                        'EN_Name': row.get("EN_Name", ""),
                        'Calories': float(row["Calories"]) if pd.notna(row["Calories"]) else 0.0,
                        'carb_ratio': float(row["carb_ratio"]) if pd.notna(row["carb_ratio"]) else 0.0,
                        'fat_ratio': float(row["fat_ratio"]) if pd.notna(row["fat_ratio"]) else 0.0,
                        'protein_ratio': float(row["protein_ratio"]) if pd.notna(row["protein_ratio"]) else 0.0,
                        'is_keto': bool(row.get('is_keto', 0)),
                        'is_med': bool(row.get('is_med', 0)),
                        'is_conditional_med': bool(row.get('is_conditional_med', 0)),
                        'is_lowcarb': bool(row.get('is_lowcarb', 0)),
                        'is_mediumcarb': bool(row.get('is_mediumcarb', 0)),
                        'is_highcarb': bool(row.get('is_highcarb', 0)),
                        'is_highprotein': bool(row.get('is_highprotein', 0)),
                        'is_lowprotein': bool(row.get('is_lowprotein', 0)),
                        'is_mediumprotein': bool(row.get('is_mediumprotein', 0)),
                        'is_mind': bool(row.get('is_mind', 0)),
                        'is_lowfat': bool(row.get('is_lowfat', 0)),
                        'is_mediumfat': bool(row.get('is_mediumfat', 0)),
                        'is_highfat': bool(row.get('is_highfat', 0)),
                        'is_low_fodmap': bool(row.get('is_low_fodmap', 0)),
                        'is_breakfast': bool(row.get('is_breakfast', 0)),
                        'is_lunch': bool(row.get('is_lunch', 0)),
                        'is_dinner': bool(row.get('is_dinner', 0)),
                        'is_snack': bool(row.get('is_snack', 0)),
                        'foods': foods,  # Parsed list of dictionaries
                        'Dessert': bool(row.get("Dessert", 0)),
                        'Added_Meat': bool(row.get("Added_Meat", 0)),
                        'Ing_Main': bool(row.get("Ing_Main", 0)),
                        'Beverage': bool(row.get("Beverage", 0)),
                        'Sandwich': bool(row.get("Sandwich", 0)),
                        'Condiment': bool(row.get("Condiment", 0)),
                        'Lunch': bool(row.get("Lunch", 0)),
                        'Snack': bool(row.get("Snack", 0)),
                        'Bread': bool(row.get("Bread", 0)),
                        'Entree': bool(row.get("Entree", 0)),
                        'Soup': bool(row.get("Soup", 0)),
                        'Side_Dish': bool(row.get("Side_Dish", 0)),
                        'Appetizer': bool(row.get("Appetizer", 0)),
                        'Dinner': bool(row.get("Dinner", 0)),
                        'Pasta': bool(row.get("Pasta", 0)),
                        'Breakfast': bool(row.get("Breakfast", 0)),
                        'Salad': bool(row.get("Salad", 0)),
                        'Ingredient': bool(row.get("Ingredient", 0)),
                        'Bacteria_Acidaminococcus': bool(row.get("Bacteria_Acidaminococcus", 0)),
                        'Bacteria_Bacteroidetes': bool(row.get("Bacteria_Bacteroidetes", 0)),
                        'Bacteria_Alistipes': bool(row.get("Bacteria_Alistipes", 0)),
                        'Bacteria_Bifidobacterium': bool(row.get("Bacteria_Bifidobacterium", 0)),
                        'Bacteria_Akkermansia': bool(row.get("Bacteria_Akkermansia", 0)),
                        'Bacteria_Blautia': bool(row.get("Bacteria_Blautia", 0)),
                        'Bacteria_Fecalibacterium': bool(row.get("Bacteria_Fecalibacterium", 0)),
                        'Bacteria_Lawsonibacter_asaccharolyticus': bool(row.get("Bacteria_Lawsonibacter_asaccharolyticus", 0)),
                        'Bacteria_Lactobacillus': bool(row.get("Bacteria_Lactobacillus", 0)),
                        'Vegan': bool(row.get("Vegan", 0)),
                        'Umami': bool(row.get("Umami", 0)),
                        'Slow_cooked': bool(row.get("Slow_cooked", 0)),
                        'Spicy': bool(row.get("Spicy", 0)),
                        'Baked': bool(row.get("Baked", 0)),
                        'Pickled': bool(row.get("Pickled", 0)),
                        'Low_calorie': bool(row.get("Low_calorie", 0)),
                        'Grilled': bool(row.get("Grilled", 0)),
                        'Roasted': bool(row.get("Roasted", 0)),
                        'High_protein': bool(row.get("High_protein", 0)),
                        'Fried': bool(row.get("Fried", 0)),
                        'Sweet': bool(row.get("Sweet", 0)),
                        'Salty': bool(row.get("Salty", 0)),
                        'Lactose_free': bool(row.get("Lactose_free", 0)),
                        'Low_carb': bool(row.get("Low_carb", 0)),
                        'Cold': bool(row.get("Cold", 0)),
                        'Vegetarian': bool(row.get("Vegetarian", 0)),
                        'Sour': bool(row.get("Sour", 0)),
                        'Sweet_Sour': bool(row.get("Sweet_Sour", 0)),
                        'Raw': bool(row.get("Raw", 0)),
                        'Gluten_free': bool(row.get("Gluten_free", 0)),
                        'Boiled': bool(row.get("Boiled", 0)),
                        'Steamed': bool(row.get("Steamed", 0)),
                        'Low_fat': bool(row.get("Low_fat", 0)),
                        'Prepared_Meals': bool(row.get("Prepared_Meals", 0)),
                        'Meats': bool(row.get("Meats", 0)),
                        'Sweets': bool(row.get("Sweets", 0)),
                        'Beans_and_Lentils': bool(row.get("Beans_and_Lentils", 0)),
                        'Snacks': bool(row.get("Snacks", 0)),
                        'Grains_and_Pasta': bool(row.get("Grains_and_Pasta", 0)),
                        'Nuts_and_Seeds': bool(row.get("Nuts_and_Seeds", 0)),
                        'Fruits': bool(row.get("Fruits", 0)),
                        'Beverages': bool(row.get("Beverages", 0)),
                        'Fish': bool(row.get("Fish", 0)),
                        'Baked_Foods': bool(row.get("Baked_Foods", 0)),
                        'Breakfast_Cereals': bool(row.get("Breakfast_Cereals", 0)),
                        'Vegetables': bool(row.get("Vegetables", 0)),
                        'Spices_and_Herbs': bool(row.get("Spices_and_Herbs", 0)),
                        'Soups_and_Sauces': bool(row.get("Soups_and_Sauces", 0)),
                        'Dairy_and_Egg_Products': bool(row.get("Dairy_and_Egg_Products", 0)),
                        'Fats_and_Oils': bool(row.get("Fats_and_Oils", 0)),
                        'Lactose_Intolerance': bool(row.get("Lactose_Intolerance", 0)),
                        'stones': bool(row.get("stones", 0)),
                        'reflux': bool(row.get("reflux", 0)),
                        'Spices': bool(row.get("Spices", 0)),
                        'Seafood': bool(row.get("Seafood", 0)),
                        'Poultry': bool(row.get("Poultry", 0)),
                        'Herbs': bool(row.get("Herbs", 0)),
                        'Processed_Meats': bool(row.get("Processed_Meats", 0)),
                        'Legumes': bool(row.get("Legumes", 0)),
                        'Dairy': bool(row.get("Dairy", 0)),
                        'Nuts': bool(row.get("Nuts", 0)),
                        'Mixed_Dishes': bool(row.get("Mixed_Dishes", 0)),
                        'Sauces': bool(row.get("Sauces", 0)),
                        'Oils': bool(row.get("Oils", 0)),
                        'Grains': bool(row.get("Grains", 0)),
                        'Seeds': bool(row.get("Seeds", 0)),
                        'Pastries': bool(row.get("Pastries", 0)),
                        'Spreads': bool(row.get("Spreads", 0)),
                        'Eggs': bool(row.get("Eggs", 0)),
                        'Prebiotic': bool(row.get("Prebiotic", 0)),
                        'Probiotic': bool(row.get("Probiotic", 0)),
                        'Low_Inflammatory': bool(row.get("Low_Inflammatory", 0)),
                        'Diverse': bool(row.get("Diverse", 0)),
                        'Polyphenol_Rich': bool(row.get("Polyphenol_Rich", 0)),
                        'Stews': bool(row.get("Stews", 0)),
                        'Mixed_Rice': bool(row.get("Mixed_Rice", 0)),
                        'Soups_and_Aashes': bool(row.get("Soups_and_Aashes", 0)),
                        'Traditional_Foods': bool(row.get("Traditional_Foods", 0)),
                        'International_Foods': bool(row.get("International_Foods", 0)),
                        'Vegetarian_Foods': bool(row.get("Vegetarian_Foods", 0)),
                        'Simple_Dishes': bool(row.get("Simple_Dishes", 0)),
                        'Main_Salads': bool(row.get("Main_Salads", 0)),
                        'Fast_Foods': bool(row.get("Fast_Foods", 0)),
                        'FODMAP_Classification': bool(row.get("FODMAP_Classification", 0)),
                        'Diet_Low_Sugar': bool(row.get("Diet_Low_Sugar", 0)),
                        'Diet_Mediterranean': bool(row.get("Diet_Mediterranean", 0)),
                        'Diet_High_Protein': bool(row.get("Diet_High_Protein", 0)),
                        'Whole_Foods': bool(row.get("Whole_Foods", 0)),
                        'Diet_Low_Fat': bool(row.get("Diet_Low_Fat", 0)),
                        'Diet_Low_Calorie': bool(row.get("Diet_Low_Calorie", 0)),
                        'Diet_Anti_Inflammatory': bool(row.get("Diet_Anti_Inflammatory", 0)),
                        'Diet_Paleo': bool(row.get("Diet_Paleo", 0)),
                        'Diet_Diabetic': bool(row.get("Diet_Diabetic", 0)),
                        'Diet_Low_Carb': bool(row.get("Diet_Low_Carb", 0)),
                        'Diet_Bodybuilding': bool(row.get("Diet_Bodybuilding", 0)),
                        'Diet_Vegan': bool(row.get("Diet_Vegan", 0)),
                        'Diet_Vegetarian': bool(row.get("Diet_Vegetarian", 0)),
                        'Diet_Plant_Based': bool(row.get("Diet_Plant_Based", 0)),
                        'Diet_Gluten_Free': bool(row.get("Diet_Gluten_Free", 0)),
                        'Diet_Keto': bool(row.get("Diet_Keto", 0)),
                        'bread_rice_tag': row.get("bread_rice_tag", ""),
                        'cooked_rice': bool(row.get("cooked_rice", 0)),
                        'main_dish': bool(row.get("main_dish", 0)),
                        'GL_category': int(row["GL_category"]) if pd.notna(row["GL_category"]) else 0,
                        'GL_value': int(row["GL_value"]) if pd.notna(row["GL_value"]) else 0,
                        'GI_category': int(row["GI_category"]) if pd.notna(row["GI_category"]) else 0,
                        'GI_value': int(row["GI_value"]) if pd.notna(row["GI_value"]) else 0,
                        'Disease_Kidney': bool(row.get("Disease_Kidney", 0)),
                        'Disease_Kidney_stones': bool(row.get("Disease_Kidney_stones", 0)),
                        'Disease_Acid_reflux': bool(row.get("Disease_Acid_reflux", 0)),
                        'Disease_Gout': bool(row.get("Disease_Gout", 0)),
                        'Disease_Celiac': bool(row.get("Disease_Celiac", 0)),
                        'Disease_IBS': bool(row.get("Disease_IBS", 0)),
                        'Disease_Diverticulitis': bool(row.get("Disease_Diverticulitis", 0)),
                        'Disease_Hypothyroidism': bool(row.get("Disease_Hypothyroidism", 0)),
                        'Disease_Gastroesophageal_Reflux': bool(row.get("Disease_Gastroesophageal_Reflux", 0)),
                        'Disease_Foodborne_Illness': bool(row.get("Disease_Foodborne_Illness", 0)),
                        'Disease_High_blood_pressure': bool(row.get("Disease_High_blood_pressure", 0)),
                        'Disease_High_cholesterol': bool(row.get("Disease_High_cholesterol", 0)),
                        'Disease_Diabetes': bool(row.get("Disease_Diabetes", 0)),
                        'Disease_Hypercholesterolemia': bool(row.get("Disease_Hypercholesterolemia", 0)),
                        'Disease_G6PD_Deficiency': bool(row.get("Disease_G6PD_Deficiency", 0)),
                        'Disease_Constipation': bool(row.get("Disease_Constipation", 0)),
                        'Disease_Gallbladder': bool(row.get("Disease_Gallbladder", 0)),
                        'Disease_Latex_Fruit_Syndrome': bool(row.get("Disease_Latex_Fruit_Syndrome", 0)),
                        'Disease_Obesity': bool(row.get("Disease_Obesity", 0)),
                        'Disease_CVD': bool(row.get("Disease_CVD", 0)),
                        'Disease_IBD': bool(row.get("Disease_IBD", 0)),
                        'Disease_Lactose_Intolerance': bool(row.get("Disease_Lactose_Intolerance", 0)),
                        'Disease_NAFLD': bool(row.get("Disease_NAFLD", 0)),
                        'Disease_Anemia': bool(row.get("Disease_Anemia", 0)),
                        'Disease_Osteoporosis': bool(row.get("Disease_Osteoporosis", 0)),
                        'Disease_Arthritis': bool(row.get("Disease_Arthritis", 0)),
                        'Disease_Autoimmune': bool(row.get("Disease_Autoimmune", 0)),
                        'Disease_CancerPrevention': bool(row.get("Disease_CancerPrevention", 0)),
                        'Disease_MentalHealth': bool(row.get("Disease_MentalHealth", 0)),
                    }
                )

                # If the card already existed, update the fields
                if not created:
                    card.FA_Name = row.get("FA_Name", card.FA_Name)
                    card.EN_Name = row.get("EN_Name", card.EN_Name)
                    card.Calories = float(row["Calories"]) if pd.notna(row["Calories"]) else card.Calories
                    card.carb_ratio = float(row["carb_ratio"]) if pd.notna(row["carb_ratio"]) else card.carb_ratio
                    card.fat_ratio = float(row["fat_ratio"]) if pd.notna(row["fat_ratio"]) else card.fat_ratio
                    card.protein_ratio = float(row["protein_ratio"]) if pd.notna(row["protein_ratio"]) else card.protein_ratio
                    card.is_keto = bool(row.get('is_keto', card.is_keto))
                    card.is_med = bool(row.get('is_med', card.is_med))
                    card.is_conditional_med = bool(row.get('is_conditional_med', card.is_conditional_med))
                    card.is_lowcarb = bool(row.get('is_lowcarb', card.is_lowcarb))
                    card.is_mediumcarb = bool(row.get('is_mediumcarb', card.is_mediumcarb))
                    card.is_highcarb = bool(row.get('is_highcarb', card.is_highcarb))
                    card.is_highprotein = bool(row.get('is_highprotein', card.is_highprotein))
                    card.is_lowprotein = bool(row.get('is_lowprotein', card.is_lowprotein))
                    card.is_mediumprotein = bool(row.get('is_mediumprotein', card.is_mediumprotein))
                    card.is_mind = bool(row.get('is_mind', card.is_mind))
                    card.is_lowfat = bool(row.get('is_lowfat', card.is_lowfat))
                    card.is_mediumfat = bool(row.get('is_mediumfat', card.is_mediumfat))
                    card.is_highfat = bool(row.get('is_highfat', card.is_highfat))
                    card.is_low_fodmap = bool(row.get('is_low_fodmap', card.is_low_fodmap))
                    card.is_breakfast = bool(row.get('is_breakfast', card.is_breakfast))
                    card.is_lunch = bool(row.get('is_lunch', card.is_lunch))
                    card.is_dinner = bool(row.get('is_dinner', card.is_dinner))
                    card.is_snack = bool(row.get('is_snack', card.is_snack))
                    card.foods = foods
                    card.Dessert = bool(row.get("Dessert", card.Dessert))
                    card.Added_Meat = bool(row.get("Added_Meat", card.Added_Meat))
                    card.Ing_Main = bool(row.get("Ing_Main", card.Ing_Main))
                    card.Beverage = bool(row.get("Beverage", card.Beverage))
                    card.Sandwich = bool(row.get("Sandwich", card.Sandwich))
                    card.Condiment = bool(row.get("Condiment", card.Condiment))
                    card.Lunch = bool(row.get("Lunch", card.Lunch))
                    card.Snack = bool(row.get("Snack", card.Snack))
                    card.Bread = bool(row.get("Bread", card.Bread))
                    card.Entree = bool(row.get("Entree", card.Entree))
                    card.Soup = bool(row.get("Soup", card.Soup))
                    card.Side_Dish = bool(row.get("Side_Dish", card.Side_Dish))
                    card.Appetizer = bool(row.get("Appetizer", card.Appetizer))
                    card.Dinner = bool(row.get("Dinner", card.Dinner))
                    card.Pasta = bool(row.get("Pasta", card.Pasta))
                    card.Breakfast = bool(row.get("Breakfast", card.Breakfast))
                    card.Salad = bool(row.get("Salad", card.Salad))
                    card.Ingredient = bool(row.get("Ingredient", card.Ingredient))
                    card.Bacteria_Acidaminococcus = bool(row.get("Bacteria_Acidaminococcus", card.Bacteria_Acidaminococcus))
                    card.Bacteria_Bacteroidetes = bool(row.get("Bacteria_Bacteroidetes", card.Bacteria_Bacteroidetes))
                    card.Bacteria_Alistipes = bool(row.get("Bacteria_Alistipes", card.Bacteria_Alistipes))
                    card.Bacteria_Bifidobacterium = bool(row.get("Bacteria_Bifidobacterium", card.Bacteria_Bifidobacterium))
                    card.Bacteria_Akkermansia = bool(row.get("Bacteria_Akkermansia", card.Bacteria_Akkermansia))
                    card.Bacteria_Blautia = bool(row.get("Bacteria_Blautia", card.Bacteria_Blautia))
                    card.Bacteria_Fecalibacterium = bool(row.get("Bacteria_Fecalibacterium", card.Bacteria_Fecalibacterium))
                    card.Bacteria_Lawsonibacter_asaccharolyticus = bool(row.get("Bacteria_Lawsonibacter_asaccharolyticus", card.Bacteria_Lawsonibacter_asaccharolyticus))
                    card.Bacteria_Lactobacillus = bool(row.get("Bacteria_Lactobacillus", card.Bacteria_Lactobacillus))
                    card.Vegan = bool(row.get("Vegan", card.Vegan))
                    card.Umami = bool(row.get("Umami", card.Umami))
                    card.Slow_cooked = bool(row.get("Slow_cooked", card.Slow_cooked))
                    card.Spicy = bool(row.get("Spicy", card.Spicy))
                    card.Baked = bool(row.get("Baked", card.Baked))
                    card.Pickled = bool(row.get("Pickled", card.Pickled))
                    card.Low_calorie = bool(row.get("Low_calorie", card.Low_calorie))
                    card.Grilled = bool(row.get("Grilled", card.Grilled))
                    card.Roasted = bool(row.get("Roasted", card.Roasted))
                    card.High_protein = bool(row.get("High_protein", card.High_protein))
                    card.Fried = bool(row.get("Fried", card.Fried))
                    card.Sweet = bool(row.get("Sweet", card.Sweet))
                    card.Salty = bool(row.get("Salty", card.Salty))
                    card.Lactose_free = bool(row.get("Lactose_free", card.Lactose_free))
                    card.Low_carb = bool(row.get("Low_carb", card.Low_carb))
                    card.Cold = bool(row.get("Cold", card.Cold))
                    card.Vegetarian = bool(row.get("Vegetarian", card.Vegetarian))
                    card.Sour = bool(row.get("Sour", card.Sour))
                    card.Sweet_Sour = bool(row.get("Sweet_Sour", card.Sweet_Sour))
                    card.Raw = bool(row.get("Raw", card.Raw))
                    card.Gluten_free = bool(row.get("Gluten_free", card.Gluten_free))
                    card.Boiled = bool(row.get("Boiled", card.Boiled))
                    card.Steamed = bool(row.get("Steamed", card.Steamed))
                    card.Low_fat = bool(row.get("Low_fat", card.Low_fat))
                    card.Prepared_Meals = bool(row.get("Prepared_Meals", card.Prepared_Meals))
                    card.Meats = bool(row.get("Meats", card.Meats))
                    card.Sweets = bool(row.get("Sweets", card.Sweets))
                    card.Beans_and_Lentils = bool(row.get("Beans_and_Lentils", card.Beans_and_Lentils))
                    card.Snacks = bool(row.get("Snacks", card.Snacks))
                    card.Grains_and_Pasta = bool(row.get("Grains_and_Pasta", card.Grains_and_Pasta))
                    card.Nuts_and_Seeds = bool(row.get("Nuts_and_Seeds", card.Nuts_and_Seeds))
                    card.Fruits = bool(row.get("Fruits", card.Fruits))
                    card.Beverages = bool(row.get("Beverages", card.Beverages))
                    card.Fish = bool(row.get("Fish", card.Fish))
                    card.Baked_Foods = bool(row.get("Baked_Foods", card.Baked_Foods))
                    card.Breakfast_Cereals = bool(row.get("Breakfast_Cereals", card.Breakfast_Cereals))
                    card.Vegetables = bool(row.get("Vegetables", card.Vegetables))
                    card.Spices_and_Herbs = bool(row.get("Spices_and_Herbs", card.Spices_and_Herbs))
                    card.Soups_and_Sauces = bool(row.get("Soups_and_Sauces", card.Soups_and_Sauces))
                    card.Dairy_and_Egg_Products = bool(row.get("Dairy_and_Egg_Products", card.Dairy_and_Egg_Products))
                    card.Fats_and_Oils = bool(row.get("Fats_and_Oils", card.Fats_and_Oils))
                    card.Lactose_Intolerance = bool(row.get("Lactose_Intolerance", card.Lactose_Intolerance))
                    card.stones = bool(row.get("stones", card.stones))
                    card.reflux = bool(row.get("reflux", card.reflux))
                    card.Spices = bool(row.get("Spices", card.Spices))
                    card.Seafood = bool(row.get("Seafood", card.Seafood))
                    card.Poultry = bool(row.get("Poultry", card.Poultry))
                    card.Herbs = bool(row.get("Herbs", card.Herbs))
                    card.Processed_Meats = bool(row.get("Processed_Meats", card.Processed_Meats))
                    card.Legumes = bool(row.get("Legumes", card.Legumes))
                    card.Dairy = bool(row.get("Dairy", card.Dairy))
                    card.Nuts = bool(row.get("Nuts", card.Nuts))
                    card.Mixed_Dishes = bool(row.get("Mixed_Dishes", card.Mixed_Dishes))
                    card.Sauces = bool(row.get("Sauces", card.Sauces))
                    card.Oils = bool(row.get("Oils", card.Oils))
                    card.Grains = bool(row.get("Grains", card.Grains))
                    card.Seeds = bool(row.get("Seeds", card.Seeds))
                    card.Pastries = bool(row.get("Pastries", card.Pastries))
                    card.Spreads = bool(row.get("Spreads", card.Spreads))
                    card.Eggs = bool(row.get("Eggs", card.Eggs))
                    card.Prebiotic = bool(row.get("Prebiotic", card.Prebiotic))
                    card.Probiotic = bool(row.get("Probiotic", card.Probiotic))
                    card.Low_Inflammatory = bool(row.get("Low_Inflammatory", card.Low_Inflammatory))
                    card.Diverse = bool(row.get("Diverse", card.Diverse))
                    card.Polyphenol_Rich = bool(row.get("Polyphenol_Rich", card.Polyphenol_Rich))
                    card.Stews = bool(row.get("Stews", card.Stews))
                    card.Mixed_Rice = bool(row.get("Mixed_Rice", card.Mixed_Rice))
                    card.Soups_and_Aashes = bool(row.get("Soups_and_Aashes", card.Soups_and_Aashes))
                    card.Traditional_Foods = bool(row.get("Traditional_Foods", card.Traditional_Foods))
                    card.International_Foods = bool(row.get("International_Foods", card.International_Foods))
                    card.Vegetarian_Foods = bool(row.get("Vegetarian_Foods", card.Vegetarian_Foods))
                    card.Simple_Dishes = bool(row.get("Simple_Dishes", card.Simple_Dishes))
                    card.Main_Salads = bool(row.get("Main_Salads", card.Main_Salads))
                    card.Fast_Foods = bool(row.get("Fast_Foods", card.Fast_Foods))
                    card.FODMAP_Classification = bool(row.get("FODMAP_Classification", card.FODMAP_Classification))
                    card.Diet_Low_Sugar = bool(row.get("Diet_Low_Sugar", card.Diet_Low_Sugar))
                    card.Diet_Mediterranean = bool(row.get("Diet_Mediterranean", card.Diet_Mediterranean))
                    card.Diet_High_Protein = bool(row.get("Diet_High_Protein", card.Diet_High_Protein))
                    card.Whole_Foods = bool(row.get("Whole_Foods", card.Whole_Foods))
                    card.Diet_Low_Fat = bool(row.get("Diet_Low_Fat", card.Diet_Low_Fat))
                    card.Diet_Low_Calorie = bool(row.get("Diet_Low_Calorie", card.Diet_Low_Calorie))
                    card.Diet_Anti_Inflammatory = bool(row.get("Diet_Anti_Inflammatory", card.Diet_Anti_Inflammatory))
                    card.Diet_Paleo = bool(row.get("Diet_Paleo", card.Diet_Paleo))
                    card.Diet_Diabetic = bool(row.get("Diet_Diabetic", card.Diet_Diabetic))
                    card.Diet_Low_Carb = bool(row.get("Diet_Low_Carb", card.Diet_Low_Carb))
                    card.Diet_Bodybuilding = bool(row.get("Diet_Bodybuilding", card.Diet_Bodybuilding))
                    card.Diet_Vegan = bool(row.get("Diet_Vegan", card.Diet_Vegan))
                    card.Diet_Vegetarian = bool(row.get("Diet_Vegetarian", card.Diet_Vegetarian))
                    card.Diet_Plant_Based = bool(row.get("Diet_Plant_Based", card.Diet_Plant_Based))
                    card.Diet_Gluten_Free = bool(row.get("Diet_Gluten_Free", card.Diet_Gluten_Free))
                    card.Diet_Keto = bool(row.get("Diet_Keto", card.Diet_Keto))
                    card.bread_rice_tag = row.get("bread_rice_tag", card.bread_rice_tag)
                    card.cooked_rice = bool(row.get("cooked_rice", card.cooked_rice))
                    card.main_dish = bool(row.get("main_dish", card.main_dish))
                    card.GL_category = int(row["GL_category"]) if pd.notna(row["GL_category"]) else card.GL_category
                    card.GL_value = int(row["GL_value"]) if pd.notna(row["GL_value"]) else card.GL_value
                    card.GI_category = int(row["GI_category"]) if pd.notna(row["GI_category"]) else card.GI_category
                    card.GI_value = int(row["GI_value"]) if pd.notna(row["GI_value"]) else card.GI_value
                    card.Disease_Kidney = bool(row.get("Disease_Kidney", card.Disease_Kidney))
                    card.Disease_Kidney_stones = bool(row.get("Disease_Kidney_stones", card.Disease_Kidney_stones))
                    card.Disease_Acid_reflux = bool(row.get("Disease_Acid_reflux", card.Disease_Acid_reflux))
                    card.Disease_Gout = bool(row.get("Disease_Gout", card.Disease_Gout))
                    card.Disease_Celiac = bool(row.get("Disease_Celiac", card.Disease_Celiac))
                    card.Disease_IBS = bool(row.get("Disease_IBS", card.Disease_IBS))
                    card.Disease_Diverticulitis = bool(row.get("Disease_Diverticulitis", card.Disease_Diverticulitis))
                    card.Disease_Hypothyroidism = bool(row.get("Disease_Hypothyroidism", card.Disease_Hypothyroidism))
                    card.Disease_Gastroesophageal_Reflux = bool(row.get("Disease_Gastroesophageal_Reflux", card.Disease_Gastroesophageal_Reflux))
                    card.Disease_Foodborne_Illness = bool(row.get("Disease_Foodborne_Illness", card.Disease_Foodborne_Illness))
                    card.Disease_High_blood_pressure = bool(row.get("Disease_High_blood_pressure", card.Disease_High_blood_pressure))
                    card.Disease_High_cholesterol = bool(row.get("Disease_High_cholesterol", card.Disease_High_cholesterol))
                    card.Disease_Diabetes = bool(row.get("Disease_Diabetes", card.Disease_Diabetes))
                    card.Disease_Hypercholesterolemia = bool(row.get("Disease_Hypercholesterolemia", card.Disease_Hypercholesterolemia))
                    card.Disease_G6PD_Deficiency = bool(row.get("Disease_G6PD_Deficiency", card.Disease_G6PD_Deficiency))
                    card.Disease_Constipation = bool(row.get("Disease_Constipation", card.Disease_Constipation))
                    card.Disease_Gallbladder = bool(row.get("Disease_Gallbladder", card.Disease_Gallbladder))
                    card.Disease_Latex_Fruit_Syndrome = bool(row.get("Disease_Latex_Fruit_Syndrome", card.Disease_Latex_Fruit_Syndrome))
                    card.Disease_Obesity = bool(row.get("Disease_Obesity", card.Disease_Obesity))
                    card.Disease_CVD = bool(row.get("Disease_CVD", card.Disease_CVD))
                    card.Disease_IBD = bool(row.get("Disease_IBD", card.Disease_IBD))
                    card.Disease_Lactose_Intolerance = bool(row.get("Disease_Lactose_Intolerance", card.Disease_Lactose_Intolerance))
                    card.Disease_NAFLD = bool(row.get("Disease_NAFLD", card.Disease_NAFLD))
                    card.Disease_Anemia = bool(row.get("Disease_Anemia", card.Disease_Anemia))
                    card.Disease_Osteoporosis = bool(row.get("Disease_Osteoporosis", card.Disease_Osteoporosis))
                    card.Disease_Arthritis = bool(row.get("Disease_Arthritis", card.Disease_Arthritis))
                    card.Disease_Autoimmune = bool(row.get("Disease_Autoimmune", card.Disease_Autoimmune))
                    card.Disease_CancerPrevention = bool(row.get("Disease_CancerPrevention", card.Disease_CancerPrevention))
                    card.Disease_MentalHealth = bool(row.get("Disease_MentalHealth", card.Disease_MentalHealth))
                    card.save()
                    updated_count += 1
                else:
                    created_count += 1

            except Exception as e:
                skipped_count += 1
                skipped_rows.append(f"Row {index}: Error processing - {str(e)}")
                continue

    response_data = {
        'status': 'success',
        'created_count': created_count,
        'updated_count': updated_count,
        'skipped_count': skipped_count,
        'skipped_rows': skipped_rows
    }
    return JsonResponse(response_data)


def excel_to_bool(value):
    if pd.isna(value):
        return False
    str_val = str(value).strip().lower()
    bool_map = {
        'true': True,
        'TRUE': True,
        '1': True,
        'yes': True,
        'false': False,
        'FALSE': False,
        '0': False,
        'no': False
    }
    return bool_map.get(str_val, False)


@csrf_exempt
def UpdateFoodCardsFromExcel(request):
    """
    Create or Update FoodCard objects based on an uploaded Excel file.
    The Excel MUST have a column named 'cart_code_final' which indicates
    the FoodCard's primary key (id). If that id exists, we update that row;
    otherwise we create a new FoodCard with that id.

    Boolean fields expect '0' or '1' in the Excel.
    FODMAP_Classification expects 'low', 'variable', or 'high'.
    GL_category/GI_category expects 'low', 'medium', or 'high'.
    """
    if request.method == 'POST':
        try:
            # ------------------------------------------------------------------
            # 1) Check for file in request
            # ------------------------------------------------------------------
            if not request.FILES:
                return JsonResponse({"error": "Please upload an Excel (.xlsx) file"}, status=400)

            uploaded_file = request.FILES.get("file")
            if not uploaded_file or not uploaded_file.name.endswith('.xlsx'):
                return JsonResponse({"error": "File must be in .xlsx format"}, status=400)

            # Save the file locally
            file_path = settings.BASE_DIR + f'/static/assets/foods/tags_{datetime.now().date()}.xlsx'
            with open(file_path, 'wb+') as destination:
                for chunk in uploaded_file.chunks():
                    destination.write(chunk)

            # FoodCard.objects.all().delete()

            # Read Excel file
            df = pd.read_excel(file_path)

            # ------------------------------------------------------------------
            # 4) Setup counters
            # ------------------------------------------------------------------
            updated_count = 0
            created_count = 0
            skipped_count = 0
            skipped_rows = []

            # ------------------------------------------------------------------
            # 5) Define your mappings
            # ------------------------------------------------------------------
            map_fodmap = {
                'low': 1,
                'variable': 2,
                'high': 3
            }
            map_gl_category = {
                'low': 1,
                'medium': 2,
                'high': 3
            }

            def parse_bool(value, default=False):
                """Convert Excel value to boolean, handling multiple formats"""
                if isinstance(value, bool):
                    return value
                if pd.isna(value):
                    return default
                try:
                    # Convert to string and lowercase for consistency
                    val_str = str(value).strip().lower()
                    if val_str in ('1', 'true', 'yes', 't', 'y'):
                        return True
                    if val_str in ('0', 'false', 'no', 'f', 'n'):
                        return False
                    # Try numeric conversion
                    return bool(int(value))
                except (ValueError, TypeError):
                    return default

            # ------------------------------------------------------------------
            # 6) Process each row
            #    We wrap this in a transaction so all changes are atomic.
            # ------------------------------------------------------------------
            with transaction.atomic():
                for index, row in df.iterrows():
                    cart_code = row.get('cart_code_final', None)
                    if pd.isna(cart_code):
                        skipped_count += 1
                        skipped_rows.append(f"Row {index} has no cart_code_final")
                        continue

                    try:
                        cart_code = int(cart_code)
                    except ValueError:
                        skipped_count += 1
                        skipped_rows.append(f"Row {index}: Invalid cart_code_final={cart_code}")
                        continue

                    try:
                        fc = FoodCard.objects.get(pk=cart_code)
                        is_new = False
                    except FoodCard.DoesNotExist:
                        fc = FoodCard(id=cart_code)
                        is_new = True

                    # Modified foods handling
                    foods_str = row.get('foods', '[]')
                    try:
                        # First try parsing as JSON with double quotes
                        fc.foods = json.loads(foods_str)
                    except json.JSONDecodeError:
                        try:
                            # If that fails, try ast.literal_eval for Python-style literals
                            fc.foods = ast.literal_eval(foods_str)
                        except (ValueError, SyntaxError) as e:
                            # If both fail, try converting single quotes to double quotes
                            try:
                                foods_str_converted = foods_str.replace("'", '"')
                                fc.foods = json.loads(foods_str_converted)
                            except json.JSONDecodeError as e:
                                skipped_count += 1
                                skipped_rows.append(f"Row {index}: Invalid foods format - {str(e)}")
                                fc.foods = []  # Default to empty list

                    fc.is_keto = excel_to_bool(row.get('Diet_Keto', 0))
                    fc.is_med = excel_to_bool(row.get('Diet_Mediterranean', 0))
                    fc.is_conditional_med = excel_to_bool(row.get('is_conditional_med', 0))
                    fc.is_lowcarb = excel_to_bool(row.get('Diet_Low_Carb', 0))
                    fc.is_mediumcarb = excel_to_bool(row.get('is_mediumcarb', 0))
                    fc.is_highcarb = excel_to_bool(row.get('is_highcarb', 0))
                    fc.is_highprotein = excel_to_bool(row.get('Diet_High_Protein', 0))
                    fc.is_lowprotein = excel_to_bool(row.get('is_lowprotein', 0))
                    fc.is_mediumprotein = excel_to_bool(row.get('is_mediumprotein', 0))
                    fc.is_mind = excel_to_bool(row.get('is_mind', 0))
                    fc.is_low_fodmap = excel_to_bool(row.get('is_low_fodmap', 0))
                    fc.is_lowfat = excel_to_bool(row.get('Diet_Low_Fat', 0))
                    fc.is_mediumfat = excel_to_bool(row.get('is_mediumfat', 0))
                    fc.is_highfat = excel_to_bool(row.get('is_highfat', 0))
                    fc.is_breakfast = excel_to_bool(row.get('is_breakfast', 0))
                    fc.is_lunch = excel_to_bool(row.get('is_lunch', 0))
                    fc.is_dinner = excel_to_bool(row.get('is_dinner', 0))
                    fc.is_snack = excel_to_bool(row.get('is_snack', 0))

                    fc.Dessert = bool(row.get('Dessert', 0))
                    fc.Added_Meat = bool(row.get('Added_Meat', 0))
                    fc.Ing_Main = bool(row.get('Ing_Main', 0))
                    fc.Beverage = bool(row.get('Beverage', 0))
                    fc.Sandwich = bool(row.get('Sandwich', 0))
                    fc.Condiment = bool(row.get('Condiment', 0))
                    fc.Snack = bool(row.get('Snacks', 0))
                    fc.Bread = bool(row.get('Bread', 0))
                    fc.Entree = bool(row.get('Entree', 0))
                    fc.Soup = bool(row.get('Soup', 0))
                    fc.Side_Dish = bool(row.get('Side_Dish', 0))
                    fc.Appetizer = bool(row.get('Appetizer', 0))
                    fc.Dinner = bool(row.get('Dinner', 0))
                    fc.Pasta = bool(row.get('Pasta', 0))
                    fc.Breakfast = bool(row.get('Breakfast', 0))
                    fc.Salad = bool(row.get('Salad', 0))
                    fc.Ingredient = bool(row.get('Ingredient', 0))
                    fc.Vegan = bool(row.get('Vegan', 0))
                    fc.Umami = bool(row.get('Umami', 0))
                    fc.Slow_cooked = bool(row.get('Slow_cooked', 0))
                    fc.Spicy = bool(row.get('Spicy', 0))
                    fc.Baked = bool(row.get('Baked', 0))
                    fc.Pickled = bool(row.get('Pickled', 0))
                    fc.Low_calorie = bool(row.get('Low_calorie', 0))
                    fc.Grilled = bool(row.get('Grilled', 0))
                    fc.Roasted = bool(row.get('Roasted', 0))
                    fc.High_protein = bool(row.get('High_protein', 0))
                    fc.Fried = bool(row.get('Fried', 0))
                    fc.Salty = bool(row.get('Salty', 0))
                    fc.Lactose_free = bool(row.get('Lactose_free', 0))
                    fc.Low_carb = bool(row.get('Diet_Low_Carb', 0))
                    fc.Cold = bool(row.get('Cold', 0))
                    fc.Vegetarian = bool(row.get('Vegetarian', 0))
                    fc.Sour = bool(row.get('Sour', 0))
                    fc.Sweet_Sour = bool(row.get('Sweet_Sour', 0))
                    fc.Raw = bool(row.get('Raw', 0))
                    fc.Gluten_free = bool(row.get('Gluten_free', 0))
                    # food.Sweet_and_Sour = bool(row.get('Sweet_and_Sour', 0))
                    fc.Boiled = bool(row.get('Boiled', 0))
                    fc.Steamed = bool(row.get('Steamed', 0))
                    fc.Prepared_Meals = bool(row.get('Prepared_Meals', 0))
                    fc.Meats = bool(row.get('Meats', 0))
                    fc.Sweets = bool(row.get('Sweets', 0))
                    fc.Beans_and_Lentils = bool(row.get('Beans_and_Lentils', 0))
                    fc.Snacks = bool(row.get('Snacks', 0))
                    fc.Grains_and_Pasta = bool(row.get('Grains_and_Pasta', 0))
                    fc.Nuts_and_Seeds = bool(row.get('Nuts_and_Seeds', 0))
                    fc.Fruits = bool(row.get('Fruits', 0))
                    fc.Beverages = bool(row.get('Beverages', 0))
                    fc.Fish = bool(row.get('Fish', 0))
                    fc.Baked_Foods = bool(row.get('Baked_Foods', 0))
                    fc.Breakfast_Cereals = bool(row.get('Breakfast_Cereals', 0))
                    fc.Vegetables = bool(row.get('Vegetables', 0))
                    fc.Spices_and_Herbs = bool(row.get('Spices_and_Herbs', 0))
                    fc.Soups_and_Sauces = bool(row.get('Soups_and_Sauces', 0))
                    fc.Dairy_and_Egg_Products = bool(row.get('Dairy_and_Egg_Products', 0))
                    fc.Fats_and_Oils = bool(row.get('Fats_and_Oils', 0))
                    fc.Lactose_Intolerance = bool(row.get('Lactose_Intolerance', 0))
                    fc.stones = bool(row.get('stones', 0))
                    fc.reflux = bool(row.get('reflux', 0))
                    fc.cooked_rice = bool(row.get('cooked_rice', 0))
                    fc.main_dish = bool(row.get('main_dish', 0))
                    fc.Spices = bool(row.get('Spices', 0))
                    fc.Seafood = bool(row.get('Seafood', 0))
                    fc.Poultry = bool(row.get('Poultry', 0))
                    fc.Herbs = bool(row.get('Herbs', 0))
                    fc.Processed_Meats = bool(row.get('Processed_Meats', 0))
                    fc.Legumes = bool(row.get('Legumes', 0))
                    fc.Dairy = bool(row.get('Dairy', 0))
                    fc.Nuts = bool(row.get('Nuts', 0))
                    fc.Mixed_Dishes = bool(row.get('Mixed_Dishes', 0))
                    fc.Sauces = bool(row.get('Sauces', 0))
                    fc.Oils = bool(row.get('Oils', 0))
                    fc.Grains = bool(row.get('Grains', 0))
                    fc.Seeds = bool(row.get('Seeds', 0))
                    fc.Pastries = bool(row.get('Pastries', 0))
                    fc.Spreads = bool(row.get('Spreads', 0))
                    fc.Eggs = bool(row.get('Eggs', 0))
                    fc.Prebiotic = bool(row.get('Prebiotic', 0))
                    fc.Probiotic = bool(row.get('Probiotic', 0))
                    fc.Low_Inflammatory = bool(row.get('Low_Inflammatory', 0))
                    fc.Diverse = bool(row.get('Diverse', 0))
                    fc.Polyphenol_Rich = bool(row.get('Polyphenol_Rich', 0))
                    fc.Stews = bool(row.get('Stews', 0))
                    fc.Mixed_Rice = bool(row.get('Mixed_Rice', 0))
                    fc.Soups_and_Aashes = bool(row.get('Soups_and_Aashes', 0))
                    fc.Traditional_Foods = bool(row.get('Traditional_Foods', 0))
                    fc.International_Foods = bool(row.get('International_Foods', 0))
                    fc.Vegetarian_Foods = bool(row.get('Vegetarian_Foods', 0))
                    fc.Simple_Dishes = bool(row.get('Simple_Dishes', 0))
                    fc.Main_Salads = bool(row.get('Main_Salads', 0))
                    fc.Fast_Foods = bool(row.get('Fast_Foods', 0))

                    # Update Allergens
                    fc.Allergens_Shrimp = parse_bool(row.get('Allergens_Shrimp', 0))
                    fc.Allergens_Mushroom = parse_bool(row.get('Allergens_Mushroom', 0))
                    fc.Allergens_Eggplant = parse_bool(row.get('Allergens_Eggplant', 0))
                    fc.Allergens_Dried_fruits = parse_bool(row.get('Allergens_Dried_fruits', 0))
                    fc.Allergens_Gluten = parse_bool(row.get('Allergens_Gluten', 0))
                    fc.Allergens_Fish = parse_bool(row.get('Allergens_Fish', 0))
                    fc.Allergens_Sesame = parse_bool(row.get('Allergens_Sesame', 0))
                    fc.Allergens_Shellfish = parse_bool(row.get('Allergens_Shellfish', 0))
                    fc.Allergens_Nuts = parse_bool(row.get('Allergens_nuts', 0))
                    fc.Allergens_Soy = parse_bool(row.get('Allergens_Soy', 0))
                    fc.Allergens_Eggs = parse_bool(row.get('Allergens_Eggs', 0))
                    fc.Allergens_Peanuts = parse_bool(row.get('Allergens_Peanut', 0))
                    fc.Allergens_Dairy = parse_bool(row.get('Allergens_Dairy', 0))
                    fc.Allergens_Legumes = parse_bool(row.get('Allergens_Legumes', 0))
                    fc.Allergens_Depends_on_filling_ingredients = parse_bool(
                        row.get('Allergens_Depends_on_filling_ingredients', 0))
                    fc.Allergens_Milk = parse_bool(row.get('Allergens_Milk', 0))
                    fc.Allergens_Celery = parse_bool(row.get('Allergens_Celery', 0))
                    fc.Allergens_Mustard = parse_bool(row.get('Allergens_Mustard', 0))
                    fc.Allergens_Sulphites = parse_bool(row.get('Allergens_Sulphites', 0))
                    fc.Allergens_Lupin = parse_bool(row.get('Allergens_Lupin', 0))
                    fc.Allergens_Molluscs = parse_bool(row.get('Allergens_Molluscs', 0))

                    # Update Diets
                    fc.Diet_Low_Sugar = bool(row.get('Diet_Low_Sugar', 0))
                    fc.Whole_Foods = bool(row.get('Whole_Foods', 0))
                    fc.Diet_Low_Calorie = bool(row.get('Diet_Low_Calorie', 0))
                    fc.Diet_Anti_Inflammatory = bool(row.get('Diet_Anti_Inflammatory', 0))
                    fc.Diet_Paleo = bool(row.get('Diet_Paleo', 0))
                    fc.Diet_Diabetic = bool(row.get('Diet_Diabetic', 0))
                    fc.Diet_Bodybuilding = bool(row.get('Diet_Bodybuilding', 0))
                    fc.Diet_Vegan = bool(row.get('Diet_Vegan', 0))
                    fc.Diet_Vegetarian = bool(row.get('Diet_Vegetarian', 0))
                    fc.Diet_Plant_Based = bool(row.get('Diet_Plant_Based', 0))
                    fc.Diet_Gluten_Free = bool(row.get('Diet_Gluten_Free', 0))

                    # Update Diseases
                    fc.Disease_Kidney = parse_bool(row.get('Disease_Kidney', 0))
                    fc.Disease_Kidney_stones = parse_bool(row.get('Disease_Kidney_stones', 0))
                    fc.Disease_Acid_reflux = parse_bool(row.get('Disease_Acid_reflux', 0))
                    fc.Disease_Gout = parse_bool(row.get('Disease_Gout', 0))
                    fc.Disease_Celiac = parse_bool(row.get('Disease_Celiac', 0))
                    fc.Disease_IBS = parse_bool(row.get('Disease_IBS', 0))
                    fc.Disease_Diverticulitis = parse_bool(row.get('Disease_Diverticulitis', 0))
                    fc.Disease_Hypothyroidism = parse_bool(row.get('Disease_Hypothyroidism', 0))
                    fc.Disease_Gastroesophageal_Reflux = parse_bool(row.get('Disease_Gastroesophageal_Reflux', 0))
                    fc.Disease_Foodborne_Illness = parse_bool(row.get('Disease_Foodborne_Illness', 0))
                    fc.Disease_High_blood_pressure = parse_bool(row.get('Disease_High_blood_pressure', 0))
                    fc.Disease_High_cholesterol = parse_bool(row.get('Disease_High_cholesterol', 0))
                    fc.Disease_Diabetes = parse_bool(row.get('Disease_Diabetes', 0))
                    fc.Disease_Hypercholesterolemia = parse_bool(row.get('Disease_Hypercholesterolemia', 0))
                    fc.Disease_G6PD_Deficiency = parse_bool(row.get('Disease_G6PD_Deficiency', 0))
                    fc.Disease_Constipation = parse_bool(row.get('Disease_Constipation', 0))
                    fc.Disease_Gallbladder = parse_bool(row.get('Disease_Gallbladder', 0))
                    fc.Disease_Latex_Fruit_Syndrome = parse_bool(row.get('Disease_Latex_Fruit_Syndrome', 0))
                    fc.Disease_Obesity = parse_bool(row.get('Disease_Obesity', 0))
                    fc.Disease_CVD = parse_bool(row.get('Disease_CVD', 0))
                    fc.Disease_IBD = parse_bool(row.get('Disease_IBD', 0))
                    fc.Disease_Lactose_Intolerance = parse_bool(row.get('Disease_Lactose_Intolerance', 0))
                    fc.Disease_NAFLD = parse_bool(row.get('Disease_NAFLD', 0))
                    fc.Disease_Anemia = parse_bool(row.get('Disease_Anemia', 0))
                    fc.Disease_Osteoporosis = parse_bool(row.get('Disease_Osteoporosis', 0))
                    fc.Disease_Arthritis = parse_bool(row.get('Disease_Arthritis', 0))
                    fc.Disease_Autoimmune = parse_bool(row.get('Disease_Autoimmune', 0))
                    fc.Disease_CancerPrevention = parse_bool(row.get('Disease_CancerPrevention', 0))
                    fc.Disease_MentalHealth = parse_bool(row.get('Disease_MentalHealth', 0))

                    # Update Bacteria fields
                    fc.Bacteria_Acidaminococcus = bool(row.get('Bacteria_Acidaminococcus', 0))
                    fc.Bacteria_Bacteroidetes = bool(row.get('Bacteria_Bacteroidetes', 0))
                    fc.Bacteria_Alistipes = bool(row.get('Bacteria_Alistipes', 0))
                    fc.Bacteria_Bifidobacterium = bool(row.get('Bacteria_Bifidobacterium', 0))
                    fc.Bacteria_Akkermansia = bool(row.get('Bacteria_Akkermansia', 0))
                    fc.Bacteria_Blautia = bool(row.get('Bacteria_Blautia', 0))
                    fc.Bacteria_Fecalibacterium = bool(row.get('Bacteria_Fecalibacterium', 0))
                    fc.Bacteria_Lawsonibacter_asaccharolyticus = bool(
                        row.get('Bacteria_Lawsonibacter_asaccharolyticus', 0))
                    fc.Bacteria_Lactobacillus = bool(row.get('Bacteria_Lactobacillus', 0))

                    # (You would continue setting all the booleans from your model
                    #  following the same pattern as in your old "UpdateFoodTagsFromExcel")

                    # ------------------------------------------------------------------
                    # d) Example: FODMAP_Classification from 'low'/'variable'/'high'
                    # ------------------------------------------------------------------
                    if 'FODMAP_Classification' in row and not pd.isna(row['FODMAP_Classification']):
                        fodmap_key = str(row['FODMAP_Classification']).strip().lower()
                        fc.FODMAP_Classification = map_fodmap.get(fodmap_key, 0)  # default 0 if not found

                    # ------------------------------------------------------------------
                    # e) Additional int fields (GL_value, GI_value, etc.)
                    # ------------------------------------------------------------------
                    if 'GL_category' in row and not pd.isna(row['GL_category']):
                        gl_cat_key = str(row['GL_category']).strip().lower()
                        fc.GL_category = map_gl_category.get(gl_cat_key, 0)

                    if 'GL_value' in row and not pd.isna(row['GL_value']):
                        try:
                            fc.GL_value = int(row['GL_value'])
                        except ValueError:
                            fc.GL_value = 0

                    if 'GI_category' in row and not pd.isna(row['GI_category']):
                        gi_cat_key = str(row['GI_category']).strip().lower()
                        fc.GI_category = map_gl_category.get(gi_cat_key, 0)

                    if 'GI_value' in row and not pd.isna(row['GI_value']):
                        try:
                            fc.GI_value = int(row['GI_value'])
                        except ValueError:
                            fc.GI_value = 0

                    # ------------------------------------------------------------------
                    # f) Any text fields (like FA_Name, EN_Name, bread_rice_tag, etc.)
                    # ------------------------------------------------------------------
                    if 'FA_Name' in row and not pd.isna(row['FA_Name']):
                        fc.FA_Name = str(row['FA_Name'])
                    if 'EN_Name' in row and not pd.isna(row['EN_Name']):
                        fc.EN_Name = str(row['EN_Name'])
                    if 'bread_rice_tag' in row and not pd.isna(row['bread_rice_tag']):
                        fc.bread_rice_tag = str(row['bread_rice_tag'])

                    # ------------------------------------------------------------------
                    # g) Numeric fields (like Calories, carb_ratio, protein_ratio, etc.)
                    # ------------------------------------------------------------------
                    if 'Calories' in row and not pd.isna(row['Calories']):
                        try:
                            fc.Calories = float(row['Calories'])
                        except ValueError:
                            fc.Calories = 0

                    if 'carb_ratio' in row and not pd.isna(row['carb_ratio']):
                        try:
                            fc.carb_ratio = float(row['carb_ratio'])
                        except ValueError:
                            fc.carb_ratio = 0

                    if 'fat_ratio' in row and not pd.isna(row['fat_ratio']):
                        try:
                            fc.fat_ratio = float(row['fat_ratio'])
                        except ValueError:
                            fc.fat_ratio = 0

                    if 'protein_ratio' in row and not pd.isna(row['protein_ratio']):
                        try:
                            fc.protein_ratio = float(row['protein_ratio'])
                        except ValueError:
                            fc.protein_ratio = 0

                    if 'data_json' in row and not pd.isna(row['data_json']):
                        try:
                            fc.foods = ast.literal_eval(row['data_json'])
                        except json.JSONDecodeError:
                            fc.foods = []
                    else:
                        # If not provided or is NaN, decide if you want to keep old value or set empty
                        pass  # fc.foods = []

                    # ------------------------------------------------------------------
                    # h) Save
                    # ------------------------------------------------------------------
                    fc.save()

                    if is_new:
                        created_count += 1
                    else:
                        updated_count += 1

            # ------------------------------------------------------------------
            # 7) Return a success response
            # ------------------------------------------------------------------
            response_data = {
                "created_count": created_count,
                "updated_count": updated_count,
                "skipped_count": skipped_count,
                "skipped_rows": skipped_rows
            }
            return JsonResponse({"message": "FoodCard tags updated successfully", "data": response_data}, status=200)

        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)

    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@csrf_exempt
def AddDietTemplatesFromExcel(request):
    if request.method == 'POST':
        try:
            # ------------------------------------------------------------
            # 1) Check for file in request
            # ------------------------------------------------------------
            if not request.FILES:
                return JsonResponse({"error": "Please upload an Excel (.xlsx) file"}, status=400)

            uploaded_file = request.FILES.get("file")
            if not uploaded_file or not uploaded_file.name.endswith('.xlsx'):
                return JsonResponse({"error": "File must be in .xlsx format"}, status=400)

            # Save the file locally
            file_path = settings.BASE_DIR + f'/static/assets/foods/tags_{datetime.now().date()}.xlsx'
            with open(file_path, 'wb+') as destination:
                for chunk in uploaded_file.chunks():
                    destination.write(chunk)

            # Read Excel file
            df = pd.read_excel(file_path)

            # ------------------------------------------------------------
            # 4) Setup counters
            # ------------------------------------------------------------
            created_count = 0
            skipped_count = 0
            skipped_rows = []

            BACTERIA_MAP = {
                'Bacteria_Akkermansia': 'akkermansia',
                'Bacteria_Bacteroidetes': 'bacteroides',
                'Bacteria_Bifidobacterium': 'bifidobacterium',
                'Bacteria_Fecalibacterium': 'faecalibacterium',
                'Bacteria_Alistipes': 'alistipes',
                'eubacterium': 'eubacterium',
                'Bacteria_Lactobacillus': 'lactobacillus',
                'Bacteria_Blautia': 'blautia',
                'Bacteria_Acidaminococcus': 'Bacteria_Acidaminococcus',
                'Bacteria_Lawsonibacter_asaccharolyticus': 'Bacteria_Lawsonibacter_asaccharolyticus',
            }

            # ------------------------------------------------------------
            # 5) Process each row in a transaction (all-or-nothing)
            # ------------------------------------------------------------
            with transaction.atomic():
                for index, row in df.iterrows():
                    # If you have any *required* fields, you can check them here and skip if missing
                    # e.g. if 'diet_name' is mandatory, skip if empty:
                    # if pd.isna(row.get('diet_name', None)):
                    #     skipped_count += 1
                    #     skipped_rows.append(f"Row {index}: Missing diet_name")
                    #     continue

                    # ------------------------------------------------
                    # a) Create a blank DietTemplate
                    # ------------------------------------------------
                    dt = DietTemplate()

                    # ------------------------------------------------
                    # b) Fill in the fields
                    # ------------------------------------------------
                    # Example: text fields
                    if 'diet_name' in row and not pd.isna(row['diet_name']):
                        dt.diet_name = str(row['diet_name'])
                    if 'diet_cal' in row and not pd.isna(row['diet_cal']):
                        try:
                            dt.calorie_range = int(row['diet_cal'])
                        except ValueError:
                            dt.calorie_range = 0
                    if 'company_name' in row and not pd.isna(row['company_name']):
                        dt.company_name = str(row['company_name'])
                    if 'city' in row and not pd.isna(row['city']):
                        dt.city = str(row['city'])
                    if 'is_user_template' in row:
                        dt.is_user_template = excel_to_bool(row['is_user_template'])

                    # Example: parse JSON data for 'diet_json'
                    if 'json_data' in row and not pd.isna(row['json_data']):
                        try:
                            diet_data = ast.literal_eval(str(row['json_data']))
                            dt.diet_json = diet_data

                            # NEW: pull "type" from the parsed JSON and put it in diet_name
                            if 'type' in diet_data:
                                dt.diet_name = diet_data['type']

                        except (ValueError, SyntaxError, json.JSONDecodeError):
                            dt.diet_json = {}

                    # Read the bacteria_type column and map to model fields
                    bacteria_value = row.get('bacteria_type', '')
                    if pd.notna(bacteria_value):  # Ensure value is not NaN
                        bacteria_str = str(bacteria_value).strip()  # Remove extra spaces
                        if bacteria_str in BACTERIA_MAP:  # Check if the value exists in the map
                            field_name = BACTERIA_MAP[bacteria_str]  # Get the model field name
                            setattr(dt, field_name, True)  # Set the corresponding field to True
                        else:
                            # Handle unmatched bacteria types (optional)
                            skipped_count += 1
                            skipped_rows.append(f"Row {index}: Unmapped bacteria_type '{bacteria_str}'")

                    # Example: boolean fields
                    # dt.akkermansia = excel_to_bool(row.get('akkermansia', False))
                    # dt.bacteroides = excel_to_bool(row.get('bacteroides', False))
                    # dt.bifidobacterium = excel_to_bool(row.get('bifidobacterium', False))
                    # dt.faecalibacterium = excel_to_bool(row.get('faecalibacterium', False))
                    # dt.alistipes = excel_to_bool(row.get('alistipes', False))
                    # dt.eubacterium = excel_to_bool(row.get('eubacterium', False))
                    # dt.lactobacillus = excel_to_bool(row.get('lactobacillus', False))
                    # dt.blautia = excel_to_bool(row.get('blautia', False))
                    # dt.Bacteria_Acidaminococcus = excel_to_bool(row.get('Bacteria_Acidaminococcus', False))
                    # dt.Bacteria_Lawsonibacter_asaccharolyticus = excel_to_bool(
                    #     row.get('Bacteria_Lawsonibacter_asaccharolyticus', False))

                    # Example: diet type booleans
                    dt.med = excel_to_bool(row.get('Diet_Mediterranean', False))
                    dt.low_gi = excel_to_bool(row.get('low_gi', False))
                    dt.fasting = excel_to_bool(row.get('fasting', False))
                    dt.keto = excel_to_bool(row.get('Diet_Keto', False))
                    dt.mind = excel_to_bool(row.get('mind', False))
                    dt.sport = excel_to_bool(row.get('sport', False))
                    dt.liquid_or_pureed_diet = excel_to_bool(row.get('liquid_or_pureed_diet', False))
                    dt.eliminate_diet = excel_to_bool(row.get('eliminate_diet', False))
                    dt.low_fodmap = excel_to_bool(row.get('low_fodmap', False))
                    dt.pregnant = excel_to_bool(row.get('pregnant', False))
                    dt.lactating = excel_to_bool(row.get('lactating', False))
                    dt.Diet_Low_Sugar = excel_to_bool(row.get('Diet_Low_Sugar', False))
                    dt.Diet_High_Protein = excel_to_bool(row.get('Diet_High_Protein', False))
                    dt.Whole_Foods = excel_to_bool(row.get('Whole_Foods', False))
                    dt.Diet_Low_Fat = excel_to_bool(row.get('Diet_Low_Fat', False))
                    dt.Diet_Low_Calorie = excel_to_bool(row.get('Diet_Low_Calorie', False))
                    dt.Diet_Anti_Inflammatory = excel_to_bool(row.get('Diet_Anti_Inflammatory', False))
                    dt.Diet_Paleo = excel_to_bool(row.get('Diet_Paleo', False))
                    dt.Diet_Diabetic = excel_to_bool(row.get('Diet_Diabetic', False))
                    dt.Diet_Low_Carb = excel_to_bool(row.get('Diet_Low_Carb', False))
                    dt.Diet_Bodybuilding = excel_to_bool(row.get('Diet_Bodybuilding', False))
                    dt.Diet_Vegan = excel_to_bool(row.get('Diet_Vegan', False))
                    dt.Diet_Vegetarian = excel_to_bool(row.get('Diet_Vegetarian', False))
                    dt.Diet_Plant_Based = excel_to_bool(row.get('Diet_Plant_Based', False))
                    dt.Diet_Gluten_Free = excel_to_bool(row.get('Diet_Gluten_Free', False))

                    # Example: diseases booleans
                    dt.fatty_liver = excel_to_bool(row.get('fatty_liver', False))
                    dt.diabetes = excel_to_bool(row.get('Disease_Diabetes', False))
                    dt.ibs = excel_to_bool(row.get('Disease_IBS', False))
                    dt.pcos = excel_to_bool(row.get('pcos', False))
                    dt.neghres = excel_to_bool(row.get('Disease_Gout', False))
                    dt.ms = excel_to_bool(row.get('ms', False))
                    dt.obesity_surgery = excel_to_bool(row.get('obesity_surgery', False))
                    dt.renal = excel_to_bool(row.get('renal', False))
                    dt.cvd = excel_to_bool(row.get('cvd', False))
                    dt.migraine = excel_to_bool(row.get('migraine', False))
                    dt.cancer = excel_to_bool(row.get('cancer', False))
                    dt.nervous_disease = excel_to_bool(row.get('nervous_disease', False))
                    dt.gi_disease = excel_to_bool(row.get('gi_disease', False))
                    dt.healthy = excel_to_bool(row.get('healthy', False))
                    dt.Disease_Kidney = excel_to_bool(row.get('Disease_Kidney', False))
                    dt.Disease_Kidney_stones = excel_to_bool(row.get('Disease_Kidney_stones', False))
                    dt.Disease_Acid_reflux = excel_to_bool(row.get('Disease_Acid_reflux', False))
                    dt.Disease_Celiac = excel_to_bool(row.get('Disease_Celiac', False))
                    dt.Disease_Diverticulitis = excel_to_bool(row.get('Disease_Diverticulitis', False))
                    dt.Disease_Hypothyroidism = excel_to_bool(row.get('Disease_Hypothyroidism', False))
                    dt.Disease_Gastroesophageal_Reflux = excel_to_bool(
                        row.get('Disease_Gastroesophageal_Reflux', False))
                    dt.Disease_Foodborne_Illness = excel_to_bool(row.get('Disease_Foodborne_Illness', False))
                    dt.Disease_High_blood_pressure = excel_to_bool(row.get('Disease_High_blood_pressure', False))
                    dt.Disease_High_cholesterol = excel_to_bool(row.get('Disease_High_cholesterol', False))
                    dt.Disease_Hypercholesterolemia = excel_to_bool(row.get('Disease_Hypercholesterolemia', False))
                    dt.Disease_G6PD_Deficiency = excel_to_bool(row.get('Disease_G6PD_Deficiency', False))
                    dt.Disease_Constipation = excel_to_bool(row.get('Disease_Constipation', False))
                    dt.Disease_Gallbladder = excel_to_bool(row.get('Disease_Gallbladder', False))
                    dt.Disease_Latex_Fruit_Syndrome = excel_to_bool(row.get('Disease_Latex_Fruit_Syndrome', False))
                    dt.Disease_Obesity = excel_to_bool(row.get('Disease_Obesity', False))

                    dt.cooked_rice = excel_to_bool(row.get('cooked_rice', False))
                    dt.main_dish = excel_to_bool(row.get('main_dish', False))
                    dt.Allergens_Peanut = excel_to_bool(row.get('Allergens_Peanut', False))
                    dt.Allergens_Wheat = excel_to_bool(row.get('Allergens_Wheat', False))
                    dt.Allergens_Shrimp = excel_to_bool(row.get('Allergens_Shrimp', False))
                    dt.Allergens_Mushroom = excel_to_bool(row.get('Allergens_Mushroom', False))
                    dt.Allergens_Eggplant = excel_to_bool(row.get('Allergens_Eggplant', False))
                    dt.Allergens_Dried_fruits = excel_to_bool(row.get('Allergens_Dried_fruits', False))
                    dt.Allergens_Gluten = excel_to_bool(row.get('Allergens_Gluten', False))
                    dt.Allergens_Fish = excel_to_bool(row.get('Allergens_Fish', False))
                    dt.Allergens_Sesame = excel_to_bool(row.get('Allergens_Sesame', False))
                    dt.Allergens_Shellfish = excel_to_bool(row.get('Allergens_Shellfish', False))
                    dt.Allergens_Nuts = excel_to_bool(row.get('Allergens_Nuts', False))
                    dt.Allergens_Soy = excel_to_bool(row.get('Allergens_Soy', False))
                    dt.Allergens_Eggs = excel_to_bool(row.get('Allergens_Eggs', False))
                    dt.Allergens_Peanuts = excel_to_bool(row.get('Allergens_Peanuts', False))
                    dt.Allergens_Dairy = excel_to_bool(row.get('Allergens_Dairy', False))
                    dt.Allergens_Legumes = excel_to_bool(row.get('Allergens_Legumes', False))
                    dt.Allergens_Depends_on_filling_ingredients = excel_to_bool(
                        row.get('Allergens_Depends_on_filling_ingredients', False))
                    dt.Allergens_Milk = excel_to_bool(row.get('Allergens_Milk', False))
                    dt.Dessert = excel_to_bool(row.get('Dessert', False))
                    dt.Added_Meat = excel_to_bool(row.get('Added_Meat', False))
                    dt.Ing_Main = excel_to_bool(row.get('Ing_Main', False))
                    dt.Beverage = excel_to_bool(row.get('Beverage', False))
                    dt.Sandwich = excel_to_bool(row.get('Sandwich', False))
                    dt.Condiment = excel_to_bool(row.get('Condiment', False))
                    dt.Lunch = excel_to_bool(row.get('Lunch', False))
                    dt.Snack = excel_to_bool(row.get('Snack', False))
                    dt.Bread = excel_to_bool(row.get('Bread', False))
                    dt.Entree = excel_to_bool(row.get('Entree', False))
                    dt.Soup = excel_to_bool(row.get('Soup', False))
                    dt.Side_Dish = excel_to_bool(row.get('Side_Dish', False))
                    dt.Appetizer = excel_to_bool(row.get('Appetizer', False))
                    dt.Dinner = excel_to_bool(row.get('Dinner', False))
                    dt.Pasta = excel_to_bool(row.get('Pasta', False))
                    dt.Breakfast = excel_to_bool(row.get('Breakfast', False))
                    dt.Salad = excel_to_bool(row.get('Salad', False))
                    dt.Ingredient = excel_to_bool(row.get('Ingredient', False))
                    dt.Vegan = excel_to_bool(row.get('Vegan', False))
                    dt.Umami = excel_to_bool(row.get('Umami', False))
                    dt.Slow_cooked = excel_to_bool(row.get('Slow_cooked', False))
                    dt.Spicy = excel_to_bool(row.get('Spicy', False))
                    dt.Baked = excel_to_bool(row.get('Baked', False))
                    dt.Pickled = excel_to_bool(row.get('Pickled', False))
                    dt.Low_calorie = excel_to_bool(row.get('Low_calorie', False))
                    dt.Grilled = excel_to_bool(row.get('Grilled', False))
                    dt.Roasted = excel_to_bool(row.get('Roasted', False))
                    dt.High_protein = excel_to_bool(row.get('High_protein', False))
                    dt.Fried = excel_to_bool(row.get('Fried', False))
                    dt.Sweet = excel_to_bool(row.get('Sweet', False))
                    dt.Salty = excel_to_bool(row.get('Salty', False))
                    dt.Lactose_free = excel_to_bool(row.get('Lactose_free', False))
                    dt.Low_carb = excel_to_bool(row.get('Low_carb', False))
                    dt.Cold = excel_to_bool(row.get('Cold', False))
                    dt.Vegetarian = excel_to_bool(row.get('Vegetarian', False))
                    dt.Sour = excel_to_bool(row.get('Sour', False))
                    dt.Sweet_Sour = excel_to_bool(row.get('Sweet_Sour', False))
                    dt.Raw = excel_to_bool(row.get('Raw', False))
                    dt.Gluten_free = excel_to_bool(row.get('Gluten_free', False))
                    dt.Boiled = excel_to_bool(row.get('Boiled', False))
                    dt.Steamed = excel_to_bool(row.get('Steamed', False))
                    dt.Low_fat = excel_to_bool(row.get('Low_fat', False))
                    dt.Prepared_Meals = excel_to_bool(row.get('Prepared_Meals', False))
                    dt.Meats = excel_to_bool(row.get('Meats', False))
                    dt.Sweets = excel_to_bool(row.get('Sweets', False))
                    dt.Beans_and_Lentils = excel_to_bool(row.get('Beans_and_Lentils', False))
                    dt.Snacks = excel_to_bool(row.get('Snacks', False))
                    dt.Grains_and_Pasta = excel_to_bool(row.get('Grains_and_Pasta', False))
                    dt.Nuts_and_Seeds = excel_to_bool(row.get('Nuts_and_Seeds', False))
                    dt.Fruits = excel_to_bool(row.get('Fruits', False))
                    dt.Beverages = excel_to_bool(row.get('Beverages', False))
                    dt.Fish = excel_to_bool(row.get('Fish', False))
                    dt.Baked_Foods = excel_to_bool(row.get('Baked_Foods', False))
                    dt.Breakfast_Cereals = excel_to_bool(row.get('Breakfast_Cereals', False))
                    dt.Vegetables = excel_to_bool(row.get('Vegetables', False))
                    dt.Spices_and_Herbs = excel_to_bool(row.get('Spices_and_Herbs', False))
                    dt.Soups_and_Sauces = excel_to_bool(row.get('Soups_and_Sauces', False))
                    dt.Dairy_and_Egg_Products = excel_to_bool(row.get('Dairy_and_Egg_Products', False))
                    dt.Fats_and_Oils = excel_to_bool(row.get('Fats_and_Oils', False))
                    dt.Lactose_Intolerance = excel_to_bool(row.get('Lactose_Intolerance', False))
                    dt.stones = excel_to_bool(row.get('stones', False))
                    dt.reflux = excel_to_bool(row.get('reflux', False))
                    dt.Spices = excel_to_bool(row.get('Spices', False))
                    dt.Seafood = excel_to_bool(row.get('Seafood', False))
                    dt.Poultry = excel_to_bool(row.get('Poultry', False))
                    dt.Herbs = excel_to_bool(row.get('Herbs', False))
                    dt.Processed_Meats = excel_to_bool(row.get('Processed_Meats', False))
                    dt.Legumes = excel_to_bool(row.get('Legumes', False))
                    dt.Dairy = excel_to_bool(row.get('Dairy', False))
                    dt.Nuts = excel_to_bool(row.get('Nuts', False))
                    dt.Mixed_Dishes = excel_to_bool(row.get('Mixed_Dishes', False))
                    dt.Sauces = excel_to_bool(row.get('Sauces', False))
                    dt.Oils = excel_to_bool(row.get('Oils', False))
                    dt.Grains = excel_to_bool(row.get('Grains', False))
                    dt.Seeds = excel_to_bool(row.get('Seeds', False))
                    dt.Pastries = excel_to_bool(row.get('Pastries', False))
                    dt.Spreads = excel_to_bool(row.get('Spreads', False))
                    dt.Eggs = excel_to_bool(row.get('Eggs', False))
                    dt.Prebiotic = excel_to_bool(row.get('Prebiotic', False))
                    dt.Probiotic = excel_to_bool(row.get('Probiotic', False))
                    dt.Low_Inflammatory = excel_to_bool(row.get('Low_Inflammatory', False))
                    dt.Diverse = excel_to_bool(row.get('Diverse', False))
                    dt.Polyphenol_Rich = excel_to_bool(row.get('Polyphenol_Rich', False))
                    dt.Stews = excel_to_bool(row.get('Stews', False))
                    dt.Mixed_Rice = excel_to_bool(row.get('Mixed_Rice', False))
                    dt.Soups_and_Aashes = excel_to_bool(row.get('Soups_and_Aashes', False))
                    dt.Traditional_Foods = excel_to_bool(row.get('Traditional_Foods', False))
                    dt.International_Foods = excel_to_bool(row.get('International_Foods', False))
                    dt.Vegetarian_Foods = excel_to_bool(row.get('Vegetarian_Foods', False))
                    dt.Simple_Dishes = excel_to_bool(row.get('Simple_Dishes', False))
                    dt.Main_Salads = excel_to_bool(row.get('Main_Salads', False))
                    dt.Fast_Foods = excel_to_bool(row.get('Fast_Foods', False))

                    # FODMAP_Classification (int) -> maybe 'low', 'variable', 'high'
                    map_fodmap = {'low': 1, 'variable': 2, 'high': 3}
                    if 'FODMAP_Classification' in row and not pd.isna(row['FODMAP_Classification']):
                        fodmap_key = str(row['FODMAP_Classification']).strip().lower()
                        dt.FODMAP_Classification = map_fodmap.get(fodmap_key, 0)

                    # GL_category, GI_category (ints)
                    map_gl_category = {'low': 1, 'medium': 2, 'high': 3}
                    if 'GL_category' in row and not pd.isna(row['GL_category']):
                        gl_cat_key = str(row['GL_category']).strip().lower()
                        dt.GL_category = map_gl_category.get(gl_cat_key, 0)

                    if 'GL_value' in row and not pd.isna(row['GL_value']):
                        try:
                            dt.GL_value = int(row['GL_value'])
                        except ValueError:
                            dt.GL_value = 0

                    if 'GI_category' in row and not pd.isna(row['GI_category']):
                        gi_cat_key = str(row['GI_category']).strip().lower()
                        dt.GI_category = map_gl_category.get(gi_cat_key, 0)

                    if 'GI_value' in row and not pd.isna(row['GI_value']):
                        try:
                            dt.GI_value = int(row['GI_value'])
                        except ValueError:
                            dt.GI_value = 0

                    if 'lunch_Stews' in row and not pd.isna(row['lunch_Stews']):
                        try:
                            dt.lunch_Stews = int(row['lunch_Stews'])
                        except ValueError:
                            dt.lunch_Stews = 0

                    if 'lunch_Mixed_Rice' in row and not pd.isna(row['lunch_Mixed_Rice']):
                        try:
                            dt.lunch_Mixed_Rice = int(row['lunch_Mixed_Rice'])
                        except ValueError:
                            dt.lunch_Mixed_Rice = 0

                    if 'lunch_Grilled' in row and not pd.isna(row['lunch_Grilled']):
                        try:
                            dt.lunch_Grilled = int(row['lunch_Grilled'])
                        except ValueError:
                            dt.lunch_Grilled = 0

                    if 'lunch_Soups_and_Aashes' in row and not pd.isna(row['lunch_Soups_and_Aashes']):
                        try:
                            dt.lunch_Soups_and_Aashes = int(row['lunch_Soups_and_Aashes'])
                        except ValueError:
                            dt.lunch_Soups_and_Aashes = 0

                    if 'lunch_Pasta' in row and not pd.isna(row['lunch_Pasta']):
                        try:
                            dt.lunch_Pasta = int(row['lunch_Pasta'])
                        except ValueError:
                            dt.lunch_Pasta = 0

                    if 'lunch_Seafood' in row and not pd.isna(row['lunch_Seafood']):
                        try:
                            dt.lunch_Seafood = int(row['lunch_Seafood'])
                        except ValueError:
                            dt.lunch_Seafood = 0

                    if 'lunch_Traditional_Foods' in row and not pd.isna(row['lunch_Traditional_Foods']):
                        try:
                            dt.lunch_Traditional_Foods = int(row['lunch_Traditional_Foods'])
                        except ValueError:
                            dt.lunch_Traditional_Foods = 0

                    if 'lunch_International_Foods' in row and not pd.isna(row['lunch_International_Foods']):
                        try:
                            dt.lunch_International_Foods = int(row['lunch_International_Foods'])
                        except ValueError:
                            dt.lunch_International_Foods = 0

                    if 'lunch_Vegetarian_Foods' in row and not pd.isna(row['lunch_Vegetarian_Foods']):
                        try:
                            dt.lunch_Vegetarian_Foods = int(row['lunch_Vegetarian_Foods'])
                        except ValueError:
                            dt.lunch_Vegetarian_Foods = 0

                    if 'lunch_Simple_Dishes' in row and not pd.isna(row['lunch_Simple_Dishes']):
                        try:
                            dt.lunch_Simple_Dishes = int(row['lunch_Simple_Dishes'])
                        except ValueError:
                            dt.lunch_Simple_Dishes = 0

                    if 'lunch_Main_Salads' in row and not pd.isna(row['lunch_Main_Salads']):
                        try:
                            dt.lunch_Main_Salads = int(row['lunch_Main_Salads'])
                        except ValueError:
                            dt.lunch_Main_Salads = 0

                    if 'lunch_Fast_Foods' in row and not pd.isna(row['lunch_Fast_Foods']):
                        try:
                            dt.lunch_Fast_Foods = int(row['lunch_Fast_Foods'])
                        except ValueError:
                            dt.lunch_Fast_Foods = 0

                    if 'dinner_Stews' in row and not pd.isna(row['dinner_Stews']):
                        try:
                            dt.dinner_Stews = int(row['dinner_Stews'])
                        except ValueError:
                            dt.dinner_Stews = 0

                    if 'dinner_Mixed_Rice' in row and not pd.isna(row['dinner_Mixed_Rice']):
                        try:
                            dt.dinner_Mixed_Rice = int(row['dinner_Mixed_Rice'])
                        except ValueError:
                            dt.dinner_Mixed_Rice = 0

                    if 'dinner_Grilled' in row and not pd.isna(row['dinner_Grilled']):
                        try:
                            dt.dinner_Grilled = int(row['dinner_Grilled'])
                        except ValueError:
                            dt.dinner_Grilled = 0

                    if 'dinner_Soups_and_Aashes' in row and not pd.isna(row['dinner_Soups_and_Aashes']):
                        try:
                            dt.dinner_Soups_and_Aashes = int(row['dinner_Soups_and_Aashes'])
                        except ValueError:
                            dt.dinner_Soups_and_Aashes = 0

                    if 'dinner_Pasta' in row and not pd.isna(row['dinner_Pasta']):
                        try:
                            dt.dinner_Pasta = int(row['dinner_Pasta'])
                        except ValueError:
                            dt.dinner_Pasta = 0

                    if 'dinner_Seafood' in row and not pd.isna(row['dinner_Seafood']):
                        try:
                            dt.dinner_Seafood = int(row['dinner_Seafood'])
                        except ValueError:
                            dt.dinner_Seafood = 0

                    if 'dinner_Traditional_Foods' in row and not pd.isna(row['dinner_Traditional_Foods']):
                        try:
                            dt.dinner_Traditional_Foods = int(row['dinner_Traditional_Foods'])
                        except ValueError:
                            dt.dinner_Traditional_Foods = 0

                    if 'dinner_International_Foods' in row and not pd.isna(row['dinner_International_Foods']):
                        try:
                            dt.dinner_International_Foods = int(row['dinner_International_Foods'])
                        except ValueError:
                            dt.dinner_International_Foods = 0

                    if 'dinner_Vegetarian_Foods' in row and not pd.isna(row['dinner_Vegetarian_Foods']):
                        try:
                            dt.dinner_Vegetarian_Foods = int(row['dinner_Vegetarian_Foods'])
                        except ValueError:
                            dt.dinner_Vegetarian_Foods = 0

                    if 'dinner_Simple_Dishes' in row and not pd.isna(row['dinner_Simple_Dishes']):
                        try:
                            dt.dinner_Simple_Dishes = int(row['dinner_Simple_Dishes'])
                        except ValueError:
                            dt.dinner_Simple_Dishes = 0

                    if 'dinner_Main_Salads' in row and not pd.isna(row['dinner_Main_Salads']):
                        try:
                            dt.dinner_Main_Salads = int(row['dinner_Main_Salads'])
                        except ValueError:
                            dt.dinner_Main_Salads = 0

                    if 'dinner_Fast_Foods' in row and not pd.isna(row['dinner_Fast_Foods']):
                        try:
                            dt.dinner_Fast_Foods = int(row['dinner_Fast_Foods'])
                        except ValueError:
                            dt.dinner_Fast_Foods = 0

                    # Save the new DietTemplate
                    dt.save()
                    created_count += 1

            # ------------------------------------------------------------
            # 6) Return results
            # ------------------------------------------------------------
            response_data = {
                "created_count": created_count,
                "skipped_count": skipped_count,
                "skipped_rows": skipped_rows
            }
            return JsonResponse({"message": "DietTemplates created successfully", "data": response_data}, status=200)

        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)

    # If other HTTP methods, return an error
    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@csrf_exempt
@api_view(['POST'])
def UpdateFoodCardAllergyTagsFromExcelWithSportBreadRiceSaladTag(request):
    if request.method == 'POST':
        try:
            # ------------------------------------------------------------
            # 1) Check for file in request
            # ------------------------------------------------------------
            if not request.FILES:
                return JsonResponse({"error": "Please upload an Excel (.xlsx) file"}, status=400)

            uploaded_file = request.FILES.get("file")
            if not uploaded_file or not uploaded_file.name.endswith('.xlsx'):
                return JsonResponse({"error": "File must be in .xlsx format"}, status=400)

            # Save the file locally
            file_path = settings.BASE_DIR + f'/static/DATABASE/20250504ـ20250401.xlsx'
            with open(file_path, 'wb+') as destination:
                for chunk in uploaded_file.chunks():
                    destination.write(chunk)

            # Read Excel file
            df = pd.read_excel(file_path)

            # ------------------------------------------------------------
            # 2) Setup counters
            # ------------------------------------------------------------
            updated_count = 0
            skipped_count = 0
            skipped_rows = []

            # ------------------------------------------------------------
            # 3) Process each row
            # ------------------------------------------------------------
            with transaction.atomic():
                for index, row in df.iterrows():
                    # Get food card code from first column
                    try:
                        food_card_code = int(row.iloc[0])
                    except (ValueError, IndexError):
                        skipped_count += 1
                        skipped_rows.append(f"Row {index + 2}: Invalid food card code")
                        continue

                    # Get corresponding food card
                    try:
                        food_card = FoodCard.objects.get(main_dish_code=food_card_code)
                    except FoodCard.DoesNotExist:
                        skipped_count += 1
                        skipped_rows.append(f"Row {index + 2}: FoodCard {food_card_code} not found")
                        continue
                    
                    main_dish_code = row.iloc[3]
                    
                    if main_dish_code == 0 or main_dish_code is None:
                        food_card.main_dish_code = -1
                    else:
                        food_card.main_dish_code = main_dish_code
                    
                    food_card.sport = row.iloc[350]
                    food_card.bread = row.iloc[351]
                    food_card.rice = row.iloc[352]
                    food_card.salad = row.iloc[353]
                    
                    # Process allergy tag fields from Excel
                    allergy_fields = [
                        'AL_Dairy_Butter', 'AL_Dairy_Cheese', 'AL_Dairy_Coconut', 'AL_Dairy_CoconutMilk',
                        'AL_Dairy_Cream', 'AL_Dairy_CreamCheese', 'AL_Dairy_IceCream', 'AL_Dairy_Mayonnaise',
                        'AL_Dairy_Milk', 'AL_Dairy_Milk_Chocolate', 'AL_Dairy_Whey', 'AL_Dairy_Yogurt',
                        'AL_Egg', 'AL_Eggs_Egg', 'AL_Eggs_Mayonnaise', 'AL_Fish_Crab', 'AL_Fish_Fish',
                        'AL_Fish_Shrimp', 'AL_Fish_Tuna', 'AL_Grain_Barley', 'AL_Grain_Bean',
                        'AL_Grain_Buckwheat', 'AL_Grain_Chickpea', 'AL_Grain_Corn', 'AL_Grain_Lentil',
                        'AL_Grain_Mung', 'AL_Grain_Oat', 'AL_Grain_Oats', 'AL_Grain_Quinoa', 'AL_Grain_Rice',
                        'AL_Grain_Rye', 'AL_Grain_Soy', 'AL_Grain_Unspecified', 'AL_Grain_Wheat',
                        'AL_Grains_Wheat', 'AL_Legume_Beans', 'AL_Legume_Lentil', 'AL_Legume_Pea',
                        'AL_Legume_RedBean', 'AL_Legume_Soy', 'AL_Legume_Split_Peas', 'AL_Legume_SplitPea',
                        'AL_Meat_Bacon', 'AL_Meat_Beef', 'AL_Meat_Chicken', 'AL_Meat_Ham', 'AL_Meat_Lamb',
                        'AL_Meat_Pepperoni', 'AL_Meat_Pork', 'AL_Meat_Processed', 'AL_Meat_Sausage',
                        'AL_Meat_Turkey', 'AL_Meat_Unspecified', 'AL_Meat_Varies', 'AL_Meat_Various',
                        'AL_Nuts_Almond', 'AL_Nuts_Coconut', 'AL_Nuts_Hazelnut', 'AL_Nuts_Nuts',
                        'AL_Nuts_Peanut', 'AL_Nuts_Pine_Nuts', 'AL_Nuts_Pistachio', 'AL_Nuts_Sesame',
                        'AL_Nuts_Unspecified', 'AL_Nuts_Varies', 'AL_Nuts_Various', 'AL_Nuts_Walnut',
                        'AL_Poultry_Chicken', 'AL_Seeds_Chia', 'AL_Shellfish_Shrimp', 'AL_Dairy_Cream_Cheese',
                        'AL_Dairy_Creamer', 'AL_Dairy_Goat_Milk', 'AL_Dairy_Kashk', 'AL_Dairy_Kefir',
                        'AL_Eggs_Whole', 'AL_Eggs_Whole_Eggs', 'AL_Eggs_Yolk', 'AL_Fish_Anchovy',
                        'AL_Fish_Carp', 'AL_Fish_Catfish', 'AL_Fish_Caviar', 'AL_Fish_Croaker',
                        'AL_Fish_Flatfish', 'AL_Fish_Flounder', 'AL_Fish_Grouper', 'AL_Fish_Herring',
                        'AL_Fish_KingMackerel', 'AL_Fish_Mackerel', 'AL_Fish_Mullet', 'AL_Fish_Pike',
                        'AL_Fish_Porgy', 'AL_Fish_Roe', 'AL_Fish_Salmon', 'AL_Fish_Sardine', 'AL_Fish_Shark',
                        'AL_Fish_Snapper', 'AL_Fish_Swordfish', 'AL_Fish_Tilapia', 'AL_Fish_Trout',
                        'AL_Fish_Unspecified', 'AL_Fish_Whitefish', 'AL_Grain_Bulgur', 'AL_Grain_Cereal',
                        'AL_Grain_Millet', 'AL_Grain_Pea', 'AL_Grain_SplitPea', 'AL_Grains_Barley',
                        'AL_Grains_Brown_Rice', 'AL_Grains_Bulgur', 'AL_Grains_Chickpea', 'AL_Grains_Corn',
                        'AL_Grains_Millet', 'AL_Grains_Oats', 'AL_Grains_Rice', 'AL_Legume_Bean',
                        'AL_Legume_Chickpea', 'AL_Legume_Fava', 'AL_Legume_FavaBean', 'AL_Legume_Peas',
                        'AL_Legume_Unspecified', 'AL_Meat_Camel', 'AL_Meat_Duck', 'AL_Meat_Fat',
                        'AL_Meat_Fish', 'AL_Meat_Goose', 'AL_Meat_Ground', 'AL_Meat_Kidney', 'AL_Meat_Offal',
                        'AL_Meat_Organ', 'AL_Meat_Ostrich', 'AL_Meat_Pigeon', 'AL_Meat_Quail',
                        'AL_Meat_Sheep', 'AL_Meat_Veal', 'AL_Nuts_Acorn', 'AL_Nuts_Almonds',
                        'AL_Nuts_Cashew', 'AL_Nuts_Chestnut', 'AL_Nuts_Hazelnuts', 'AL_Nuts_Hemp',
                        'AL_Nuts_Mixed', 'AL_Nuts_Nutmeg', 'AL_Nuts_Peanuts', 'AL_Nuts_Pecan',
                        'AL_Other_Sesame', 'AL_Poultry_Duck', 'AL_Poultry_Offal', 'AL_Seafood_Fish',
                        'AL_Seeds_Cottonseed', 'AL_Seeds_Flax', 'AL_Seeds_Flaxseed', 'AL_Seeds_Poppy',
                        'AL_Seeds_Pumpkin', 'AL_Seeds_Safflower', 'AL_Seeds_Sesame', 'AL_Seeds_Sunflower',
                        'AL_Seeds_Watermelon', 'AL_Sesame_Sesame', 'AL_Soy_Soy', 'AL_Soy_SoySauce',
                        'AL_Soy_Soybean', 'AL_Soy_Soybeans'
                    ]

                    # Update each allergy field from Excel data
                    for field in allergy_fields:
                        if field in row:
                            try:
                                # Convert Excel value to boolean and set on food_card
                                value = bool(row[field]) if not pd.isna(row[field]) else False
                                setattr(food_card, field, value)
                            except Exception as e:
                                skipped_rows.append(f"Row {index + 2}: Error setting {field} - {str(e)}")

                    # Disease mapping from Excel headers to model fields
                    disease_mapping = {
                        'Diabetes': 'Disease_Diabetes',
                        'Hypertension': 'Disease_High_blood_pressure', 
                        'High Cholesterol': 'Disease_High_cholesterol',
                        'CVD': 'Disease_CVD',
                        'Kidney Disease': 'Disease_Kidney',
                        'Celiac': 'Disease_Celiac',
                        'IBS': 'Disease_IBS',
                        'IBD': 'Disease_IBD',
                        'Gout': 'Disease_Gout',
                        'Lactose Intolerance': 'Disease_Lactose_Intolerance',
                        'NAFLD': 'Disease_NAFLD',
                        'Anemia': 'Disease_Anemia',
                        'Osteoporosis': 'Disease_Osteoporosis',
                        'Arthritis': 'Disease_Arthritis',
                        'Thyroid': 'Disease_Hypothyroidism',
                        'Autoimmune': 'Disease_Autoimmune',
                        'Cancer Prevention': 'Disease_CancerPrevention',
                        'Mental Health': 'Disease_MentalHealth'
                    }

                    # Update each disease field from Excel data
                    for excel_field, model_field in disease_mapping.items():
                        if excel_field in row:
                            try:
                                # Convert Excel value to boolean and set on food_card
                                value = bool(row[excel_field]) if not pd.isna(row[excel_field]) else False
                                setattr(food_card, model_field, value)
                            except Exception as e:
                                skipped_rows.append(f"Row {index + 2}: Error setting {model_field} - {str(e)}")


                    # Save updated food card
                    try:
                        food_card.save()
                        updated_count += 1
                    except Exception as e:
                        skipped_count += 1
                        skipped_rows.append(f"Row {index + 2}: Error saving food card - {str(e)}")
                        continue

            # ------------------------------------------------------------
            # 4) Return results
            # ------------------------------------------------------------
            response_data = {
                "updated_count": updated_count,
                "skipped_count": skipped_count,
                "skipped_rows": skipped_rows
            }
            return JsonResponse({"message": "FoodCard allergy tags updated successfully", "data": response_data}, status=200)

        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)

    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@csrf_exempt
@api_view(['POST'])
def StaticAddFoodCardsFromExcel(request):
    if request.method == 'POST':
        try:
            # ------------------------------------------------------------
            # 1) Check for file in request
            # ------------------------------------------------------------
            if not request.FILES:
                return JsonResponse({"error": "Please upload an Excel (.xlsx) file"}, status=400)

            uploaded_file = request.FILES.get("file")
            if not uploaded_file or not uploaded_file.name.endswith('.xlsx'):
                return JsonResponse({"error": "File must be in .xlsx format"}, status=400)

            # Save the file locally
            file_path = settings.BASE_DIR + f'/static/assets/foods/food_cards_{datetime.now().date()}.xlsx'
            
            # Create directories if they don't exist
            os.makedirs(os.path.dirname(file_path), exist_ok=True)
            
            with open(file_path, 'wb+') as destination:
                for chunk in uploaded_file.chunks():
                    destination.write(chunk)

            # Read Excel file
            df = pd.read_excel(file_path)

            # ------------------------------------------------------------
            # 2) Setup counters
            # ------------------------------------------------------------
            created_count = 0
            skipped_count = 0
            skipped_rows = []

            # ------------------------------------------------------------
            # 3) Process each row in a transaction (all-or-nothing)
            # ------------------------------------------------------------
            with transaction.atomic():
                for index, row in df.iterrows():
                    try:
                        # Create new FoodCard object
                        food_card = FoodCard()

                        # Iterate through all columns and set attributes
                        for column in df.columns:
                            if hasattr(food_card, column):
                                value = row[column]
                                
                                # Handle different data types
                                if pd.isna(value):
                                    continue
                                    
                                if isinstance(value, bool):
                                    setattr(food_card, column, value)
                                elif isinstance(value, (int, float)):
                                    if column in ['GL_value', 'GI_value']:
                                        setattr(food_card, column, int(value))
                                    else:
                                        setattr(food_card, column, float(value))
                                elif column == 'foods':
                                    try:
                                        foods_value = ast.literal_eval(str(value))
                                        setattr(food_card, column, foods_value)
                                    except:
                                        setattr(food_card, column, [])
                                else:
                                    setattr(food_card, column, str(value))

                        # Save the food card
                        food_card.save()
                        created_count += 1

                    except Exception as e:
                        skipped_count += 1
                        skipped_rows.append(f"Row {index + 2}: {str(e)}")
                        continue

            # ------------------------------------------------------------
            # 4) Return results
            # ------------------------------------------------------------
            response_data = {
                "created_count": created_count,
                "skipped_count": skipped_count,
                "skipped_rows": skipped_rows
            }
            return JsonResponse({"message": "FoodCards created successfully", "data": response_data}, status=200)

        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)

    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@api_view(['POST'])
def update_food_card_from_excel(request):
    try:
        # Get excel file from static folder
        excel_file_path = os.path.join(settings.STATIC_ROOT, 'food_cards.xlsx')
        
        # Read excel file
        df = pd.read_excel(excel_file_path)
        
        # Get food code from column A (first column)
        food_codes = df.iloc[:, 0]
        
        # Get parameters from columns 14-342
        params_df = df.iloc[:, 14:343]
        
        updated_count = 0
        skipped_count = 0
        skipped_rows = []
        
        # baraye marizi ha age sefr bood yani nabayad ono bokhoran, yani onayy ke bishtar az sefran bayad true beshan ta exclude nashan
        
        # Process each row
        for index, food_code in enumerate(food_codes):
            try:
                # Get food card object
                food_card = FoodCard.objects.get(FA_Name= row[1], Calories=row[8])
                
                # Update parameters from columns 14-342
                for col_idx, value in enumerate(params_df.iloc[index], 14):
                    col_name = df.columns[col_idx]
                    
                    if hasattr(food_card, col_name):
                        # For columns 162-324, set True if value is 0, False otherwise
                        
                        if 169 <= col_idx <= 335:
                            # allergens, bread, rice, salad, sport for loop
                            setattr(food_card, col_name, value == 0)
                        elif 336 <= col_idx <= 353:
                            # Diseases for loop
                            setattr(food_card, col_name, value != 0)
                        # For other columns, set value directly
                        else:
                            setattr(food_card, col_name, value)
                
                food_card.save()
                updated_count += 1
                
            except FoodCard.DoesNotExist:
                skipped_count += 1
                skipped_rows.append(f"Row {index + 2}: Food card with code {food_code} not found")
                continue
            except Exception as e:
                skipped_count += 1 
                skipped_rows.append(f"Row {index + 2}: {str(e)}")
                continue
                
        response_data = {
            "updated_count": updated_count,
            "skipped_count": skipped_count,
            "skipped_rows": skipped_rows
        }
        
        return JsonResponse({"message": "Food cards updated successfully", "data": response_data}, status=200)
        
    except Exception as e:
        return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)


@api_view(['POST'])
def addDatabaseFoodCards(request):
    if request.method == 'POST':
        try:
            food_cards = request.data.get('food_cards')
            for food_card in food_cards:
                FoodCard.objects.filter(id=food_card).delete()
            return JsonResponse({"message": "FoodCards deleted successfully"}, status=200)  
        except Exception as e:
            return JsonResponse({"error": f"Error occurred: {str(e)}"}, status=500)
    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@api_view(['POST'])     
def delete_food_cards_items(request):
    if request.method == 'POST':
        FoodCard.objects.all().delete()
        return JsonResponse({"message": "Food cards deleted successfully"}, status=200)
    return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@api_view(['POST'])
def addFoodCardsFromExcel(request):
    if request.method == 'POST':
        
    # try:
        # Read Excel file from static folder
        file_names = ["__20250101.xlsx", "20250101_20250201.xlsx", "20250201_20250301.xlsx", "20250301_20250401.xlsx", "20250401_20250504.xlsx"]
        for file_name in file_names:
            excel_path = os.path.join(settings.BASE_DIR, 'static/DATABASE', file_name)
            print(f"This is the excel path: {excel_path}")
            df = pd.read_excel(excel_path)

            added_count = 0
            skipped_count = 0
            skipped_rows = []

            # Iterate through each row
            for index, row in df.iterrows():
                # try:
                fa_name = str(row[1])  # Get food code from column A
                card_calorie = str(row[8])  # Get card calorie from column I
                
                doctor = Doctor.objects.all().first()
                
                # Create new FoodCard instance
                food_card = FoodCard(FA_Name=fa_name, Calories=card_calorie, creator=doctor.django_user)

                # Add base card attributes
                for col_idx in range(8, 157):
                    col_name = df.columns[col_idx]
                    value = row[col_idx]

                    if hasattr(food_card, col_name):
                        setattr(food_card, col_name, value)


                # Set attributes for columns from index 158 onwards
                for col_idx in range(158, len(df.columns)):
                    col_name = df.columns[col_idx]
                    value = row[col_idx]

                    if hasattr(food_card, col_name):
                        # Set True if value is 0, False otherwise
                        setattr(food_card, col_name, value)

                food_card.save()
                added_count += 1
                

            # except Exception as e:
            #     skipped_count += 1
            #     skipped_rows.append(f"Row {index + 2}: {str(e)}")
            #     continue

        response_data = {
            "added_count": added_count,
            "skipped_count": skipped_count, 
            "skipped_rows": skipped_rows
        }

        return JsonResponse({
            "message": "Food cards added successfully",
            "data": response_data
        }, status=200)

        # except Exception as e:
        #     return JsonResponse({
        #         "error": f"Error occurred: {str(e)}"
        #     }, status=500)

    # return JsonResponse({'error': 'Invalid HTTP method'}, status=405)






@api_view(['POST'])
def updateTagggggg(request):
    if request.method == 'POST':
        
            
        # try:
            # Read Excel file from static folder
            excel_path = os.path.join(settings.BASE_DIR, 'static', 'tag_20250401_20250504.xlsx')
            print(f"This is the excel path: {excel_path}")
            df = pd.read_excel(excel_path)

            added_count = 0
            skipped_count = 0
            skipped_rows = []
            
            
            # Iterate through each row
            for index, row in df.iterrows():
                fa_name = str(row[1])  # Get food code from column A
                card_calorie = str(row[8])  # Get card calorie from column I
                
                doctor = Doctor.objects.all().first()
                
                # Find the food card
                food_card = FoodCard.objects.filter(FA_Name=fa_name, Calories=card_calorie, creator=doctor.django_user)[0]

                # Update parameters from columns 14-342
                for col_idx, value in enumerate(df.iloc[index], 14):
                    col_name = df.columns[col_idx]
                    
                    print(f"This is the column name: {col_name}")
                    print(f"This is the value: {value}")
                    
                    if hasattr(food_card, col_name):
                        # For columns 169-335, set True if value is 0, False otherwise
                        if 169 <= col_idx <= 335:
                            # allergens, bread, rice, salad, sport for loop
                            setattr(food_card, col_name, value == 0)
                        elif 336 <= col_idx <= 353:
                            # Diseases for loop
                            setattr(food_card, col_name, value != 0)
                        # For other columns, set value directly
                        else:
                            setattr(food_card, col_name, value)

                food_card.save()
                added_count += 1

                # # Add base card attributes
                # for col_idx in range(8, 157):
                #     col_name = df.columns[col_idx]
                #     value = row[col_idx]

                #     if hasattr(food_card, col_name):
                #         setattr(food_card, col_name, value)


                # # Set attributes for columns from index 158 onwards
                # for col_idx in range(158, len(df.columns)):
                #     col_name = df.columns[col_idx]
                #     value = row[col_idx]

                #     if hasattr(food_card, col_name):
                #         # Set True if value is 0, False otherwise
                #         setattr(food_card, col_name, value)

                food_card.save()
                added_count += 1
                

                # except Exception as e:
                #     skipped_count += 1
                #     skipped_rows.append(f"Row {index + 2}: {str(e)}")
                #     continue

            response_data = {
                "added_count": added_count,
                "skipped_count": skipped_count, 
                "skipped_rows": skipped_rows
            }

            return JsonResponse({
                "message": "Food cards added successfully",
                "data": response_data
            }, status=200)

        # except Exception as e:
        #     return JsonResponse({
        #         "error": f"Error occurred: {str(e)}"
        #     }, status=500)

    # return JsonResponse({'error': 'Invalid HTTP method'}, status=405)


@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules(request):
    print("\n=== Starting FoodCard Update Process ===")

    # Track statistics
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag__20250101_.xlsx", "tag_20250101_20250201.xlsx", "tag_20250201_20250301.xlsx", "tag_20250301_20250401.xlsx", "tag_20250401_20250504.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)





@csrf_exempt
@api_view(['POST'])
def process_food_card_foods(request):
    print("\n=== Starting FoodCard Foods Processing ===")
    
    # Track statistics
    processed_cards = 0
    skipped_cards = 0
    errors = []

    try:
        # Get all food cards
        food_cards = FoodCard.objects.all()
        print(f"Found {food_cards.count()} food cards to process")

        # Process each food card
        for food_card in food_cards:
            try:
                if food_card.foods:
                    # Convert string representation of foods to JSON
                    try:
                        # Replace single quotes with double quotes
                        foods_str = str(food_card.foods).replace("'", '"')
                        # Parse the JSON string
                        food_card.foods = json.loads(foods_str)
                        food_card.save()
                        processed_cards += 1
                        print(f"Successfully processed foods for FoodCard: {food_card.FA_Name}")
                    except json.JSONDecodeError as e:
                        print(f"JSON parsing error for FoodCard {food_card.FA_Name}: {str(e)}")
                        skipped_cards += 1
                        errors.append(f"FoodCard {food_card.FA_Name}: JSON parsing error - {str(e)}")
                else:
                    print(f"Skipping FoodCard {food_card.FA_Name} - no foods field")
                    skipped_cards += 1

            except Exception as e:
                print(f"Error processing FoodCard {food_card.FA_Name}: {str(e)}")
                skipped_cards += 1
                errors.append(f"FoodCard {food_card.FA_Name}: {str(e)}")

        print("\n=== Processing Completed ===")
        print(f"Total cards processed: {processed_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Processing completed',
            'stats': {
                'processed_cards': processed_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error in processing: {str(e)}")
        return JsonResponse({
            'error': f'Error in processing: {str(e)}'
        }, status=500)



@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules_tag_20250101(request):

    # Track statistics - 
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag__20250101_.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)


@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules_tag_20250101_20250201(request):

    # Track statistics -
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag_20250101_20250201.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)


@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules_tag_20250201_20250301(request):
    
    # Track statistics - 
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag_20250201_20250301.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)


@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules_tag_20250301_20250401(request):

    # Track statistics -
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag_20250301_20250401.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)


@api_view(['POST'])
def update_food_cards_from_excel_with_specific_rules_tag_20250401_20250504(request):

    # Track statistics - 
    updated_cards = 0
    skipped_cards = 0
    errors = []

    try:
        file_names = ["tag_20250401_20250504.xlsx"]
        for file_name in file_names:
            
            print(f"Analyzing file: {file_name}")
            
            excel_path = os.path.join(settings.BASE_DIR, 'static/tag_files', file_name)
            print(f"This is the excel path: {excel_path}")
                
            # Read the Excel file
            df = pd.read_excel(excel_path)
            print(f"\nExcel file loaded successfully. Number of rows: {len(df)}")
            
            # Get column headers
            headers = df.columns.tolist()
            print(f"\nColumn headers found: {headers}")
            
            # Use transaction to ensure atomicity
            with transaction.atomic():
                # Iterate through each row
                for index, row in df.iterrows():
                    print(f"\n--- Processing Row {index + 2} ---")
                    
                    # Get FA_Name and Calories for matching
                    fa_name = row.iloc[1]
                    calories = row.iloc[8]
                    print(f"Row data - FA_Name: {fa_name}, Calories: {calories}")

                    if pd.isna(fa_name) or pd.isna(calories):
                        skipped_cards += 1
                        errors.append(f"Row {index + 2}: Missing FA_Name or Calories")
                        print(f"SKIPPED: Missing FA_Name or Calories in row {index + 2}")
                        continue

                    # Find the corresponding FoodCard
                    food_cards = FoodCard.objects.filter(
                        FA_Name=fa_name,
                        Calories=float(calories)
                    )
                    for food_card in food_cards:
                        print(f"food card: {food_card} found and it is being edited")

                        if not food_card:
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: No matching FoodCard found for {fa_name} with {calories} calories")
                            print(f"SKIPPED: No matching FoodCard found for {fa_name} with {calories} calories")
                            continue

                        try:
                            
                            # Update food card fields
                            
                            if row.iloc[3] == 0:
                                food_card.main_dish_code = -1
                            else:
                                food_card.main_dish_code = row.iloc[3]
                                
                            food_card.Bread = row.iloc[15] == 1
                            food_card.rice = row.iloc[16] == 1
                            food_card.salad_main_dish = row.iloc[17] == 1
                            food_card.sport = row.iloc[18] == 1
                            food_card.AL_Dairy_Butter = row.iloc[19] == 0
                            food_card.AL_Dairy_Cheese = row.iloc[20] == 0
                            food_card.AL_Dairy_Coconut = row.iloc[21] == 0
                            food_card.AL_Dairy_CoconutMilk = row.iloc[22] == 0
                            food_card.AL_Dairy_Cream = row.iloc[23] == 0
                            food_card.AL_Dairy_CreamCheese = row.iloc[24] == 0
                            food_card.AL_Dairy_IceCream = row.iloc[25] == 0
                            food_card.AL_Dairy_Mayonnaise = row.iloc[26] == 0
                            food_card.AL_Dairy_Milk = row.iloc[27] == 0
                            food_card.AL_Dairy_Milk_Chocolate = row.iloc[28] == 0
                            food_card.AL_Dairy_Whey = row.iloc[29] == 0
                            food_card.AL_Dairy_Yogurt = row.iloc[30] == 0
                            food_card.AL_Egg = row.iloc[31] == 0
                            food_card.AL_Eggs_Egg = row.iloc[32] == 0
                            food_card.AL_Eggs_Mayonnaise = row.iloc[33] == 0
                            food_card.AL_Fish_Crab = row.iloc[34] == 0
                            food_card.AL_Fish_Fish = row.iloc[35] == 0
                            food_card.AL_Fish_Shrimp = row.iloc[36] == 0
                            food_card.AL_Fish_Tuna = row.iloc[37] == 0
                            food_card.AL_Grain_Barley = row.iloc[38] == 0
                            food_card.AL_Grain_Bean = row.iloc[39] == 0
                            food_card.AL_Grain_Buckwheat = row.iloc[40] == 0
                            food_card.AL_Grain_Chickpea = row.iloc[41] == 0
                            food_card.AL_Grain_Corn = row.iloc[42] == 0
                            food_card.AL_Grain_Lentil = row.iloc[43] == 0
                            food_card.AL_Grain_Mung = row.iloc[44] == 0
                            food_card.AL_Grain_Oat = row.iloc[45] == 0
                            food_card.AL_Grain_Oats = row.iloc[46] == 0
                            food_card.AL_Grain_Quinoa = row.iloc[47] == 0
                            food_card.AL_Grain_Rice = row.iloc[48] == 0
                            food_card.AL_Grain_Rye = row.iloc[49] == 0
                            food_card.AL_Grain_Soy = row.iloc[50] == 0
                            food_card.AL_Grain_Unspecified = row.iloc[51] == 0
                            food_card.AL_Grain_Wheat = row.iloc[52] == 0
                            food_card.AL_Grains_Wheat = row.iloc[53] == 0
                            food_card.AL_Legume_Beans = row.iloc[54] == 0
                            food_card.AL_Legume_Lentil = row.iloc[55] == 0
                            food_card.AL_Legume_Pea = row.iloc[56] == 0
                            food_card.AL_Legume_RedBean = row.iloc[57] == 0
                            food_card.AL_Legume_Soy = row.iloc[58] == 0
                            food_card.AL_Legume_Split_Peas = row.iloc[59] == 0
                            food_card.AL_Legume_SplitPea = row.iloc[60] == 0
                            food_card.AL_Meat_Bacon = row.iloc[61] == 0
                            food_card.AL_Meat_Beef = row.iloc[62] == 0
                            food_card.AL_Meat_Chicken = row.iloc[63] == 0
                            food_card.AL_Meat_Ham = row.iloc[64] == 0
                            food_card.AL_Meat_Lamb = row.iloc[65] == 0
                            food_card.AL_Meat_Pepperoni = row.iloc[66] == 0
                            food_card.AL_Meat_Pork = row.iloc[67] == 0
                            food_card.AL_Meat_Processed = row.iloc[68] == 0
                            food_card.AL_Meat_Sausage = row.iloc[69] == 0
                            food_card.AL_Meat_Turkey = row.iloc[70] == 0
                            food_card.AL_Meat_Unspecified = row.iloc[71] == 0
                            food_card.AL_Meat_Varies = row.iloc[72] == 0
                            food_card.AL_Meat_Various = row.iloc[73] == 0
                            food_card.AL_Nuts_Almond = row.iloc[74] == 0
                            food_card.AL_Nuts_Coconut = row.iloc[75] == 0
                            food_card.AL_Nuts_Hazelnut = row.iloc[76] == 0
                            food_card.AL_Nuts_Nuts = row.iloc[77] == 0
                            food_card.AL_Nuts_Peanut = row.iloc[78] == 0
                            food_card.AL_Nuts_Pine_Nuts = row.iloc[79] == 0
                            food_card.AL_Nuts_Pistachio = row.iloc[80] == 0
                            food_card.AL_Nuts_Sesame = row.iloc[81] == 0
                            food_card.AL_Nuts_Unspecified = row.iloc[82] == 0
                            food_card.AL_Nuts_Varies = row.iloc[83] == 0
                            food_card.AL_Nuts_Various = row.iloc[84] == 0
                            food_card.AL_Nuts_Walnut = row.iloc[85] == 0
                            food_card.AL_Poultry_Chicken = row.iloc[86] == 0
                            food_card.AL_Seeds_Chia = row.iloc[87] == 0
                            food_card.AL_Shellfish_Shrimp = row.iloc[88] == 0
                            food_card.AL_Dairy_Cream_Cheese = row.iloc[89] == 0
                            food_card.AL_Dairy_Creamer = row.iloc[90] == 0
                            food_card.AL_Dairy_Goat_Milk = row.iloc[91] == 0
                            food_card.AL_Dairy_Kashk = row.iloc[92] == 0
                            food_card.AL_Dairy_Kefir = row.iloc[93] == 0
                            food_card.AL_Eggs_Whole = row.iloc[94] == 0
                            food_card.AL_Eggs_Whole_Eggs = row.iloc[95] == 0
                            food_card.AL_Eggs_Yolk = row.iloc[96] == 0
                            food_card.AL_Fish_Anchovy = row.iloc[97] == 0
                            food_card.AL_Fish_Carp = row.iloc[98] == 0
                            food_card.AL_Fish_Catfish = row.iloc[99] == 0
                            food_card.AL_Fish_Caviar = row.iloc[100] == 0
                            food_card.AL_Fish_Croaker = row.iloc[101] == 0
                            food_card.AL_Fish_Flatfish = row.iloc[102] == 0
                            food_card.AL_Fish_Flounder = row.iloc[103] == 0
                            food_card.AL_Fish_Grouper = row.iloc[104] == 0
                            food_card.AL_Fish_Herring = row.iloc[105] == 0
                            food_card.AL_Fish_KingMackerel = row.iloc[106] == 0
                            food_card.AL_Fish_Mackerel = row.iloc[107] == 0
                            food_card.AL_Fish_Mullet = row.iloc[108] == 0
                            food_card.AL_Fish_Pike = row.iloc[109] == 0
                            food_card.AL_Fish_Porgy = row.iloc[110] == 0
                            food_card.AL_Fish_Roe = row.iloc[111] == 0
                            food_card.AL_Fish_Salmon = row.iloc[112] == 0
                            food_card.AL_Fish_Sardine = row.iloc[113] == 0
                            food_card.AL_Fish_Shark = row.iloc[114] == 0
                            food_card.AL_Fish_Snapper = row.iloc[115] == 0
                            food_card.AL_Fish_Swordfish = row.iloc[116] == 0
                            food_card.AL_Fish_Tilapia = row.iloc[117] == 0
                            food_card.AL_Fish_Trout = row.iloc[118] == 0
                            food_card.AL_Fish_Unspecified = row.iloc[119] == 0
                            food_card.AL_Fish_Whitefish = row.iloc[120] == 0
                            food_card.AL_Grain_Bulgur = row.iloc[121] == 0
                            food_card.AL_Grain_Cereal = row.iloc[122] == 0
                            food_card.AL_Grain_Millet = row.iloc[123] == 0
                            food_card.AL_Grain_Pea = row.iloc[124] == 0
                            food_card.AL_Grain_SplitPea = row.iloc[125] == 0
                            food_card.AL_Grains_Barley = row.iloc[126] == 0
                            food_card.AL_Grains_Brown_Rice = row.iloc[127] == 0
                            food_card.AL_Grains_Bulgur = row.iloc[128] == 0
                            food_card.AL_Grains_Chickpea = row.iloc[129] == 0
                            food_card.AL_Grains_Corn = row.iloc[130] == 0
                            food_card.AL_Grains_Millet = row.iloc[131] == 0
                            food_card.AL_Grains_Oats = row.iloc[132] == 0
                            food_card.AL_Grains_Rice = row.iloc[133] == 0
                            food_card.AL_Legume_Bean = row.iloc[134] == 0
                            food_card.AL_Legume_Chickpea = row.iloc[135] == 0
                            food_card.AL_Legume_Fava = row.iloc[136] == 0
                            food_card.AL_Legume_FavaBean = row.iloc[137] == 0
                            food_card.AL_Legume_Peas = row.iloc[138] == 0
                            food_card.AL_Legume_Unspecified = row.iloc[139] == 0
                            food_card.AL_Meat_Camel = row.iloc[140] == 0
                            food_card.AL_Meat_Duck = row.iloc[141] == 0
                            food_card.AL_Meat_Fat = row.iloc[142] == 0
                            food_card.AL_Meat_Fish = row.iloc[143] == 0
                            food_card.AL_Meat_Goose = row.iloc[144] == 0
                            food_card.AL_Meat_Ground = row.iloc[145] == 0
                            food_card.AL_Meat_Kidney = row.iloc[146] == 0
                            food_card.AL_Meat_Offal = row.iloc[147] == 0
                            food_card.AL_Meat_Organ = row.iloc[148] == 0
                            food_card.AL_Meat_Ostrich = row.iloc[149] == 0
                            food_card.AL_Meat_Pigeon = row.iloc[150] == 0
                            food_card.AL_Meat_Quail = row.iloc[151] == 0
                            food_card.AL_Meat_Sheep = row.iloc[152] == 0
                            food_card.AL_Meat_Veal = row.iloc[153] == 0
                            food_card.AL_Nuts_Acorn = row.iloc[154] == 0
                            food_card.AL_Nuts_Almonds = row.iloc[155] == 0
                            food_card.AL_Nuts_Cashew = row.iloc[156] == 0
                            food_card.AL_Nuts_Chestnut = row.iloc[157] == 0
                            food_card.AL_Nuts_Hazelnuts = row.iloc[158] == 0
                            food_card.AL_Nuts_Hemp = row.iloc[159] == 0
                            food_card.AL_Nuts_Mixed = row.iloc[160] == 0
                            food_card.AL_Nuts_Nutmeg = row.iloc[161] == 0
                            food_card.AL_Nuts_Peanuts = row.iloc[162] == 0
                            food_card.AL_Nuts_Pecan = row.iloc[163] == 0
                            food_card.AL_Other_Sesame = row.iloc[164] == 0
                            food_card.AL_Poultry_Duck = row.iloc[165] == 0
                            food_card.AL_Poultry_Offal = row.iloc[166] == 0
                            food_card.AL_Seafood_Fish = row.iloc[167] == 0
                            food_card.AL_Seeds_Cottonseed = row.iloc[168] == 0
                            food_card.AL_Seeds_Flax = row.iloc[169] == 0
                            food_card.AL_Seeds_Flaxseed = row.iloc[170] == 0
                            food_card.AL_Seeds_Poppy = row.iloc[171] == 0
                            food_card.AL_Seeds_Pumpkin = row.iloc[172] == 0
                            food_card.AL_Seeds_Safflower = row.iloc[173] == 0
                            food_card.AL_Seeds_Sesame = row.iloc[174] == 0
                            food_card.AL_Seeds_Sunflower = row.iloc[175] == 0
                            food_card.AL_Seeds_Watermelon = row.iloc[176] == 0
                            food_card.AL_Sesame_Sesame = row.iloc[177] == 0
                            food_card.AL_Soy_Soy = row.iloc[178] == 0
                            food_card.AL_Soy_SoySauce = row.iloc[179] == 0
                            food_card.AL_Soy_Soybean = row.iloc[180] == 0
                            food_card.AL_Soy_Soybeans = row.iloc[181] == 0
                            
                            food_card.Disease_Diabetes = row.iloc[181] != 0
                            food_card.Disease_High_blood_pressure = row.iloc[182] != 0
                            food_card.Disease_High_cholesterol = row.iloc[183] != 0
                            food_card.Disease_CVD = row.iloc[184] != 0
                            food_card.Disease_Kidney = row.iloc[185] != 0
                            food_card.Disease_Celiac = row.iloc[186] != 0
                            food_card.Disease_IBS = row.iloc[187] != 0
                            food_card.Disease_IBD = row.iloc[188] != 0
                            food_card.Disease_Gout = row.iloc[189] != 0
                            food_card.Disease_Lactose_Intolerance = row.iloc[190] != 0
                            food_card.Disease_NAFLD = row.iloc[191] != 0
                            food_card.Disease_Anemia = row.iloc[192] != 0
                            food_card.Disease_Osteoporosis = row.iloc[193] != 0
                            food_card.Disease_Arthritis = row.iloc[194] != 0
                            food_card.Disease_Hypothyroidism = row.iloc[195] != 0
                            food_card.Disease_Autoimmune = row.iloc[196] != 0
                            food_card.Disease_CancerPrevention = row.iloc[197] != 0
                            food_card.Disease_MentalHealth = row.iloc[198] != 0

                            print(f"\nSaving FoodCard: {food_card}")
                            food_card.save()
                            updated_cards += 1
                            print(f"Successfully updated FoodCard: {food_card}")

                        except Exception as e:
                            print(f"Error updating food card: {str(e)}")
                            skipped_cards += 1
                            errors.append(f"Row {index + 2}: Error updating food card - {str(e)}")

        print("\n=== Update Process Completed ===")
        print(f"Total cards updated: {updated_cards}")
        print(f"Total cards skipped: {skipped_cards}")
        print(f"Total errors: {len(errors)}")
        if errors:
            print("\nErrors encountered:")
            for error in errors:
                print(f"- {error}")

        return JsonResponse({
            'message': 'Update completed',
            'stats': {
                'updated_cards': updated_cards,
                'skipped_cards': skipped_cards,
                'errors': errors
            }
        }, status=200)

    except Exception as e:
        print(f"Error processing file: {str(e)}")
        return JsonResponse({
            'error': f'Error processing file: {str(e)}'
        }, status=500)


