from django.urls import path
from APIs.views import views, user, report, DBAccess, list, Comments, update, Edit, freeStyle, firebase, diet, comment_api
from APIs import resources
# from panel import coach_telegram_bot
from django.views.decorators.csrf import csrf_exempt
from panel.view import coach_login
from APIs.views.script_runner import ExecuteScriptView
from APIs import generate_free_diet
from ziluck_project.settings import BOT_TOKEN

urlpatterns = [
    path('user/activation_code/', user.activation_code),
    path('user/activation_code/debuging/', user.activation_code_debuging),
    path('user/check/number/', user.checkNumber),  # todo: you can remove this line after release
    path('user/check/phone/exists/', user.check_phone_exists),
    # path('user/check/user/registration/', user.checkRegistration),

    path('coach/login/', coach_login),
    path('user/sign/', user.sign),
    path('user/create/hospital/', user.create_hospital_user),
    path('user/login/', user.LogIn),
    path('user/logout/', user.LogOut),
    path('user/profile_info', user.profile_info),
    path('user/profile_info/update/', user.profile_info_update),
    path('user/profile_info/updateeee/', user.profile_info_update),
    path('user/profile_info/image/', user.send_profile_image),
    path('user/profile_info/update/weight/', user.update_weight),
    path('user/questionnaire', user.user_questionnaire),
    path('questionnaire', user.questionnaire),
    path('user/profile_info/register/to/site/', user.registerToSite),
    path('user/settings', user.settings),
    path('user/check/', user.check),
    path('user/update/last/login/', user.update_last_login),
    path('user/test/recommendation/engine/', user.test_recommendation_engine),
    path('user/acquisition/update/', user.update_acquisition_source),
    path('user/acquisition/sources/', user.get_acquisition_sources),
    # path('user/comment/', user.CommentHandler),-----------

    # Resource Hub APIs
    path('resources/categories/', resources.categories),
    path('resources/categories/<int:category_id>/', resources.category_detail),
    path('resources/category/<str:category_name>/', resources.resources_by_category_name),
    path('resources/', resources.resources),
    path('resources/<int:resource_id>/', resources.resource_detail),
    path('resources/interaction/', resources.mark_resource_interaction),
    path('resources/unseen/', resources.unseen_resources),
    path('resources/featured/', resources.featured_resources),
    path('resources/progress/', resources.user_progress),

    path('report/activities', report.activities_log),
    path('report/activities/edit/', Edit.edit_activity),
    path('report/activities/delete/', Edit.delete_actiity),
    path('report/eating', report.eating),
    path('report/eating/with/pic/', report.insertFoodWithPic),
    path('report/Foodstuffs/', report.getFoodstuffs),
    path('report/insulin', report.insulinUse),
    path('report/insulin/delete/', Edit.delete_insulin),
    path('report/insulin/edit/', Edit.edit_insulin),
    path('report/sleep/delete/', Edit.delete_sleep),
    path('report/freestyle/with/pic/', freeStyle.freeStyle),
    path('report/feel', report.feel),
    path('report/drug', report.drugUsage),
    path('report/glp1/', report.glp1Usage),
    path('report/sugar', report.sugar),
    path('report/sugar/glocometer/', report.glocometer_with_image),
    path('report/eating/delete/', Edit.delete_eating),
    path('report/sugar/delete/', Edit.delete_sugar),
    path('report/sugar/edit/', Edit.edit_sugar),
    path('report/a1c/', report.a_one_c),
    path('report/blood/pressure/', report.blood_pressure),
    path('report/blood/pressure/edit/', Edit.edit_blood_pressure),
    path('report/blood/pressure/delete/', Edit.delete_blood_pressure),
    path('report/points', report.points),
    path('report/last/thirty/days/points/', report.last_thirty_days_points),
    path('report/generate/', report.generateReport),
    path('report/summary', report.reports),
    path('report/sleep/report', report.sleep_report),
    path('report/bmi', report.bmi),
    path('report/hei/params/', report.getHEIParams),
    path('report/macro_nutrients_distribution', report.macro_nutrients_distribution),
    path('report/reports/steps', report.steps),
    path('report/reports/toDay', report.reportToDay),
    path('report/reports/weekly', report.reportWeekly),
    path('report/reports/api', report.report_api),
    path('report/Top/scores/', report.Top_scores),
    path('report/add/water', report.add_water),
    path('report/get/water', report.get_water),
    path('report/add/weight', report.add_weight),
    path('report/get/weight', report.get_weight),
    path('report/wellness_summary/', report.get_wellness_summary),
    path('report/blood/test/generate/', report.generate_blood_test_report),
    path('report/food/recommendations/disease/', report.get_food_recommendations_by_disease),
    path('report/food/recommendations/cached/', report.get_cached_food_recommendations),
    path('report/food/suggestions/by/mc/', report.get_food_suggestions_by_mc),
    path('report/food/list/dislike/', report.food_list_dislike),
    path('diet/list/', diet.diet),

    # Payment Plans API
    path('payment/plans/', views.payment_plans_api, name='payment-plans-api'),

    path('list/drugs/', list.drugList),
    path('list/add/to/favorite/drugs/', list.addToFavoritDrugs),
    path('list/delete/from/favorite/drugs/', list.deleteFromFavoritDrugs),
    path('list/favorite/drugs/', list.FavoritDrugs),

    path('list/foods', list.foodList),
    path('list/foods/check/for/update/', list.checkFoodUpdate),
    path('list/add/to/favorite/foods/', list.addToFavoritFoods),
    path('list/delete/from/favorite/foods/', list.deleteFromFavoritFoods),
    path('list/favorite/foods/', list.FavoritFoods),

    path('list/activities', list.activities),
    path('list/add/to/favorite/activities/', list.addToFavoritActivities),
    path('list/delete/from/favorite/activities/', list.deleteFromFavoritActivities),
    path('list/favorite/activities/', list.favoritActivities),

    path('list/insulins', list.insulinList),
    path('list/insulins/short_effect', list.short_effect_insulinList),
    path('list/insulins/long_effect', list.long_effect_insulinList),
    path('list/insulins/mixed_effect/', list.mixed_effect_insulinList),

    path('list/glp1/', list.glp1List),

    path('list/doctors/', list.doctorsList),

    path('list/drugstore/', list.get_drugstore_list),

    path('DB/activity', DBAccess.activity),
    path('DB/Adding/activity/from/excel/', DBAccess.AddingActivityFromExcel),
    path('DB/Adding/drugs/from/excel/', DBAccess.AddingDrugFromExcel),
    path('DB/Adding/glp1/from/excel/', DBAccess.AddingGLP1FromExcel),
    path('DB/Adding/insulins/from/excel/', DBAccess.AddingInsulinsFromExcel),
    path('DB/Adding/diabetes/info/from/excel/', DBAccess.AddingDiabetesInfoFromExcel),
    path('DB/food', DBAccess.food),
    path('DB/insulin', DBAccess.insulin),
    path('DB/drug', DBAccess.drug),

    path('check/for/update/', update.checkForUpdate),
    path('check/meal/parameters/', report.check_meal_parameters),

    path('list/notifications/', list.notifications),
    path('delete/user/', DBAccess.deleteUser),

    path('message/send/', Comments.sendMessage),
    path('message/recent/', Comments.getRecentMessage),

    path('random/diabetes/info/', list.getRandomInfo),


    # path('telegram/bot/idia/main/bot/', csrf_exempt(coach_telegram_bot.start)),
    # path('telegram/set/webhook/zz', coach_telegram_bot.set_webhook),

    # path('telegram/set/webhook/ziluck/', coach_telegram_bot.set_idia_webhook),
    # path('telegram/set/webhook/ziluck/response/', csrf_exempt(coach_telegram_bot.response)),

    path('test/parallel/', DBAccess.parallel),
    path('firebase/lastweek/', firebase.send_notification_to_not_active_last_week),
    path('firebase/send/link/to/all/', firebase.send_notification_with_link_to_all),
    path('firebase/send/note/', firebase.send_notification_note),

    path('execute-script/', ExecuteScriptView.as_view(), name='execute_script'),

    path('api/generate/', generate_free_diet.generate, name='generate_api'),
    
    path('add/summer/food/cards/', user.add_summer_food_cards),
    path('test/wellness/report/', user.wellness_report),
    path('user/mood/store/', user.store_mood),
    path('user/breath_work/log/', user.log_breath_work),
    path('user/mindfulness/', user.mindfulness),
    path('user/suggest/food/card/', user.suggest_food_card),
    
    # Timeslot payment endpoints
    path('timeslot/purchase/with/coins/', user.purchase_timeslot_with_coins),
    path('timeslot/payment/link/', user.get_timeslot_payment_link),
    
    # Comment endpoints
    path('comments/post/', comment_api.post_comment),
    path('comments/get/', comment_api.get_comments),
    path('comments/user/', comment_api.get_user_comments),
    
    # Timeslot payment endpoints
    path('timeslot/available/for/purchase/', user.get_available_timeslots_for_purchase),
    path('timeslot/user/purchased/', user.get_user_purchased_timeslots),
    path('timeslot/user/interface/', user.user_timeslot_interface),
    path('debug/timeslot/purchases/', user.debug_timeslot_purchases),
    
    # Doctor timeslot management endpoints
    path('doctor/timeslot/create/', user.doctor_create_timeslot_for_purchase),
    path('doctor/timeslot/purchased/', user.doctor_get_purchased_timeslots),
    path('doctor/timeslot/assign/', user.doctor_assign_timeslot_to_therapist),
    path('doctor/therapists/available/', user.doctor_get_available_therapists),

    # Meeting session verification endpoints
    path('meeting/verify/access/', user.verify_meeting_session_access),
    path('meeting/verify/by/token/', user.verify_meeting_session_by_token),
    path('meeting/check/upcoming/', user.check_upcoming_meeting),

]
