import platform

server = platform.version()
print("running in", server)

if "#48-Ubuntu" in server:
    import os
    import django
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
    django.setup()
else:
    import os
    import sys
    import django
    sys.path.append('/home/idiair/.ziluck310')
    os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
    django.setup()


if __name__ == '__main__':
    from APIs.models import UserQuestionnaire
    from datetime import datetime
    answers = UserQuestionnaire.objects.all()
    name = f'outputs/test1_{datetime.now().strftime("%Y_%m_%d_%H_%M")}.csv'
    file = open(name, 'w', encoding='utf-8')
    for item in answers:
        user = item.user
        json = item.QandA
        line = f"{user},"
        for Q in json:
            line += f"{Q},{json[Q]},"
        line += "\n"
        file.write(line)
    file.close()

