import platform

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck38')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()

init()


from APIs.models import Diet
from panel.models import Assistant
from payment.models import Discount, ZarinPalPayment
from datetime import datetime

mghods = Assistant.objects.filter(telegram_chat_id=343198342)[0].django_user
mtabesh = Assistant.objects.filter(telegram_chat_id=128752737)[0].django_user
# discount = Discount.objects.filter(code="NESTLE")[0]
# payments = ZarinPalPayment.objects.filter(discount=discount)

dietss = Diet.objects.filter(from_date=datetime(2025, 2, 15))








































# -----------------------------------------
# 1) HELPER FUNCTIONS
# -----------------------------------------
def get_category(total_energy, categories=None, tolerance=100):
    """
    Returns the matched category (e.g., 1200)
    if total_energy is within ±tolerance of one of the category values.
    Otherwise returns None.
    """


    if categories is None:
        categories = [1200, 1400, 1600, 1800, 2000, 2200, 2400]

    for cat in categories:
        if abs(total_energy - cat) <= tolerance:
            print("This is category", cat)
            return cat
    return None


def calculate_total_energy(diet_obj):
    """
    Given the JSON from diet_obj['diet_json'],
    calculate total energy by summing
    the FIRST day's energy for each meal type
    (breakfast, lunch, dinner, snack1, snack2).
    """
    meal_types = ["breakfast", "lunch", "dinner", "snack1", "snack2"]
    total_energy = 0.0

    # 1) Get the 'week1' portion
    week1_data = diet_obj.get("week1", {})

    for meal_type in meal_types:
        meal_list = week1_data.get(meal_type, [])

        if not meal_list:
            continue  # No data for this meal

        # 2) Only take the first day (index 0)
        day1_meal = meal_list[0]  # e.g. { "title": "...", "ingredient": [...] }

        # 3) Sum up the 'energy' of each item in 'ingredient'
        ingredients = day1_meal.get("ingredient", [])
        meal_energy = sum(item.get("energy", 0.0) for item in ingredients)

        total_energy += meal_energy


    return total_energy


# -----------------------------------------
# 2) REPLACEMENT LUNCH (SAMPLE)
# -----------------------------------------
# This is just an example structure. You can replace it
# with actual data you want to store in `diet_json["week1"]["lunch"]`.
SAMPLE_LUNCH_REPLACEMENT = [
    [
        {
            "title": "Replaced Lunch Example",
            "ingredient": [
                {
                    "name": "Replacement Chicken",
                    "home_unit": "grams",
                    "amount_in_home_unit": 150,
                    "amount_g": 150,
                    "protein": 30,
                    "energy": 250,
                    "carbohydrate": 5,
                    "fat": 10,
                    "food_code": 99999999
                }
            ]
        }
    ]
]


# -----------------------------------------
# 3) MAIN COMMAND OR SCRIPT LOGIC
# -----------------------------------------
class Command():
    help = "Process and update diets based on total energy categorization."

    def handle(self, *args, **options):
        self.process_all_diets(diets)

    def process_all_diets(self, diets):
        # Fetch all Diet objects
        # diets = Diet.objects.all()

        for diet in diets:
            if not diet.diet_json:
                # If there's no JSON, skip
                continue

            # Parse the JSON object from the model
            # (It's already a Python dict if using JSONField,
            #  but let's be safe if you're on older Django versions)
            diet_data = diet.diet_json

            # Calculate total energy
            total_energy = calculate_total_energy(diet_data)

            # Check which category this total_energy matches
            category = get_category(total_energy)

            if category is not None:
                # Example: If total_energy is ~1200 +/- 60, category = 1200
                # Then replace lunch in 'week1'
                if "week1" in diet_data:
                    diet_data["week1"]["lunch"] = SAMPLE_LUNCH_REPLACEMENT

                # Assign updated JSON back to the model
                diet.diet_json = diet_data

                # Save changes
                diet.save()

                self.stdout.write(
                    self.style.SUCCESS(
                        f"Updated diet (ID: {diet.id}) with category {category}. Lunch replaced."
                    )
                )
            else:
                # Not in any category ± 60
                self.stdout.write(f"Diet (ID: {diet.id}) not in ±60 range of the known categories.")


























first_choice_1200 = {
          "title": "خورش قورمه سبزی و سالاد شیرازی",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 2,
              "amount_g": 60,
              "protein": 18.92,
              "energy": 114.6,
              "carbohydrate": 0,
              "fat": 3.72,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 12,
              "amount_g": 84,
              "protein": 2.26,
              "energy": 109.2,
              "carbohydrate": 23.66,
              "fat": 0.24,
              "food_code": 20345
            },
            {
              "name": "خورش قورمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 6,
              "amount_g": 90,
              "protein": 9,
              "energy": 94.5,
              "carbohydrate": 23.54,
              "fat": 2.79,
              "food_code": 9880000
            },
            {
              "name": "سالاد شیرازی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 7,
              "amount_g": 105,
              "protein": 0.72,
              "energy": 37.8,
              "carbohydrate": 3.93,
              "fat": 2.44,
              "food_code": 9880089
            }
          ]
        }

first_choice_1400 = {
          "title": "خورش قورمه سبزی و سالاد شیرازی",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 3,
              "amount_g": 90,
              "protein": 28.39,
              "energy": 171.9,
              "carbohydrate": 0,
              "fat": 5.58,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 10,
              "amount_g": 70,
              "protein": 1.88,
              "energy": 91,
              "carbohydrate": 19.72,
              "fat": 0.2,
              "food_code": 20345
            },
            {
              "name": "خورش قورمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 6,
              "amount_g": 90,
              "protein": 9,
              "energy": 94.5,
              "carbohydrate": 23.54,
              "fat": 2.79,
              "food_code": 9880000
            },
            {
              "name": "سالاد شیرازی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 9,
              "amount_g": 135,
              "protein": 0.93,
              "energy": 48.6,
              "carbohydrate": 5.05,
              "fat": 3.13,
              "food_code": 9880089
            }
          ]
        }

first_choice_1600 = {
          "title": "خورش قورمه سبزی با سبزی خوردن",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 4,
              "amount_g": 120,
              "protein": 37.85,
              "energy": 229.2,
              "carbohydrate": 0,
              "fat": 7.44,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 12,
              "amount_g": 84,
              "protein": 2.26,
              "energy": 109.2,
              "carbohydrate": 23.66,
              "fat": 0.24,
              "food_code": 20345
            },
            {
              "name": "خورش قرمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 7,
              "amount_g": 105,
              "protein": 10.5,
              "energy": 110.25,
              "carbohydrate": 27.46,
              "fat": 3.26,
              "food_code": 9880000
            },
            {
              "name": "سبزی خوردن",
              "home_unit": "پیش دستی",
              "amount_in_home_unit": 1,
              "amount_g": 24,
              "protein": 0.76,
              "energy": 5.52,
              "carbohydrate": 0.64,
              "fat": 0.15,
              "food_code": 2044
            }
          ]
        }

first_choice_1800 = {
          "title": "خورش قورمه سبزی با سالاد کلم",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 4,
              "amount_g": 120,
              "protein": 37.85,
              "energy": 229.2,
              "carbohydrate": 0,
              "fat": 7.44,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 15,
              "amount_g": 105,
              "protein": 2.82,
              "energy": 136.5,
              "carbohydrate": 29.58,
              "fat": 0.29,
              "food_code": 20345
            },
            {
              "name": "خورش قرمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 8,
              "amount_g": 120,
              "protein": 12,
              "energy": 126,
              "carbohydrate": 31.38,
              "fat": 3.72,
              "food_code": 9880000
            },
            {
              "name": "سالاد کلم بدون سس",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 9,
              "amount_g": 90,
              "protein": 1.32,
              "energy": 54.9,
              "carbohydrate": 5.63,
              "fat": 3.45,
              "food_code": 9980324
            }
          ]
        }

first_choice_2000 = {
          "title": "خورش قورمه سبزی با سالاد فصل",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 5,
              "amount_g": 150,
              "protein": 47.31,
              "energy": 286.5,
              "carbohydrate": 0,
              "fat": 9.3,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 16,
              "amount_g": 112,
              "protein": 3.01,
              "energy": 145.6,
              "carbohydrate": 31.55,
              "fat": 0.31,
              "food_code": 20345
            },
            {
              "name": "خورش قرمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 8,
              "amount_g": 120,
              "protein": 12,
              "energy": 126,
              "carbohydrate": 31.38,
              "fat": 3.72,
              "food_code": 9880000
            },
            {
              "name": "سالاد فصل",
              "home_unit": "پیش دستی",
              "amount_in_home_unit": 1,
              "amount_g": 77,
              "protein": 0.9,
              "energy": 27.72,
              "carbohydrate": 4.3,
              "fat": 1.12,
              "food_code": 14054
            },
            {
              "name": "لیمو ترش",
              "home_unit": "عدد",
              "amount_in_home_unit": 0.5,
              "amount_g": 42,
              "protein": 0.46,
              "energy": 12.18,
              "carbohydrate": 3.92,
              "fat": 0.13,
              "food_code": 9326
            }
          ]
        }

first_choice_2200 = {
          "title": "خورش قورمه سبزی با ماست و خیار",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 5,
              "amount_g": 150,
              "protein": 47.31,
              "energy": 286.5,
              "carbohydrate": 0,
              "fat": 9.3,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 18,
              "amount_g": 126,
              "protein": 3.39,
              "energy": 163.8,
              "carbohydrate": 35.49,
              "fat": 0.35,
              "food_code": 20345
            },
            {
              "name": "خورش قرمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 8,
              "amount_g": 120,
              "protein": 12,
              "energy": 126,
              "carbohydrate": 31.38,
              "fat": 3.72,
              "food_code": 9880000
            },
            {
              "name": "ماست و خیار",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 11,
              "amount_g": 165,
              "protein": 5.78,
              "energy": 74.25,
              "carbohydrate": 8.25,
              "fat": 1.65,
              "food_code": 99900520
            }
          ]
        }

first_choice_2400 = {
          "title": "خورش قورمه سبزی با دوغ کفیر",
          "ingredient": [
            {
              "name": "گوشت سر دست پخته",
              "home_unit": "قوطی کبریت",
              "amount_in_home_unit": 4,
              "amount_g": 120,
              "protein": 37.85,
              "energy": 229.2,
              "carbohydrate": 0,
              "fat": 7.44,
              "food_code": 17277
            },
            {
              "name": "برنج پخته",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 20,
              "amount_g": 140,
              "protein": 3.77,
              "energy": 182,
              "carbohydrate": 39.43,
              "fat": 0.4,
              "food_code": 20345
            },
            {
              "name": "خورش قرمه سبزی",
              "home_unit": "قاشق غذاخوری",
              "amount_in_home_unit": 7,
              "amount_g": 105,
              "protein": 10.5,
              "energy": 110.25,
              "carbohydrate": 27.46,
              "fat": 3.26,
              "food_code": 9880000
            },
            {
              "name": "دوغ کفیر",
              "home_unit": "لیوان",
              "amount_in_home_unit": 2,
              "amount_g": 480,
              "protein": 15.89,
              "energy": 192,
              "carbohydrate": 21.36,
              "fat": 4.22,
              "food_code": 14036
            }
          ]
        }





second_choice_1200 = {
        "title": "عدس پلو با سالاد فصل",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 8,
                "amount_g": 120,
                "protein": 9.05,
                "energy": 296.4,
                "carbohydrate": 40.81,
                "fat": 10.84,
                "food_code": 9880039
            },
            {
                "name": "سالاد فصل",
                "home_unit": "پیش دستی",
                "amount_in_home_unit": 1,
                "amount_g": 77,
                "protein": 0.9,
                "energy": 27.72,
                "carbohydrate": 4.3,
                "fat": 1.12,
                "food_code": 14054
            },
            {
                "name": "لیمو ترش",
                "home_unit": "عدد",
                "amount_in_home_unit": 1,
                "amount_g": 84,
                "protein": 0.92,
                "energy": 24.36,
                "carbohydrate": 7.83,
                "fat": 0.25,
                "food_code": 9326
            }
        ]
    }

second_choice_1400 = {
        "title": "عدس پلو با سالاد کلم",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 10,
                "amount_g": 150,
                "protein": 11.31,
                "energy": 370.5,
                "carbohydrate": 51.01,
                "fat": 13.54,
                "food_code": 9880039
            },
            {
                "name": "سالاد کلم بدون سس",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 6,
                "amount_g": 60,
                "protein": 0.88,
                "energy": 36.6,
                "carbohydrate": 3.75,
                "fat": 2.3,
                "food_code": 9980324
            }
        ]
    }

second_choice_1600 = {
        "title": "عدس پلو با زیتون",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 11,
                "amount_g": 165,
                "protein": 12.44,
                "energy": 407.55,
                "carbohydrate": 56.12,
                "fat": 14.9,
                "food_code": 9880039
            },
            {
                "name": "زیتون",
                "home_unit": "عدد",
                "amount_in_home_unit": 10,
                "amount_g": 38,
                "protein": 0.31,
                "energy": 43.7,
                "carbohydrate": 2.37,
                "fat": 4.06,
                "food_code": 9193
            }
        ]
    }

second_choice_1800 = {
        "title": "عدس پلو و سالاد شیرازی",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 14,
                "amount_g": 210,
                "protein": 15.83,
                "energy": 518.7,
                "carbohydrate": 71.42,
                "fat": 18.96,
                "food_code": 9880039
            },
            {
                "name": "سالاد شیرازی",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 6,
                "amount_g": 90,
                "protein": 0.62,
                "energy": 32.4,
                "carbohydrate": 3.37,
                "fat": 2.08,
                "food_code": 9880089
            }
        ]
    }

second_choice_2000 = {
        "title": "عدس پلو با ماست و خیار",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 15,
                "amount_g": 225,
                "protein": 16.96,
                "energy": 555.75,
                "carbohydrate": 76.52,
                "fat": 20.32,
                "food_code": 9880039
            },
            {
                "name": "ماست و خیار",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 6,
                "amount_g": 90,
                "protein": 3.15,
                "energy": 40.5,
                "carbohydrate": 4.5,
                "fat": 0.9,
                "food_code": 99900520
            }
        ]
    }

second_choice_2200 = {
        "title": "عدس پلو با سبزی خوردن",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 17,
                "amount_g": 255,
                "protein": 19.23,
                "energy": 629.85,
                "carbohydrate": 86.73,
                "fat": 23.03,
                "food_code": 9880039
            },
            {
                "name": "سبزی خوردن",
                "home_unit": "پیش دستی",
                "amount_in_home_unit": 2,
                "amount_g": 48,
                "protein": 1.52,
                "energy": 11.04,
                "carbohydrate": 1.28,
                "fat": 0.3,
                "food_code": 2044
            }
        ]
    }

second_choice_2400 = {
        "title": "عدس پلو با سالاد فصل",
        "ingredient": [
            {
                "name": "عدس پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 16,
                "amount_g": 240,
                "protein": 18.1,
                "energy": 592.8,
                "carbohydrate": 81.62,
                "fat": 21.67,
                "food_code": 9880039
            },
            {
                "name": "سالاد فصل",
                "home_unit": "پیش دستی",
                "amount_in_home_unit": 1,
                "amount_g": 77,
                "protein": 0.9,
                "energy": 27.72,
                "carbohydrate": 4.29,
                "fat": 1.11,
                "food_code": 14054
            },
            {
                "name": "لیمو ترش",
                "home_unit": "عدد",
                "amount_in_home_unit": 1,
                "amount_g": 84,
                "protein": 0.92,
                "energy": 24.36,
                "carbohydrate": 7.83,
                "fat": 0.25,
                "food_code": 9326
            },
            {
                "name": "روغن زیتون",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 0.5,
                "amount_g": 7,
                "protein": 0,
                "energy": 62,
                "carbohydrate": 0,
                "fat": 7,
                "food_code": 4053
            }
        ]
    }

third_choice_1200 = {
        "title": "شوید پلو با مرغ و سالاد شیرازی",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 8,
                "amount_g": 120,
                "protein": 2.89,
                "energy": 159.6,
                "carbohydrate": 30.36,
                "fat": 2.89,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 3,
                "amount_g": 90,
                "protein": 25.99,
                "energy": 143.1,
                "carbohydrate": 0,
                "fat": 3.59,
                "food_code": 5042
            },
            {
                "name": "سالاد شیرازی",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 8,
                "amount_g": 120,
                "protein": 0.83,
                "energy": 43.2,
                "carbohydrate": 4.49,
                "fat": 2.79,
                "food_code": 9880089
            }
        ]
    }

third_choice_1400 = {
        "title": "شوید پلو با مرغ و زیتون",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 10,
                "amount_g": 150,
                "protein": 3.62,
                "energy": 199.5,
                "carbohydrate": 37.95,
                "fat": 3.62,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 3,
                "amount_g": 90,
                "protein": 25.99,
                "energy": 143.1,
                "carbohydrate": 0,
                "fat": 3.58,
                "food_code": 5042
            },
            {
                "name": "زیتون",
                "home_unit": "عدد",
                "amount_in_home_unit": 12,
                "amount_g": 45.6,
                "protein": 0.38,
                "energy": 52.44,
                "carbohydrate": 2.85,
                "fat": 4.87,
                "food_code": 9193
            }
        ]
    }

third_choice_1600 = {
        "title": "شوید پلو با مرغ و سالاد تبوله",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 14,
                "amount_g": 210,
                "protein": 5.06,
                "energy": 279.3,
                "carbohydrate": 53.13,
                "fat": 5.06,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 3,
                "amount_g": 90,
                "protein": 25.99,
                "energy": 143.1,
                "carbohydrate": 0,
                "fat": 3.58,
                "food_code": 5042
            },
            {
                "name": "سالاد تبوله",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 8,
                "amount_g": 76,
                "protein": 0.89,
                "energy": 25.84,
                "carbohydrate": 4.16,
                "fat": 0.97,
                "food_code": 9980344
            }
        ]
    }

third_choice_1800 = {
        "title": "شوید پلو با مرغ و ماست و خیار",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 17,
                "amount_g": 255,
                "protein": 6.15,
                "energy": 339.15,
                "carbohydrate": 64.52,
                "fat": 6.15,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 3,
                "amount_g": 90,
                "protein": 25.99,
                "energy": 143.1,
                "carbohydrate": 0,
                "fat": 3.59,
                "food_code": 5042
            },
            {
                "name": "ماست و خیار",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 11,
                "amount_g": 165,
                "protein": 5.78,
                "energy": 74.25,
                "carbohydrate": 8.25,
                "fat": 1.65,
                "food_code": 99900520
            }
        ]
    }

third_choice_2000 = {
        "title": "شوید پلو با مرغ و سبزی خوردن",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 18,
                "amount_g": 270,
                "protein": 6.51,
                "energy": 359.1,
                "carbohydrate": 68.31,
                "fat": 6.51,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 5,
                "amount_g": 150,
                "protein": 43.32,
                "energy": 238.5,
                "carbohydrate": 0,
                "fat": 5.98,
                "food_code": 5042
            },
            {
                "name": "سبزی خوردن",
                "home_unit": "پیش دستی",
                "amount_in_home_unit": 1,
                "amount_g": 24,
                "protein": 0.76,
                "energy": 5.52,
                "carbohydrate": 0.64,
                "fat": 0.15,
                "food_code": 2044
            }
        ]
    }

third_choice_2200 = {
        "title": "شوید پلو با مرغ و سالاد کلم",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 18,
                "amount_g": 270,
                "protein": 6.51,
                "energy": 359.1,
                "carbohydrate": 68.31,
                "fat": 6.51,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 5,
                "amount_g": 150,
                "protein": 43.32,
                "energy": 238.5,
                "carbohydrate": 0,
                "fat": 5.98,
                "food_code": 5042
            },
            {
                "name": "سالاد کلم بدون سس",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 7,
                "amount_g": 70,
                "protein": 1.03,
                "energy": 42.7,
                "carbohydrate": 4.38,
                "fat": 2.68,
                "food_code": 9980324
            }
        ]
    }

third_choice_2400 = {
        "title": "شوید پلو با مرغ و بورانی اسفناج",
        "ingredient": [
            {
                "name": "شوید پلو",
                "home_unit": "قاشق غذاخوری",
                "amount_in_home_unit": 17,
                "amount_g": 255,
                "protein": 6.14,
                "energy": 339.15,
                "carbohydrate": 64.52,
                "fat": 6.14,
                "food_code": 9880267
            },
            {
                "name": "سینه مرغ پخته شده",
                "home_unit": "قوطی کبریت",
                "amount_in_home_unit": 5,
                "amount_g": 150,
                "protein": 43.32,
                "energy": 238.5,
                "carbohydrate": 0,
                "fat": 5.99,
                "food_code": 5042
            },
            {
                "name": "بورانی اسفناج",
                "home_unit": "پیاله کوچک",
                "amount_in_home_unit": 1,
                "amount_g": 116,
                "protein": 6.8,
                "energy": 127.6,
                "carbohydrate": 8.6,
                "fat": 8.02,
                "food_code": 9990507
            }
        ]
    }








category_special_choices = {
    1200: (first_choice_1200, second_choice_1200, third_choice_1200),
    1400: (first_choice_1400, second_choice_1400, third_choice_1400),
    1600: (first_choice_1600, second_choice_1600, third_choice_1600),
    1800: (first_choice_1800, second_choice_1800, third_choice_1800),
    2000: (first_choice_2000, second_choice_2000, third_choice_2000),
    2200: (first_choice_2200, second_choice_2200, third_choice_2200),
    # 2400: (first_choice_2400, second_choice_2400) if needed
}





lunch_template_1200 = [[{"title": "چلو جوجه کباب با ماست و خیار", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 4, "amount_g": 120, "protein": 37.1, "energy": 207.6, "carbohydrate": 0, "fat": 5.42, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 8, "amount_g": 56, "protein": 1.5, "energy": 72.8, "carbohydrate": 15.78, "fat": 0.15, "food_code": 20345}, {"name": "لیمو ترش", "home_unit": "عدد", "amount_in_home_unit": 0.5, "amount_g": 42, "protein": 0.46, "energy": 12.18, "carbohydrate": 3.91, "fat": 0.13, "food_code": 9326}, {"name": "ماست و خیار", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 6, "amount_g": 90, "protein": 3.15, "energy": 40.5, "carbohydrate": 4.5, "fat": 0.9, "food_code": 99900520}]}], [{"title": "چلو خورش قیمه با گوشت و دوغ کفیر", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 48, "protein": 7.76, "energy": 88.32, "carbohydrate": 4.34, "fat": 3.01, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 18.92, "energy": 114.6, "carbohydrate": 0, "fat": 3.72, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 5, "amount_g": 35, "protein": 0.94, "energy": 45.5, "carbohydrate": 9.86, "fat": 0.1, "food_code": 20345}, {"name": "دوغ کفیر", "home_unit": "لیوان", "amount_in_home_unit": 1, "amount_g": 240, "protein": 7.94, "energy": 96, "carbohydrate": 10.68, "fat": 2.11, "food_code": 14036}]}], [{"title": "زرشک پلو با مرغ و سبزی خوردن", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 17.33, "energy": 95.4, "carbohydrate": 0, "fat": 2.39, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 5, "amount_g": 75, "protein": 3.76, "energy": 246.75, "carbohydrate": 29.78, "fat": 2.24, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.1, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [{"title": "لوبیا پلو و سالاد شیرازی", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 15.69, "energy": 301.05, "carbohydrate": 33.25, "fat": 11.2, "food_code": 9880048}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 0.93, "energy": 48.6, "carbohydrate": 5.05, "fat": 3.14, "food_code": 9880089}]}], [], [], []]

lunch_template_1400 = [[{"title": "چلو جوجه کباب با سالاد کلم", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 5, "amount_g": 150, "protein": 46.37, "energy": 259.5, "carbohydrate": 0, "fat": 6.77, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 10, "amount_g": 70, "protein": 1.88, "energy": 91, "carbohydrate": 19.72, "fat": 0.19, "food_code": 20345}, {"name": "سالاد کلم بدون سس", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 6, "amount_g": 60, "protein": 0.88, "energy": 36.6, "carbohydrate": 3.75, "fat": 2.3, "food_code": 9980324}]}], [{"title": "چلو خورش قیمه با گوشت و سبزی خوردن", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 6, "amount_g": 96, "protein": 15.52, "energy": 176.64, "carbohydrate": 8.69, "fat": 6.03, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 18.92, "energy": 114.6, "carbohydrate": 0, "fat": 3.72, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 12, "amount_g": 84, "protein": 2.26, "energy": 109.2, "carbohydrate": 23.66, "fat": 0.24, "food_code": 20345}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [{"title": "زرشک پلو با مرغ و سالاد فصل", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 17.33, "energy": 95.4, "carbohydrate": 0, "fat": 2.39, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 5, "amount_g": 75, "protein": 3.76, "energy": 246.75, "carbohydrate": 29.78, "fat": 2.24, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.1, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سالاد فصل", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 77, "protein": 0.9, "energy": 27.72, "carbohydrate": 4.3, "fat": 1.12, "food_code": 14054}, {"name": "لیمو ترش", "home_unit": "عدد", "amount_in_home_unit": 0.5, "amount_g": 42, "protein": 0.46, "energy": 12.18, "carbohydrate": 3.91, "fat": 0.13, "food_code": 9326}]}], [{"title": "لوبیا پلو و سالاد شیرازی", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 11, "amount_g": 165, "protein": 19.17, "energy": 367.95, "carbohydrate": 40.63, "fat": 13.7, "food_code": 9880048}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 105, "protein": 0.72, "energy": 37.8, "carbohydrate": 3.93, "fat": 2.44, "food_code": 9880089}]}], [], [], []]

lunch_template_1600 = [[{"title": "چلو جوجه کباب با زیتون", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 5, "amount_g": 150, "protein": 46.36, "energy": 259.5, "carbohydrate": 0, "fat": 6.76, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 13, "amount_g": 91, "protein": 2.45, "energy": 118.3, "carbohydrate": 25.63, "fat": 0.25, "food_code": 20345}, {"name": "زیتون پرورده", "home_unit": "عدد", "amount_in_home_unit": 5, "amount_g": 40, "protein": 0.74, "energy": 49.6, "carbohydrate": 4.89, "fat": 3.36, "food_code": 9195}]}], [{"title": "چلو خورش قیمه با گوشت و دوغ کفیر", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 5, "amount_g": 80, "protein": 12.94, "energy": 147.2, "carbohydrate": 7.24, "fat": 5.02, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 18.92, "energy": 114.6, "carbohydrate": 0, "fat": 3.72, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 10, "amount_g": 70, "protein": 1.88, "energy": 91, "carbohydrate": 19.72, "fat": 0.2, "food_code": 20345}, {"name": "دوغ کفیر", "home_unit": "لیوان", "amount_in_home_unit": 1, "amount_g": 240, "protein": 7.94, "energy": 96, "carbohydrate": 10.68, "fat": 2.11, "food_code": 14036}]}], [{"title": "زرشک پلو با مرغ و سبزی خوردن", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 17.33, "energy": 95.4, "carbohydrate": 0, "fat": 2.39, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 105, "protein": 5.26, "energy": 345.45, "carbohydrate": 41.68, "fat": 3.13, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.1, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [{"title": "لوبیا پلو و سالاد شیرازی", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 12, "amount_g": 180, "protein": 20.91, "energy": 401.4, "carbohydrate": 44.33, "fat": 14.95, "food_code": 9880048}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 8, "amount_g": 120, "protein": 0.82, "energy": 43.2, "carbohydrate": 4.48, "fat": 2.79, "food_code": 9880089}]}], [], [], []]

lunch_template_1800 = [[{"title": "چلو جوجه کباب با ماست و خیار", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 7, "amount_g": 210, "protein": 64.91, "energy": 363.3, "carbohydrate": 0, "fat": 9.47, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 14, "amount_g": 98, "protein": 2.64, "energy": 127.4, "carbohydrate": 27.61, "fat": 0.27, "food_code": 20345}, {"name": "ماست و خیار", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 6, "amount_g": 90, "protein": 3.15, "energy": 40.5, "carbohydrate": 4.5, "fat": 0.9, "food_code": 99900520}]}], [{"title": "چلو خورش قیمه با گوشت و سالاد شیرازی", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 112, "protein": 18.11, "energy": 206.08, "carbohydrate": 10.14, "fat": 7.03, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 3, "amount_g": 90, "protein": 28.39, "energy": 171.9, "carbohydrate": 0, "fat": 5.58, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 14, "amount_g": 98, "protein": 2.64, "energy": 127.4, "carbohydrate": 27.61, "fat": 0.27, "food_code": 20345}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 10, "amount_g": 150, "protein": 1.03, "energy": 54, "carbohydrate": 5.61, "fat": 3.48, "food_code": 9880089}]}], [{"title": "زرشک پلو با مرغ و سبزی خوردن", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 17.33, "energy": 95.4, "carbohydrate": 0, "fat": 2.39, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 6.76, "energy": 444.15, "carbohydrate": 53.59, "fat": 4.02, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": " قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.099999999999998, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [{"title": "لوبیا پلو و سالاد کلم", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 15, "amount_g": 225, "protein": 26.15, "energy": 501.75, "carbohydrate": 55.42, "fat": 18.68, "food_code": 9880048}, {"name": "سالاد کلم و هویج", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 8, "amount_g": 80, "protein": 1.17, "energy": 48.8, "carbohydrate": 5.01, "fat": 3.07, "food_code": 9980324}]}], [], [], []]

lunch_template_2000 = [[{"title": "چلو جوجه کباب با سالاد کلم", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 7, "amount_g": 210, "protein": 64.9, "energy": 363.3, "carbohydrate": 0, "fat": 9.46, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 15, "amount_g": 105, "protein": 2.83, "energy": 136.5, "carbohydrate": 29.58, "fat": 0.29, "food_code": 20345}, {"name": "لیمو ترش", "home_unit": "عدد", "amount_in_home_unit": 1, "amount_g": 84, "protein": 0.92, "energy": 24.36, "carbohydrate": 7.83, "fat": 0.25, "food_code": 9326}, {"name": "سالاد کلم بدون سس", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 90, "protein": 1.32, "energy": 54.9, "carbohydrate": 5.63, "fat": 3.45, "food_code": 9980324}]}], [{"title": "چلو خورش قیمه با گوشت و سالاد شیرازی", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 8, "amount_g": 128, "protein": 20.7, "energy": 235.52, "carbohydrate": 11.59, "fat": 8.03, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 3, "amount_g": 90, "protein": 28.39, "energy": 171.9, "carbohydrate": 0, "fat": 5.58, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 15, "amount_g": 105, "protein": 2.82, "energy": 136.5, "carbohydrate": 29.57, "fat": 0.3, "food_code": 20345}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 10, "amount_g": 150, "protein": 1.04, "energy": 54, "carbohydrate": 5.61, "fat": 3.49, "food_code": 9880089}]}], [{"title": "زرشک پلو با مرغ و ماست و خیار", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 2, "amount_g": 60, "protein": 17.33, "energy": 95.4, "carbohydrate": 0, "fat": 2.39, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 6.76, "energy": 444.15, "carbohydrate": 53.6, "fat": 4.02, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.1, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "ماست و خیار", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 105, "protein": 3.68, "energy": 47.25, "carbohydrate": 5.25, "fat": 1.05, "food_code": 99900520}]}], [{"title": "لوبیا پلو و سبزی خوردن", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 18, "amount_g": 270, "protein": 31.37, "energy": 602.1, "carbohydrate": 66.5, "fat": 22.41, "food_code": 9880048}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [], [], []]

lunch_template_2200 = [[{"title": "چلو جوجه کباب با سالاد فصل", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 7, "amount_g": 210, "protein": 64.91, "energy": 363.3, "carbohydrate": 0, "fat": 9.47, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 2, "amount_g": 246, "protein": 2.34, "energy": 44.28, "carbohydrate": 9.86, "fat": 0.27, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 20, "amount_g": 140, "protein": 3.77, "energy": 182, "carbohydrate": 39.43, "fat": 0.39, "food_code": 20345}, {"name": "سالاد فصل", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 77, "protein": 0.9, "energy": 27.72, "carbohydrate": 4.3, "fat": 1.12, "food_code": 14054}, {"name": "لیمو ترش", "home_unit": "عدد", "amount_in_home_unit": 1, "amount_g": 84, "protein": 0.92, "energy": 24.36, "carbohydrate": 7.83, "fat": 0.25, "food_code": 9326}]}], [{"title": "چلو خورش قیمه با گوشت و دوغ کفیر", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 112, "protein": 18.11, "energy": 206.08, "carbohydrate": 10.14, "fat": 7.03, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 3, "amount_g": 90, "protein": 28.39, "energy": 171.9, "carbohydrate": 0, "fat": 5.58, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 20, "amount_g": 140, "protein": 3.77, "energy": 182, "carbohydrate": 39.44, "fat": 0.39, "food_code": 20345}, {"name": "دوغ کفیر", "home_unit": "لیوان", "amount_in_home_unit": 1, "amount_g": 240, "protein": 7.94, "energy": 96, "carbohydrate": 10.68, "fat": 2.11, "food_code": 14036}]}], [{"title": "زرشک پلو با مرغ و سالاد کلم", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 3, "amount_g": 90, "protein": 25.99, "energy": 143.1, "carbohydrate": 0, "fat": 3.59, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 6.76, "energy": 444.15, "carbohydrate": 53.6, "fat": 4.02, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.099999999999998, "protein": 0.22, "energy": 10.19, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سالاد کلم و هویج", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 90, "protein": 1.32, "energy": 54.9, "carbohydrate": 5.63, "fat": 3.45, "food_code": 9980324}]}], [{"title": "لوبیا پلو و سالاد شیرازی", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 18, "amount_g": 270, "protein": 31.38, "energy": 602.1, "carbohydrate": 66.5, "fat": 22.41, "food_code": 9880048}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 135, "protein": 0.93, "energy": 48.6, "carbohydrate": 5.05, "fat": 3.13, "food_code": 9880089}]}], [], [], []]

lunch_template_2400 = [[{"title": "چلو جوجه کباب با سالاد شیرازی", "ingredient": [{"name": "جوجه کباب", "home_unit": "قوطی کبریت", "amount_in_home_unit": 8, "amount_g": 240, "protein": 74.19, "energy": 415.2, "carbohydrate": 0, "fat": 10.83, "food_code": 5041}, {"name": "گوجه فرنگی پخته", "home_unit": "عدد متوسط", "amount_in_home_unit": 1, "amount_g": 123, "protein": 1.17, "energy": 22.14, "carbohydrate": 4.93, "fat": 0.14, "food_code": 11530}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 23, "amount_g": 161, "protein": 4.33, "energy": 209.3, "carbohydrate": 45.36, "fat": 0.45, "food_code": 20345}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 10, "amount_g": 150, "protein": 1.04, "energy": 54, "carbohydrate": 5.61, "fat": 3.49, "food_code": 9880089}]}], [{"title": "چلو خورش قیمه با گوشت و سالاد کلم", "ingredient": [{"name": "خورش قیمه", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 9, "amount_g": 144, "protein": 23.28, "energy": 264.96, "carbohydrate": 13.04, "fat": 9.04, "food_code": 9880001}, {"name": "گوشت سر دست پخته", "home_unit": "قوطی کبریت", "amount_in_home_unit": 4, "amount_g": 120, "protein": 37.85, "energy": 229.2, "carbohydrate": 0, "fat": 7.44, "food_code": 17277}, {"name": "برنج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 20, "amount_g": 140, "protein": 3.77, "energy": 182, "carbohydrate": 39.43, "fat": 0.4, "food_code": 20345}, {"name": "سالاد کلم بدون سس", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 6, "amount_g": 60, "protein": 0.88, "energy": 36.6, "carbohydrate": 3.76, "fat": 2.3, "food_code": 9980324}]}], [{"title": "زرشک پلو با مرغ و سبزی خوردن", "ingredient": [{"name": "سینه مرغ پخته شده", "home_unit": "قوطی کبریت", "amount_in_home_unit": 3, "amount_g": 90, "protein": 25.99, "energy": 143.1, "carbohydrate": 0, "fat": 3.59, "food_code": 5042}, {"name": "زرشک پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 11, "amount_g": 165, "protein": 8.27, "energy": 542.85, "carbohydrate": 65.51, "fat": 4.92, "food_code": 9880044}, {"name": "هویج پخته", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 3, "amount_g": 29.1, "protein": 0.22, "energy": 10.18, "carbohydrate": 2.39, "fat": 0.05, "food_code": 11125}, {"name": "سبزی خوردن", "home_unit": "پیش دستی", "amount_in_home_unit": 1, "amount_g": 24, "protein": 0.76, "energy": 5.52, "carbohydrate": 0.64, "fat": 0.15, "food_code": 2044}]}], [{"title": "لوبیا پلو و سالاد شیرازی", "ingredient": [{"name": "لوبیا پلو", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 20, "amount_g": 300, "protein": 34.86, "energy": 669, "carbohydrate": 73.89, "fat": 24.9, "food_code": 9880048}, {"name": "سالاد شیرازی", "home_unit": "قاشق غذاخوری", "amount_in_home_unit": 7, "amount_g": 105, "protein": 0.73, "energy": 37.8, "carbohydrate": 3.93, "fat": 2.44, "food_code": 9880089}]}], [], [], []]


# If you have 2400, define lunch_template_2400 similarly.

# Combine them in a single dictionary
lunch_templates = {
    1200: lunch_template_1200,
    1400: lunch_template_1400,
    1600: lunch_template_1600,
    1800: lunch_template_1800,
    2000: lunch_template_2000,
    2200: lunch_template_2200,
    2400: lunch_template_2400
}


#
# 2) HELPER FUNCTIONS
#

def get_category(total_energy: float, categories=None, tolerance=100) -> int:
    """
    Return the matched category (e.g., 1200) if total_energy is within ± tolerance
    of one of the known category values. Otherwise return None.
    """
    if categories is None:
        categories = [1200, 1400, 1600, 1800, 2000, 2200, 2400]

    for cat in categories:
        if abs(total_energy - cat) <= tolerance:
            return cat
    return None


def calculate_total_energy(diet_data: dict) -> float:
    """
    Sums the energy for the FIRST day's entry (index 0) of each meal type
    (breakfast, lunch, dinner, snack1, snack2) in 'week1'.
    """
    meal_types = ["breakfast", "lunch", "dinner", "snack1", "snack2"]
    total_energy = 0.0

    week1_data = diet_data.get("week1", {})

    for meal_type in meal_types:
        meal_list = week1_data.get(meal_type, [])
        if not meal_list:
            continue


        # First day -> meal_list[0]
        day1_meal = meal_list[0][0] if len(meal_list) > 0 else {}
        ingredients = day1_meal.get("ingredient", [])

        # Sum the energy in each ingredient
        meal_energy = sum(item.get("energy", 0.0) for item in ingredients)
        total_energy += meal_energy

    return total_energy


def replace_first_five_lunch_days(diet_data: dict, template: list) -> None:
    """
    Replaces the first FIVE days of diet_data["week1"]["lunch"]
    with the first FIVE items from 'template'. If 'template' has fewer than 5 items,
    fill the rest with empty lists. If lunch does not have 7 items, ensure it's length 7.
    Modifies diet_data in-place.
    """
    week1 = diet_data.setdefault("week1", {})

    if "lunch" not in week1 or not isinstance(week1["lunch"], list):
        # If "lunch" missing or not a list, create a 7-item list of empty
        week1["lunch"] = [[] for _ in range(7)]

    # Ensure exactly 7 items for lunch
    while len(week1["lunch"]) < 7:
        week1["lunch"].append([])

    # Replace the first 5 days
    for i in range(4):
        if i < len(template):
            week1["lunch"][i] = template[i]
        else:
            week1["lunch"][i] = []

    # if week1["lunch"][5]["title"].starsWith("زرشک پلو"):
    #     print("repl")
    # week1["lunch"][5]["title"].starsWith("زرشک پلو")



def fix_last_two_lunch_days(diet_data: dict, category: int) -> None:
    """
    1) For day 6 (index 5) and day 7 (index 6) in 'week1' -> 'lunch':
       - Check if the meal's 'title' starts with any string in STRINGS_TO_CHECK.
       - If so, replace that day with the appropriate first_choice_xxxx (for day 6)
         or second_choice_xxxx (for day 7), based on the diet's category.
    2) If 'category' is None or not in category_special_choices, we do nothing.
    """

    STRINGS_TO_CHECK = [
        "چلو جوجه کباب",
        "زرشک پلو",
        "چلو خورش قیمه",
        "لوبیا پلو",
        # "سبزی پلو با ماهی",
        # "زرشک پلو"
    ]

    # If category is not recognized or not in category_special_choices, skip
    if category not in category_special_choices:
        return

    # Unpack the (first_choice, second_choice) for this category
    first_choice, second_choice, third_choice = category_special_choices[category]

    week1 = diet_data.setdefault("week1", {})

    if "lunch" not in week1 or not isinstance(week1["lunch"], list):
        return  # No lunch data => do nothing

    lunch = week1["lunch"]

    # Ensure lunch has at least 7 day entries
    while len(lunch) < 7:
        lunch.append([])

    # For day 6 => index [5], day 7 => index [6]
    # We'll check if there's at least one meal dictionary in each day's list.

    for day_index, replacement_item in [(4, first_choice), (5, second_choice), (5, third_choice)]:
        if lunch[day_index]:  # list is not empty
            first_meal = lunch[day_index][0]  # dayX's first meal dictionary
            meal_title = first_meal.get("title", "")

            # If the meal's title starts with one of the triggers, we replace.
            if any(meal_title.startswith(prefix) for prefix in STRINGS_TO_CHECK):
                lunch[day_index] = [replacement_item]


done_counter = 47
counter = 0
print(" new code ")
for diet in dietss:
    try:
        d_profile = diet.user.profile

        diet_data = diet.diet_json  # JSONField in Django => Python dict or None
        if not diet_data:
            # self.stdout.write(f"Diet ID {diet.id} has empty/invalid diet_json, skipping.")
            continue

        # 1) Calculate total energy
        total_energy = calculate_total_energy(diet_data)

        # 2) Determine category
        category = get_category(total_energy)

        if category is not None:
            # 3) Get the correct lunch template
            template_for_category = lunch_templates.get(category)

            if template_for_category:
                # 4) Replace the first five days of lunch
                replace_first_five_lunch_days(diet_data, template_for_category)
                fix_last_two_lunch_days(diet_data, category)

                # 5) Save changes
                diet.diet_json = diet_data
                diet.save()

                # print(f"Diet ID {diet.id}: total_energy={total_energy:.1f}, category={category}, lunch replaced.")

                # return myResponse.OK(
                #         f"Diet ID {diet.id}: total_energy={total_energy:.1f}, category={category}, lunch replaced.",
                #     {})
                # self.stdout.write(
                #     self.style.SUCCESS(
                #         f"Diet ID {diet.id}: total_energy={total_energy:.1f}, "
                #         f"category={category}, lunch replaced."
                #     )
                # )
                done_counter += 1
            else:
                print(f"    Diet ID {diet.id}: total_energy={total_energy:.1f}, category={category} but no template found.",
                      1029)
        else:
            print(
                f"  Diet ID {diet.id}: total_energy={total_energy:.1f} is not in ±60 range of known categories.")
    except:
        print(f"    Error occured on user {diet.user.profile.first_name}")

# print(f"   . This is the count of counter: {counter}")

print(f"    {done_counter} diets has been changed")

