import sys
import os

current = os.path.dirname(os.path.realpath(__file__))
parent = os.path.dirname(current)
parent = os.path.dirname(parent)
sys.path.append(parent)
try:
    from prerequisite import init
    init()
except ModuleNotFoundError as e:
    print(e)

output_dir = 'output_dir'

if not os.path.exists(output_dir):
    os.makedirs(output_dir)

from payment.models import Discount, ZarinPalPayment
from panel.models import Message, TherapistSelection
from panel.PushNotification import PushNotification
from APIs.models import User as AppUser

nestle = Discount.objects.filter(code="NESTLE")[0]
if 2 < 3:
    payments = ZarinPalPayment.objects.filter(discount=nestle, is_payed=True)
else:
    hossein = AppUser.objects.filter(phone_number="09217761645")[0]
    payments = ZarinPalPayment.objects.filter(user=hossein)



print("length nestle payments:", len(payments))

texts = ["سلام دوست خوب لاکتویی! بالاخره اون روز خاص رسید! رژیم اختصاصی شما از همین لحظه تو اپلیکیشن لاکتو منتظرتونه. و بهترین قسمت؟ امروز همون شنبه معروفه که همیشه میگفتی رژیم رو شروع می کنی!",
         "https://lacto.ir/menu_tutorial.mp4",
         "ما یک ویدیو کوچیک هم برات گذاشتیم که نشون میده چطوری به راحتی رژیمتو پیدا کنی و استارت بزنی. حالا وقتشه که تغییر رو شروع کنی! اپ رو باز کن و قدم بعدیتو بردار. تو میتونی. ما هم کنارتیم. 💚"]

for pay in payments:
    # try:
    #     app_user = pay.user
    #     therapist_django_user = app_user.profile.therapist
    #
    #     m1 = Message(sender=therapist_django_user,
    #                  receiver=app_user.django_user,
    #                  text=texts[0])
    #     m1.save()
    #
    #     m2 = Message(sender=therapist_django_user,
    #                  receiver=app_user.django_user,
    #                  text=texts[1])
    #     m2.save()
    #
    #     m3 = Message(sender=therapist_django_user,
    #                  receiver=app_user.django_user,
    #                  text=texts[2])
    #     m3.save()
    # except Exception as e:
    #     print("Error on sending message:", e)
    try:
        app_user = pay.user
        therapist_django_user = app_user.profile.therapist
        notification_body = "\n".join(texts)
        title = app_user.profile.first_name + " عزیز\n" + "پیام جدید از مربی!"
        PushNotification().send_notification_to(app_user.profile.firebase_token, title, notification_body)
    except Exception as e:
        print("Error on sending notification:", e)
