import platform

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck310')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()

init()

import pandas as pd
from django.core.wsgi import get_wsgi_application
import os
from APIs.models import FoodCard, Food
from panel.models import Message
from datetime import datetime
from APIs.models import FoodCard # Change "your_app" to your actual Django app name

# Define output directory and filename
output_dir = "static/amin/"  # Change this to your desired directory
output_filename = "foods_card_23-25april.xlsx"
output_path = os.path.join(output_dir, output_filename)
# https://ziluck.probiofit.net/static/amin/pnlist.xlsx
# Ensure the directory exists
os.makedirs(output_dir, exist_ok=True)

# Fetch all objects from the database
food_cards = FoodCard.objects.filter(created_at__gt=datetime(2025, 4, 23, 0 ,0, 0))

# Convert QuerySet to a list of dictionaries
data = list(food_cards.values())

# Create a Pandas DataFrame
df = pd.DataFrame(data)

# Save DataFrame to an Excel file
df.to_excel(output_path, index=False)

# Generate the public link
base_url = "https://ziluck.probiofit.net/static/amin/"  # Adjust this based on your server's URL structure
file_url = base_url + output_filename

print("Excel file created successfully.")
print(f"Download link: {file_url}")
