import sys
import os

from datetime import datetime
from datetime import timedelta

current = os.path.dirname(os.path.realpath(__file__))
parent = os.path.dirname(current)
parent = os.path.dirname(parent)
sys.path.append(parent)
try:
    from prerequisite import init
    init()
except ModuleNotFoundError as e:
    print(e)


import json
import os

from APIs.models import Diet

output_dir = 'output_dir'

if not os.path.exists(output_dir):
    os.makedirs(output_dir)

diets = Diet.objects.filter(created_at__gt=datetime.now() - timedelta(days=14))
file = open(output_dir + "/result_{}.csv".format(datetime.now().date()), "w")
file.write("{diet.creator},{diet.user},{diet.diet_json},{diet.from_date}\n")
for diet in diets:
    line = f"{diet.creator},{diet.user},{diet.diet_json},{diet.from_date}\n"
    file.write(line)
file.close()

