import sys
import os
current = os.path.dirname(os.path.realpath(__file__))
parent = os.path.dirname(current)
parent = os.path.dirname(parent)
sys.path.append(parent)
try:
    from prerequisite import init
    init()
except ModuleNotFoundError as e:
    print(e)


import json
import os
from django.apps import apps
from django.core.serializers import serialize
from django.core.management.base import CommandError


my_apps = ["APIs", "panel"]

app_label = 'APIs'
output_dir = 'output_dir'

if not os.path.exists(output_dir):
    os.makedirs(output_dir)

for app_label in my_apps:
    if not os.path.exists(f'{output_dir}/{app_label}'):
        os.makedirs(f'{output_dir}/{app_label}')
    models = apps.get_app_config(app_label).get_models()
    for model in models:
        try:
            model_name = model.__name__
            data = serialize('json', model.objects.all())
            with open(f'{output_dir}/{app_label}/{model_name}.json', 'w') as f:
                f.write(data)
            print(f'Successfully serialized {model_name}')
        except CommandError as e:
            print(f'Error serializing {model_name}: {e}')
        except Exception as e:
            print(f'Unexpected error for {model_name}: {e}')
