import platform

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck38')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()

init()

prefix = "static/amin/"

from payment.models import Discount
from APIs.models import User, Profile
from datetime import datetime, timedelta

profiles = Profile.objects.all()
i = 0

for profile in profiles:
    user_code = profile.user_code.upper()
    print(f"This is the user code '{user_code}' for the user of {profile.first_name} {profile.last_name}")

    if i < 2:
        discount = Discount(
            code= user_code.upper(),
            created_at= datetime.now(),
            expire_date= datetime.now() + timedelta(days=365),
            percentage = 5,
            number_of_discounts= 1000,
        )
        discount.save()
    else:
        print(f"The code was {user_code} and nothing has been created. \n")

    i += 1