import sys
import os
current = os.path.dirname(os.path.realpath(__file__))
parent = os.path.dirname(current)
parent = os.path.dirname(parent)
sys.path.append(parent)
try:
    from prerequisite import init
    init()
except ModuleNotFoundError as e:
    print(e)


from ziluck_project.settings import BASE_DIR
from APIs.models import Analysis
from datetime import date
from panel.SMSNotification import SMS

path = BASE_DIR + "/stderr.log"
stderrFile = open(path)
text = stderrFile.read()
stderrFile.close()

result = dict()
data = []
segments = text.split("+--------------------- START OF LOG ----------------------+")
total_api_call = 0
total_api_errors = 0
total_api_true = 0
for segment in segments:
    lines = segment.split("\n")
    link = None
    try:
        for line in lines:
            if "URL:" in line:
                link = line
                total_api_call +=1
                if "?" in line:
                    link = line.split("?")[0] + "?"
                if link not in result:
                    result[link] = dict()
                    result[link]["true"] = 0
                    result[link]["false"] = 0
                    result[link]["errors"] = []
                    result[link]["error_rate"] = 0
            if "api call" in line:
                time = line.split("]")[0].split("[")[1].split(".")[0].strip()
                # print(time)
                hours = time.split(" ")[1].split(":")[0]
                minutes = time.split(" ")[1].split(":")[1]
                seconds = time.split(" ")[1].split(":")[2]
                # data.append(60 * hours +  minutes)
                data.append(60 * hours +  minutes)
                if "true" in line:
                    result[link]["true"] += 1
                    total_api_true += 1
                else:
                    result[link]["false"] += 1
                    result[link]["error_rate"] = 100 * result[link]["false"] / (result[link]["false"] + result[link]["true"])
                    result[link]["errors"].append(segment.replace("<", "|").replace(">", "/"))
                    total_api_errors += 1
    except Exception as e:
        continue

R = list(result.items())
R.sort(key=lambda a: -a[1]["false"])

# send sms to admin
try:
    message = "calls:"
    message += str(total_api_call) + "\n"
    message += "errors:"
    message += str(total_api_errors) + "\n"
    message += "true:"
    message += str(total_api_true) + "\n"
    message += "max errors:\n"
    message += R[0][0].split("ziluck.info")[1] + "->" + str(R[0][1]["false"]) + "\n"
    message += R[1][0].split("ziluck.info")[1] + "->" + str(R[1][1]["false"])
    SMS().send_to_admin(message)
except Exception as e:
    print("error on sending sms to admin: ",e)


an = Analysis.objects.filter(date=date.today()).last()
if an:
    an.api_monitoring = {"report": R}
    an.save()
else:
    an = Analysis(date=date.today())
    an.api_monitoring = {"report": R}
    an.save()
