# import os
# import pathlib
#
# import cv2
# import numpy as np
# import tensorflow as tf
# from PIL import Image
#
# class Predict:
#     def __init__(self, model_dir="saved_model", use_gpu: bool = False):
#
#         # Patch the location of gfile
#         tf.gfile = tf.io.gfile
#
#         if not use_gpu:
#             os.environ["CUDA_VISIBLE_DEVICES"] = "-1"
#
#         self.model_dir = pathlib.Path(model_dir)
#
#         self.labels = list(range(1, 10))
#         self.labels.append(0)
#         self.labels.append(".")
#
#         self.category_index = self.create_cat_index()
#
#         self.load_model()
#
#     # @staticmethod
#     def create_cat_index(self):
#         a = dict()
#         for i, l in enumerate(self.labels):
#             a[i+1] = {"id": i+1, "name": str(l)}
#
#         return a
#
#     def load_model(self):
#
#         self.model = tf.saved_model.load(str(self.model_dir))
#         self.model = self.model.signatures['serving_default']
#
#     def infer(self, input_tensor):
#
#         # Run inference
#         output_dict = self.model(input_tensor)
#
#         num_detections = int(output_dict.pop('num_detections'))
#         output_dict = {key: value[0, :num_detections].numpy()
#                        for key, value in output_dict.items()}
#         output_dict['num_detections'] = num_detections
#
#         output_dict['detection_classes'] = output_dict['detection_classes'].astype(np.int64)
#
#         return output_dict
#
#     @staticmethod
#     def load_image(image_path, image_np=False):
#         if not image_np:
#             image_np = cv2.imread(image_path)
#         else:
#             image_np = image_path
#
#         image = cv2.resize(image_np, (300, 300))
#         image = cv2.cvtColor(image_np, cv2.COLOR_BGR2RGB)
#
#         tensor = tf.convert_to_tensor(image)
#         tensor = tensor[tf.newaxis, ...]
#
#         return tensor
#
#     def get_number(self, output_dict, threshold=0.4):
#         indexes = np.argsort(output_dict["detection_boxes"][
#                                  np.where(output_dict["detection_scores"] > threshold)][:, 1])
#         number = ""
#         for char in output_dict["detection_classes"][indexes]:
#
#             number += str(self.labels[char - 1])
#
#         return number
