from .util import *
from panel.telegram_notification import TelegramNotification


class WeightCronJob1(CronJobBase):
    """همراه عزیز آیدیا لطفا وزن خود را در صورت تغییر به روز رسانی کنید.
     وزن قبلی شما ... بوده است. """
    # RUN_EVERY_MINS = 1  # every 2 hours
    RUN_AT_TIMES = CRONTIMES["WeightCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.weight.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "وزن!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(profile__birth_date__gt=(datetime.now() - timedelta(days=365 * 17))) & Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        firebase_tokens.append(user.profile.firebase_token)
                        msg = user.profile.first_name + " عزیز  لطفا وزن خود را در صورت تغییر به روز رسانی کنید. وزن قبلی شما " + str(
                            user.profile.weight) + " بوده است."
                        messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)


class WeightCronJob2(CronJobBase):  # row 7 in notification list
    """ تبریک می گوییم! اولین قدم شما برای جلوگیری از افزایش وزن با موفقیت انجام شده است.
    برای دریافت راهنمایی اختصاصی جهت کنترل کالری دریافتی برای کاهش وزن کلیک کنید.
     یک ماه بعد از ثبت نام اولیه و هر ماه اگر وزن حفظ شده است و فرد اضافه وزن یا چاقی دارد"""
    RUN_AT_TIMES = CRONTIMES['WeightCronJob2']
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.weight.message2'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "وزن!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        bmi = user.profile.weight / ((user.profile.height/100)**2)
                        if bmi > 25:
                            weights = Weights.objects.filter(user=user, time__gt=(datetime.now() -
                                                                                  timedelta(days=60))).order_by("time")
                            if len(weights) > 2:  # Users who have updated their weight more than twice.
                                # Users who have lost weight or have had a stable weight
                                if weights[-1].weight == weights[-2].weight:
                                    firebase_tokens.append(user.profile.firebase_token)
                                    msg = user.profile.first_name + " عزیز تبریک می گوییم! اولین قدم شما برای جلوگیری از افزایش وزن با موفقیت انجام شده است. برای دریافت راهنمایی اختصاصی جهت کنترل کالری دریافتی برای کاهش وزن کلیک کنید."
                                    messages.append(msg)
                                elif weights[-1].weight < weights[-2].weight:
                                    firebase_tokens.append(user.profile.firebase_token)
                                    msg = user.profile.first_name + " عزیز دستاورد شما در یک ماه گذشته عالی بوده است! جزییات مسیری که طی کردید را اینجا ببینید. "
                                    messages.append(msg)
            # sendSMSToAdmin(len(messages))
            TelegramNotification().send_notif_to_admin(len(messages))
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)

