from APIs.models import *
from datetime import timedelta
from django.db.models import Q
from pprint import pprint
from django_cron import CronJobBase, Schedule
import requests
import jdatetime
from pyfcm import FCMNotification

from APIs.scripts.ApiMonitoring.jobs.today import message
from panel.telegram_notification import TelegramNotification

from ziluck_project.constants import FIREBASE_API_KEY
from ziluck_project.constants import SMS_API_URL


DEBUG = False

CRONTIMES = {
    'ActivityCronJob1': ['10:00'],
    'WeightCronJob1': ['15:00'],
    'WeightCronJob2': ['16:30'],
    'HeightCronJob1': ['13:00'],
    'InsulinCronJob1': ['18:00'],
    'InsulinCronJob2': ['18:30'],
    'DrugCronJob1': ['19:00'],
    'DrugCronJob2': ['19:30'],
    'CalorieCronJob1': ['20:00'],
    'CalorieCronJob2': ['20:30'],
    'CarbohydrateCronJob1': ['21:00'],
    'CarbohydrateCronJob2': ['21:00'],

}


def send_list_notification(firebase_tokens, messages, message_title):
    try:
        t0 = datetime.now()
        if DEBUG:
            pprint(firebase_tokens)
            pprint(messages)
            pprint("length:" + str(len(firebase_tokens)))

            number_of_messages = len(messages)
            firebase_tokens = []
            messages = ["test mode, number of message:" + str(number_of_messages)]
            temp = User.objects.filter(phone_number="09910412375")
            if temp.exists():
                firebase_tokens.append(temp[0].profile.firebase_token)

        push_service = FCMNotification(
            api_key=FIREBASE_API_KEY)

        for i in range(min(len(firebase_tokens), len(messages))):
            result = push_service.notify_single_device(registration_id=firebase_tokens[i],
                                                       message_title=message_title,
                                                       message_body=messages[i])

        # send message to admin ...
        t1 = datetime.now()
        execution_time = t1.timestamp() - t0.timestamp()

        t_note = ("The following message was sent to " + str(len(firebase_tokens)) +
                  " people via notification:\nsending time: " +
                  str(round(execution_time, 2)) + " s\n\n" + message_title)
        TelegramNotification().send_notif_to_admin(t_note)

    except Exception as e:
        print(e)
