from .util import *


class InsulinCronJob1(CronJobBase):
    """
     همراه عزیز آیدیا  درصورتیکه پزشک معالج شما در آخرین ویزیت نوع انسولین مصرفی تان را تغییر داده، اطلاعات اولیه خود را به روزرسانی کنید.
    """
    RUN_AT_TIMES = CRONTIMES["InsulinCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.insulin.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "نوع انسولین !"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(profile__birth_date__gt=(datetime.now() - timedelta(days=365 * 17))) & Q(created_at=(today - timedelta(days=30 * period + 1)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        firebase_tokens.append(user.profile.firebase_token)
                        msg = user.profile.first_name + " عزیز  درصورتیکه پزشک معالج شما در آخرین ویزیت نوع انسولین مصرفی تان را تغییر داده، اطلاعات اولیه خود را به روزرسانی کنید."
                        messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)


class InsulinCronJob2(CronJobBase):
    """
     همراه عزیز آیدیا  درصورتیکه پزشک معالج شما در آخرین ویزیت دوز انسولین مصرفی تان را تغییر داده، اطلاعات اولیه خود را به روزرسانی کنید.
    """
    RUN_AT_TIMES = CRONTIMES["InsulinCronJob2"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.insulin.message2'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "دوز انسولین !"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(profile__birth_date__gt=(datetime.now() - timedelta(days=365 * 17))) & Q(created_at=(today - timedelta(days=30 * period + 2)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        firebase_tokens.append(user.profile.firebase_token)
                        msg = user.profile.first_name + " عزیز  درصورتیکه پزشک معالج شما در آخرین ویزیت دوز انسولین مصرفی تان را تغییر داده، اطلاعات اولیه خود را به روزرسانی کنید."
                        messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)
