from .util import *


class HeightCronJob1(CronJobBase):
    """ همراه عزیز آیدیا لطفا قد خود را در صورت تغییر به روز رسانی کنید.
    قد قبلی شما ... بوده است. """
    RUN_AT_TIMES = CRONTIMES["HeightCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.height.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "قد!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(profile__birth_date__gt=(datetime.now() - timedelta(days=365 * 17))) & Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        firebase_tokens.append(user.profile.firebase_token)
                        msg = user.profile.first_name + " عزیز  لطفا قد خود را در صورت تغییر به روز رسانی کنید. قد قبلی شما " + str(
                            user.profile.height) + " بوده است."
                        messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)

