from .util import *


class CarbohydrateCronJob1(CronJobBase):  # row 24
    """
    همراه عزیز آیدیا میانگین مصرف روزانه کربوهیدرات شما در یک هفته گذشته ؟؟؟؟ درصد بالاتر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کربوهیدرات مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید.
     """
    RUN_AT_TIMES = CRONTIMES["CarbohydrateCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.carbohydrate.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "کربوهیدرات!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        hyper_number = SugarMeasurement.objects.filter(user=user, time__gt=datetime.now() - timedelta(days=7), hyper=True).count()
                        if hyper_number > 3:
                            firebase_tokens.append(user.profile.firebase_token)
                            msg = "همراه عزیز آیدیا میانگین مصرف روزانه کربوهیدرات شما در یک هفته گذشته بالاتر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کربوهیدرات مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید."
                            messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)


class CarbohydrateCronJob2(CronJobBase):  # row 25
    """
    همراه عزیز آیدیا میانگین مصرف روزانه کربوهیدرات شما در یک هفته گذشته ؟؟؟؟ درصد کمتر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کربوهیدرات مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید.
     """
    RUN_AT_TIMES = CRONTIMES["CarbohydrateCronJob2"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.carbohydrate.message2'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "کربوهیدرات!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        hypo_number = SugarMeasurement.objects.filter(user=user, time__gt=datetime.now() - timedelta(days=7), hypo=True).count()
                        if hypo_number > 3:
                            firebase_tokens.append(user.profile.firebase_token)
                            msg = "همراه عزیز آیدیا میانگین مصرف روزانه کربوهیدرات شما در یک هفته گذشته پایین تر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کربوهیدرات مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید."
                            messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)

