from .util import *


class CalorieCronJob1(CronJobBase):
    """
    همراه عزیز آیدیا میانگین مصرف روزانه کالری شما در سه ماه گذشته ؟؟؟؟ درصد بالاتر/پایین تر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کالری مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید.
    """
    RUN_AT_TIMES = CRONTIMES["CalorieCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.calorie.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "کنترل کالری!"
        try:
            today = datetime.today()
            for period in range(0, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period + 5)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        calorie_to_use = user.profile.CR
                        average_calorie_used = 0
                        sum_of_calorie_used = 0
                        points = Points.objects.filter(user=user, date__range=(datetime.today() - timedelta(days=90),
                                                                               datetime.today()))
                        if points.exists():
                            for p in points:
                                sum_of_calorie_used += p.total_Calories_used
                            average_calorie_used = sum_of_calorie_used / points.count()
                            rate = average_calorie_used / calorie_to_use
                            BMI = user.profile.weight / ((user.profile.height / 100) ** 2)
                            if rate > 1:
                                extra_calorie_percentage = round((rate - 1) * 100)
                                msg = "همراه عزیز آیدیا میانگین مصرف روزانه کالری شما در سه ماه گذشته " + str(extra_calorie_percentage) + " درصد بالاتر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کالری مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید. "
                                firebase_tokens.append(user.profile.firebase_token)
                                messages.append(msg)
                            elif BMI < 18.5:
                                lack_of_calorie_percentage = round((1 - rate) * 100)
                                msg = "همراه عزیز آیدیا میانگین مصرف روزانه کالری شما در سه ماه گذشته " + str(lack_of_calorie_percentage) + " درصد پایین تر از حد مجاز بوده است. در صورت تمایل برای کنترل بهتر کالری مصرفی خود می توانید از برنامه اختصاصی آیدیا استفاده کنید. "
                                firebase_tokens.append(user.profile.firebase_token)
                                messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)


class CalorieCronJob2(CronJobBase):  # row 22 in file
    """
    دوست عزیز متوسط کالری دریافتی شما در یک ماه گذشته ... درصد بالاتر از میزان مورد نیاز برای حفظ وزن فعلی بوده است. برای دیدن گزارش تکمیلی کلیک کنید.
    """
    RUN_AT_TIMES = CRONTIMES["CalorieCronJob2"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.calorie.message2'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "کنترل کالری!"
        try:
            today = datetime.today()
            for period in range(0, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period + 6)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        calorie_to_use = user.profile.CR
                        average_calorie_used = 0
                        sum_of_calorie_used = 0
                        points = Points.objects.filter(user=user, date__range=(datetime.today() - timedelta(days=30),
                                                                               datetime.today()))
                        if points.exists():
                            for p in points:
                                sum_of_calorie_used += p.total_Calories_used
                            average_calorie_used = sum_of_calorie_used / points.count()
                            rate = average_calorie_used / calorie_to_use
                            BMI = user.profile.weight / ((user.profile.height / 100) ** 2)
                            if rate > 1:
                                extra_calorie_percentage = round((rate - 1) * 100)
                                msg = "دوست عزیز متوسط کالری دریافتی شما در یک ماه گذشته " + str(extra_calorie_percentage) + " درصد بالاتر از میزان مورد نیاز برای حفظ وزن فعلی بوده است. برای دیدن گزارش تکمیلی کلیک کنید. "
                                firebase_tokens.append(user.profile.firebase_token)
                                messages.append(msg)
                            elif BMI < 18.5:
                                lack_of_calorie_percentage = round((1 - rate) * 100)
                                msg = "دوست عزیز متوسط کالری دریافتی شما در یک ماه گذشته " + str(
                                    lack_of_calorie_percentage) + " درصد پایین تر از میزان مورد نیاز برای حفظ وزن فعلی بوده است. برای دیدن گزارش تکمیلی کلیک کنید. "
                                firebase_tokens.append(user.profile.firebase_token)
                                messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)
