from .util import *


class ActivityCronJob1(CronJobBase):
    """
    همراه عزیز آیدیا از آخرین باری که فعالیت بدنی خود را ثبت کرده اید،
     سه روز گذشته است. توصیه می شود برای کنترل بهتر قند خون
    اطلاعات مربوط به فعالیت بدنی خود را ثبت کنید.
    """

    RUN_AT_TIMES = CRONTIMES["ActivityCronJob1"]
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'cron.activity.message1'  # a unique code

    def do(self):
        print(self.code)
        firebase_tokens = []
        messages = []
        title = "فعالیت!"
        try:
            today = datetime.today()
            for period in range(1, 10):
                temp = User.objects.filter(
                    (~(Q(profile__firebase_token="-") | Q(profile__firebase_token=None))) & Q(isRegistered=True) &
                    Q(created_at=(today - timedelta(days=30 * period)).date()))
                for user in temp:
                    if not (user.profile.firebase_token in firebase_tokens):
                        activity_counter = Activities_log.objects.filter(user__eating=user, end_date_time__gt=datetime.now() - timedelta(days=3)).count()
                        if activity_counter == 0:
                            firebase_tokens.append(user.profile.firebase_token)
                            msg = "همراه عزیز آیدیا از آخرین باری که فعالیت بدنی خود را ثبت کرده اید، بیش از سه روز گذشته است. توصیه می شود برای کنترل بهتر قند خون اطلاعات مربوط به فعالیت بدنی خود را ثبت کنید."
                            messages.append(msg)
        except Exception as e:
            print(e)

        send_list_notification(firebase_tokens, messages, title)

