# Content of this file is for the folder wellness_profile_v3, file wellness_assistant_v2.py

import openai
import json
from datetime import datetime, timedelta
from openai import OpenAI
import re

# Initialize the OpenAI client with your API key
client = OpenAI(api_key="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")  # Replace with your actual key

def calculate_weighted_metrics(history_data: list, current_date: str) -> dict:
    """
    Calculate weighted averages and patterns from historical data.
    Weights: 0-7 days (1.0), 8-14 days (0.8), 15-30 days (0.6).
    """
    weights = []
    water_glasses = []
    calories = []
    steps = []
    sleep_hours = []
    meals_count = []
    current_date = datetime.strptime(current_date, "%Y-%m-%d")
    
    for snapshot in history_data:
        snapshot_date = datetime.strptime(snapshot["date"], "%Y-%m-%d")
        days_diff = (current_date - snapshot_date).days
        if days_diff <= 30:
            weight = 1.0 if days_diff <= 7 else 0.8 if days_diff <= 14 else 0.6
            weights.append(weight)
            water_glasses.append(snapshot["daily_log"].get("water_glasses", 0))
            calories.append(sum(meal.get("calories", 0) for meal in snapshot["daily_log"].get("meals", [])))
            steps.append(snapshot["daily_log"].get("walking_steps", 0))
            sleep_hours.append(snapshot["daily_log"].get("sleep", {}).get("duration_hours", 0))
            meals_count.append(1 if len(snapshot["daily_log"].get("meals", [])) >= 2 else 0)
    
    def weighted_avg(values, weights):
        return sum(v * w for v, w in zip(values, weights)) / sum(weights) if weights else 0
    
    days_with_meals = sum(meals_count) if meals_count else 0
    total_days = len(meals_count) if meals_count else 1
    
    return {
        "weekly_average_glasses": weighted_avg(water_glasses[:7], weights[:7]),
        "weekly_average_calories": weighted_avg(calories[:7], weights[:7]),
        "weekly_steps_average": weighted_avg(steps[:7], weights[:7]),
        "weekly_average_hours": weighted_avg(sleep_hours[:7], weights[:7]),
        "meal_frequency": days_with_meals / total_days if total_days > 0 else 0,
        "weekend_steps_avg": weighted_avg(
            [s for i, s in enumerate(steps) if datetime.strptime(history_data[i]["date"], "%Y-%m-%d").weekday() >= 5],
            [w for i, w in enumerate(weights) if datetime.strptime(history_data[i]["date"], "%Y-%m-%d").weekday() >= 5]
        ),
        "weekday_steps_avg": weighted_avg(
            [s for i, s in enumerate(steps) if datetime.strptime(history_data[i]["date"], "%Y-%m-%d").weekday() < 5],
            [w for i, w in enumerate(weights) if datetime.strptime(history_data[i]["date"], "%Y-%m-%d").weekday() < 5]
        ),
        "weekly_completeness_score": sum(1 for s in history_data[:7] if s["scores"].get("logging_completeness", 0) > 0.5) / 7 if history_data else 0
    }

def call_health_wellness_assistant(user_data: dict, history_data: list) -> dict:
    """
    Sends structured health data to the OpenAI GPT model and receives a personalized
    Farsi daily message, notification title, notification body, and an updated wellness profile.
    """
    # Calculate metrics from historical data
    metrics = calculate_weighted_metrics(history_data, user_data["daily_log"]["date"])
    
    # Update user_data with calculated metrics
    user_data["wellness_profile"].update({
        "hydration": {"weekly_average_glasses": metrics["weekly_average_glasses"], "last_updated": user_data["daily_log"]["date"]},
        "diet": {"weekly_average_calories": metrics["weekly_average_calories"], "last_updated": user_data["daily_log"]["date"]},
        "dietary_habits": {"meal_frequency": metrics["meal_frequency"], "last_updated": user_data["daily_log"]["date"]},
        "sleep": {"weekly_average_hours": metrics["weekly_average_hours"], "last_updated": user_data["daily_log"]["date"]},
        "exercise": {"weekly_steps_average": metrics["weekly_steps_average"], "last_updated": user_data["daily_log"]["date"]},
        "history_summary": {
            "days_with_meals": int(metrics["meal_frequency"] * 7),
            "weekend_steps_avg": metrics["weekend_steps_avg"],
            "weekday_steps_avg": metrics["weekday_steps_avg"],
            "last_cleared": user_data["wellness_profile"]["history_summary"].get("last_cleared", user_data["daily_log"]["date"])
        },
        "logging_behavior": {"weekly_completeness_score": metrics["weekly_completeness_score"], "last_updated": user_data["daily_log"]["date"]}
    })
    
    user_data_json_str = json.dumps(user_data, ensure_ascii=False, indent=2)

    system_prompt = f"""
You are a health and wellness AI assistant providing personalized advice in Persian (Farsi). Below is the user's input data in JSON format:

{user_data_json_str}

**Context**:
- The input contains `user_id`, `profile`, `daily_log` (today's data), and `wellness_profile` with pre-calculated metrics (e.g., weekly averages, meal_frequency).
- Historical data is processed, and summaries (e.g., weekly_average_glasses, days_with_meals) are provided in `wellness_profile`.
- Use these metrics to generate scores, reasoning, and personalized messages.

**Responsibilities**:

1. **Analyze Input Data**:
   - **Profile**: first_name, gender, age, weight_kg, height_cm, goal_weight_kg, diseases.
   - **Daily Log (Today)**: meals (name, quantity, calories, description, time), water_glasses, activities (name, duration_minutes), walking_steps, sleep (duration_hours).
   - **Wellness Profile**: hydration, diet, dietary_habits, sleep, exercise, mental_wellbeing, goals, health_conditions, adherence, logging_behavior, history_summary, wellness_score.
   - **Wellness Tip**: Daily tip (e.g., hydration, exercise).

2. **Reason Through Dimensions**:
   For each dimension (hydration, diet, dietary_habits, sleep, exercise, mental_wellbeing, logging_behavior):
   - Compare today's `daily_log` to health guidelines (e.g., 8 glasses water, 7-9 hours sleep, 7000 steps).
   - Use pre-calculated metrics (e.g., weekly_average_glasses, meal_frequency) from `wellness_profile`.
   - Consider `profile` (e.g., diseases like iron deficiency) and goals (e.g., weight loss).
   - Assign a score (0-100) and provide reasoning (1-2 sentences).

3. **Update wellness_profile**:
   - **hydration**: Set `score` (e.g., water_glasses vs. 8), `reasoning`, `trend` (up/down/stable vs. weekly_average_glasses), `last_updated` ("2025-05-24").
   - **diet**: Set `score` (penalize if meals empty, use weekly_average_calories), `reasoning`, `trend`, `nutrient_balance` (prioritize iron-rich foods for "کمبود آهن"), `last_updated`.
   - **dietary_habits**: Set `consistency_score` (based on meal_frequency), `reasoning`, `last_updated`.
   - **sleep**: Set `score` (7-9 hours), `reasoning`, `trend` (vs. weekly_average_hours), `last_updated`.
   - **exercise**: Set `score` (based on activities, steps vs. 7000), `reasoning`, `trend`, `weekly_total_minutes`, `last_updated`.
   - **mental_wellbeing**: Set `score` (inferred from other dimensions), `reasoning`, `trend`, `last_updated`.
   - **goals**: Update `progress` (e.g., weight loss: (initial_weight_kg - weight_kg) / (initial_weight_kg - goal_weight_kg)), `last_updated`.
   - **health_conditions**: Update `impacts` (e.g., recommend iron-rich foods), `severity_score`, `last_updated`.
   - **adherence**: Set `tip_followed` (true if daily_log aligns with last_tip), `consistency_score`, `last_tip`, `last_updated`.
   - **logging_behavior**: Set `completeness` (0-1, based on missing fields), `last_missing_log` (e.g., "meals, activities"), `action_plan` (e.g., priority: "improve meal logging", recommendations: "ثبت حداقل 2 وعده غذایی"), `last_updated`.
   - **wellness_score**: Set `value` (weighted average of dimension scores), `reasoning`, `logging_penalty` (based on completeness), `last_updated`.

4. **Generate Notification and Message**:
   - **Notification Title**: A concise title (max 30 characters) summarizing the daily message or key action (e.g., "سارا، قدم‌هات رو بیشتر کن!").
   - **Notification Body**: A summary of the daily message (max 178 characters) that highlights key points and encourages reading the full text (e.g., "سارا، این هفته قدم‌هات عالیه! آب کافی بنوش و صبحانه رو جا ننداز. ادامه بده!").
   - **Daily Message (text)**: A short, warm, human-like message in Persian (Farsi, 3–4 sentences).
     - Speak as a caring coach, using natural, respectful expressions (avoid slang like "داداش").
     - Include:
       - User's name (from profile.first_name).
       - Reference to recent behavior (e.g., "این هفته قدم‌هات بیشتر شده" using history_summary).
       - The provided `wellness_tip`.
       - One practical suggestion from `action_plan.recommendations`.
       - A motivational quote or reflection.
     - Example: "سارا عزیز، این هفته قدم‌هات به 8200 رسیده، عالیه! مصرف آب کافی انرژی‌ات رو حفظ می‌کنه. چون صبحانه رو گاهی جا می‌ندازی، یه میوه صبح امتحان کن. هر قدم کوچیک تو رو به هدفت نزدیک‌تر می‌کنه!"

**Output**:
    Return valid JSON with:
    - `notification_title`: The notification title (max 30 characters).
    - `notification_body`: The notification body (max 178 characters, summarizing the text).
    - `text`: The daily message.
    - `wellness_profile`: Updated profile with all fields.
    If data is missing, use defaults (e.g., score: 50, reasoning: "داده کافی نیست", trend: "stable").
    Example:
    {{
      "notification_title": "سارا، قدم‌هات رو بیشتر کن!",
      "notification_body": "سارا، این هفته قدم‌هات عالیه! آب کافی بنوش و صبحانه رو جا ننداز. ادامه بده!",
      "text": "سارا عزیز، این هفته قدم‌هات به 8200 رسیده، عالیه! مصرف آب کافی انرژی‌ات رو حفظ می‌کنه. چون صبحانه رو گاهی جا می‌ندازی، یه میوه صبح امتحان کن. هر قدم کوچیک تو رو به هدفت نزدیک‌تر می‌کنه!",
      "wellness_profile": {{
        "hydration": {{"score": 85, "reasoning": "7 لیوان نزدیک به هدف 8 است", "trend": "stable", "weekly_average_glasses": 7.0, "last_updated": "2025-05-24"}},
        "diet": {{"score": 60, "reasoning": "عدم ثبت وعده‌ها، از تاریخچه تخمین شد", "trend": "stable", "weekly_average_calories": 1800, "nutrient_balance": {{}}, "last_updated": "2025-05-24"}},
        ...
      }}
    }}
"""
    messages = [
        {"role": "system", "content": system_prompt},
    ]

    # Call the OpenAI Chat API
    response = client.chat.completions.create(
        model="gpt-4o",
        messages=messages,
        temperature=0.7,
    )

    # Extract and return the response
    reply = response.choices[0].message.content
    reply = re.sub(r'^```json\s*|\s*```$', '', reply).strip()
    
    try:
        result = json.loads(reply)
    except json.JSONDecodeError:
        raise ValueError("Failed to parse the response. Response was:\n" + reply)

    # Store output in database (team to implement)
    # Example: save_to_database(user_data["user_id"], user_data["daily_log"]["date"], result["wellness_profile"])
    
    return result