# scoring_module.py

import math

# --- Data Structures for Scoring ---

# !!! PASTE YOUR COMPLETE DISEASE_CONDITIONS DICTIONARY HERE !!!
# Example structure (replace with your full dictionary):
# --- Data Structures for Scoring ---
DISEASE_CONDITIONS = {
    "Diabetes": {
        # Main Meals
        "main": {
            "carb_to_fiber": {
                "very_bad": (20, float('inf')),
                "bad": (15, 20),
                "average": (10, 14),
                "good": (5, 9),
                "very_good": (-float('inf'), 5)
            },
            "glycemic_load": {
                "very_bad": (20, float('inf')),
                "bad": (15, 19),
                "average": (10, 14),
                "good": (5, 9),
                "very_good": (-float('inf'), 5)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.20),
                "good": (0.21, 0.25),
                "very_good": (0.25, float('inf'))
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
        },
        # Snacks
        "snacks": {
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (8, 10),
                "average": (5, 7),
                "good": (2.5, 4),
                "very_good": (-float('inf'), 2.5)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.05),
                "bad": (0.05, 0.09),
                "average": (0.10, 0.14),
                "good": (0.15, 0.25),
                "very_good": (0.25, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.05, 0.04), # توجه: بازه معکوس!
                "good": (0, 0.05),
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.01, 0.03),
                "good": (0.005, 0.01),
                "very_good": (-float('inf'), 0.005)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (151, 200),
                "average": (100, 150),
                "good": (60, 99),
                "very_good": (-float('inf'), 59)
            }
        }
    },
    "Obesity": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.25),
                "good": (0.26, 0.30),
                "very_good": (0.30, float('inf'))
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (7, 9),
                "good": (4, 6),
                "very_good": (-float('inf'), 4)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.02, 0.03),
                "very_good": (-float('inf'), 0.02)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.19),
                "good": (0.20, 0.25),
                "very_good": (0.25, float('inf'))
            },
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (8, 10),
                "average": (5, 7),
                "good": (3, 4),
                "very_good": (-float('inf'), 3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.06, 0.10),
                "average": (0.03, 0.05),
                "good": (0.01, 0.02),
                "very_good": (0.01, 0) # توجه: بازه معکوس!
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.01, 0.02),
                "very_good": (-float('inf'), 0.01)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (151, 200),
                "average": (100, 150),
                "good": (76, 99),
                "very_good": (-float('inf'), 75)
            }
        }
    },
    "Cardiovascular": {
        "main": {
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (7, 9),
                "good": (3, 6),
                "very_good": (-float('inf'), 3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.06, 0.10),
                "average": (0.03, 0.05),
                "good": (0.015, 0.02),
                "very_good": (-float('inf'), 0.015)
            },
            "fiber_per_100_calories":{
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            }
            ,
            "omega3_to_fatty_acid": {
                "very_bad": (-float('inf'), 100),
                "bad": (100, 250),
                "average": (250, 500),
                "good": (500, 1000),
                "very_good": (1000, float('inf'))
            }
        },
        "snacks": {
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.01, 0.02),
                "very_good": (-float('inf'), 0.01)
            },
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (8, 10),
                "average": (5, 7),
                "good": (2.5, 4),
                "very_good": (-float('inf'), 2.5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.06, 0.10),
                "average": (0.03, 0.05),
                "good": (0.005, 0.02),
                "very_good": (-float('inf'), 0.005)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (150, 200),
                "average": (100, 149),
                "good": (60, 99),
                "very_good": (-float('inf'), 59)
            }
        }
    },
    "PCOS": {
        "main": {
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (7, 9),
                "good": (3, 6),
                "very_good": (-float('inf'), 3)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.25),
                "good": (0.26, 0.4),
                "very_good": (0.4, float('inf'))
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_to_calories":{
                "very_bad": (-float('inf'), 2),
                "bad": (2,4),
                "average": (4,6),
                "good": (6,8),
                "very_good": (8, float('inf'))
            },
            "healthy_fats_to_total_fat": {
                "very_bad": (-float('inf'), 0.25),
                "bad": (0.25, 0.49),
                "average": (0.50, 0.74),
                "good": (0.75, 0.89),
                "very_good": (0.90, float('inf'))
            }
        },
        "snacks": {
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (8, 10),
                "average": (5, 7),
                "good": (2.5, 4),
                "very_good": (-float('inf'), 2.5)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.19),
                "good": (0.20, 0.35),
                "very_good": (0.35, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.06, 0.10),
                "average": (0.03, 0.05),
                "good": (0.005, 0.02),
                "very_good": (0, 0.005)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.02, 0.01), # توجه: بازه معکوس!
                "very_good": (-float('inf'), 0.01)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (151, 200),
                "average": (100, 150),
                "good": (76, 99),
                "very_good": (-float('inf'), 75)
            }
        }
    },
    "Hyperlipidemia": {
        "main": {
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "cholesterol_per_1000kcal": {
                "very_bad": (300, float('inf')),
                "bad": (200, 300),
                "average": (100, 199),
                "good": (30, 100),
                "very_good": (-float('inf'), 30)
            },
            "total_fat_to_calories": {
                "very_bad": (0.35, float('inf')),
                "bad": (0.30, 0.35),
                "average": (0.25, 0.29),
                "good": (0.15, 0.24),
                "very_good": (-float('inf'), 0.15)
            },
            "fiber_to_carb": {
                "very_bad": (-float('inf'), 0.05),
                "bad": (0.05, 0.09),
                "average": (0.10, 0.14),
                "good": (0.15, 0.19),
                "very_good": (0.20, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.005, 0.03),
                "very_good": (-float('inf'), 0.005)
            },
            "trans_fat_to_calories": {
                "very_bad": (0.01, float('inf')),
                "bad": (0.005, 0.01),
                "average": (0.001, 0.0049),
                "good": (0, 0.001),
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            }
        },
        "snacks": {
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.01, 0.04),
                "very_good": (-float('inf'), 0.01)
            },
            "total_fat_to_calories": {
                "very_bad": (0.30, float('inf')),
                "bad": (0.25, 0.30),
                "average": (0.20, 0.24),
                "good": (0.1, 0.20),
                "very_good": (-float('inf'), 0.10)
            },
            "fiber_to_carb": {
                "very_bad": (-float('inf'), 0.05),
                "bad": (0.05, 0.09),
                "average": (0.10, 0.14),
                "good": (0.15, 0.19),
                "very_good": (0.20, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.03, 0.04),
                "good": (0.005, 0.03),
                "very_good": (-float('inf'), 0.005)
            },
            "calorie_range": {
                "very_bad": (250, float('inf')),
                "bad": (200, 250),
                "average": (150, 199),
                "good": (80, 149),
                "very_good": (-float('inf'), 80)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            }
        }
    },
    "Sedentary Healthy Adults": {
        "main": {
            "carb_to_fiber": {
                "very_bad": (20, float('inf')),
                "bad": (15, 20),
                "average": (10, 14),
                "good": (4, 9),
                "very_good": (-float('inf'), 4)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories":{
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            }
        },
        "snacks": {
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (5, 9),
                "good": (2.5, 4),
                "very_good": (-float('inf'), 2.5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.03, 0.04),
                "good": (0.005, 0.02),
                "very_good": (-float('inf'), 0.005)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.005, 0.02),
                "very_good": (-float('inf'), 0.005)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.19),
                "good": (0.20, 0.29),
                "very_good": (0.30, float('inf'))
            },
            "calorie_range": {
                "very_bad": (250, float('inf')),
                "bad": (200, 250),
                "average": (150, 199),
                "good": (80, 149),
                "very_good": (-float('inf'), 80)
            }
        }
    },
    "Athletes": {
        "main": {
            "carb_to_calories": {
                "very_bad": (-float('inf'), 0.45),
                "bad": (0.45, 0.54),
                "average": (0.55, 0.64),
                "good": (0.65, 0.74),
                "very_good": (0.75, float('inf'))
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.24),
                "good": (0.25, 0.34),
                "very_good": (0.35, float('inf'))
            },
            "healthy_fats_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.29),
                "good": (0.30, 0.34),
                "very_good": (0.35, float('inf'))
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_to_carb":{
                "very_bad": (-float('inf'), 0.02),
                "bad": (0.02, 0.04),
                "average": (0.04 , 0.08),
                "good": (0.08, 0.16),
                "very_good": (0.016 , float('inf')) # توجه: 0.016 کوچکتر از 0.02 است! ترتیب؟
            }
        },
        "snacks": {
            "carb_to_protein": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 1.9),
                "average": (2, 2.9),
                "good": (3, 3.9),
                "very_good": (4, float('inf'))
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.19),
                "average": (0.20, 0.29),
                "good": (0.30, 0.39),
                "very_good": (0.40, float('inf'))
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "calorie_range": {
                "very_bad_low": (-float('inf'), 150),
                "very_bad_high": (500, float('inf')),
                "bad": (150, 199),
                "average": (200, 299),
                "good": (300, 400),
                "very_good": (400, 500) # or a higher value
            }
        }
    },
    # "Prediabetes" در DISEASE_CONDITIONS تعریف نشده بود
    "NAFLD": {
        "main": {
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (11, 15),
                "average": (8, 10),
                "good": (5, 7),
                "very_good": (-float('inf'), 5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "total_fat_to_calories": {
                "very_bad": (0.35, float('inf')),
                "bad": (0.30, 0.35),
                "average": (0.25, 0.29),
                "good": (0.15, 0.24),
                "very_good": (-float('inf'), 0.15)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            }
        },
        "snacks": {
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (5, 7),
                "good": (2.5, 4),
                "very_good": (-float('inf'), 2.5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.015, 0.03),
                "very_good": (-float('inf'), 0.015)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.015, 0.03), # توجه: با very_good همپوشانی دارد؟
                "very_good": (-float('inf'), 0.015)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (150, 200),
                "average": (100, 149),
                "good": (76, 99),
                "very_good": (-float('inf'), 60) # توجه: 60 تا 75 در هیچ دسته ای نیستند!
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            }
        }
    },
    "Hypertension": {
        "main": {
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.02, 0.03), # توجه: 0.015 تا 0.02 در هیچ دسته ای نیست!
                "very_good": (-float('inf'), 0.015)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.06, 0.10),
                "average": (0.03, 0.05),
                "good": (0.01, 0.02), # توجه: 0.005 تا 0.01 در هیچ دسته ای نیست!
                "very_good": (-float('inf'), 0.005)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (7, 9),
                "good": (4, 6), # توجه: 3 تا 4 در هیچ دسته ای نیست!
                "very_good": (-float('inf'), 3)
            }
        },
        "snacks": {
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (-float('inf'), 0.01), # توجه: بازه نامتعارف برای good
                "very_good": (-float('inf'), 0.005) # توجه: با good همپوشانی دارد
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.03, 0.04), # توجه: 0.04 تا 0.05 در هیچ دسته ای نیست!
                "good": (0.01, 0.02), # توجه: 0.005 تا 0.01 در هیچ دسته ای نیست!
                "very_good": (-float('inf'), 0.005)
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (150, 200),
                "average": (100, 149),
                "good": (76, 99), # توجه: 60 تا 76 در هیچ دسته ای نیست!
                "very_good": (-float('inf'), 60)
            }
        }
    },
    "Migraine": {
        "main": {
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (11, 15),
                "average": (8, 10),
                "good": (5, 7), # توجه: 5 در good و very_good?
                "very_good": (-float('inf'), 5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.02, 0.03), # توجه: 0.02 در good و very_good?
                "very_good": (0, 0.02)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06),
                "good": (0.02, 0.03), # توجه: 0.02 در good و very_good?
                "very_good": (-float('inf'), 0.02)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49),
                "good": (0.5, 0.99),
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14),
                "average": (0.15, 0.20),
                "good": (0.21, 0.25),
                "very_good": (0.25, float('inf'))
            }
        },
        "snacks": {
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (8, 10),
                "average": (5, 7),
                "good": (3, 4), # توجه: 3 در good و very_good?
                "very_good": (-float('inf'), 3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.03, 0.04), # توجه: 0.04 تا 0.05?
                "good": (0.01, 0.02), # توجه: 0.01 در good و very_good?
                "very_good": (0, 0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03),
                "good": (0.015, 0.02), # توجه: 0.015 در good و very_good?
                "very_good": (-float('inf'), 0.015)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.05),
                "bad": (0.05, 0.09),
                "average": (0.10, 0.14),
                "good": (0.15, 0.20), # توجه: 0.20 تا 0.25؟
                "very_good": (0.25, float('inf'))
            },
            "calorie_range": {
                "very_bad": (200, float('inf')),
                "bad": (150, 200),
                "average": (100, 149),
                "good": (76, 99), # توجه: 60 تا 76؟
                "very_good": (-float('inf'), 60)
            }
        }
    },
    "IBS": {
        "main": {
            "carb_to_fiber": {
                "very_bad": [(15, float('inf')), (-float('inf'), 5)], # فرمت خاص
                "bad": (10, 15),
                "average": (7, 9), # توجه: 9 تا 10؟
                "good": (6, 7),
                "very_good": (5, 6)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.01 تا 0.02؟
                "very_good": (0, 0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.03, 0.04), # توجه: 0.02 تا 0.03؟
                "very_good": (-float('inf'), 0.02)
            },
            "total_fat_to_calories": {
                "very_bad": (0.40, float('inf')),
                "bad": (0.35, 0.40),
                "average": (0.30, 0.34), # توجه: 0.34 تا 0.35؟
                "good": (0.25, 0.29), # توجه: 0.29 تا 0.30؟
                "very_good": (-float('inf'), 0.25)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49), # توجه: 1.49 تا 1.5؟
                "good": (0.5, 0.99), # توجه: 0.99 تا 1؟
                "very_good": (-float('inf'), 0.5)
            }
        },
        "snacks": {
            "carb_to_fiber": {
                "very_bad": [(10, float('inf')), (-float('inf'), 4)], # فرمت خاص
                "bad": (8, 10),
                "average": (7, 8),
                "good": (6, 7),
                "very_good": (5, 6) # توجه: 4 تا 5؟
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2),
                "average": (2, 3),
                "good": (3, 4),
                "very_good": (4, float('inf'))
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.03, 0.04), # توجه: 0.04 تا 0.05؟
                "good": (0.01, 0.02), # توجه: 0.01 در good و very_good?
                "very_good": (0, 0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.01 تا 0.015؟
                "very_good": (-float('inf'), 0.01)
            },
            "total_fat_to_calories": {
                "very_bad": (0.35, float('inf')),
                "bad": (0.30, 0.35),
                "average": (0.25, 0.29), # توجه: 0.29 تا 0.30؟
                "good": (0.20, 0.24), # توجه: 0.24 تا 0.25؟
                "very_good": (-float('inf'), 0.20)
            },
            "calorie_range": {
                "very_bad": (180, float('inf')),
                "bad": (131, 180),
                "average": (90, 130), # توجه: 130 تا 131؟
                "good": (60, 89), # توجه: 89 تا 90؟
                "very_good": (-float('inf'), 60) # ادغام excellent (0,40) و very_good (40,60)
            }
        }
    },
    "Adolescents": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.12),
                "average": (0.13, 0.15), # توجه: 0.12 تا 0.13؟
                "good": (0.16, 0.19), # توجه: 0.15 تا 0.16؟
                "very_good": (0.20, float('inf')) # ادغام very_good (0.20,0.24) و excellent (0.25,inf)
            },
            "carb_to_fiber": {
                "very_bad": (20, float('inf')),
                "bad": (15, 20),
                "average": (10, 14), # توجه: 14 تا 15؟
                "good": (7, 9), # توجه: 9 تا 10؟
                "very_good": (-float('inf'), 6) # ادغام very_good (5,6) و excellent (-inf,5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.15, float('inf')),
                "bad": (0.11, 0.15),
                "average": (0.07, 0.10), # توجه: 0.10 تا 0.11؟
                "good": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "very_good": (-float('inf'), 0.03) # ادغام very_good (0.01,0.03) و excellent (-inf,0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.02) # ادغام very_good (0.015,0.02) و excellent (-inf,0.015)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49), # توجه: 1.49 تا 1.5؟
                "good": (0.5, 0.99), # توجه: 0.99 تا 1؟
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 1.5),
                "average": (1.6, 1.9), # توجه: 1.5 تا 1.6؟ 1.9 تا 2.0؟
                "good": (2.0, 2.5), # توجه: 2.5 تا 2.6؟
                "very_good": (2.6, float('inf')) # ادغام very_good (2.6,3.0) و excellent (3.0,inf)
            }
        },
        "snacks": {
            "added_sugars_to_calories": {
                "very_bad": (0.15, float('inf')),
                "bad": (0.10, 0.15),
                "average": (0.05, 0.09), # توجه: 0.09 تا 0.10؟
                "good": (0.02, 0.04), # توجه: 0.04 تا 0.05؟
                "very_good": (0, 0.01) # ادغام very_good (0,0.01) و excellent (0,0)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (10, 15),
                "average": (7, 9), # توجه: 9 تا 10؟
                "good": (4, 6), # توجه: 6 تا 7؟
                "very_good": (-float('inf'), 3) # ادغام very_good (2.5,3) و excellent (-inf,2.5)
            },
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.05),
                "bad": (0.05, 0.09), # توجه: 0.09 تا 0.10؟
                "average": (0.10, 0.14), # توجه: 0.14 تا 0.15؟
                "good": (0.15, 0.19), # توجه: 0.19 تا 0.20؟
                "very_good": (0.20, float('inf'))
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.02 تا 0.02؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good (0.01,0.015) و excellent (-inf,0.01)
            },
            "calorie_range": {
                "very_bad": (300, float('inf')),
                "bad": (251, 300),
                "average": (200, 250), # توجه: 250 تا 251؟
                "good": (150, 199), # توجه: 199 تا 200؟
                "very_good": (-float('inf'), 149) # ادغام very_good (100,149) و excellent (-inf,100)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 1.5),
                "average": (1.6, 1.9), # توجه: 1.5 تا 1.6؟ 1.9 تا 2.0؟
                "good": (2.0, 2.5), # توجه: 2.5 تا 2.5؟
                "very_good": (2.5, float('inf'))
            }
        }
    },
    "Pregnant Women": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.24), # توجه: 0.19 تا 0.20؟
                "good": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "very_good": (0.30, float('inf')) # ادغام very_good(0.30,0.34) و excellent(0.35,inf)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (11, 15),
                "average": (8, 10), # توجه: 10 تا 11؟
                "good": (5, 7), # توجه: 7 تا 8؟
                "very_good": (-float('inf'), 4) # ادغام very_good(3.5,4) و excellent(-inf,3.5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (0, 0.01) # ادغام very_good(0,0.01) و excellent(0,0)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.02) # ادغام very_good(0.01,0.02) و excellent(-inf,0.01)
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49), # توجه: 1.49 تا 1.5؟
                "good": (0.5, 0.99), # توجه: 0.99 تا 1؟
                "very_good": (-float('inf'), 0.5)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2), # توجه: 2 تا 2.1؟
                "average": (2.1, 2.5),
                "good": (2.6, 3.0), # توجه: 2.5 تا 2.6؟
                "very_good": (3.0, float('inf'))
            }
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14), # توجه: 0.14 تا 0.15؟
                "average": (0.15, 0.19), # توجه: 0.19 تا 0.20؟
                "good": (0.20, 0.24), # توجه: 0.24 تا 0.25؟
                "very_good": (0.25, float('inf'))
            },
            "carb_to_fiber": {
                "very_bad": (12, float('inf')),
                "bad": (9, 12),
                "average": (6, 8), # توجه: 8 تا 9؟
                "good": (4, 5), # توجه: 5 تا 6؟
                "very_good": (-float('inf'), 3.5) # ادغام very_good(3,3.5) و excellent(-inf,3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.02, 0.04), # توجه: 0.04 تا 0.05؟
                "good": (0, 0.01), # توجه: 0.01 تا 0.02؟
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.02 تا 0.02؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            },
            "calorie_range": {
                "very_bad": (250, float('inf')),
                "bad": (201, 250),
                "average": (150, 200), # توجه: 200 تا 201؟
                "good": (100, 149), # توجه: 149 تا 150؟
                "very_good": (-float('inf'), 100)
            }
        }
    },
    "Lactating Women": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.18),
                "bad": (0.18, 0.21),
                "average": (0.22, 0.25), # توجه: 0.21 تا 0.22؟
                "good": (0.26, 0.30), # توجه: 0.25 تا 0.26؟
                "very_good": (0.31, float('inf')) # ادغام very_good(0.31,0.34) و excellent(0.35,inf)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (11, 15),
                "average": (8, 10), # توجه: 10 تا 11؟
                "good": (5, 7), # توجه: 7 تا 8؟
                "very_good": (-float('inf'), 4) # ادغام very_good(3.5,4) و excellent(-inf,3.5)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (0, 0.01) # ادغام very_good(0,0.01) و excellent(0,0)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.02) # ادغام very_good(0.01,0.02) و excellent(-inf,0.01)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 2), # توجه: 2 تا 2.1؟
                "average": (2.1, 2.5),
                "good": (2.6, 3.0), # توجه: 2.5 تا 2.6؟
                "very_good": (3.0, float('inf'))
            },
            "sodium_to_potassium": {
                "very_bad": (2, float('inf')),
                "bad": (1.5, 2),
                "average": (1, 1.49), # توجه: 1.49 تا 1.5؟
                "good": (0.5, 0.99), # توجه: 0.99 تا 1؟
                "very_good": (-float('inf'), 0.5)
            }
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.24), # توجه: 0.19 تا 0.20؟
                "good": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "very_good": (0.30, float('inf'))
            },
            "carb_to_fiber": {
                "very_bad": (12, float('inf')),
                "bad": (9, 12),
                "average": (6, 8), # توجه: 8 تا 9؟
                "good": (4, 5), # توجه: 5 تا 6؟
                "very_good": (-float('inf'), 3.5) # ادغام very_good(3,3.5) و excellent(-inf,3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.05, 0.10),
                "average": (0.02, 0.04), # توجه: 0.04 تا 0.05؟
                "good": (0, 0.01), # توجه: 0.01 تا 0.02؟
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.02 تا 0.02؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            },
            "calorie_range": {
                "very_bad": (300, float('inf')),
                "bad": (251, 300),
                "average": (200, 250), # توجه: 250 تا 251؟
                "good": (150, 199), # توجه: 199 تا 200؟
                "very_good": (-float('inf'), 150)
            }
        }
    },
    "Older Adults": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.24), # توجه: 0.19 تا 0.20؟
                "good": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "very_good": (0.30, float('inf')) # ادغام very_good(0.30,0.34) و excellent(0.35,inf)
            },
            "sodium_to_potassium": {
                "very_bad": (1.5, float('inf')),
                "bad": (1.0, 1.5),
                "average": (0.7, 0.99), # توجه: 0.99 تا 1.0؟
                "good": (0.5, 0.69), # توجه: 0.69 تا 0.7؟
                "very_good": (-float('inf'), 0.5) # ادغام very_good(0.3,0.5) و excellent(-inf,0.3)
            },
            "carb_to_fiber": {
                "very_bad": (18, float('inf')),
                "bad": (14, 18),
                "average": (10, 13), # توجه: 13 تا 14؟
                "good": (7, 9), # توجه: 9 تا 10؟
                "very_good": (-float('inf'), 6) # ادغام very_good(5,6) و excellent(-inf,5)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.08, float('inf')),
                "bad": (0.05, 0.08),
                "average": (0.03, 0.04), # توجه: 0.04 تا 0.05؟
                "good": (0.01, 0.02), # توجه: 0.02 تا 0.03؟
                "very_good": (0, 0.005) # ادغام very_good(0,0.005) و excellent(0,0)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1.5),
                "bad": (1.5, 2.0),
                "average": (2.1, 2.5), # توجه: 2.0 تا 2.1؟
                "good": (2.6, 3.0), # توجه: 2.5 تا 2.6؟
                "very_good": (3.0, float('inf'))
            }
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.10),
                "bad": (0.10, 0.14), # توجه: 0.14 تا 0.15؟
                "average": (0.15, 0.19), # توجه: 0.19 تا 0.20؟
                "good": (0.20, 0.24), # توجه: 0.24 تا 0.25؟
                "very_good": (0.25, float('inf'))
            },
            "sodium_to_potassium": {
                "very_bad": (1.2, float('inf')),
                "bad": (0.8, 1.2),
                "average": (0.5, 0.79), # توجه: 0.79 تا 0.8؟
                "good": (0.3, 0.49), # توجه: 0.49 تا 0.5؟
                "very_good": (-float('inf'), 0.3) # ادغام very_good(0.2,0.3) و excellent(-inf,0.2)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0, 0.01), # توجه: 0.01 تا 0.02؟
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "carb_to_fiber": {
                "very_bad": (12, float('inf')),
                "bad": (9, 12),
                "average": (6, 8), # توجه: 8 تا 9؟
                "good": (4, 5), # توجه: 5 تا 6؟
                "very_good": (-float('inf'), 4)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.02 تا 0.02؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            },
            "calorie_range": {
                "very_bad": (150, float('inf')),
                "bad": (121, 150),
                "average": (100, 120), # توجه: 120 تا 121؟
                "good": (75, 99), # توجه: 99 تا 100؟
                "very_good": (-float('inf'), 75) # ادغام very_good(60,75) و excellent(-inf,60)
            }
        }
    },
    "Weight Loss": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.18),
                "bad": (0.18, 0.22),
                "average": (0.23, 0.27), # توجه: 0.22 تا 0.23؟
                "good": (0.28, 0.32), # توجه: 0.27 تا 0.28؟
                "very_good": (0.33, float('inf')) # ادغام very_good(0.33,0.37) و excellent(0.38,inf)
            },
            "carb_to_fiber": {
                "very_bad": (15, float('inf')),
                "bad": (11, 15),
                "average": (8, 10), # توجه: 10 تا 11؟
                "good": (5, 7), # توجه: 7 تا 8؟
                "very_good": (-float('inf'), 4.5) # ادغام very_good(4,4.5) و excellent(-inf,4)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1.5),
                "bad": (1.5, 2.4),
                "average": (2.5, 3.4), # توجه: 2.4 تا 2.5؟
                "good": (3.5, 4.4), # توجه: 3.4 تا 3.5؟
                "very_good": (4.5, float('inf')) # توجه: 4.4 تا 4.5؟
            },
            "added_sugars_to_calories": {
                "very_bad": (0.08, float('inf')),
                "bad": (0.05, 0.08),
                "average": (0.03, 0.04), # توجه: 0.04 تا 0.05؟
                "good": (0.01, 0.02), # توجه: 0.02 تا 0.03؟
                "very_good": (0, 0.005) # ادغام very_good(0,0.005) و excellent(0,0)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            }
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.24), # توجه: 0.19 تا 0.20؟
                "good": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "very_good": (0.30, float('inf'))
            },
            "calorie_range": {
                "very_bad": (150, float('inf')),
                "bad": (121, 150),
                "average": (100, 120), # توجه: 120 تا 121؟
                "good": (75, 99), # توجه: 99 تا 100؟
                "very_good": (-float('inf'), 75) # ادغام very_good(60,75) و excellent(-inf,60)
            },
            "carb_to_fiber": {
                "very_bad": (10, float('inf')),
                "bad": (7, 10),
                "average": (5, 6), # توجه: 6 تا 7؟
                "good": (3.5, 4), # توجه: 4 تا 5؟
                "very_good": (-float('inf'), 3.5) # ادغام very_good(3,3.5) و excellent(-inf,3)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.05, float('inf')),
                "bad": (0.03, 0.05),
                "average": (0.01, 0.02), # توجه: 0.02 تا 0.03؟
                "good": (0, 0.005), # توجه: 0.005 تا 0.01؟
                "very_good": (0, 0) # توجه: بازه (0,0)!
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0.015, 0.02), # توجه: 0.02 تا 0.02؟
                "very_good": (-float('inf'), 0.015) # ادغام very_good(0.01,0.015) و excellent(-inf,0.01)
            }
        }
    },
    "Muscle Gain": {
        "main": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.20),
                "bad": (0.20, 0.24),
                "average": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "good": (0.30, 0.34), # توجه: 0.29 تا 0.30؟
                "very_good": (0.35, float('inf')) # ادغام very_good(0.35,0.37) و excellent(0.38,inf)
            },
            "carb_to_calories": {
                "very_bad": (-float('inf'), 0.35),
                "bad": (0.35, 0.44),
                "average": (0.45, 0.54), # توجه: 0.44 تا 0.45؟
                "good": (0.55, 0.60), # توجه: 0.54 تا 0.55؟
                "very_good": (0.61, float('inf')) # ادغام very_good(0.61,0.65) و excellent(0.65,inf)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (0, 0.02) # ادغام very_good(0,0.02) و excellent(0,0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (-float('inf'), 0.02) # ادغام very_good(0,0.02) و excellent(-inf,0.015)
            },
            "total_fat_to_calories": {
                "very_bad": (0.40, float('inf')),
                "bad": (0.35, 0.40),
                "average": (0.30, 0.34), # توجه: 0.34 تا 0.35؟
                "good": (0.25, 0.29), # توجه: 0.29 تا 0.30؟
                "very_good": (-float('inf'), 0.24) # ادغام very_good(0.20,0.24) و excellent(-inf,0.20)
            },
            "fiber_per_100_calories": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 1.5),
                "average": (1.6, 2.0), # توجه: 1.5 تا 1.6؟
                "good": (2.1, 2.5), # توجه: 2.0 تا 2.1؟
                "very_good": (2.5, float('inf'))
            }
        },
        "snacks": {
            "protein_to_calories": {
                "very_bad": (-float('inf'), 0.15),
                "bad": (0.15, 0.19),
                "average": (0.20, 0.24), # توجه: 0.19 تا 0.20؟
                "good": (0.25, 0.29), # توجه: 0.24 تا 0.25؟
                "very_good": (0.30, float('inf')) # ادغام very_good(0.30,0.34) و excellent(0.35,inf)
            },
            "carb_to_protein": {
                "very_bad": (-float('inf'), 1),
                "bad": (1, 1.9),
                "average": (2, 2.9),
                "good": (3, 3.9),
                "very_good": (4, float('inf'))
            },
            "calorie_range": {
                "very_bad_low": (-float('inf'), 150),
                "very_bad_high": (500, float('inf')),
                "bad": (150, 199),
                "average": (200, 299),
                "good": (300, 399), # توجه: 399 تا 400؟
                "very_good": (400, 500)
            },
            "added_sugars_to_calories": {
                "very_bad": (0.10, float('inf')),
                "bad": (0.07, 0.10),
                "average": (0.04, 0.06), # توجه: 0.06 تا 0.07؟
                "good": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "very_good": (0, 0.02) # ادغام very_good(0,0.02) و excellent(0,0.01)
            },
            "saturated_fat_to_calories": {
                "very_bad": (0.07, float('inf')),
                "bad": (0.04, 0.07),
                "average": (0.02, 0.03), # توجه: 0.03 تا 0.04؟
                "good": (0, 0.015), # توجه: بازه نامتعارف good
                "very_good": (0, 0.01) # توجه: با good همپوشانی دارد
            }
        }
    }
}

WEIGHTS = {
    "Diabetes": {
        "main": {
            "carb_to_fiber": 0.3,
            "glycemic_load": 0.25,
            "protein_to_calories": 0.2,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.10,
        },
        "snacks": {
            "carb_to_fiber": 0.35,
            "protein_to_calories": 0.25,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.10
        }
    },
    "Obesity": {
        "main": {
            "protein_to_calories": 0.30,
            "carb_to_fiber": 0.25,
            "saturated_fat_to_calories": 0.2,
            "sodium_to_potassium": 0.25,
        },
        "snacks": {
            "protein_to_calories": 0.30,
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.2,
            "saturated_fat_to_calories": 0.15,
            "calorie_range": 0.1
        }
    },
    "Cardiovascular": {
        "main": {
            "sodium_to_potassium": 0.3,
            "saturated_fat_to_calories": 0.25,
            "carb_to_fiber": 0.15,
            "added_sugars_to_calories": 0.10,
            "fiber_per_100_calories": 0.15,
            "omega3_to_fatty_acid": 0.5
        },
        "snacks": {
            "sodium_to_potassium": 0.35,
            "saturated_fat_to_calories": 0.25,
            "carb_to_fiber": 0.2,
            "added_sugars_to_calories": 0.15,
            "calorie_range": 0.05
        }
    },
    "PCOS": {
        "main": {
            "carb_to_fiber": 0.3,
            "protein_to_calories": 0.2,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.1,
            "fiber_to_calories": 0.15,
            "healthy_fats_to_total_fat": 0.1
            
        },
        "snacks": {
            "carb_to_fiber": 0.35,
            "protein_to_calories": 0.25,
            "added_sugars_to_calories": 0.2,
            "saturated_fat_to_calories": 0.1,
            "calorie_range": 0.1
        }
    },
    "Hyperlipidemia": {
        "main": {
            "saturated_fat_to_calories": 0.25,
            "cholesterol_per_1000kcal": 0.1,
            "total_fat_to_calories": 0.1,
            "fiber_to_carb": 0.2,
            "added_sugars_to_calories": 0.1,
            "trans_fat_to_calories": 0.1,
            "sodium_to_potassium": 0.05
        },
        "snacks": {
            "saturated_fat_to_calories": 0.3,
            "total_fat_to_calories": 0.15,
            "fiber_to_carb": 0.2,
            "added_sugars_to_calories": 0.15,
            "calorie_range": 0.1,
            "sodium_to_potassium": 0.1
        }
    },
    "Sedentary Healthy Adults": {
        "main": {
            "carb_to_fiber": 0.2,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.15,
            "fiber_per_100_calories": 0.2
        },
        "snacks": {
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.25,
            "saturated_fat_to_calories": 0.15,
            "protein_to_calories": 0.2,
            "calorie_range": 0.15
        }
    },
    "Athletes": {
        "main": {
            "carb_to_calories": 0.3,
            "protein_to_calories": 0.25,
            "healthy_fats_to_calories": 0.20,
            "sodium_to_potassium": 0.15,
            "fiber_to_carb": 10
        },
        "snacks": {
            "carb_to_protein": 0.35,
            "protein_to_calories": 0.25,
            "sodium_to_potassium": 0.20,
            "calorie_range": 0.20
        }
    },
    "Prediabetes": {
        "main": {
            "carb_to_fiber": 0.35,
            "protein_to_calories": 0.20,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.05,
            "fiber_per_100_calories": 0.05
        },
        "snacks": {
            "carb_to_fiber": 0.35,
            "protein_to_calories": 0.25,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.10
        }
    },
    "NAFLD": {
        "main": {
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.25,
            "saturated_fat_to_calories": 0.2,
            "total_fat_to_calories": 0.2,
            "fiber_per_100_calories": 0.1
        },
        "snacks": {
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.25,
            "saturated_fat_to_calories": 0.2,
            "calorie_range": 0.2,
            "fiber_per_100_calories": 0.1
        }
    },
    "Hypertension": {
        "main": {
            "sodium_to_potassium": 0.3,
            "fiber_per_100_calories": 0.2,
            "saturated_fat_to_calories": 0.2,
            "added_sugars_to_calories": 0.15,
            "carb_to_fiber": 0.15
        },
        "snacks": {
            "sodium_to_potassium": 0.3,
            "fiber_per_100_calories": 0.2,
            "saturated_fat_to_calories": 0.2,
            "added_sugars_to_calories": 0.15,
            "calorie_range": 0.15
        }
    },
    "Migraine": {
        "main": {
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.15,
            "fiber_per_100_calories": 0.15,
            "protein_to_calories": 0.10
        },
        "snacks": {
            "carb_to_fiber": 0.30,
            "added_sugars_to_calories": 0.25,
            "saturated_fat_to_calories": 0.15,
            "protein_to_calories": 0.15,
            "calorie_range": 0.15
        }
    },
    "IBS": {
        "main": {
            "carb_to_fiber": 0.25,
            "fiber_per_100_calories": 0.25,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.15,
            "total_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.05
        },
        "snacks": {
            "carb_to_fiber": 0.30,
            "fiber_per_100_calories": 0.25,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.10,
            "total_fat_to_calories": 0.10,
            "calorie_range": 0.05
        }
    },
    "Adolescents": {
        "main": {
            "protein_to_calories": 0.25,
            "carb_to_fiber": 0.20,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.10,
            "fiber_per_100_calories": 0.10
        },
        "snacks": {
            "added_sugars_to_calories": 0.25,
            "carb_to_fiber": 0.25,
            "protein_to_calories": 0.20,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.15,
            "fiber_per_100_calories": 0.05
        }
    },
    "Pregnant Women": {
        "main": {
            "protein_to_calories": 0.25,
            "carb_to_fiber": 0.20,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.15,
            "sodium_to_potassium": 0.10,
            "fiber_per_100_calories": 0.10
        },
        "snacks": {
            "protein_to_calories": 0.30,
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.25,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.10
        }
    },
    "Lactating Women": {
        "main": {
            "protein_to_calories": 0.35,
            "carb_to_fiber": 0.20,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.15,
            "fiber_per_100_calories": 0.10,
            "sodium_to_potassium": 0.05
        },
        "snacks": {
            "protein_to_calories": 0.35,
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.20,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.10
        }
    },
    "Older Adults": {
        "main": {
            "protein_to_calories": 0.30,
            "sodium_to_potassium": 0.20,
            "carb_to_fiber": 0.15,
            "saturated_fat_to_calories": 0.15,
            "added_sugars_to_calories": 0.10,
            "fiber_per_100_calories": 0.10
        },
        "snacks": {
            "protein_to_calories": 0.30,
            "sodium_to_potassium": 0.25,
            "added_sugars_to_calories": 0.15,
            "carb_to_fiber": 0.15,
            "saturated_fat_to_calories": 0.10,
            "calorie_range": 0.05
        }
    },
    "Weight Loss": {
        "main": {
            "protein_to_calories": 0.30,
            "carb_to_fiber": 0.25,
            "fiber_per_100_calories": 0.15,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.15
        },
        "snacks": {
            "protein_to_calories": 0.35,
            "calorie_range": 0.20,
            "carb_to_fiber": 0.25,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.05
        }
    },
    "Muscle Gain": {
        "main": {
            "protein_to_calories": 0.35,
            "carb_to_calories": 0.20,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.10,
            "total_fat_to_calories": 0.10,
            "fiber_per_100_calories": 0.10
        },
        "snacks": {
            "protein_to_calories": 0.30,
            "carb_to_protein": 0.30,
            "calorie_range": 0.20,
            "added_sugars_to_calories": 0.15,
            "saturated_fat_to_calories": 0.05
        }
    }
}

SCORES = {
    "very_good": 10,
    "good": 8,
    "average": 5,
    "bad": 0,
    "very_bad": -2,
}

# In scoring_module.py

# ... (Keep existing functions like safe_float, calculate_all_metrics_for_food, get_score_from_metrics etc.) ...

# --- NEW HELPER: Calculate metrics from total nutrient dictionary ---
def calculate_all_metrics_for_food_from_totals(total_nutrients_dict, meal_category):
    """
    Calculates scoring metrics directly from a dictionary containing
    the SUM of actual nutrients for the entire meal/sequence.
    """
    metrics = {}
    # Get total values safely
    c_energy = total_nutrients_dict.get('calories', 1.0); c_energy = max(c_energy, 1.0)
    c_protein = total_nutrients_dict.get('protein', 0.0)
    c_carbs = total_nutrients_dict.get('carbohydrate', 0.0)
    c_fiber = total_nutrients_dict.get('dietary_fiber', 0.0)
    c_sugars = total_nutrients_dict.get('total_sugars', 0.0)
    c_added_sugars = total_nutrients_dict.get('added_sugar_g')
    c_sat_fat = total_nutrients_dict.get('total_saturated', 0.0)
    c_sodium = total_nutrients_dict.get('sodium', 0.0)
    c_potassium = total_nutrients_dict.get('potassium', 1.0); c_potassium = max(c_potassium, 1.0)
    c_mono_fat = total_nutrients_dict.get('total_monounsaturated', 0.0)
    c_poly_fat = total_nutrients_dict.get('total_polyunsaturated', 0.0)
    c_total_fat = total_nutrients_dict.get('total_fat', 0.0)
    c_omega3 = total_nutrients_dict.get('omega_3')
    c_cholesterol = total_nutrients_dict.get('cholesterol', 0.0)
    c_trans_fat = total_nutrients_dict.get('total_trans', 0.0)
    c_gl = total_nutrients_dict.get('gl')

    # Calculate metrics based on these TOTALS
    metrics["protein_to_calories"] = c_protein / c_energy
    metrics["carb_to_fiber"] = c_carbs / c_fiber if c_fiber > 0 else float('inf')
    sugar_source = c_added_sugars if c_added_sugars is not None else c_sugars
    metrics["added_sugars_to_calories"] = sugar_source / c_energy
    metrics["saturated_fat_to_calories"] = c_sat_fat / c_energy
    metrics["sodium_to_potassium"] = c_sodium / c_potassium
    metrics["fiber_per_100_calories"] = (c_fiber / c_energy) * 100
    metrics["total_fat_to_calories"] = c_total_fat / c_energy
    if c_gl is not None: metrics["glycemic_load"] = c_gl # Use combined GL
    if c_omega3 is not None:
        total_fatty_acids = c_mono_fat + c_poly_fat + c_sat_fat
        metrics["omega3_to_fatty_acid"] = c_omega3 / total_fatty_acids if total_fatty_acids > 0 else float('inf')
    metrics["fiber_to_calories"] = c_fiber / c_energy
    metrics["healthy_fats_to_total_fat"] = (c_poly_fat + c_mono_fat) / c_total_fat if c_total_fat > 0 else 0.0
    metrics["cholesterol_per_1000kcal"] = (c_cholesterol / c_energy) * 1000
    metrics["fiber_to_carb"] = c_fiber / c_carbs if c_carbs > 0 else float('inf')
    metrics["trans_fat_to_calories"] = c_trans_fat / c_energy
    metrics["carb_to_calories"] = c_carbs / c_energy
    metrics["healthy_fats_to_calories"] = (c_mono_fat + c_poly_fat) / c_energy
    metrics["carb_to_protein"] = c_carbs / c_protein if c_protein > 0 else float('inf')
    # calorie_range uses the total actual calories
    metrics["calorie_range"] = c_energy # Use the total energy (which is total actual calories here)

    return metrics

# --- Helper Functions for Scoring ---

def safe_float(value, default=None):
    """Safely convert value to float, return default on error or None."""
    if value is None: return default
    try: return float(value)
    except (ValueError, TypeError): return default

def categorize_metric(value, condition_thresholds):
    """Categorizes a numeric value based on threshold ranges."""
    if value is None or not isinstance(value, (int, float)) or math.isinf(value) or math.isnan(value):
        return "average" # Default for non-numeric, None, NaN, Inf
    for category, range_value in condition_thresholds.items():
        # Handle list of tuples (like for IBS)
        if isinstance(range_value, list):
            for low, high in range_value:
                if isinstance(low, (int, float)) and isinstance(high, (int, float)) and low <= value < high:
                     return category
        # Handle single tuple
        elif isinstance(range_value, tuple) and len(range_value) == 2:
            low, high = range_value
            if isinstance(low, (int, float)) and isinstance(high, (int, float)) and low <= value < high:
                 return category
        # else: ignore unexpected formats in thresholds dict
    return "average" # Default if no category matches

def calculate_all_metrics_for_food(food_dict, meal_category):
    """
    Calculates nutrient ratios and metrics (EXCEPT calorie_range) needed for scoring
    from a raw food dict, typically based on 100g values.
    """
    metrics = {}
    # Get nutrient values safely
    energy = safe_float(food_dict.get("Energy") or food_dict.get("Calories"), 1.0); energy = max(energy, 1.0)
    protein = safe_float(food_dict.get("Protein") or food_dict.get("Protein_g"), 0.0)
    carbs = safe_float(food_dict.get("Carbohydrate") or food_dict.get("Carbohydrates_g"), 0.0)
    fiber = safe_float(food_dict.get("Dietary Fiber") or food_dict.get("Fiber_g"), 0.0)
    sugars = safe_float(food_dict.get("Total Sugars") or food_dict.get("Sugar_g"), 0.0)
    added_sugars = safe_float(food_dict.get("AddedSugar_g"))
    sat_fat = safe_float(food_dict.get("Total Saturated") or food_dict.get("SaturatedFat_g"), 0.0)
    sodium = safe_float(food_dict.get("Sodium") or food_dict.get("Sodium_mg"), 0.0)
    potassium = safe_float(food_dict.get("Potassium") or food_dict.get("Potassium_mg"), 1.0); potassium = max(potassium, 1.0)
    mono_fat = safe_float(food_dict.get("Total Monounsaturated") or food_dict.get("MonounsaturatedFat_g"), 0.0)
    poly_fat = safe_float(food_dict.get("Total Polyunsaturated") or food_dict.get("PolyunsaturatedFat_g"), 0.0)
    total_fat = safe_float(food_dict.get("Total Fat") or food_dict.get("Fat_g"), 0.0)
    omega3 = safe_float(food_dict.get("Omega-3"))
    cholesterol = safe_float(food_dict.get("Cholesterol") or food_dict.get("Cholesterol_mg"), 0.0)
    trans_fat = safe_float(food_dict.get("Total Trans") or food_dict.get("TransFat_g"), 0.0)
    gl_value = safe_float(food_dict.get("GL") or food_dict.get("glycemic_load"))

    # Calculate metrics (excluding calorie_range)
    metrics["protein_to_calories"] = protein / energy
    metrics["carb_to_fiber"] = carbs / fiber if fiber > 0 else float('inf')
    sugar_source = added_sugars if added_sugars is not None else sugars
    metrics["added_sugars_to_calories"] = sugar_source / energy
    metrics["saturated_fat_to_calories"] = sat_fat / energy
    metrics["sodium_to_potassium"] = sodium / potassium
    metrics["fiber_per_100_calories"] = (fiber / energy) * 100
    metrics["total_fat_to_calories"] = total_fat / energy
    if gl_value is not None: metrics["glycemic_load"] = gl_value # Keep non-ratio GL
    if omega3 is not None:
        total_fatty_acids = mono_fat + poly_fat + sat_fat
        metrics["omega3_to_fatty_acid"] = omega3 / total_fatty_acids if total_fatty_acids > 0 else float('inf')
    metrics["fiber_to_calories"] = fiber / energy
    metrics["healthy_fats_to_total_fat"] = (poly_fat + mono_fat) / total_fat if total_fat > 0 else 0.0
    metrics["cholesterol_per_1000kcal"] = (cholesterol / energy) * 1000
    metrics["fiber_to_carb"] = fiber / carbs if carbs > 0 else float('inf')
    metrics["trans_fat_to_calories"] = trans_fat / energy
    metrics["carb_to_calories"] = carbs / energy
    metrics["healthy_fats_to_calories"] = (mono_fat + poly_fat) / energy
    metrics["carb_to_protein"] = carbs / protein if protein > 0 else float('inf')
    # if meal_category == "snacks": metrics["calorie_range"] = energy # <--- REMOVED THIS LINE

    return metrics

# --- Keep get_score_from_metrics unchanged ---
def get_score_from_metrics(calculated_metrics, score_condition, meal_category):
    # ... (This function remains exactly the same as before) ...
    score = 0.0
    if not isinstance(calculated_metrics, dict): return 0.0
    if score_condition not in DISEASE_CONDITIONS or score_condition not in WEIGHTS: return 0.0
    if meal_category not in ["main", "snacks"]: return 0.0
    condition_rules = DISEASE_CONDITIONS[score_condition].get(meal_category)
    condition_weights = WEIGHTS[score_condition].get(meal_category)
    if not condition_rules or not condition_weights: return 0.0
    for metric, thresholds in condition_rules.items():
        metric_value = calculated_metrics.get(metric)
        weight = condition_weights.get(metric, 0)
        if metric_value is not None and isinstance(metric_value, (int, float)) and \
           not math.isinf(metric_value) and not math.isnan(metric_value) and weight != 0:
            category = categorize_metric(metric_value, thresholds)
            base_score = SCORES.get(category, 5)
            try: weighted_score = float(base_score) * float(weight); score += weighted_score
            except (ValueError, TypeError) as e: print(f"Warning: Error calculating weighted score for metric '{metric}': {e}")
    return score
# --- Core Scoring Function (Uses Pre-calculated Metrics) ---
def get_score_from_metrics(calculated_metrics, score_condition, meal_category):
    """
    Calculates the suitability score based on pre-calculated metrics dictionary.
    """
    score = 0.0
    # Validate inputs
    if not isinstance(calculated_metrics, dict): return 0.0
    if score_condition not in DISEASE_CONDITIONS or score_condition not in WEIGHTS: return 0.0
    if meal_category not in ["main", "snacks"]: return 0.0

    # Get rules and weights safely
    condition_rules = DISEASE_CONDITIONS[score_condition].get(meal_category)
    condition_weights = WEIGHTS[score_condition].get(meal_category)

    if not condition_rules or not condition_weights: return 0.0

    # Calculate weighted score
    for metric, thresholds in condition_rules.items():
        metric_value = calculated_metrics.get(metric)
        weight = condition_weights.get(metric, 0)

        if metric_value is not None and isinstance(metric_value, (int, float)) and \
           not math.isinf(metric_value) and not math.isnan(metric_value) and weight != 0:
            category = categorize_metric(metric_value, thresholds)
            base_score = SCORES.get(category, 5) # Default to average
            try:
                weighted_score = float(base_score) * float(weight)
                score += weighted_score
            except (ValueError, TypeError) as e:
                 print(f"Warning: Error calculating weighted score for metric '{metric}': {e}")

    return score

# You could optionally keep the old get_score_for_food here as a wrapper
# if you sometimes need to score directly from a raw food dict without combined metrics
# def get_score_for_food(food_dict, score_condition, meal_category):
#     """ Calculates score directly from raw food_dict. """
#     metrics = calculate_all_metrics_for_food(food_dict, meal_category)
#     return get_score_from_metrics(metrics, score_condition, meal_category)

# --- END OF scoring_module.py ---