from neo4j import GraphDatabase

# -------------------------------
# Neo4j connection configuration
# -------------------------------
# URI = "bolt://172.164.240.161:7687"
USER = "neo4j"
PASSWORD = "@MahilaMoghadami@"

# driver = GraphDatabase.driver(URI, auth=(USER, PASSWORD))

# -------------------------------
# Function: update multiple foods efficiently
# -------------------------------
def update_foods(user_token: str, food_codes: list, action: str, log_factor: float = 0.5):
    """
    Efficiently update INTERACTED relationships for multiple FoodCodes.
    
    - action: "like", "dislike", "log"
    - log_factor: fixed weight contribution for each log action
    """

    if action not in ("like", "dislike", "log"):
        raise ValueError("action must be 'like', 'dislike' or 'log'")

    query = """
    MATCH (u:User {token: $token})
    UNWIND $food_codes AS fc
    MATCH (f:Food {FoodCode: fc})
    MERGE (u)-[i:INTERACTED]->(f)

    // Like/dislike toggle
    SET i.like = CASE
        WHEN $action='like' AND coalesce(i.like,0)=1 THEN 0
        WHEN $action='like' THEN 1
        ELSE coalesce(i.like,0)
    END,
    i.dislike = CASE
        WHEN $action='dislike' AND coalesce(i.dislike,0)=1 THEN 0
        WHEN $action='dislike' THEN 1
        ELSE coalesce(i.dislike,0)
    END,

    i.weight = CASE
        WHEN $action='like' AND coalesce(i.like,0)=0 THEN coalesce(i.weight,0)+1
        WHEN $action='like' AND coalesce(i.like,0)=1 THEN coalesce(i.weight,0)-1
        WHEN $action='dislike' AND coalesce(i.dislike,0)=0 THEN coalesce(i.weight,0)-1
        WHEN $action='dislike' AND coalesce(i.dislike,0)=1 THEN coalesce(i.weight,0)+1
        WHEN $action='log' THEN coalesce(i.weight,0)+$log_factor
        ELSE coalesce(i.weight,0)
    END,

    i.log = CASE WHEN $action='log' THEN coalesce(i.log,0)+1 ELSE coalesce(i.log,0) END,
    i.updated_at = datetime()

    RETURN i
    """

    # with driver.session() as session:
    #     result = session.run(
    #         query,
    #         token=user_token,
    #         food_codes=food_codes,
    #         action=action,
    #         log_factor=log_factor
    #     )
    #     records = result.values("i")
    #     print(f"Updated {len(records)} relations")
    #     for r in records:
    #         print(r)

# -------------------------------
# Example usage
# -------------------------------

# Toggle like for multiple foods
update_foods(
    user_token="12345678901234567890",
    food_codes=[90024, 90025, 90026],
    action="like"
)

# Log consumption for multiple foods
update_foods(
    user_token="12345678901234567890",
    food_codes=[90024, 90025],
    action="log"
)

# Toggle dislike for multiple foods
update_foods(
    user_token="12345678901234567890",
    food_codes=[90024, 90026],
    action="dislike"
)
