import os
import base64
import json
import re
from openai import OpenAI
from django.conf import settings
import uuid
import datetime

# Settings
OPENAI_API_KEY = "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"  # Replace with your OpenAI API key
IMAGE_PATH = "WA.png"  
COVER_IMAGE_PATH = "APIs/modules/assets/cover_image.jpg"  
WELCOME_IMAGE_PATH = "APIs/modules/assets/welcome_image.png" 
LOGO_PATH = "APIs/modules/assets/lacto_logo.png"  
CSS_PATH = "styles.css"
OUTPUT_TXT_FILE = "body_composition_analysis.txt"
OUTPUT_HTML_FILE = "body_composition_report.html"
# JSON template
JSON_TEMPLATE = {
    "identification": {
        "id": None,
        "gender": None,
        "age": None,
        "height": None,
        "testing_time": None
    },
    "body_composition_analysis": [
        {
            "indicator": "Weight",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Fat mass",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Bone Mass",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Protein mass",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Water weight",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Muscle mass",
            "value": None,
            "evaluation": None
        },
        {
            "indicator": "Skeletal muscle",
            "value": None,
            "evaluation": None
        }
    ],
    "muscle_fat_analysis": {
        "weight": None,
        "skeletal_muscle": None,
        "fat_mass": None
    },
    "obesity_analysis": {
        "bmi": None,
        "body_fat_rate": None
    },
    "body_score": {
        "score": None
    },
    "weight_control": {
        "recommended_target_weight": None,
        "weight_control": None,
        "fat_control": None,
        "muscle_control": None
    },
    "obesity_assessment": {
        "bmi": None,
        "body_fat_rate": None,
        "obesity": None
    },
    "body_type_assessment": {
        "type": None
    },
    "segmental_fat_analysis": [
        {
            "part": "L Arm",
            "fat_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "R Arm",
            "fat_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "L Leg",
            "fat_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "R Leg",
            "fat_mass": None,
            "percentage": None,
            "evaluation": None
        }
    ],
    "muscle_balance": [
        {
            "part": "Left Arm",
            "muscle_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "Right Arm",
            "muscle_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "Trunk",
            "muscle_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "Left Leg",
            "muscle_mass": None,
            "percentage": None,
            "evaluation": None
        },
        {
            "part": "Right Leg",
            "muscle_mass": None,
            "percentage": None,
            "evaluation": None
        }
    ],
    "bioelectrical_impedance": {
        "20kHz": {
            "right_arm": None,
            "left_arm": None,
            "trunk": None,
            "right_leg": None,
            "left_leg": None
        },
        "100kHz": {
            "right_arm": None,
            "left_arm": None,
            "trunk": None,
            "right_leg": None,
            "left_leg": None
        }
    },
    "other_indicators": {
        "visceral_fat_grade": None,
        "basal_metabolic_rate": None,
        "fat_free_body_weight": None,
        "subcutaneous_fat": None,
        "smi": None,
        "body_age": None,
        "whr": None
    }
}

# CSS template
CSS_TEMPLATE = """
@font-face {
    font-family: 'YekanBakhFaNum-SemiBold';
    src: url('static/css/YekanBakhFaNum-Regular.otf') format('opentype');
    font-weight: 600;
    font-style: normal;
}

body {
    font-family: 'YekanBakhFaNum-SemiBold', sans-serif;
    background-color: #f3f4f6;
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

header {
    position: fixed;
    top: 0;
    left: 0;
    right: 0;
    background-color: transparent;
    padding: 1rem 1.5rem;
    display: flex;
    justify-content: flex-start;
    align-items: center;
    z-index: 1000;
    height: 90px;
}

.header-icon {
    width: 80px;
    height: 80px;
    object-fit: contain;
}

.page {
    width: 100%;
    max-width: 1200px;
    min-height: 100vh;
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    padding: 2rem 1rem;
    box-sizing: border-box;
    margin: 0 auto;
}

.page-first {
    padding-top: 0;
    padding-bottom: 0;
}

.page:not(.page-first) {
    padding-top: 100px;
}

.content-box {
    border: 1px solid #d1d5db;
    border-radius: 0.5rem;
    padding: 1.5rem;
    background-color: #ffffff;
    width: 100%;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.first-page-content-box {
    padding: 0;
    border: none;
    box-shadow: none;
    display: flex;
    flex-direction: column;
    height: 100vh;
}

.cover-image {
    width: 100%;
    height: calc(100vh - 80px);
    object-fit: contain;
    background-color: #e0e0e0;
    border-radius: 0;
    image-rendering: auto;
}

.cover-text {
    text-align: center;
    color: #ffffff;
    background-color: rgba(0, 0, 0, 0.7);
    padding: 1rem;
    width: 100%;
    box-sizing: border-box;
    height: 80px;
    display: flex;
    flex-direction: column;
    justify-content: center;
}

.cover-text p {
    margin: 0.25rem 0;
    font-size: 1rem;
}

.cover-text a {
    color: #ffffff;
    text-decoration: none;
}

.cover-text a:hover {
    text-decoration: underline;
}

.half-image {
    width: 100%;
    max-height: 40vh;
    object-fit: contain;
    background-color: #f0f0f0;
    border-radius: 0.5rem;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    margin-bottom: 1.5rem;
    display: block;
    margin-left: auto;
    margin-right: auto;
}

.welcome-text {
    padding: 1rem 0;
    text-align: justify;
    width: 100%;
}

.welcome-text h2 {
    text-align: center;
}

.report-content {
    padding: 1.5rem;
    width: 100%;
}

.report-content h1, .report-content h2, .report-content h3 {
    color: #1f2937;
    font-weight: bold;
    margin-top: 1.5rem;
    margin-bottom: 1rem;
}

.report-content h1 { font-size: 1.875rem; }
.report-content h2 { font-size: 1.5rem; }
.report-content h3 { font-size: 1.25rem; }

.styled-table {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
    font-size: 0.9em;
    font-family: 'YekanBakhFaNum-SemiBold', Tahoma, sans-serif;
    min-width: 320px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.05);
    direction: rtl;
    border-radius: 8px;
    overflow: hidden;
}

.styled-table thead tr {
    background-color: #6C757D;
    color: #ffffff;
    text-align: center;
    font-weight: bold;
}

.styled-table th,
.styled-table td {
    padding: 10px 12px;
    text-align: right;
    border-bottom: 1px solid #e0e0e0;
    border-left: 1px solid #e0e0e0;
}

.styled-table th:last-child,
.styled-table td:last-child {
    border-left: none;
}

.styled-table tbody tr {
    background-color: #f8f9fa;
}

.styled-table tbody tr:nth-of-type(even) {
    background-color: #f1f3f5;
}

.styled-table tbody tr:last-of-type td {
    border-bottom: none;
}

.styled-table td.evaluation-too-high {
    color: #dc3545;
    font-weight: bold;
    text-align: center;
}

.styled-table td.evaluation-normal {
    color: #28a745;
    text-align: center;
}

.styled-table td.evaluation-too-low {
    color: #ffc107;
    font-weight: bold;
    text-align: center;
}

.styled-table td small {
    font-size: 0.8em;
    color: #555;
    display: block;
    margin-top: 2px;
}

.styled-table.cols-4 th:nth-child(1) { width: 25%; }
.styled-table.cols-4 th:nth-child(2) { width: 15%; text-align: center; }
.styled-table.cols-4 td:nth-child(2) { text-align: center; }
.styled-table.cols-4 th:nth-child(3) { width: 15%; text-align: center; }
.styled-table.cols-4 td:nth-child(3) { text-align: center; }
.styled-table.cols-4 th:nth-child(4) { width: 45%; }

.styled-table.cols-5 th:nth-child(1) { width: 20%; }
.styled-table.cols-5 th:nth-child(2) { width: 10%; text-align: center; }
.styled-table.cols-5 td:nth-child(2) { text-align: center; }
.styled-table.cols-5 th:nth-child(3) { width: 15%; text-align: center; }
.styled-table.cols-5 td:nth-child(3) { text-align: center; }
.styled-table.cols-5 th:nth-child(4) { width: 10%; text-align: center; }
.styled-table.cols-5 td:nth-child(4) { text-align: center; }
.styled-table.cols-5 th:nth-child(5) { width: 45%; }

.original-image {
    width: 100%;
    max-width: 700px;
    height: auto;
    object-fit: contain;
    border-radius: 0.5rem;
    margin: 1.5rem auto;
    display: block;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    background-color: #f0f0f0;
}

.bold-header {
    font-weight: bold;
}

.report-text {
    margin-bottom: 1rem;
    line-height: 1.7;
    text-align: justify;
}

ul {
    list-style-type: disc;
    margin-right: 2rem;
    margin-bottom: 1rem;
    padding-right: 0;
}

ul ul {
    list-style-type: circle;
    margin-right: 2rem;
    margin-top: 0.5rem;
    margin-bottom: 0.5rem;
}

li {
    margin-bottom: 0.5rem;
}

@media (max-width: 768px) {
    .page {
        padding: 1rem 0.5rem;
    }
    .page:not(.page-first) {
        padding-top: 80px;
    }
    .header-icon {
        width: 60px;
        height: 60px;
    }
    .report-content h1 { font-size: 1.5rem; }
    .report-content h2 { font-size: 1.25rem; }
    .report-content h3 { font-size: 1.125rem; }
    .styled-table th, .styled-table td {
        padding: 8px 10px;
        font-size: 0.85em;
        width: auto !important;
    }
    .styled-table.cols-4 th:nth-child(4), .styled-table.cols-4 td:nth-child(4),
    .styled-table.cols-5 th:nth-child(5), .styled-table.cols-5 td:nth-child(5) {
        min-width: 120px;
    }
    .cover-image {
        height: calc(100vh - 70px);
    }
    .cover-text {
        height: 70px;
        padding: 0.5rem;
    }
    .cover-text p {
        font-size: 0.9rem;
    }
}
"""

def image_to_base64(image_path):
    if not os.path.exists(image_path):
        raise FileNotFoundError(f"Image file not found: {image_path}")
    
    ext = os.path.splitext(image_path)[1].lower()
    mime_types = {'.png': 'image/png', '.jpg': 'image/jpeg', '.jpeg': 'image/jpeg'}
    mime_type = mime_types.get(ext, 'image/png')  # Default to PNG if unknown
    
    try:
        with open(image_path, "rb") as image_file:
            base64_string = base64.b64encode(image_file.read()).decode("utf-8")
        # Verify Base64 string
        if not base64_string:
            raise ValueError(f"Failed to encode image to Base64: {image_path}")
        print(f"Successfully encoded image to Base64: {image_path}")
        return base64_string, mime_type
    except Exception as e:
        raise ValueError(f"Error encoding image {image_path}: {str(e)}")
# Function to extract structured JSON from image using OpenAI API
# def extract_structured_data():
#     client = OpenAI(api_key=OPENAI_API_KEY)
#     image_base64 = image_to_base64(IMAGE_PATH)

#     try:
#         response = client.chat.completions.create(
#             model="gpt-4o",
#             messages=[
#                 {
#                     "role": "user",
#                     "content": [
#                         {
#                             "type": "text",
#                             "text": f"""
# You are a body composition analysis expert. Extract the data from the provided image and fill the following JSON template. Only include values explicitly present in the image. Keep fields that are not present as null. Ensure all numbers and texts (English or Persian) are accurately extracted. Return the filled JSON template.

# Template:
# {json.dumps(JSON_TEMPLATE, ensure_ascii=False, indent=2)}
# """
#                         },
#                         {
#                             "type": "image_url",
#                             "image_url": {
#                                 "url": f"data:image/png;base64,{image_base64}"
#                             }
#                         }
#                     ]
#                 }
#             ],
#             max_tokens=2000
#         )

#         if response.choices and response.choices[0].message.content:
#             response_text = response.choices[0].message.content
#             json_match = re.search(r'\{.*\}', response_text, re.DOTALL)
#             if json_match:
#                 structured_data = json.loads(json_match.group(0))
#                 print("Structured JSON extracted successfully.")
#                 return structured_data
#             else:
#                 raise ValueError("No valid JSON found in API response.")
#         else:
#             raise ValueError("API response is empty or contains no content.")

#     except Exception as e:
#         print(f"Error in JSON extraction: {str(e)}")
#         raise

# Function to extract structured JSON data from image
def extract_structured_data():
    client = OpenAI(api_key=OPENAI_API_KEY)
    
    # Convert image to base64
    base64_image, mime_type = image_to_base64(IMAGE_PATH)
    image_url = f"data:{mime_type};base64,{base64_image}"
    
    prompt = """
You are an expert in extracting structured data from body composition analysis images. Your task is to analyze the provided image and extract the data into a structured JSON format in Persian. Follow these instructions carefully:

1. **Identification Section (شناسایی):**
   - Extract fields like identifier (شناسه), gender (جنسیت), age (سن), height (قد), and testing time (تاریخ و زمان آزمایش) if present.
   - If no identifier is available, set "id" to null.

2. **Body Composition Analysis (تحلیل ترکیب بدنی):**
   - Extract metrics like body score (امتیاز بدن), weight control (کنترل وزن), suggested target weight (وزن هدف پیشنهادی), fat control (کنترل چربی), muscle control (کنترل عضله), BMI (شاخص توده بدنی), body fat percentage (درصد چربی بدن), visceral fat level (درجه چربی احشایی) if present.
   - Include value, evaluation, and description for each metric if available.

3. **Measurement Analysis (تحلیل اندازه‌گیری):**
   - Extract metrics like weight (وزن), fat mass (توده چربی), muscle mass (توده عضلانی), bone mass (توده استخوانی), protein mass (توده پروتئینی), water weight (وزن آب), skeletal muscle (عضله اسکلتی) if present.
   - Include value, normal range, evaluation, and description for each metric if available.

4. **Muscle Fat Analysis (تحلیل چربی عضلانی):**
   - Extract weight, skeletal muscle, and fat mass if present.

5. **Obesity Analysis (تحلیل چاقی):**
   - Extract BMI (شاخص توده بدنی), body fat percentage (درصد چربی بدن), obesity (چاقی - وزن فعلی در مقابل وزن هدف) if present.

6. **Segmental Fat Analysis (تحلیل چربی بخش‌ها):**
   - Extract fat distribution for arms, trunk, and legs if present.

7. **Muscle Balance (تعادل عضلانی):**
   - Extract muscle balance data for body sections if present.

8. **Bioelectrical Impedance (مقاومت بیوالکتریک):**
   - Extract impedance for right arm, left arm, trunk, right leg, left leg if present.

**Instructions:**
- Use Persian labels for all fields (e.g., "شناسه" instead of "id").
- If a field or section is not present in the image, set it to null or an empty list/dict as appropriate.
- Return the extracted data as a JSON object with Persian keys.
- Do not include any fields or sections not explicitly listed above.
- Do not include any explanatory text or Markdown, only the JSON object.

**Output Format:**
Return a JSON object with Persian keys, e.g.:
{
  "شناسایی": {
    "شناسه": "گلناز مددی",
    "جنسیت": "خانم",
    "سن": 39,
    "قد": 164,
    "تاریخ و زمان آزمایش": "۲ دی ۱۴۰۳، ساعت ۱۳:۰۸:۱۳"
  },
  "تحلیل ترکیب بدنی": [
    {
      "شاخص": "شاخص توده بدنی",
      "مقدار": 24.1,
      "ارزیابی": "نرمال",
      "توضیحات": "وضعیت نرمال"
    }
  ],
  ...
}

**Image:**
[Image will be provided as base64]
"""
    try:
        response = client.chat.completions.create(
            model="gpt-4o",
            messages=[
                {
                    "role": "user",
                    "content": [
                        {"type": "text", "text": prompt},
                        {"type": "image_url", "image_url": {"url": image_url}}
                    ]
                }
            ],
            max_tokens=2000
        )
        
        if response.choices and response.choices[0].message.content:
            json_data = response.choices[0].message.content
            # Remove any Markdown code fences if present
            json_data = json_data.strip()
            if json_data.startswith('```'):
                lines = json_data.split('\n')
                json_data = '\n'.join(line for line in lines if not line.startswith('```'))
                json_data = json_data.strip()
            structured_data = json.loads(json_data)
            print("Structured JSON extracted successfully.")
            return structured_data
        else:
            raise ValueError("API response is empty or contains no content.")
            
    except Exception as e:
        print(f"Error in JSON extraction: {str(e)}")
        raise
# Function to analyze JSON data using OpenAI API
def analyze_data_with_openai(data):
    client = OpenAI(api_key=OPENAI_API_KEY)
    
    prompt = f"""
You are a professional data analyst and health consultant. Your task is to write a comprehensive report in Persian based on the body composition analysis provided in the JSON data below. Follow these steps carefully, ensuring no section or insight is included unless the data for that section is explicitly provided. **Use ONLY Persian language for all labels, titles, content, and table headers in the report. Do not include any English words or parentheses containing English, like (ID), (Gender), (Value), (Range), etc., ANYWHERE in your response.**

**Important Instruction for Missing Data:**
- If any field, indicator, or metric specified below is not present in the provided data (i.e., has a null value or is missing), skip that field or metric entirely in the report. Do not include it in tables, lists, or discussions, and do not mention its absence.
- For each section (e.g., تحلیل ترکیب بدنی, تحلیل اندازه‌گیری, تحلیل چربی عضلانی, تحلیل چاقی, تحلیل چربی بخش‌ها, تعادل عضلانی, مقاومت بیوالکتریک), if no data is available for that section (i.e., all relevant fields are null or missing), include the following message in Persian as a paragraph under the section title: 
  **داده‌ی کافی برای تحلیل این بخش در تصویر آنالیز توده‌ی بدنی شما وجود ندارد.**

**Report Structure and Tasks:**
1. **Identification Section (شناسایی):**
   - Title: شناسایی
   - Present the following details as a bulleted list (not a table) if they are available in the data. Each item MUST be in Persian, with the label in bold followed by the value. For example:
     * **شناسه:** گلناز مددی
     * **جنسیت:** خانم
     * **سن:** ۳۹ سال
     * **قد:** ۱۶۴ سانتی‌متر
     * **تاریخ و زمان آزمایش:** ۲ دی ۱۴۰۳، ساعت ۱۳:۰۸:۱۳
   - Only include the fields that are present in the input data. Skip any missing fields without mention.
   - if شناسه is not available and none or null present this : ' دوست لاکتویی عزیز' 

2. **Body Composition Analysis (تحلیل ترکیب بدنی):**
   - Create a table titled "تحلیل ترکیب بدنی" with the following PURELY PERSIAN columns:
     - شاخص
     - مقدار
     - ارزیابی
     - توضیحات
   - Include only the following key indicators that are present in the data (translate their names to Persian for display):
     - امتیاز بدن
     - کنترل وزن
     - وزن هدف پیشنهادی
     - کنترل چربی
     - کنترل عضله
     - شاخص توده بدنی
     - درصد چربی بدن
     - درجه چربی احشایی
   - For each included indicator, provide three mandatory **detailed and comprehensive** insights in Persian. Each insight should be at least 2-3 sentences long and provide actionable information:
     1. چرا این بخش مهم است؟
     2. وضعیت کلی شما چیست؟
     3. پیشنهادات ما برای شما چیست؟
   - If an indicator is missing from the data, exclude it from the table and insights without mention.

3. **Measurement Analysis (تحلیل اندازه‌گیری):**
   - Create a table titled "تحلیل اندازه‌گیری" with the following PURELY PERSIAN columns:
     - شاخص
     - مقدار
     - محدوده نرمال
     - ارزیابی
     - توضیحات
   - Include only the following key indicators that are present in the data (translate their names to Persian for display):
     - وزن
     - توده چربی
     - توده عضلانی
     - توده استخوانی
     - توده پروتئینی
     - وزن آب
     - عضله اسکلتی
   - For each included measurement, ensure the following questions are answered **detailed and comprehensive** in Persian. Each should be at least 2-3 sentences long and provide actionable information:
     0. این اندازه‌گیری چه ارتباطی با اهداف سلامتی دارد؟
     1. تاثیر آن بر زندگی روزمره چیست؟
     2. چه اقدامات مشخصی باید انجام شود؟
   - If a measurement is missing, exclude it from the table and insights without mention.

4. **Muscle Fat Analysis (تحلیل چربی عضلانی):**
   - Title: تحلیل چربی عضلانی
   - Include data on weight, skeletal muscle, and fat mass (use Persian labels) only if they are available in the input.
   - Address the following for each available metric in Persian:
     - چرا مهم است؟
     - وضعیت فعلی به چه معناست؟
     - چه بهبودهای عملی می‌توان انجام داد؟
   - Skip any metric that is not provided without mention.

5. **Obesity Analysis (تحلیل چاقی):**
   - Title: تحلیل چاقی
   - Create a table with PURELY PERSIAN headers for the following metrics, only if they are available:
     - شاخص توده بدنی
     - درصد چربی بدن
     - چاقی - وزن فعلی در مقابل وزن هدف
   - Include insights in Persian for available metrics:
     - توضیح دهید این شاخص‌ها چگونه بر سلامت تأثیر می‌گذارند.
     - آنها را به عملکرد روزانه و خطرات سلامتی درازمدت مرتبط کنید.
     - توصیه‌های مشخصی برای بهبود ارائه دهید.
   - Skip any missing metrics without mention.

6. **Segmental Fat Analysis (تحلیل چربی بخش‌ها):**
   - Title: تحلیل چربی بخش‌ها
   - Analyze fat distribution across arms, trunk, and legs (use Persian labels) only if the data is available.
   - Provide detailed insights in Persian for available data:
     0. چرا این توزیع مهم است؟
     1. توزیع چربی فعلی فرد چه چیزی را نشان می‌دهد؟
     2. چه گام‌های عملی می‌تواند سطح چربی را متعادل کند؟
   - Skip this section entirely if no relevant data is provided.

7. **Muscle Balance (تعادل عضلانی):**
   - Title: تعادل عضلانی
   - Evaluate muscle balance across body sections (use Persian labels) only if the data is available.
   - Address in Persian for available data:
     - تعادل عضلانی چگونه بر وضعیت بدن و پیشگیری از آسیب تأثیر می‌گذارد؟
     - توصیه‌هایی برای بهبود تعادل.
   - Skip this section if no relevant data is provided.

8. **Bioelectrical Impedance (مقاومت بیوالکتریک):**
   - Title: مقاومت بیوالکتریک
   - Create a table with PURELY PERSIAN headers for the following, only if data is available:
     - بازوی راست
     - بازوی چپ
     - تنه
     - پای راست
     - پای چپ
   - Include insights in Persian for available data:
     - چرا این داده‌ها مهم هستند؟
     - چگونه به ترکیب کلی بدن مرتبط می‌شوند؟
   - Skip this section if no relevant data is provided.

9. **Overall Suggestions (پیشنهادات کلی):**
   - Title: پیشنهادات کلی
   - Provide practical advice in these areas in Persian, tailored to the available data:
     - Nutrition: Recommend dietary changes, including foods to increase or avoid.
     - Exercise: Suggest workout types, frequency, and duration.
     - Lifestyle: Offer tips on improving sleep, stress management, and hydration.
   - Ensure the advice is motivating, easy to follow, and scientifically sound. Only base suggestions on available data.

10. **Health Journey with Lacto (مسیریابی سلامت با لاکتو):**
    - Title: مسیریابی سلامت با لاکتو
    - Provide a motivational closing paragraph in Persian addressing the individual by name (e.g., "خانم گلناز مددی عزیز") if the name is available. Summarize their challenges and strengths based on available data, and explain how Lacto can help them achieve their health goals.
    - If the name is not provided, use a general address like "کاربر عزیز".

**Key Features of the Report:**
1. Detailed Insights: Comprehensive and engaging explanations, answering why, what, and how in detail, all in Persian.
2. Scientific yet Friendly Tone: Simple, motivational Persian. All content, including table headers, MUST be in Persian. NO ENGLISH.
3. Error-Proof: Ensure no indicator or section is included unless its data is available.
4. Action-Oriented: Focus on practical steps.
5. Personalization: Interpret available data uniquely.
6. List Formatting: For bulleted lists like in the Identification section, use a single '*' or '-' at the beginning of the line for main items. For sub-items, indent with 2 spaces then use '*' or '-'. Example:
   * **آیتم اصلی**
     * **زیرآیتم**

**Output Format:**
- Return the report as plain text in Markdown format, using Persian for all content.
- Do NOT wrap the output in Markdown code fences (e.g., ```markdown or ```). Return only the plain Markdown text.

**JSON Data:**
{json.dumps(data, ensure_ascii=False, indent=2)}
"""

    try:
        response = client.chat.completions.create(
            model="gpt-4o",
            messages=[
                {
                    "role": "user",
                    "content": prompt
                }
            ],
            max_tokens=3000
        )
        
        if response.choices and response.choices[0].message.content:
            analysis_text = response.choices[0].message.content
            print("Analysis text (sample):\n", analysis_text[:300] + "...\n")
            return analysis_text
        else:
            raise ValueError("API response is empty or contains no content.")
            
    except Exception as e:
        print(f"Error in analysis: {str(e)}")
        raise

# Function to convert Markdown to HTML with specific styling
# Function to convert Markdown to HTML with specific styling
# Function to convert Markdown to HTML with specific styling
# Function to convert Markdown to HTML with specific styling
import re

def markdown_to_html(markdown_text):
    html_content = []
    lines = markdown_text.split('\n')
    in_table = False
    table_headers = []
    table_rows = []
    in_list = False
    in_code_block = False

    # Function to process bold text within a line
    def process_bold_text(text):
        # Convert **text** to <strong>text</strong>
        return re.sub(r'\*\*(.*?)\*\*', r'<strong>\1</strong>', text)

    for line in lines:
        line = line.strip()
        # Skip empty lines completely
        if not line:
            continue

        # Handle code block fences
        if line.startswith('```'):
            if in_code_block:
                in_code_block = False  # End of code block
            else:
                in_code_block = True  # Start of code block
            continue  # Skip the fence line itself

        # Skip lines inside code blocks
        if in_code_block:
            continue

        # Process bold text for the line
        line = process_bold_text(line)

        # Headers
        if line.startswith('# '):
            if in_list:
                html_content.append('</ul>')
                in_list = False
            html_content.append(f'<h1 class="text-3xl font-bold mb-4 text-center">{line[2:].strip()}</h1>')
        elif line.startswith('## '):
            if in_list:
                html_content.append('</ul>')
                in_list = False
            html_content.append(f'<h2 class="text-2xl font-bold text-gray-800 mb-4">{line[3:].strip()}</h2>')
        elif line.startswith('### '):
            if in_list:
                html_content.append('</ul>')
                in_list = False
            html_content.append(f'<h3 class="text-xl font-bold text-gray-800 mb-3">{line[4:].strip()}</h3>')

        # Table handling
        elif line.startswith('|'):
            if in_list:
                html_content.append('</ul>')
                in_list = False
            if not in_table:
                in_table = True
                table_headers = [header.strip() for header in line.split('|')[1:-1]]
                table_rows = []
            elif line.startswith('|-'):
                continue  # Skip table separator
            else:
                row = [process_bold_text(cell.strip()) for cell in line.split('|')[1:-1]]
                if len(row) == len(table_headers):
                    table_rows.append(row)
                else:
                    print(f"Warning: Skipping malformed table row with {len(row)} columns (expected {len(table_headers)}): {line}")
        else:
            if in_table:
                if table_headers:
                    table_class = 'styled-table cols-5' if len(table_headers) == 5 else 'styled-table cols-4'
                    html_content.append(f'<table class="{table_class}">')
                    html_content.append('<thead><tr>')
                    for header in table_headers:
                        html_content.append(f'<th>{process_bold_text(header)}</th>')
                    html_content.append('</tr></thead><tbody>')
                    for row in table_rows:
                        html_content.append('<tr>')
                        for i, cell in enumerate(row):
                            if i < len(table_headers) and table_headers[i] == 'ارزیابی':
                                if 'بالا' in cell:
                                    html_content.append(f'<td class="evaluation-too-high">{cell}</td>')
                                elif 'استاندارد' in cell or 'نرمال' in cell:
                                    html_content.append(f'<td class="evaluation-normal">{cell}</td>')
                                elif 'پایین' in cell or 'کم' in cell:
                                    html_content.append(f'<td class="evaluation-too-low">{cell}</td>')
                                else:
                                    html_content.append(f'<td>{cell}</td>')
                            else:
                                html_content.append(f'<td>{cell}</td>')
                        html_content.append('</tr>')
                    html_content.append('</tbody></table>')
                in_table = False
                table_headers = []
                table_rows = []
            # Lists or paragraphs
            if line.startswith('- ') or line.startswith('* '):
                if not in_list:
                    html_content.append('<ul>')
                    in_list = True
                html_content.append(f'<li class="report-text">{line[2:].strip()}</li>')
            elif line.startswith('  * ') or line.startswith('  - '):
                html_content.append(f'<li class="report-text">{line[4:].strip()}</li>')
            else:
                if in_list:
                    html_content.append('</ul>')
                    in_list = False
                html_content.append(f'<p class="report-text">{line}</p>')

    # Close any open table or list
    if in_table and table_headers:
        table_class = 'styled-table cols-5' if len(table_headers) == 5 else 'styled-table cols-4'
        html_content.append(f'<table class="{table_class}">')
        html_content.append('<thead><tr>')
        for header in table_headers:
            html_content.append(f'<th>{process_bold_text(header)}</th>')
        html_content.append('</tr></thead><tbody>')
        for row in table_rows:
            html_content.append('<tr>')
            for i, cell in enumerate(row):
                if i < len(table_headers) and table_headers[i] == 'ارزیابی':
                    if 'بالا' in cell:
                        html_content.append(f'<td class="evaluation-too-high">{cell}</td>')
                    elif 'استاندارد' in cell or 'نرمال' in cell:
                        html_content.append(f'<td class="evaluation-normal">{cell}</td>')
                    elif 'پایین' in cell or 'کم' in cell:
                        html_content.append(f'<td class="evaluation-too-low">{cell}</td>')
                    else:
                        html_content.append(f'<td>{cell}</td>')
                else:
                    html_content.append(f'<td>{cell}</td>')
            html_content.append('</tr>')
        html_content.append('</tbody></table>')
    
    if in_list:
        html_content.append('</ul>')

    return ''.join(html_content)


# Function to generate HTML with specific template
def generate_html(analysis_text, structured_data):
    # Convert images to base64
    original_image_base64, original_mime_type = image_to_base64(IMAGE_PATH)
    cover_image_base64, cover_mime_type = image_to_base64(COVER_IMAGE_PATH) if os.path.exists(COVER_IMAGE_PATH) else (original_image_base64, original_mime_type)
    welcome_image_base64, welcome_mime_type = image_to_base64(WELCOME_IMAGE_PATH) if os.path.exists(WELCOME_IMAGE_PATH) else (original_image_base64, original_mime_type)
    
    if os.path.exists(COVER_IMAGE_PATH):
        print(f"Loaded cover image: {COVER_IMAGE_PATH}")
    else:
        print(f"Warning: Cover image not found at {COVER_IMAGE_PATH}. Falling back to original image.")
    
    if os.path.exists(WELCOME_IMAGE_PATH):
        print(f"Loaded welcome image: {WELCOME_IMAGE_PATH}")
    else:
        print(f"Warning: Welcome image not found at {WELCOME_IMAGE_PATH}. Falling back to original image.")
    
    logo_base64 = ""
    logo_mime_type = "image/png"
    if os.path.exists(LOGO_PATH):
        logo_base64, logo_mime_type = image_to_base64(LOGO_PATH)
        print(f"Loaded logo: {LOGO_PATH}")
    
    # Convert Markdown analysis to HTML
    report_content = markdown_to_html(analysis_text)
    
    # Set welcome message based on identification data
    identification = structured_data.get("identification", {})
    user_id = identification.get("id")
    greeting = "سلام دوست لاکتویی" if not user_id else f"سلام {user_id} عزیز"
    
    # HTML template
    html_template = f"""
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>گزارش تحلیل ترکیب بدنی</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="{CSS_PATH}" rel="stylesheet">
</head>
<body>
    <!-- صفحه اول: تصویر تمام‌صفحه با متن زیرش -->
    <div class="page page-first">
        <div class="content-box first-page-content-box">
            <img src="data:{cover_mime_type};base64,{cover_image_base64}" alt="Cover Image" class="cover-image">
            <div class="cover-text">
                <p>- گزارش تحلیل ترکیب بدنی -</p>
                <p><a href="https://www.lacto.ir" target="_blank">www.lacto.ir</a></p>
            </div>
        </div>
    </div>

    <!-- صفحه دوم: هدر با آیکون، عکس و متن -->
    <div class="page">
        <header>
            <img src="data:{logo_mime_type};base64,{logo_base64}" alt="Lacto Icon" class="header-icon">
        </header>
        <div class="content-box">
            <img src="data:{welcome_mime_type};base64,{welcome_image_base64}" alt="Welcome Image" class="half-image">
            <div class="welcome-text">
                <h2 class="text-2xl font-bold text-gray-800 mb-4">{greeting}</h2>
                <p class="text-gray-600 leading-relaxed">
                    ما در لاکتو به شما افتخار می‌کنیم. این سه ماه نشان‌دهنده تعهد و اراده شما برای داشتن سبک زندگی سالم‌تر و دستیابی به اهداف سلامتی‌تان بوده است.<br>
                    لاکتو همیشه همراه شما بوده و حالا زمان آن رسیده که نتایج تلاش‌هایتان را بررسی کنیم. گزارش جدید بادی آنالیز شما، تنها یک گزارش ساده نیست؛ بلکه مدرکی از پیشرفت‌ها، بهبودها و دستاوردهایی است که با پشتکار و همراهی ما به دست آمده است.<br>
                    مهم‌ترین نکته این است که این سفر هنوز به پایان نرسیده است. تغییرات واقعی و پایدار به استمرار و انگیزه نیاز دارند. ما اینجاییم تا به شما کمک کنیم که به مسیر خود ادامه دهید و هر روز به هدف نهایی‌تان نزدیک‌تر شوید.<br>
                    بیایید نگاهی دقیق‌تر به نتایج این سه ماه بیندازیم و قدم‌های بعدی را با هم برنامه‌ریزی کنیم. شما آماده‌اید؟<br>
                    ما به شما ایمان داریم و می‌دانیم که می‌توانید موفق شوید. به مسیر خود ادامه دهید، چون بهترین‌ها هنوز در راه‌اند.
                </p>
            </div>
        </div>
    </div>

    <!-- صفحه سوم: گزارش تحلیل -->
    <div class="page">
        <header>
            <img src="data:{logo_mime_type};base64,{logo_base64}" alt="Lacto Icon" class="header-icon">
        </header>
        <div class="content-box report-content">
            <h1 class="text-3xl font-bold mb-4 text-center">گزارش تحلیل ترکیب بدنی (بادی آنالیز)</h1>
            {report_content}
            <img src="data:{original_mime_type};base64,{original_image_base64}" alt="Original Analysis Image" class="original-image">
        </div>
    </div>
</body>
</html>
"""
    return html_template
# Function to save text to file
def save_to_txt(text, output_file):
    with open(output_file, 'w', encoding='utf-8') as f:
        f.write(text)
    if os.path.exists(output_file):
        print(f"Analysis successfully saved to {output_file}.")
    else:
        raise FileNotFoundError(f"Failed to save text file: {output_file}")

# Function to save CSS to file
def save_css(css_content, css_file):
    with open(css_file, 'w', encoding='utf-8') as f:
        f.write(css_content)
    if os.path.exists(css_file):
        print(f"CSS file successfully saved to {css_file}.")
    else:
        raise FileNotFoundError(f"Failed to save CSS file: {css_file}")

# Function to save HTML to file
def save_to_html(html_content, output_file):
    with open(output_file, 'w', encoding='utf-8') as f:
        f.write(html_content)
    if os.path.exists(output_file):
        print(f"HTML report successfully saved to {output_file}.")
    else:
        raise FileNotFoundError(f"Failed to save HTML file: {output_file}")

def process_body_composition_image(image_path):
    """
    Processes the given image for body composition analysis and returns the generated HTML file path.
    The HTML report file is given a unique name per request, while CSS and TXT files are static.
    """
    try:
        # Set output directory inside static
        static_dir = os.path.join(settings.BASE_DIR, 'static', 'bia_reports')
        os.makedirs(static_dir, exist_ok=True)
        # Generate a unique base name for the HTML report
        timestamp = datetime.datetime.now().strftime('%Y%m%d_%H%M%S')
        unique_id = uuid.uuid4().hex[:8]
        html_base_name = f'body_composition_report_{timestamp}_{unique_id}.html'
        # Set output file paths
        global OUTPUT_HTML_FILE, OUTPUT_TXT_FILE, CSS_PATH
        OUTPUT_HTML_FILE = os.path.join(static_dir, html_base_name)
        OUTPUT_TXT_FILE = os.path.join(static_dir, 'body_composition_analysis.txt')
        CSS_PATH = os.path.join(static_dir, 'styles.css')

        print(f"Checking input image path: {image_path}")
        if not os.path.exists(image_path):
            raise FileNotFoundError(f"Input image file not found: {image_path}")
        
        print(f"Checking logo path: {LOGO_PATH}")
        if not os.path.exists(LOGO_PATH):
            print(f"Warning: Logo file not found at {LOGO_PATH}. Using empty logo placeholder.")
        
        print(f"Checking cover image path: {COVER_IMAGE_PATH}")
        if not os.path.exists(COVER_IMAGE_PATH):
            print(f"Warning: Cover image not found at {COVER_IMAGE_PATH}. Falling back to original image.")
        
        print(f"Checking welcome image path: {WELCOME_IMAGE_PATH}")
        if not os.path.exists(WELCOME_IMAGE_PATH):
            print(f"Warning: Welcome image not found at {WELCOME_IMAGE_PATH}. Falling back to original image.")

        # Set the global IMAGE_PATH for downstream functions
        global IMAGE_PATH
        IMAGE_PATH = image_path

        print("1. Extracting structured JSON from image...")
        structured_data = extract_structured_data()

        print("2. Analyzing JSON data...")
        analysis_text = analyze_data_with_openai(structured_data)

        print("3. Saving analysis to text file...")
        save_to_txt(analysis_text, OUTPUT_TXT_FILE)

        print("4. Saving CSS file...")
        save_css(CSS_TEMPLATE, CSS_PATH)

        print("5. Converting analysis to HTML...")
        html_content = generate_html(analysis_text, structured_data)

        print("6. Saving HTML report...")
        save_to_html(html_content, OUTPUT_HTML_FILE)

        abs_html_path = os.path.abspath(OUTPUT_HTML_FILE)
        print(f"HTML report generated at: file://{abs_html_path}")
        return abs_html_path

    except FileNotFoundError as fnfe:
        print(f"\nFile error: {str(fnfe)}")
        raise
    except Exception as e:
        print(f"\nAn error occurred: {str(e)}")
        import traceback
        traceback.print_exc()
        raise

# CLI interface for running as a script
if __name__ == "__main__":
    import argparse
    parser = argparse.ArgumentParser(description="Process a body composition analysis image and generate an HTML report.")
    parser.add_argument("image_path", type=str, help="Path to the input image file")
    args = parser.parse_args()
    html_path = process_body_composition_image(args.image_path)
    print(f"Generated HTML report: file://{html_path}")