from datetime import datetime
from APIs.models import ApiRequestLog
import re
from urllib.parse import urlparse

def clean_url(url):
    """
    Clean the URL by:
    1. Removing query parameters.
    2. Replacing variable numbers with the word "number".
    Example:
    - /api/data/1/ → /api/data/number/
    - /api/data/42/details/ → /api/data/number/details/
    """
    parsed_url = urlparse(url)
    path = parsed_url.path  # Get the path part of the URL

    # Replace variable numbers with "number"
    cleaned_path = re.sub(r'/\d+/', '/number/', path)

    return cleaned_path

class ResponseTimeMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        # Record the start time of the request
        start_time = datetime.now()

        # Process the request and get the response
        response = self.get_response(request)

        # Record the end time of the request
        end_time = datetime.now()

        # Calculate the response time
        response_time = (end_time - start_time).total_seconds()

        # Clean the URL by removing query parameters
        cleaned_url = clean_url(request.path)

        # Save the request details to the database
        ApiRequestLog.objects.create(
            url=cleaned_url,  # Use the cleaned URL
            response_time=response_time
        )

        return response