import time

import requests
from datetime import *
import numpy as np
from time import sleep

base = "https://i-dia.ir/api/v1/"

phone_number = "09999999999"
temp_token = ""
activation_code = ""
token = ""

DEBUG_MODE = True

flag = False

def log(strr):
    # todo write to file
    f = open("../static/logs/HealthCheckLogs.txt", "a+")
    f.write(str(strr))
    f.write("\n")
    f.close()
    # print(str(strr))

def flag(api, e):
    global flag
    flag = True
    log("flag was True in " + api + " error or Exception: " + str(e))

def ptime():
    log(str(datetime.now()))

def deleteTestUser():
    api = "delete/user/"
    url = base + api
    log(url)
    ptime()
    try:
        payload = {
            "phone_number": phone_number,
            "userName": "UserCanDelete",
            "password": "fegrdhtfyguhijolkujhbgvcsdfgdxth575@#$%^&dflknv",
        }
        print("ok")
        response = requests.request("POST", url, data=payload)

        if not (response.status_code == 200):
            ptime()
            flag(api, "!200 code")
            log("response in " + api + " ---> status: " + str(response.status_code))
            log("response: " + response.text)
        else:
            resp = response.json()
            if resp["status"] == "Error":
                error_code = str(resp["error_code"])
                log("error_code: " + error_code)
                # flag(api, error_code)
            elif not (resp["status"] == "OK"):
                flag(api, "Trouble in " + api + " api!!")
            else:
                log("The test user was deleted correctly.")
    except Exception as e:
        flag(api, e)

def get_activation_code():
    api = "user/activation_code/debuging/"
    url = base + api
    log(url)
    ptime()

    try:
        payload = {
            "phone_number": phone_number,
        }

        response = requests.request("POST", url, data=payload)
        if not (response.status_code == 200):
            ptime()
            flag(api, "!200 code")
            log("response in " + api + " ---> status: " + str(response.status_code))
            log("response: " + response.text)
        else:
            resp = response.json()
            if not (resp["status"] == "OK"):
                flag(api, "Trouble in " + api + " api!!")
                log("error_code " + str(resp["error_code"]))
            else:
                data = resp["data"][0]
                global temp_token
                temp_token = str(data["temp_token"])
                global activation_code
                activation_code = str(data["activation_code"])
                log("activation_code and temp_token were successfully obtained.")
                log("temp_token: " + temp_token)
                log("activation_code: " + activation_code)
    except Exception as e:
        flag(api, e)


def sign():
    api = "user/sign/"
    url = base + api
    log(url)
    ptime()

    global temp_token
    global activation_code

    payload = {
        "phone_number": phone_number,
        "temp_token": temp_token,
        "activation_code": activation_code,
    }
    try:

        response = requests.request("POST", url, data=payload)
        if not (response.status_code == 200):
            ptime()
            flag(api, "!200 code")
            log("response in " + api + " ---> status: " + str(response.status_code))
            log("response: " + response.text)
        else:
            resp = response.json()
            if not (resp["status"] == "OK"):
                flag(api, "Trouble in " + api + " api!!")
                log("error_code " + str(resp["error_code"]))
            else:
                data = resp["data"][0]
                global token
                token = str(data["token"])
                log("token was successfully obtained.")
                log("token: " + token)
    except Exception as e:
        flag(api, e)


def profile():
    api = "user/profile_info"
    url = base + api
    log(url)
    ptime()

    global temp_token
    global activation_code

    try:
        birth_date = datetime.now() - timedelta(days=365 * np.random.randint(5, 45))
        weight = np.random.randint(15, 120)

        payload = {
            "phone_number": phone_number,
            "token": token,
            "first_name": "aouto test",
            "last_name": "for aouto test",
            "birth_date": int(birth_date.timestamp()),
            "weight": weight,
            "diabetes_type": np.random.randint(0, 1),
            "detection_year": 1395,
            "minimum_sugar": 70,
            "maximum_sugar": 190,
            "hypo": 70,
            "hyper": 250,
            "user_setting": "aouto user test",
            "type_of_treatment": "123",
            "insulin_sensitivity": "20",
            "insulin_short_effect_code": "3",
            "insulin_long_effect_code": "5",
            "pills": "&",
            "height": np.random.randint(120, 200),
            "activity_level": 1.5,
            "gender": np.random.randint(0, 1),
            "carb_rate": np.random.randint(10, 25),
            "glp1_code": 1002,
        }
        log("payload:")
        log(payload)

        response = requests.request("POST", url, data=payload)
        if not (response.status_code == 200):
            ptime()
            flag(api, "!200 code")
            log("response in " + api + " ---> status: " + str(response.status_code))
            log("response: " + response.text)
        else:
            resp = response.json()
            if not (resp["status"] == "OK"):
                flag(api, "Trouble in " + api + " api!!")
                log("error_code " + str(resp["error_code"]))
            else:
                data = resp["data"][0]
                log("profile params were successfully saved.")
                # log("weight_state: " + str(data["weight_state"]))
                log("IBW: " + str(data["IBW"]))
    except Exception as e:
        flag(api, e)


try:
    log("/*******************************************/")
    log("test for time: " + str(datetime.now()))
    st = datetime.now()
    log("/*******************************************/")

    deleteTestUser()  # delete user
    sleep(2)
    get_activation_code()  # get activation code
    sleep(2)
    sign()  # sign
    sleep(2)
    profile()  # profile
    sleep(2)

    # exe time:
    et = datetime.now()
    last_state_file = open("../static/logs/server_last_state.txt", "w")

    if flag is True:
        # save state in last state file
        last_state_file.write("no" + "\n")  # It means there is a problem.
        test_time = str(et)  # time
        last_state_file.write("The last test was done at " + test_time +
                              ". There were some problems with the server in this test. This test takes about " +
                              str(round(et.timestamp() - st.timestamp(), 4)) + " seconds.")

        # send message ...
        url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"
        receptors = ["09217761645", "09123059677", "09123861393"]
        if DEBUG_MODE is True:
            receptors = ["09217761645", "09910412375"]

        for i in range(len(receptors)):
            querystring = {"receptor": receptors[i],
                           "message": "ظاهرا مشکلی برای سرور بوجود آمده است. لطفا مسئول فنی را مطلع سازید. (ارسال شده از ربات بررسی وضعیت سرور)" + "\n" +
                                      str(datetime.now())}
            response = requests.request("POST", url, params=querystring)
        ptime()
        log("Trouble messages were sent.")
    else:
        # save state in last state file
        last_state_file.write("yes" + "\n")  # It means there is no problem.
        test_time = str(et)  # time
        last_state_file.write("The last test was done at " + test_time +
                              ". There were no problems with the server in this test. This test takes about " +
                              str(round(et.timestamp() - st.timestamp(), 4)) + " seconds.")

        log("The tests were performed without any problems.")

    log("=================================================================")
    log("\n\n\n")
    last_state_file.close()

except Exception as e:
    # save state in last state file
    last_state_file = open("../static/logs/server_last_state.txt", "w")

    last_state_file.write("no" + "\n")  # It means there is a problem.

    last_state_file.write("The last test was done at " + str(datetime.now()) +
                          ". There were some problems with the server in this test. click to download !")
    last_state_file.close()

    # send message ...
    url = "https://api.kavenegar.com/v1/776643766A357671537637453675434446764F4A57336A783831512F423163685465576B2B6D78366331593D/sms/send.json"
    receptors = ["09217761645", "09910412375"]
    if DEBUG_MODE is True:
        receptors = ["09217761645", "09910412375"]

    for i in range(len(receptors)):
        querystring = {"receptor": receptors[i],
                       "message": "ظاهرا مشکلی برای سرور بوجود آمده است. لطفا مسئول فنی را مطلع سازید. (ارسال شده از ربات بررسی وضعیت سرور)" + "\n" +
                                  str(datetime.now())}
        response = requests.request("POST", url, params=querystring)
    ptime()
    log(str(e))
    log("Trouble messages were sent.")