import json
import time
import re
import pandas as pd
import google.generativeai as genai
import arabic_reshaper
from django.http import HttpResponse
from rest_framework.decorators import api_view
from datetime import datetime
from .models import FreeDietPlan


API_KEYS = [
    "AIzaSyAdbmYbpNCYzStOIC51LRJ-OjQ_MVBUyZY",
    "AIzaSyBJtyXgYA3z9f47jhpVPqldxCLQemp21qM",
    "AIzaSyCGgiPXaSMa38eJ12T2DSGHAGIg14SzKcI",
]

# Index to track the current API key in use
current_key_index = 0

COLUMN_MAPPING = {
    "item_meta[183][]": "جنسیت شما چیست؟",
    "item_meta[177]": "سن شما چقدر است؟",
    "item_meta[178]": "وزن فعلی شما چقدر است؟",
    "item_meta[181]": "قد شما چقدر است؟",
    "item_meta[249][]": "هدف شما از نظر وزنی پیست؟",
    "item_meta[205]": "چقدر می‌خواهید وزن اضافه کنید؟",
    "item_meta[206]": "چقدر می‌خواهید وزن کم کنید؟",
    "item_meta[207][]": "در حال حاضر چه هدفی برای سلامتی خود دارید؟",
    "item_meta[210][]": "معمولاً در طول روز چه وعده‌های غذایی و میان‌وعده‌هایی مصرف می‌کنید؟",
    "item_meta[212]": "معمولاً چه ساعتی صبحانه می‌خورید؟",
    "item_meta[246]": "معمولاً چه ساعتی ناهار می‌خورید؟",
    "item_meta[213]": "معمولاً چه ساعتی شام می‌خورید؟",
    "item_meta[214][]": "آیا غذایی را محدود یا حذف کرده‌اید؟",
    "item_meta[248][]": "آیا رژیم غذایی خاصی را دنبال می کنی؟",
    "item_meta[247]": "لطفاً بنویسید",
    "item_meta[216][]": "آیا آلرژی غذایی یا بیماری خاصی دارید؟",
    "item_meta[218]": "لطفاً نوع بیماری را بنویسید",
    "item_meta[219][]": "برای صبحانه چه گزینه‌هایی را ترجیح می‌دهید؟",
    "item_meta[220]": "لطفاً بنویسید.1",
    "item_meta[221][]": "آیا تمایل دارید صبحانه شما شامل پروتئین/فیبر/کربوهیدرات باشد؟",
    "item_meta[222][]": "برای ناهار چه نوع غذاهایی را ترجیح می‌دهید؟",
    "item_meta[223]": "لطفاً بنویسید.2",
    "item_meta[225][]": "برای شام چه نوع غذاهایی را ترجیح می‌دهید؟",
    "item_meta[226]": "لطفاً بنویسید.3",
    "item_meta[227][]": "چند بار در هفته گوشت (قرمز، مرغ، ماهی یا بوقلمون) مصرف می‌کنید؟",
    "item_meta[228][]": "کدام نوع گوشت را بیشتر مصرف می‌کنید؟",
    "item_meta[229]": "لطفاً بنویسید.4",
    "item_meta[230][]": "آیا غذاهای تخمیرشده مصرف می‌کنید؟",
    "item_meta[231][]": "کدام نوع از غذاهای تخمیرشده را بیشتر مصرف می‌کنید؟",
    "item_meta[232]": "لطفاً بنویسید.5",
    "item_meta[250]": "نام",
    "item_meta[251]": "شماره تلفن"
}

# Define the complete set of expected keys in the final JSON format.
EXPECTED_KEYS = [
    "جنسیت شما چیست؟",
    "سن شما چقدر است؟",
    "وزن فعلی شما چقدر است؟",
    "قد شما چقدر است؟",
    "هدف شما از نظر وزنی پیست؟",
    "چقدر می‌خواهید وزن اضافه کنید؟",
    "چقدر می‌خواهید وزن کم کنید؟",
    "در حال حاضر چه هدفی برای سلامتی خود دارید؟",
    "معمولاً در طول روز چه وعده‌های غذایی و میان‌وعده‌هایی مصرف می‌کنید؟",
    "معمولاً چه ساعتی صبحانه می‌خورید؟",
    "معمولاً چه ساعتی ناهار می‌خورید؟",
    "معمولاً چه ساعتی شام می‌خورید؟",
    "آیا غذایی را محدود یا حذف کرده‌اید؟",
    "آیا رژیم غذایی خاصی را دنبال می کنی؟",
    "لطفاً بنویسید",
    "آیا آلرژی غذایی یا بیماری خاصی دارید؟",
    "لطفاً نوع بیماری را بنویسید",
    "برای صبحانه چه گزینه‌هایی را ترجیح می‌دهید؟",
    "لطفاً بنویسید.1",
    "آیا تمایل دارید صبحانه شما شامل پروتئین/فیبر/کربوهیدرات باشد؟",
    "برای ناهار چه نوع غذاهایی را ترجیح می‌دهید؟",
    "لطفاً بنویسید.2",
    "برای شام چه نوع غذاهایی را ترجیح می‌دهید؟",
    "لطفاً بنویسید.3",
    "چند بار در هفته گوشت (قرمز، مرغ، ماهی یا بوقلمون) مصرف می‌کنید؟",
    "کدام نوع گوشت را بیشتر مصرف می‌کنید؟",
    "لطفاً بنویسید.4",
    "آیا غذاهای تخمیرشده مصرف می‌کنید؟",
    "کدام نوع از غذاهای تخمیرشده را بیشتر مصرف می‌کنید؟",
    "لطفاً بنویسید.5",
    "نام",
    "شماره تلفن"
]



def load_user_data_from_request(request):
    """
    Extracts user data from the incoming request.

    - If a CSV file is uploaded (with key 'csv_file' or 'file'), reads and converts it.
    - Otherwise, if JSON data is provided in the request body, uses that.
    Always returns a list of dictionaries.
    """
    if 'csv_file' in request.FILES or 'file' in request.FILES:
        file_key = 'csv_file' if 'csv_file' in request.FILES else 'file'
        csv_file = request.FILES[file_key]
        # try:
        df = pd.read_csv(csv_file, dtype=str)
        df.columns = df.columns.str.strip()
        data = json.loads(df.to_json(orient="records", force_ascii=False))
        print("Loaded user data from CSV:", data)
        return data
        # except Exception as e:
        #     print("Error processing CSV file:", e)
        #     return []
    elif request.data:
        # try:
        data = request.data
        if hasattr(data, 'dict'):
            data = data.dict()
        if isinstance(data, str):
            data = json.loads(data)
        if not isinstance(data, list):
            data = [data]
        print("Loaded user data from JSON:", data)
        return data
        # except Exception as e:
        #     print("Error processing JSON input:", e)
        #     return []
    else:
        return []


@api_view(["POST"])
def generate(request):
    global current_key_index

    BASE_PROMPT = """
As an AI-driven nutrition expert and marketing strategist, your task is to generate a fully personalized 7-day meal plan in Persian (Farsi) that adheres to the following principles:
✅ The output language must be Persian (Farsi)
✅ No processed foods
✅ Snacks must include fruits + nuts or dried fruits
✅ The first snack must contain dairy (milk or yogurt)
✅ Meals must align with Iranian cuisine and be easily accessible in Iran
✅ No expensive ingredients (e.g., avocado, mango, blueberries)
✅ Use white rice but suggest substituting with brown rice for better nutrition
✅ No meal repetition throughout the week
✅ Eliminate foods harmful to the user’s health conditions (diabetes, high cholesterol, hypertension, etc.)
✅ Clearly define portion sizes (grams, tablespoons, pieces, etc.)
✅ Professional and respectful tone, making the user feel they are consulting a top-tier nutritionist
✅ Include a short motivational health tip at the end of each day
✅ Avoid generic statements like "similar to the previous day"—each day must be fully unique
✅ Follow a structured format for meal presentation
✅ Strategically placed CTAs (Calls to Action) for premium plan conversion
✅ Include app installation links, website, and Instagram page in CTAs
________________________________________
📌 Final Prompt
🔷 AI Model’s Role:
You are an advanced AI specializing in nutrition, behavioral economics, and conversion-optimized marketing. Your goal is to generate a scientifically sound, tasty, and practical 7-day meal plan that encourages user engagement and premium plan upgrades.
⚠️ The output must be in Persian (Farsi).
________________________________________
🔹 Step 1: Process User Inputs
Before generating the diet plan, analyze the following user data:
✅ Health Metrics: Age, weight, height, BMI, health conditions (diabetes, cholesterol, hypertension, etc.)
✅ Health Goals: Weight loss, increased energy, improved gut health, stabilized blood sugar, etc.
✅ Dietary Restrictions & Allergies: Sensitivities, preferences, or exclusions
✅ User Preferences: Number of meals per day, vegetarian or special diets
✅ Food Accessibility: Exclude expensive or unavailable ingredients in Iran
________________________________________
🔹 Step 2: Core Rules for Meal Plan Generation
When generating the plan, ensure adherence to the following:
✅ Variety: No meal should repeat within the 7-day period
✅ Healthy & Accessible Foods: No processed foods or expensive ingredients
✅ Nutritional Balance: Proper distribution of proteins, healthy fats, and carbohydrates
✅ Snacks:
•   The first snack must contain dairy (milk or yogurt)
•   All snacks should include fruits + nuts or dried fruits
✅ Precise Portioning: Use grams, tablespoons, pieces, etc.
✅ Rice Recommendations: Use white rice but explain that substituting with brown rice is a healthier option
________________________________________
🔹 Step 3: Daily Meal Plan Structure
Each day should be unique, with no meal repetition, following this format:
🔷 📅 روز X
🍳 صبحانه (۰۸:۰۰)
🥖 [نان سبوس‌دار] ([مقدار دقیق]) – برای تأمین فیبر بالا و بهبود هضم
🧀 [پنیر کم‌چرب / شیر / ماست] ([مقدار]) – برای تأمین کلسیم و سلامت استخوان‌ها
🥜 [آجیل] ([مقدار]) – سرشار از چربی‌های مفید و آنتی‌اکسیدان
🍵 [نوشیدنی] – برای افزایش متابولیسم و کنترل قند خون
🍏 میان‌وعده صبح (۱۰:۳۰)
🍌 [میوه] – برای تأمین فیبر و تنظیم قند خون
🥜 [آجیل] – برای تأمین انرژی پایدار و چربی‌های سالم
🍛 ناهار (۱۳:۳۰)
🍚 [برنج سفید] ([مقدار]) – توضیح بده که جایگزینی با برنج قهوه‌ای بهتر است
🥩 / 🍗 / 🥗 [منبع پروتئین] ([مقدار]) – برای تأمین پروتئین و افزایش انرژی
🥗 [سبزیجات] – برای بهبود هضم و تأمین ویتامین‌ها
🥛 [دوغ کم‌نمک / ماست] – برای بهبود سلامت گوارش و تأمین پروبیوتیک
🥑 میان‌وعده عصر (۱۸:۰۰)
🍏 [میوه] – برای تأمین فیبر و ویتامین‌های مورد نیاز بدن
🥜 [آجیل] – برای کاهش التهاب و افزایش تمرکز
🥙 شام (۲۱:۰۰)
🍲 [غذای سبک و کم‌چرب] – برای بهبود هضم و جلوگیری از سنگینی قبل از خواب
🥖 [نان سبوس‌دار] ([مقدار]) – برای تأمین کربوهیدرات سالم و کاهش گرسنگی شبانه
🌿 [سبزیجات] – برای تقویت سیستم ایمنی و بهبود گوارش
✅ 🔹 نکته انگیزشی روز:
📢 [یک جمله کوتاه و الهام‌بخش درباره تغذیه سالم و سبک زندگی بهتر]
________________________________________
🔹 Step 4: Engagement & Premium Subscription Conversion Strategy
📢 "دوست داری برنامه تغذیه‌ات رو ارتقا بدی؟! همین حالا نسخه کامل 30 روزه رو دریافت کن!"
📎 وب‌سایت: <a href="https://lacto.ir/">lacto.ir</a>
📎 نصب نسخه آیفون: <a href="https://apps.apple.com/us/app/lacto/id6730123640">اپ استور</a>
📎 نصب نسخه اندروید: <a href="https://cafebazaar.ir/app/com.lacto">کافه‌بازار</a>
📎 اینستاگرام: <a href="https://www.instagram.com/lacto_.app/">lacto_.app</a>
📢 "فقط دو روز تا پایان رژیم ۷ روزه مانده! تصور کن اگر یک ماه این برنامه را دنبال کنی چه نتیجه‌ای خواهی گرفت!"
📎 "برای ارتقا و دریافت تحلیل میکروبیوم اختصاصی، اینجا کلیک کن!"
📢 "نتایج خود را با دوستانت در اینستاگرام به اشتراک بگذار!" 📸
📎 "پیج ما: <a href="https://www.instagram.com/lacto_.app/">lacto_.app</a>"
________________________________________
✅ ⚠️ Ensure that the entire output is in Persian (Farsi).
✅ ⚠️ Avoid English words unless necessary (e.g., Lacto, branding elements).
✅ ⚠️ Format the text in an easy-to-read structure for user experience.
✅ ⚠️ our page linke is https://www.instagram.com/lacto_.app/ so show it as a hyperlink not a text element
✅ ⚠️ all links such as our website 'https://lacto.ir/',  اپ استور: https://apps.apple.com/us/app/lacto/id6730123640 , کافه بازار: https://cafebazaar.ir/app/com.lacto must be hyperlink not a text element.
✅ ⚠️ Avoid using words such as ok, یاشه, بسم الله الرحمن الرحیم. Use a friendly and casual tone at first of your response too. I don't want the user to realize that this response was generated by an LLM. so pay attention.
"""

    # Load user data from the request.
    user_data_list = load_user_data_from_request(request)
    print("Loaded user data:", user_data_list)

    def bold_to_html(text):
        pattern = re.compile(r"\*\*(.*?)\*\*")
        return pattern.sub(r'<strong style="color:#009A6E;">\1</strong>', text)

    def generate_diet_plan(user_data_json, retries=3):
        global current_key_index

        # try:
        weight = float(user_data_json.get("وزن فعلی شما چقدر است؟", "0"))
        height = float(user_data_json.get("قد شما چقدر است؟", "0"))
        # except Exception as e:
        #     print("Error parsing weight/height:", e)
        #     weight = 0
        #     height = 0
        bmi = weight / ((height / 100) ** 2) if height > 0 else 0

        user_data_summary = ""
        for key, value in user_data_json.items():
            user_data_summary += f"{key}: {value}\n"
        user_data_summary += f"""
        قد: {height} سانتی‌متر
        وزن: {weight} کیلوگرم
        شاخص توده‌ی بدنی: {bmi:.1f}
        اهداف سلامتی: {user_data_json.get("هدف", "")}
        محدودیت/پرهیز از: {user_data_json.get("محدودیت‌های غذایی", "")}
        لطفاً بر اساس این شرایط، رژیم غذایی ۷ روزه را تطبیق دهید.
        """
        personalized_prompt = user_data_summary + BASE_PROMPT

        for attempt in range(retries):
            try:
                # Configure the API with the current key
                genai.configure(api_key=API_KEYS[current_key_index])
                model = genai.GenerativeModel(model_name="gemini-2.0-pro-exp-02-05")
                response = model.generate_content(personalized_prompt)
                return response.text
            except Exception as e:
                print(f"Error on attempt {attempt + 1} with key {current_key_index}: {e}")
                # Switch to the next API key
                current_key_index = (current_key_index + 1) % len(API_KEYS)
                print(f"Switching to API key index: {current_key_index}")
                time.sleep(2)
        return "Error: Unable to generate the diet plan."

    def create_html_content():
        html_content = """<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8"/>
    <title>برنامه نهایی رژیم</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
    <style>
        
        .print {
            border-radius: 10px; 
            background-color: #009A6E;
            text-align: center;
            font-size: 1.2em;
            font-weight: bold;
            border-radius: 10px;
        }
        
         @media print {
                 header, footer {
                     display: none;
                 }

                 .elementor-top-section,
                 .elementor-header,
                 .wpr-logo,
                 .wpr-nav-menu-container {
                     display: none !important;
                 }

                 .elementor-top-section[data-id="d23c153"], /* Header */
                 .elementor-top-section[data-id="aaf5aad"]  /* Footer */ {
                     display: none !important;
                 }

                 /* Optional: Optimize page width */
                 body {
                     margin: 0;
                     padding: 20px;
                 }
         }

    
        @font-face {
            font-family: 'MyCustomFont';
            src: url('BYEKAN.ttf') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        body {
            margin: 0;
            padding: 0;
            direction: rtl;
            font-family: 'MyCustomFont', Tahoma, sans-serif;
            background: #fff;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
        }
        .cover-page {
            width: 100%;
            aspect-ratio: 2400 / 3500;
            overflow: hidden;
        }
        .cover-page img {
            width: 100%;
            height: 100%;
            object-fit: contain;
            display: block;
        }
        .content {
            padding: 20px;
            line-height: 1.6;
        }
        h1, h2 {
            color: #009A6E;
            font-weight: bold;
        }
        .user-section {
            border: 1px solid #ccc;
            padding: 15px;
            margin-bottom: 30px;
            border-radius: 8px;
        }
        .user-section h2 {
            margin-top: 0;
        }
        .diet-text {
            white-space: pre-line;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="cover-page">
            <img src="https://lacto.ir/wp-content/uploads/2025/02/cover_1-scaled.jpg" alt="First cover page">
        </div>
        <div class="cover-page">
            <img src="https://lacto.ir/wp-content/uploads/2025/02/cover_2-scaled.jpg" alt="Second cover page">
        </div>
    </div>
    <div class="container content">
        <h1>خروجی نهایی رژیم شما</h1>
"""
        for i, user_data in enumerate(user_data_list):
            if not isinstance(user_data, dict):
                print(f"Skipping invalid entry (not a dict): {user_data}")
                continue
            # Extract user's name and phone using the keys from the submitted data.
            name = user_data.get("item_meta[250]", "نام مشخص نشده")
            phone = user_data.get("item_meta[251]", "شماره مشخص نشده")
            diet_text = generate_diet_plan(user_data)
            reshaped_text = arabic_reshaper.reshape(diet_text)
            html_formatted_text = bold_to_html(reshaped_text)
            html_content += f"""
        <div class="user-section">
            <h2>دوست خوب لاکتو</h2>
            <p>نام: {name} - شماره تلفن: {phone}</p>
            <div class="diet-text">
                {html_formatted_text}
            </div>
        </div>
"""
            # Save the individual diet plan to the database.
            FreeDietPlan.objects.create(
                name=name,
                phone_number=phone,
                diet_html=html_formatted_text
            )
        html_content += """
    </div>
    <div class="button-container">
        <button onclick="window.print()" class="print">ذخیره</button>
    </div>
</body>
</html>
"""
        return html_content

    html_content = create_html_content()
    return HttpResponse(html_content, content_type="text/html")
