from django import forms
from .models import Food, FoodCard, Activity
from django import forms


class UploadFileForm(forms.Form):
    title = forms.CharField(max_length=80)
    file = forms.FileField()


class FoodCardForm(forms.ModelForm):
    class Meta:
        model = FoodCard
        fields = '__all__'
        widgets = {
            'foods': forms.CheckboxSelectMultiple(),  # Use checkboxes for better selection UI
        }

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.fields['foods'].queryset = Food.objects.all()  # Limit queryset if needed
        self.fields['foods'].widget.can_add_related = False  # Disable the inline add button


class FoodForm(forms.ModelForm):
    class Meta:
        model = Food
        fields = [
            'Data_Base_Number', 'FA_Name', 'Protein_g', 'Fat_g', 'Carbohydrates_g',
            'HEI_1_Fruit', 'HEI_2_Fruit', 'HEI_1_Vegetables', 'HEI_2_Vegetables',
            'HEI_Whole_Grain_Grains', 'HEI_Dairy', 'HEI_Protein_Foods',
            'HEI_Seafood_and_Plant_Proteins', 'HEI_Refined_Grains', 'HEI_Sodium',
            'HEI_Sugar', 'Saturated_Fat_g', 'dairy_unit', 'fat_unit', 'For_calculation',
            'cereal_unit', 'meat_unit', 'fruit_unit', 'vegetables_unit', 'Ash_g',
            'Calories', 'Starch_g', 'Sucrose_g', 'Glucose_g', 'Fructose_g', 'Lactose_g',
            'Maltose_g', 'Alcohol_g', 'Water_g', 'Caffeine_mg', 'Theobromine_mg', 'Sugar_g',
            'Galactose_g', 'Fiber_g', 'Calcium_mg', 'Iron_mg', 'Magnesium_mg', 'Phosphorus_mg',
            'Potasssium_mg', 'Sodium_mg', 'Zinc_mg', 'Cupper_mg', 'Fluoride_mcg', 'Manganese_mg',
            'Selenium_mcg', 'Vitamin_A_IU', 'Retinol_mcg', 'Retinol_Equivalents_mcg',
            'Beta_Carotene_mcg', 'Alpha_Carotene_mcg', 'Vitamin_E_mg', 'Vitamin_D_mcg',
            'Vitamin_D2_Ergocalciferol_mcg', 'Vitamin_D3_Cholecalciferol_mcg',
            'Beta_Cryptoxanthin_mcg', 'Lycopene_mcg', 'Lutein_and_Zeaxanthin_mcg',
            'Vitamin_C_mg', 'Vitamin_B1_mg', 'Vitamin_B2_mg', 'Vitamin_B3_mg',
            'Vitamin_B5_mg', 'Vitamin_B6_mg', 'Vitamin_B9_mg', 'Vitamin_B12', 'Choline_mg',
            'Cholesterol_mg', 'MUFA', 'PUFA', 'Name_of_home_units', 'Weight_of_home_units',
            'Index_of_home_units', 'english_Name', 'arabic_Name', 'microbiome_score',
            'priority'
        ]

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        # Make the Data_Base_Number field readonly
        self.fields['Data_Base_Number'].widget.attrs['readonly'] = True


class ActivityForm(forms.ModelForm):
    class Meta:
        model = Activity
        fields = ['name', 'Metz']