import platform

def init():
    server = platform.version()
    print("running in", server)

    if "#52-Ubuntu" in server:
        import os
        import django
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()
    else:
        import os
        import sys
        import django
        sys.path.append('/home/idiair/.ziluck310')
        os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'ziluck_project.settings')
        django.setup()

init()


from payment.models import Discount
from datetime import datetime, timedelta, date
from APIs.models import ZiLuckGroup

codes = [
    "KABD204",
    "BAAM205",
    "AMAL206",
    "KHAL207",
    "MAMA208",
    "AFAB209",
    "BAMO210",
    "FAGA211",
    "MAMA212",
    "SHHO213",
    "TOMO214",
    "JABE215",
    "NAMI216",
    "ZAMA217",
    "SARO218",
    "BAPA219",
    "TAAL220",
    "AMAR221",
    "MOBA222",
    "NOAB223",
    "SOBE224",
    "BEVI225",
    "MONA226",
    "GHXX227",
    "AHXX228",
    "GHRA229",
    "MOZA230",
    "AZFA231",
    "MOSE232",
    "MOAR233",
    "HAYA234",
    "SAEK235",
    "KAFE236",
    "VAKO237",
    "SAMA238",
    "ZARA239",
    "TOGH240",
    "HASA241",
    "RAYA242",
    "MAAL243",
    "FAKH244",
    "RAJA245",
    "JASH246",
    "FANE247",
    "HOMA248",
    "SASH249",
    "DEMA250",
    "TARE251",
    "BAMO252",
    "SHSH253"
]

names = [
"Abdolreza Kazemi",
"Amir Baghani",
"Ali Amini",
"Aliakbar Khalesi",
"Mehdi Mehran",
"Abolghasem Afsar",
"Mohammad Behnia",
"Ghazal Fakhraei",
"Marjan Mehrparvar",
"Hossein Sharifi",
"Mohammadbagher Tavakoli",
"Bahman Jafari",
"Mitra Najafipour",
"Mahsa Zargaran",
"Rozhin Jalal Safari",
"Parastoo Balaei",
"Ali Torabian",
"Arvin Amin Ziaei",
"Bahram Moradi",
"Abdolreza Norouzi",
"Behyar Soleimani",
"Victoria Beigi",
"Nahid Mohammadzadeh",
"Dr. Ghavamali",
"Mousa Ahmadi",
"Raziyeh Ghorayshi",
"Zahra Mokhtari",
"Forough Azadi",
"Soheila Shokouh Moeid",
"Arezoo Hayati Moghaddam",
"Yazdan Haghshenas",
"Akram Saber Nejad",
"Farin Karimi",
"Kourosh Vafaei",
"Mahshid Sahabi",
"Rashid Zare Dar",
"Gholamreza Toogheh",
"Soroush Hayati",
"Yasin Rahimi",
"Ali Mehripour",
"Khadijeh Fazeli",
"Javad Rahimi",
"Shahram Jafari",
"Narges Farahani",
"Mahsa Hosseini",
"Sakineh Shariati",
"Maliheh Derakhshan",
"Reza Taheri",
"Mozhgan Bagheri",
"Shirin Shams",
]

ids = [
  "dr_abdolreza_kazemi",
  "dr_amir_baghani",
  "dr_ali_amini",
  "dr_aliakbar_khalesi",
  "dr_mehdi_mehran",
  "dr_abolghasem_afsar",
  "dr_mohammad_behnia",
  "dr_ghazal_fakhraei",
  "dr_marjan_mehrparvar",
  "dr_hossein_sharifi",
  "dr_mohammadbagher_tavakoli",
  "dr_bahman_jafari",
  "dr_mitra_najafipour",
  "dr_mahsa_zargaran",
  "dr_rozhin_jalal_safari",
  "dr_parastoo_balaei",
  "dr_ali_torabian",
  "dr_arvin_amin_ziaei",
  "dr_bahram_moradi",
  "dr_abdolreza_norouzi",
  "dr_behyar_soleimani",
  "dr_victoria_beigi",
  "dr_nahid_mohammadzadeh",
  "dr_ghavamali",
  "dr_mousa_ahmadi",
  "dr_raziyeh_ghorayshi",
  "dr_zahra_mokhtari",
  "dr_forough_azadi",
  "dr_soheila_shokouh_moeid",
  "dr_arezoo_hayati_moghaddam",
  "dr_yazdan_haghshenas",
  "dr_akram_saber_nejad",
  "dr_farin_karimi",
  "dr_kourosh_vafaei",
  "dr_mahshid_sahabi",
  "dr_rashid_zare_dar",
  "dr_gholamreza_toogheh",
  "dr_soroush_hayati",
  "dr_yasin_rahimi",
  "dr_ali_mehripour",
  "dr_khadijeh_fazeli",
  "dr_javad_rahimi",
  "dr_shahram_jafari",
  "dr_narges_farahani",
  "dr_mahsa_hosseini",
  "dr_sakineh_shariati",
  "dr_maliheh_derakhshan",
  "dr_reza_taheri",
  "dr_mozhgan_bagheri",
  "dr_shirin_shams"
]

i = 0

for code in codes:
    
    # code
    # created_at
    # expire_date
    # percentage
    # number_of_discounts
    
    group = ZiLuckGroup(is_public=False, is_company=False, group_id=codes[i], name=names[i])
    group.save()
    
    discount = Discount(
        code=code,
        created_at=datetime.now(),
        # expire_date=datetime.date(2026,1,1),
        expire_date=date(2026, 1, 1),
        percentage=5,
        number_of_discounts=1000,
        ziluck_group=group
    )
    
    discount.save()
    i += 1
    print(f"Discount {i} of {len(codes)} created")
