from matplotlib import pyplot as plt
from datetime import datetime, date, timedelta
import telebot
import os
import numpy as np
import platform
import jdatetime


BOT_TOKEN = "1087727284:AAHpk_m0_B66Z1lV-knjwiupV0LaoOaN9yc"


def get_list(strList, t="int"):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if (not (S[i] == "")) and (not (S[i]=="\n")):
            if t == "str":
                F.append(str(S[i]))
            elif t == "int":
                F.append(int(S[i]))
            else:
                F.append(str(S[i]))
    return F


class SendReportsToGroup:
    def __init__(self, token):
        self.token = token
        # self.id = 93465629  # hossein
        self.id = -319359350  # i carbo
        self.bot = telebot.TeleBot(self.token)
        if platform.version() == "10.0.19042":  # win
            self.report_path = os.path.join(os.path.dirname(os.path.dirname(__file__))) + "/static/logs/DailyReportsData.txt"
            self.log_path = os.path.join(os.path.dirname(os.path.dirname(__file__))) + "/static/logs/DailyReportsPhotos/"
        else:  # for linux
            self.report_path = "../static/logs/DailyReportsData.txt"
            self.log_path = "../static/logs/DailyReportsPhotos/"
        self.today_active_user = []
        self.today_active_user_transaction = []
        self.date = ""
        self.new_user_message = "New Users:👇🏻👇🏻\n\n"
        self.new_users_number = 0

    def create_reports(self):
        report_file = open(self.report_path, "rt")

        t = get_list(report_file.readline(), "str")
        exe_time = get_list(report_file.readline(), "str")
        d_array = get_list(report_file.readline(), "str")
        user_counter = get_list(report_file.readline())
        registered_user_counter = get_list(report_file.readline())
        active_user_counter = get_list(report_file.readline())
        insulin_logs_list = get_list(report_file.readline())
        activities_logs_list = get_list(report_file.readline())
        drug_logs_list = get_list(report_file.readline())
        sugar_logs_list = get_list(report_file.readline())
        walking_logs_list = get_list(report_file.readline())
        feeling_logs_list = get_list(report_file.readline())
        message_logs_list = get_list(report_file.readline())
        eating_logs_list = get_list(report_file.readline())
        sumation_logs_list = get_list(report_file.readline())
        active_in_30_days_ago = get_list(report_file.readline())
        self.today_active_user = get_list(report_file.readline(), "str")
        self.today_active_user_transaction = get_list(report_file.readline())
        new_user_list = get_list(report_file.readline(), "str")
        self.new_users_number = len(new_user_list)
        report_file.close()
        self.date = jdatetime.datetime.fromgregorian(datetime=datetime(int(d_array[-1].split("-")[0]),
                                                                       int(d_array[-1].split("-")[1]),
                                                                       int(d_array[-1].split("-")[2]))).date()

        plt.figure(figsize=(10, 8))

        plt.subplot(2, 1, 1)
        plt.xlabel('The last 30 days')
        plt.ylabel('number of people')
        plt.grid(True)
        plt.title("%s: %s" % (d_array[-1], active_in_30_days_ago[-1]), loc='right')
        plt.plot(np.array(range(1, 31)), np.array(active_in_30_days_ago),
                 label="Active users in the last 30 days (range = 30)", marker="o")
        plt.legend(loc='upper left')

        plt.subplot(2, 1, 2)
        plt.xlabel('The last 30 days')
        plt.ylabel('number of people')
        plt.grid(True)
        plt.title("%s: %s" % (d_array[-1], active_user_counter[-1]), loc='right')
        plt.plot(np.array(range(1, 31)), np.array(active_user_counter),
                 label="Active users in the last 30 days (range = 1)", marker="o")
        plt.legend(loc='upper left')

        plt.savefig(self.log_path + "active_users.png", dpi=500)

        # clear all plots
        plt.close()
        plt.figure(figsize=(10, 8))

        # Users Counter
        plt.subplot(2, 1, 1)
        plt.xlabel('The last 30 days')
        plt.ylabel('number of people')
        plt.grid(True)
        plt.title("%s: %s" % (d_array[-1], user_counter[-1]), loc='right')
        plt.plot(np.array(range(1, 31)), np.array(user_counter),
                 label="Number of users in the last 30 days", marker="o")
        plt.legend(loc='upper left')


        plt.subplot(2, 1, 2)
        plt.xlabel('The last 30 days')
        plt.ylabel('number of people')
        plt.grid(True)
        plt.title("%s: %s" % (d_array[-1], registered_user_counter[-1]), loc='right')
        plt.plot(np.array(range(1, 31)), np.array(registered_user_counter),
                 label="Number of registered users in the last 30 days", marker="o")
        plt.legend(loc='upper left')

        plt.savefig(self.log_path + "users.png", dpi=500)

        # clear all plots
        plt.close()
        plt.figure(figsize=(10, 8))

        # Activities
        plt.xlabel('The last 30 days')
        plt.ylabel('number of transactions')
        plt.title("Transactions, date: %s" % d_array[-1])
        plt.plot(range(1, 31), sumation_logs_list, label="all", marker="o")
        plt.plot(range(1, 31), eating_logs_list, label="eatings")
        plt.plot(range(1, 31), activities_logs_list, label="activities")
        plt.plot(range(1, 31), insulin_logs_list, label="insulins")
        plt.plot(range(1, 31), sugar_logs_list, label="sugar measurement")
        plt.plot(range(1, 31), drug_logs_list, label="drug")
        plt.plot(range(1, 31), walking_logs_list, label="walking")
        plt.plot(range(1, 31), feeling_logs_list, label="feeling")
        plt.legend(loc='upper left')
        plt.grid(True)
        plt.savefig(self.log_path + "activities.png", dpi=500)

        # new users message
        j = 1
        for phone in new_user_list:
            self.new_user_message += "%s) %s\n" % (j, phone)
            j += 1

    def send_reports(self):
        if self.new_users_number > 70:
            message = "Woooooow, the number of new users was more than 70 :)))"
            self.bot.send_message(chat_id=self.id, text=message)
        elif self.new_users_number > 50:
            message = "Woooooow, the number of new users was more than 50 :)))"
            self.bot.send_message(chat_id=self.id, text=message)

        self.bot.send_message(chat_id=self.id, text=self.new_user_message)

        active_users_message = "Active Users (last day):👇🏻👇🏻\n\n" + "phone          ----> transactions\n"
        for i in range(len(self.today_active_user)):
            active_users_message += "%s ----> %s\n" % (self.today_active_user[i], self.today_active_user_transaction[i])

        self.bot.send_message(chat_id=self.id, text=active_users_message)

        self.bot.send_message(chat_id=self.id, text="آمار تعداد کاربران:👇🏻👇🏻👇🏻")
        self.bot.send_photo(self.id, photo=open(self.log_path + "users.png", 'rb'))

        self.bot.send_message(chat_id=self.id, text="تعداد کاربران فعال در 30 روز اخیر (فعال ماهانه و روزانه):👇🏻👇🏻👇🏻")
        self.bot.send_photo(self.id, photo=open(self.log_path + "active_users.png", 'rb'))

        self.bot.send_message(chat_id=self.id, text="آمار تعداد فعالیت ها:👇🏻👇🏻👇🏻")
        self.bot.send_photo(self.id, photo=open(self.log_path + "activities.png", 'rb'))

        end = "#آمار روز " + "%s/%s/%s" % (self.date.year, self.date.month, self.date.day)
        self.bot.send_message(chat_id=self.id, text=end)


def send_reports_to_group():
    srtg = SendReportsToGroup(BOT_TOKEN)
    srtg.create_reports()
    srtg.send_reports()


if __name__ == '__main__':
    send_reports_to_group()
