from datetime import datetime

import requests
from datetime import *


base = "https://ziluck.probiofit.net/"

user = "User_Update_Report_Data"
password = "%easwdVYTY@#$%^(&$9sd8u(*Y&$^%ef&^*sdeG&(Hd*)J(K"
offset = 0  # just today calculation
durations = 30


DEBUG_MODE = True

flag = False


def getList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if (not (S[i] == "")) and (not (S[i]=="\n")):
            F.append(str(S[i]))
    return F

def listToStr(list):
    S = "&"
    for item in list:
        S += str(item)+"&"
    return S

def log(strr):
    # todo write to file
    f = open("../static/logs/DailyReports.txt", "a+")
    f.write(str(strr))
    f.write("\n")
    f.close()
    # print(str(strr))

def sumOfListWithDuration(list1, list2, duration):  # list1 is str list "&1&2&" in list2 is normal list
    l = getList(list1) + list2
    if len(l) >= duration:
        return l[-duration:]
    else:
        return l


def write_list_to_file(list, file):
    s = "&"
    for item in list:
        s += (str(item) + "&")
    file.write(s + "\n")



def call_api_to_update_data():
    api = "generate/recent/profiles/data/"
    url = base + api
    log(url)

    try:
        payload = {
            "user": user,
            "password": password,
            "durations": offset,
        }

        response = requests.request("POST", url, data=payload)
        if not (response.status_code == 200):

            log("response in " + api + " ---> status: " + str(response.status_code))
            log("response: " + response.text)
            return False
        else:
            resp = response.json()
            if not (resp["status"] == "OK"):
                log("error_code " + str(resp["error_code"]))
                log("error " + str(resp["message"]))
                return False
            else:
                log(resp)
                data = resp["data"][0]
                log("end of update")
                return data

    except Exception as e:
        log(e)
        return False


log("/************************/")
log(str(datetime.now()))
log("--------------------------")

data = call_api_to_update_data()
if data is False:
    log("there is a problem: " + str(datetime.now()))
else:
    # read last saved data
    report_file = open("../static/logs/DailyReportsData.txt", "r")

    t = str(report_file.readline())

    exe_time = str(report_file.readline())

    # date_array = []
    d_array = str(report_file.readline())
    # for item in d_array:
    #     if item.count("-") > 0:
    #         date_array.append(item)

    user_counter = str(report_file.readline())

    registered_user_counter = str(report_file.readline())

    active_user_counter = str(report_file.readline())

    insulin_logs_list = str(report_file.readline())

    activities_logs_list = str(report_file.readline())

    drug_logs_list = str(report_file.readline())

    sugar_logs_list = str(report_file.readline())

    walking_logs_list = str(report_file.readline())

    feeling_logs_list = str(report_file.readline())

    message_logs_list = str(report_file.readline())

    eating_logs_list = str(report_file.readline())

    sumation_logs_list = str(report_file.readline())

    active_in_30_days_ago = str(report_file.readline())

    today_active_user = str(report_file.readline())

    today_active_user_transaction = str(report_file.readline())
    report_file.close()


    # append today's data
    DailyReportsData = open("../static/logs/DailyReportsData.txt", "w")

    t = data["time"]
    DailyReportsData.write(str(t) + "\n")

    exe_time = data["exe_time"]
    DailyReportsData.write(str(exe_time) + "\n")

    date_array = sumOfListWithDuration(d_array, data["date"], durations)
    write_list_to_file(date_array, DailyReportsData)

    user_counter = sumOfListWithDuration(user_counter, data["user_counter"], durations)
    write_list_to_file(user_counter, DailyReportsData)

    registered_user_counter = sumOfListWithDuration(registered_user_counter, data["registered_user_counter"], durations)
    write_list_to_file(registered_user_counter, DailyReportsData)

    active_user_counter = sumOfListWithDuration(active_user_counter, data["active_user_counter"], durations)
    write_list_to_file(active_user_counter, DailyReportsData)

    insulin_logs_list = sumOfListWithDuration(insulin_logs_list, data["insulin_logs_list"], durations)
    write_list_to_file(insulin_logs_list, DailyReportsData)

    activities_logs_list = sumOfListWithDuration(activities_logs_list, data["activities_logs_list"], durations)
    write_list_to_file(activities_logs_list, DailyReportsData)

    drug_logs_list = sumOfListWithDuration(drug_logs_list, data["drug_logs_list"], durations)
    write_list_to_file(drug_logs_list, DailyReportsData)

    sugar_logs_list = sumOfListWithDuration(sugar_logs_list, data["sugar_logs_list"], durations)
    write_list_to_file(sugar_logs_list, DailyReportsData)

    walking_logs_list = sumOfListWithDuration(walking_logs_list, data["walking_logs_list"], durations)
    write_list_to_file(walking_logs_list, DailyReportsData)

    feeling_logs_list = sumOfListWithDuration(feeling_logs_list, data["feeling_logs_list"], durations)
    write_list_to_file(feeling_logs_list, DailyReportsData)

    message_logs_list = sumOfListWithDuration(message_logs_list, data["message_logs_list"], durations)
    write_list_to_file(message_logs_list, DailyReportsData)

    eating_logs_list = sumOfListWithDuration(eating_logs_list, data["eating_logs_list"], durations)
    write_list_to_file(eating_logs_list, DailyReportsData)

    sumation_logs_list = sumOfListWithDuration(sumation_logs_list, data["sumation_logs_list"], durations)
    write_list_to_file(sumation_logs_list, DailyReportsData)

    active_in_30_days_ago = sumOfListWithDuration(active_in_30_days_ago, data["active_in_30_days_ago"], durations)
    write_list_to_file(active_in_30_days_ago, DailyReportsData)

    today_active_user = data["today_active_user"]
    write_list_to_file(today_active_user, DailyReportsData)

    today_active_user_transaction = data["today_active_user_transaction"]
    write_list_to_file(today_active_user_transaction, DailyReportsData)

    new_users_list = data["new_users_list"]
    write_list_to_file(new_users_list, DailyReportsData)


    DailyReportsData.close()
log("/************************/")
log("\n\n")
