from APIs.models import *
from panel.models import FirebaseNotification, TherapistSelection
from django_cron import CronJobBase, Schedule
import requests
import jdatetime
from datetime import timedelta, date, time, datetime
from ziluck_project.settings import STATIC_ROOT
from panel.SMSNotification import SMS
from panel.PushNotification import PushNotification
import random
import telebot
from payment.models import ZarinPalPayment
from APIs.models import User
from panel.models import TimeSlot
from payment.models import Discount

def getList(strList):
    S = strList.split("&")
    last = len(S) - 1
    F = []
    for i in range(1, last):
        if (not (S[i] == "")) and (not (S[i] == "\n")):
            F.append(str(S[i]))
    return F


def listToStr(list):
    S = "&"
    for item in list:
        S += str(item) + "&"
    return S


def log(strr):
    # todo write to file
    f = open(str(STATIC_ROOT) + "/logs/DailyReports.txt", "a+")
    f.write(str(strr))
    f.write("\n")
    f.close()
    # print(str(strr))


def sumOfListWithDuration(list1, list2, duration):  # list1 is str list "&1&2&" in list2 is normal list
    l = getList(list1) + list2
    if len(l) >= duration:
        return l[-duration:]
    else:
        return l


def write_list_to_file(list, file):
    s = "&"
    for item in list:
        s += (str(item) + "&")
    file.write(s + "\n")


class DailyReport(CronJobBase):
    # RUN_EVERY_MINS = 120  # every 2 hours
    RUN_AT_TIMES = ['23:50']

    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.Reports'  # a unique code

    def do(self):
        print("start!", datetime.now())
        durations = 30
        try:
            t0 = datetime.now()

            dt = date.today() - timedelta(days=durations)
            t_start = date.today() - timedelta(days=30)
            t_stop = date.today()
            p = datetime.now()
            p_start = datetime.combine(p.date(), time(0, 0, 0))
            p_end = datetime.combine(p.date(), time(23, 59, 59))
            active_in_30_days_ago = []
            today_active_user = []
            today_active_user_transaction = []

            # AllUsers = User.objects.filter(isRegistered=True)

            ActiveUserSet = set()
            points = Points.objects.filter(date__range=(t_start, t_stop))
            for po in points:
                if not (po.user in ActiveUserSet):
                    ActiveUserSet.add(po.user)
            actives = len(ActiveUserSet)
            print("actives:", actives)

            active_in_30_days_ago.append(actives)
            print("step1", datetime.now())

            points = Points.objects.filter(date=p.date())
            for i in range(points.count()):
                temp = 0
                temp += Eating.objects.filter(user=points[i].user, date_time__range=(p_start, p_end)).count()
                temp += InsulinUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Activities_log.objects.filter(user=points[i].user,
                                                      start_date_time__range=(p_start, p_end)).count()
                temp += DrugUsage.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Feeling.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Walking.objects.filter(user=points[i].user, date=p.date()).count()
                temp += SugarMeasurement.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()
                temp += Message.objects.filter(user=points[i].user, time__range=(p_start, p_end)).count()

                # Since the rating is registered, then the user is definitely active
                today_active_user.append(points[i].user.phone_number)
                today_active_user_transaction.append(temp)

            users = User.objects.filter(created_at__gte=dt)
            user_counter = []
            registered_user_counter = []
            active_user_counter = []
            date_array = []
            insulin_logs_list = []
            activities_logs_list = []
            drug_logs_list = []
            feeling_logs_list = []
            message_logs_list = []
            eating_logs_list = []
            sumation_list = []
            sugar_logs_list = []
            walking_logs_list = []

            number_of_last_users = User.objects.filter(created_at__lt=dt).count()
            number_of_last_registered_users = User.objects.filter(created_at__lt=dt, isRegistered=True).count()
            print("step2", datetime.now())

            for i in range(durations + 1):
                try:
                    sumation = 0
                    number_of_last_users = users.filter(created_at=dt).count() + number_of_last_users
                    user_counter.append(number_of_last_users)
                    number_of_last_registered_users = users.filter(created_at=dt,
                                                                   isRegistered=True).count() + number_of_last_registered_users
                    registered_user_counter.append(number_of_last_registered_users)

                    active_user_counter.append(Points.objects.filter(date=dt).count())

                    temp = InsulinUsage.objects.filter(time__year=dt.year,
                                                       time__month=dt.month,
                                                       time__day=dt.day).count()
                    sumation += temp
                    insulin_logs_list.append(temp)

                    temp = Activities_log.objects.filter(start_date_time__year=dt.year,
                                                         start_date_time__month=dt.month,
                                                         start_date_time__day=dt.day).count()
                    sumation += temp
                    activities_logs_list.append(temp)

                    temp = DrugUsage.objects.filter(time__year=dt.year,
                                                    time__month=dt.month,
                                                    time__day=dt.day).count()
                    sumation += temp
                    drug_logs_list.append(temp)

                    temp = SugarMeasurement.objects.filter(time__year=dt.year,
                                                           time__month=dt.month,
                                                           time__day=dt.day).count()
                    sumation += temp
                    sugar_logs_list.append(temp)

                    temp = Walking.objects.filter(date=dt).count()
                    sumation += temp
                    walking_logs_list.append(temp)

                    temp = Feeling.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    feeling_logs_list.append(temp)

                    temp = Message.objects.filter(time__year=dt.year,
                                                  time__month=dt.month,
                                                  time__day=dt.day).count()
                    sumation += temp
                    message_logs_list.append(temp)

                    temp = Eating.objects.filter(date_time__year=dt.year,
                                                 date_time__month=dt.month,
                                                 date_time__day=dt.day).count()
                    sumation += temp
                    sumation_list.append(sumation)
                    eating_logs_list.append(temp)
                    date_array.append(str(dt))
                    # date_array.append(str(jdatetime.date.fromgregorian(date=dt)))
                    dt = dt + timedelta(days=1)

                except Exception as e:
                    print(str(e))
            print("step3", datetime.now())

            new_users = User.objects.filter(created_at=date.today())
            new_users_list = []
            for u in new_users:
                new_users_list.append(u.phone_number)

            print("step4", datetime.now())
            t1 = datetime.now()
            data = {
                "user_counter": user_counter,
                "registered_user_counter": registered_user_counter,
                "date": date_array,
                "active_user_counter": active_user_counter,
                "insulin_logs_list": insulin_logs_list,
                "activities_logs_list": activities_logs_list,
                "drug_logs_list": drug_logs_list,
                "sugar_logs_list": sugar_logs_list,
                "walking_logs_list": walking_logs_list,
                "feeling_logs_list": feeling_logs_list,
                "message_logs_list": message_logs_list,
                "eating_logs_list": eating_logs_list,
                "sumation_logs_list": sumation_list,
                "active_in_30_days_ago": active_in_30_days_ago,
                "today_active_user": today_active_user,
                "today_active_user_transaction": today_active_user_transaction,
                "new_users_list": new_users_list,
                "time": str(jdatetime.datetime.fromgregorian(datetime=datetime.now())),
                "exe_time": (t1 - t0).seconds,
                "durations": durations,
            }
            # create Analysis
            d = date.today()
            tt = Analysis.objects.filter(date=d)
            if tt.exists():
                an = tt[0]
            else:
                an = Analysis(date=d)
            last = len(user_counter) - 1
            an.user_counter = user_counter[last]
            an.registered_user_counter = registered_user_counter[last]
            an.active_user_counter = active_user_counter[last]
            an.insulin_logs = insulin_logs_list[last]
            an.activities_logs = activities_logs_list[last]
            an.drug_logs = drug_logs_list[last]
            an.sugar_logs = sugar_logs_list[last]
            an.walking_logs = walking_logs_list[last]
            an.feeling_logs = feeling_logs_list[last]
            an.message_logs = message_logs_list[last]
            an.eating_logs = eating_logs_list[last]
            an.sumation_logs = sumation_list[last]
            an.active_in_30_days_ago = active_in_30_days_ago[-1]
            an.today_active_user_list = today_active_user
            an.today_active_user_transaction_list = today_active_user_transaction
            an.new_users = len(new_users_list)
            an.save()

            if data is False:
                log("there is a problem: " + str(datetime.now()))
            else:
                # read last saved data
                report_file = open(str(STATIC_ROOT) + "/logs/DailyReportsData.txt", "r")

                t = str(report_file.readline())

                exe_time = str(report_file.readline())

                # date_array = []
                d_array = str(report_file.readline())
                # for item in d_array:
                #     if item.count("-") > 0:
                #         date_array.append(item)

                user_counter = str(report_file.readline())

                registered_user_counter = str(report_file.readline())

                active_user_counter = str(report_file.readline())

                insulin_logs_list = str(report_file.readline())

                activities_logs_list = str(report_file.readline())

                drug_logs_list = str(report_file.readline())

                sugar_logs_list = str(report_file.readline())

                walking_logs_list = str(report_file.readline())

                feeling_logs_list = str(report_file.readline())

                message_logs_list = str(report_file.readline())

                eating_logs_list = str(report_file.readline())

                sumation_logs_list = str(report_file.readline())

                active_in_30_days_ago = str(report_file.readline())

                today_active_user = str(report_file.readline())

                today_active_user_transaction = str(report_file.readline())
                report_file.close()

                # append today's data
                DailyReportsData = open(str(STATIC_ROOT) + "/logs/DailyReportsData.txt", "w")

                t = data["time"]
                DailyReportsData.write(str(t) + "\n")

                exe_time = data["exe_time"]
                DailyReportsData.write(str(exe_time) + "\n")

                date_array = sumOfListWithDuration(d_array, data["date"], durations)
                write_list_to_file(date_array, DailyReportsData)

                user_counter = sumOfListWithDuration(user_counter, data["user_counter"], durations)
                write_list_to_file(user_counter, DailyReportsData)

                registered_user_counter = sumOfListWithDuration(registered_user_counter,
                                                                data["registered_user_counter"], durations)
                write_list_to_file(registered_user_counter, DailyReportsData)

                active_user_counter = sumOfListWithDuration(active_user_counter, data["active_user_counter"], durations)
                write_list_to_file(active_user_counter, DailyReportsData)

                insulin_logs_list = sumOfListWithDuration(insulin_logs_list, data["insulin_logs_list"], durations)
                write_list_to_file(insulin_logs_list, DailyReportsData)

                activities_logs_list = sumOfListWithDuration(activities_logs_list, data["activities_logs_list"],
                                                             durations)
                write_list_to_file(activities_logs_list, DailyReportsData)

                drug_logs_list = sumOfListWithDuration(drug_logs_list, data["drug_logs_list"], durations)
                write_list_to_file(drug_logs_list, DailyReportsData)

                sugar_logs_list = sumOfListWithDuration(sugar_logs_list, data["sugar_logs_list"], durations)
                write_list_to_file(sugar_logs_list, DailyReportsData)

                walking_logs_list = sumOfListWithDuration(walking_logs_list, data["walking_logs_list"], durations)
                write_list_to_file(walking_logs_list, DailyReportsData)

                feeling_logs_list = sumOfListWithDuration(feeling_logs_list, data["feeling_logs_list"], durations)
                write_list_to_file(feeling_logs_list, DailyReportsData)

                message_logs_list = sumOfListWithDuration(message_logs_list, data["message_logs_list"], durations)
                write_list_to_file(message_logs_list, DailyReportsData)

                eating_logs_list = sumOfListWithDuration(eating_logs_list, data["eating_logs_list"], durations)
                write_list_to_file(eating_logs_list, DailyReportsData)

                sumation_logs_list = sumOfListWithDuration(sumation_logs_list, data["sumation_logs_list"], durations)
                write_list_to_file(sumation_logs_list, DailyReportsData)

                active_in_30_days_ago = sumOfListWithDuration(active_in_30_days_ago, data["active_in_30_days_ago"],
                                                              durations)
                write_list_to_file(active_in_30_days_ago, DailyReportsData)

                today_active_user = data["today_active_user"]
                write_list_to_file(today_active_user, DailyReportsData)

                today_active_user_transaction = data["today_active_user_transaction"]
                write_list_to_file(today_active_user_transaction, DailyReportsData)

                write_list_to_file(new_users_list, DailyReportsData)

                DailyReportsData.close()
            log("/************************/")
            log("\n\n")
            print("end:", datetime.now())
        except Exception as e:
            SMS().send_to_admin("در محاسبه آمار امروز مشکلی وجود داشت")
            print(str(e))

        SMS().send_to_admin("آمار امروز محاسبه شد")


class DailyCoinUpdate(CronJobBase):
    RUN_AT_TIMES = ['23:55']
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.Coins'  # a unique code

    def do(self):
        print("start!", datetime.now())
        try:
            points = Points.objects.filter(date=date.today())
            for po in points:
                coins = int(po.total_points)
                if coins > 0:
                    po.user.profile.add_coins(coins, _type='app usage')
            print("DailyCoinUpdate time:", datetime.now())
        except Exception as e:
            SMS().send_to_admin("در محاسبه آمار سکه های امروز مشکلی وجود داشت")
            print(str(e))

        SMS().send_to_admin("آمار امروز محاسبه شد")


class InactiveUserNotification(CronJobBase):
    RUN_AT_TIMES = ['12:00']  # Runs daily at noon
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.InactiveUsers'

    # Your new list of messages
    INACTIVE_MESSAGES = [
        "🌟 مدتی است شما را ندیده‌ایم! برگردید و از امکانات جدید ما لذت ببرید.",
        "💬 به یاد شما هستیم! با بازگشت به اپلیکیشن، تجربه‌ای جدید را از دست ندهید.",
        "📅 مدت زیادی است که خبری از شما نیست! از امکانات و به‌روزرسانی‌های جدید استفاده کنید.",
        "🔥 وقتشه که دوباره شروع کنید! اپلیکیشن منتظر شماست. به جمع ما بپیوندید.",
        "🎯 به هدفتان نزدیک‌تر شوید! دوباره وارد شوید و گام‌های بزرگتری بردارید.",
        "🚀 هنوز فرصت دارید! بیایید تا از جدیدترین ویژگی‌ها و امتیازات بهره‌مند شوید.",
        "💡 همیشه در حال بهبود هستیم! به اپلیکیشن برگردید و تغییرات جدید را تجربه کنید.",
        "🎉 خوشحال می‌شویم دوباره شما را ببینیم! اپلیکیشن به روز شده است، منتظر شما هستیم.",
        "⏰ فرصت زیادی از دست ندهید! برگشتن به اپلیکیشن می‌تواند آغازگر یک تجربه هیجان‌انگیز باشد.",
        "💪 باز هم به شما نیاز داریم! به اپلیکیشن برگشته و به راه‌تان ادامه دهید.",
        "⭐ شما را کم داریم! بازگشت به اپلیکیشن فرصتی برای رشد و بهبود است.",
        "🕒 این فرصت طلایی رو از دست ندید! به اپلیکیشن برگردید و از پاداش‌های جدید بهره‌مند شوید.",
        "🌱 دوباره شروع کنید! اپلیکیشن به روزرسانی‌های جالبی دارد. بازگشت شما به آن، راهی برای پیشرفت است."
    ]
    MAX_NOTIFICATIONS = 3  # Cap at 3 notifications
    MAX_INACTIVITY_DAYS = 30  # Stop after 30 days of inactivity

    def do(self):
        print(f"Checking inactive users... {datetime.now()}")

        inactive_threshold = datetime.now() - timedelta(days=7)
        inactive_profiles = Profile.objects.filter(
            last_login__lt=inactive_threshold,
            firebase_token__isnull=False
        )

        if not inactive_profiles.exists():
            print("No inactive users found.")
            return

        for profile in inactive_profiles:
            try:
                app_user = User.objects.filter(profile=profile).first()
                if not app_user:
                    print(f"No User linked to profile {profile.first_name}")
                    continue

                message_title = "لاکتو!" if app_user.profile.version else "زیلاک!"
                days_inactive = (datetime.now() - profile.last_login).days

                # Stop if inactive for too long
                if days_inactive > self.MAX_INACTIVITY_DAYS:
                    print(f"Skipping {app_user.identifier} - inactive for over {self.MAX_INACTIVITY_DAYS} days")
                    continue

                # Count previous successful notifications
                notification_count = NotificationLog.objects.filter(
                    user=app_user,
                    title=message_title,
                    status='success',
                    body__in=self.INACTIVE_MESSAGES
                ).count()

                if notification_count >= self.MAX_NOTIFICATIONS:
                    print(f"Skipping {app_user.identifier} - reached max notifications ({self.MAX_NOTIFICATIONS})")
                    continue

                # Randomly select a message
                message = random.choice(self.INACTIVE_MESSAGES)

                # Check if this specific message was already sent
                has_sent_this_message = NotificationLog.objects.filter(
                    user=app_user,
                    title=message_title,
                    body=message,
                    status='success'
                ).exists()

                if has_sent_this_message:
                    print(f"Skipping {app_user.identifier} - already sent '{message}'")
                    # Optional: Pick a different message if this one was sent
                    available_messages = [msg for msg in self.INACTIVE_MESSAGES if not NotificationLog.objects.filter(
                        user=app_user, title=message_title, body=msg, status='success').exists()]
                    if not available_messages:
                        print(f"No new messages available for {app_user.identifier}")
                        continue
                    message = random.choice(available_messages)

                push_notification = PushNotification(user=app_user)
                success = push_notification.send_inactive_user_notification(
                    app_user=app_user,
                    message=message
                )

                if success:
                    print(f"Notification {notification_count + 1}/{self.MAX_NOTIFICATIONS} sent to {app_user.identifier} - {days_inactive} days inactive")
                else:
                    print(f"Failed to send notification to {app_user.identifier}")

            except Exception as e:
                print(f"Error processing profile {profile.first_name}: {e}")

        print(f"Inactive user check complete. {datetime.now()}")



class LowCreditNotification(CronJobBase):
    RUN_AT_TIMES = ['13:00']  # Runs daily at noon
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.LowCreditNotification'
        
    def generate_random_string():
        letters = ''.join(random.choices(string.ascii_letters, k=4))
        digits = ''.join(random.choices(string.digits, k=2))
        lst = list(letters + digits)
        random.shuffle(lst)
        return ''.join(lst)

    
    
    def do(self):
        print(f"Checking users with low credit... {datetime.now()}")

        # Define the low credit threshold (3 days or less)
        low_credit_threshold = 3
        low_credit_entries = TherapistSelection.objects.filter(
            credit__lte=datetime.now() + timedelta(days=low_credit_threshold),
            credit__gt=datetime.now()  # Exclude already expired credits
        )
        amin = User.objects.filter(pk=27).first()

        if not low_credit_entries.exists():
            print("No users with low credit found.")
            return

        for entry in low_credit_entries:
            try:
                # Get the app user linked to the DjangoUser via Profile
                app_user = User.objects.filter(django_user=entry.user).first()
                if not app_user or not app_user.profile or not app_user.profile.firebase_token:
                    print(f"No valid User or token for {entry.user.username}")
                    continue

                message_title = "لاکتو!" if app_user.profile.version else "زیلاک!"
                days_left = entry.remaining_credit()

                # Skip if no days left (already handled by credit__gt filter, but extra safety)
                if days_left < 1:
                    continue

                # Dynamic message based on remaining days
                message = f"⏰ اعتبار شما تا {days_left} روز دیگر به پایان می‌رسد. لطفاً آن را تمدید کنید!"

                # Check if this specific message was already sent successfully
                has_sent_this_message = NotificationLog.objects.filter(
                    user=app_user,
                    title=message_title,
                    body=message,  # Match exact message with days_left
                    status='success'
                ).exists()

                if has_sent_this_message:
                    print(f"Skipping {app_user.identifier} - already sent '{message}'")
                    continue

                # Send the notification
                push_notification = PushNotification(user=app_user)
                success = push_notification.send_inactive_user_notification(
                    app_user=app_user,
                    message=message
                )

                if success:
                    print(f"Notification sent to {app_user.identifier} - {days_left} days left")
                else:
                    print(f"Failed to send notification to {app_user.identifier}")

            except Exception as e:
                print(f"Error processing user {entry.user.username}: {e}")

        try:
            # Calculate the date range for yesterday
            yesterday = datetime.now().date() - timedelta(days=1)
            start_of_yesterday = datetime.combine(yesterday, datetime.min.time())
            end_of_yesterday = datetime.combine(yesterday, datetime.max.time())

            # Get users whose registration time (created_at) was yesterday
            users_registered_yesterday = User.objects.filter(created_at__gte=start_of_yesterday, created_at__lte=end_of_yesterday)

            # Find users who have not booked a TimeSlot (i.e., are not a patient in any TimeSlot)
            users_who_have_not_booked = []
            for user in users_registered_yesterday:
                # Check if user is linked as patient in any TimeSlot
                has_booked = TimeSlot.objects.filter(patient=user).exists()
                if not has_booked:
                    users_who_have_not_booked.append(user)
                    

            # Output usernames or phone numbers for demonstration
            for user in users_who_have_not_booked:
                yester_day_message_text = "هنوز فرصت داری تا از جلسه مشاوره رایگان خودت با متخصص تغذیه لاکتو استفاده کنی. 🌱\nدر این جلسه می‌تونی یک نقشه راه اولیه برای اهداف سلامتی‌ات دریافت کنی و همه سوالاتت رو بپرسی.\n برای اینکه جلسه‌تو رزرو کنی کافیه بری تو اپلیکیشن و از قسمت “رزرو جلسه اولین” اولین جلسه‌ات رو رزرو کن!!"
                PushNotification(user).send_notification_to(user.profile.firebase_token, "جلسه رایگاه مشاوره با متخصص لاکتو!", yester_day_message_text)
                data = {'from': '50002710089184', 'to': user.phone_number, 'text': yester_day_message_text}
                response = requests.post('https://console.melipayamak.com/api/send/simple/7b4e26f2301d405f925498b37bd09ef5', json=data)
                
                if response.json()['status'] == "ارسال نشده":
                    PushNotification(amin).send_notification_to(amin.profile.firebase_token, user.phone_number, "SMS didn't send for this user")
        except Exception as e:
            PushNotification(amin).send_notification_to(amin.profile.firebase_token, amin.phone_number, f"Exception in هنوز فرصت داری تا از جلسه مشاوره رایگان: {e}")
            
            
        try:        
            week_ago = datetime.now().date() - timedelta(days=7)
            start_of_last_week = datetime.combine(week_ago, datetime.min.time())
            end_of_last_week = datetime.combine(week_ago, datetime.max.time())
            users_registered_last_week = User.objects.filter(date_joined__gte=start_of_last_week, date_joined__lte=end_of_last_week)

            week_users_who_have_not_booked = []
            for user in users_registered_last_week:
                # Check if user is linked as patient in any TimeSlot
                has_booked = TimeSlot.objects.filter(patient=user).exists()
                if not has_booked:
                    week_users_who_have_not_booked.append(user)
            for user in week_users_who_have_not_booked:
                print(f"User ID: {user.id}, Phone: {getattr(user, 'phone_number', '')}")
                yester_day_message_text = "{first_name} عزیز ⏳\n\nهدیه جلسه مشاوره رایگان لاکتو به زودی منقضی می‌شود.\n\nاین آخرین فرصت شما برای دریافت یک نقشه راه شخصی از متخصص تغذیه لاکتو است. اگر نمی‌خواهید این هدیه ارزشمند را از دست بدهید، اولین جلسه‌ات رو داخل اپلیکیشن از قسمت “رزرو جلسه” با ما هماهنگ کن!"
                
                PushNotification(user).send_notification_to(user.profile.firebase_token, "اعتبار جلسه رایگان شما در حال انقضاست!", yester_day_message_text)
                
                data = {'from': '50002710089184', 'to': user.phone_number, 'text': yester_day_message_text}
                response = requests.post('https://console.melipayamak.com/api/send/simple/7b4e26f2301d405f925498b37bd09ef5', json=data)
                
                if response.json()['status'] == "ارسال نشده":
                    PushNotification(user).send_notification_to(amin.profile.firebase_token, user.phone_number, "SMS didn't send for this user  -- They've beeen last week users.")
        except Exception as e:
            PushNotification(amin).send_notification_to(amin.profile.firebase_token, amin.phone_number, f"Exception in scenario_two: {e}")

        try:
            
            """ Scenario 6: Monthly gift to the user
            This function is used to send a notification to users who have not booked a meeting in the last month.
            """
            month_ago = datetime.now().date() - timedelta(days=30)
            start_of_last_month = datetime.combine(month_ago, datetime.min.time())
            end_of_last_month = datetime.combine(month_ago, datetime.max.time())
            users_registered_last_month = User.objects.filter(date_joined__gte=start_of_last_month, date_joined__lte=end_of_last_month)
            
            month_users_who_have_not_booked = []
            for user in users_registered_last_month:
                # Check if user is linked as patient in any TimeSlot
                has_booked = TimeSlot.objects.filter(patient=user).exists()
                if not has_booked:
                    month_users_who_have_not_booked.append(user)
            for user in month_users_who_have_not_booked:
                print(f"User ID: {user.id}, Phone: {getattr(user, 'phone_number', '')}")
                monthly_discount_code = generate_random_string().upper()
                Discount.objects.create(
                    code=monthly_discount_code,
                    percentage=11.4064104,
                    created_at=datetime.now(),
                    expire_date=datetime.now() + timedelta(hours=72)
                )
                
                first_name = user.profile.first_name
                monthy_message_text = f"""سلام {first_name} عزیز 🌿
درست یک ماه از آشناییمون باهمدیگه میگذره! امیدوارم این مدت، لاکتو تونسته باشه همراه خوبی برات باشه.
به مناسبت یک ماهگیمون، یه هدیه مخصوص برات داریم 🎁

۱۰۰ هزار تومان تخفیف برای پلن نقره‌ای
کد تخفیف: {monthly_discount_code}
حواست باشه که ۷۲ ساعت وقت داری تا از کد تخفیفت استفاده کنی پس همین حالا پلن خودت رو فعال کن و نسخه بهتری از خودت باش!
"""

                PushNotification(user).send_notification_to(user.profile.firebase_token, "درست یک ماه از آشناییمون باهمدیگه میگذره!", monthy_message_text)

                data = {'from': '50002710089184', 'to': user.phone_number, 'text': monthy_message_text}
                response = requests.post('https://console.melipayamak.com/api/send/simple/7b4e26f2301d405f925498b37bd09ef5', json=data)
                
                if response.json()['status'] == "ارسال نشده":
                    PushNotification(user).send_notification_to(amin.profile.firebase_token, user.phone_number, "SMS didn't send for this user  -- They've beeen last month users.")
        except Exception as e:
            PushNotification(amin).send_notification_to(amin.profile.firebase_token, "Exception in monthly gift to the user scenario", f"{e}")
                            


                
        try:
                
            """
            SCENARIO THREE
            This function is used to send a notification to users who have purchased a meeting yesterday and do not have an active therapist selection.
            """
            
                
            # Calculate yesterday's date range
            yesterday = datetime.now().date() - timedelta(days=1)
            start_of_yesterday = datetime.combine(yesterday, datetime.min.time())
            end_of_yesterday = datetime.combine(yesterday, datetime.max.time())

            # Find users who have purchased a meeting yesterday by checking TimeSlot where patient is set and created_at is yesterday
            meeting_timeslots = TimeSlot.objects.filter(
                patient__isnull=False,
                start_time__gte=start_of_yesterday,
                start_time__lte=end_of_yesterday
            )

            # Collect unique users who purchased a meeting yesterday
            purchased_meeting_yesterday_users = User.objects.filter(
                id__in=meeting_timeslots.values_list('patient_id', flat=True)
            ).distinct()

            # Find users who have an ACTIVE therapist selection (credit not expired)
            users_with_active_therapist_selection = User.objects.filter(
                django_user__applicant__isnull=False,
                django_user__applicant__credit__gt=datetime.now()
            ).distinct()

            # Users who have purchased a meeting yesterday and do not have an active therapist selection
            # (either no selection at all, or expired credit)
            target_users = purchased_meeting_yesterday_users.exclude(id__in=users_with_active_therapist_selection.values_list('id', flat=True))

            # Send notifications to target users
            for user in target_users:
                profile = user.profile
                print("Notification should be sent for this user:", profile.first_name, profile.last_name)
                
                daily_discount_code = generate_random_string().upper()
                
                discount = Discount.objects.create(
                    code=daily_discount_code,
                    percentage=11.4064104,
                    created_at=datetime.now(),
                    expire_date=datetime.now() + timedelta(hours=48)
                )
                
                promotion_text = f""""امیدواریم از گفت‌وگو با متخصص لاکتو لذت برده باشید 🌿
        برای اینکه راحت‌تر مسیر سلامتی‌تون رو ادامه بدید، با وارد کردن کد تخفیف {daily_discount_code} از ۱۰۰ هزار تومان تخفیف برای خرید پلن نقره‌ای استفاده کنید 💎
        این فرصت فقط تا ۴۸ ساعت آینده فعاله ⏰
        ✨ پس همین حالا شروع کنید و سلامتی‌تون رو به سطح بعدی برسونید!
        """
                PushNotification(user).send_notification_to(user.profile.firebase_token, "جلسه خوب بود؟😃", monthy_message_text)
        

        
                data = {'from': '50002710089184', 'to': user.phone_number, 'text': promotion_text}
                response = requests.post('https://console.melipayamak.com/api/send/simple/7b4e26f2301d405f925498b37bd09ef5', json=data)
                    
                if response.json()['status'] == "ارسال نشده":
                    PushNotification(amin).send_notification_to(amin.profile.firebase_token, user.phone_number, "SMS didn't send for this user  -- They've beeen last month users.")
                            

        except Exception as e:
            PushNotification(amin).send_notification_to(amin.profile.firebase_token, "Exception in scenario 3", f"{e}")
            
            
            
            
            


class sendCoinMessage(CronJobBase):
    RUN_AT_TIMES = ['9:00']  # Runs daily at 9:00
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.SendCoinMessage'  # a unique code
    
    def do(self):
        print("Running sendCoinMessage job at", datetime.now())
        try:
            today = datetime.now().date()
            yesterday = today - timedelta(days=1)
            two_days_ago = today - timedelta(days=2)
            three_days_ago = today - timedelta(days=3)
            four_days_ago = today - timedelta(days=4)

            # Find users created on each of the last four days
            yesterdayUsers = User.objects.filter(created_at__date=yesterday)
            twoDaysAgoUsers = User.objects.filter(created_at__date=two_days_ago)
            threeDaysAgoUsers = User.objects.filter(created_at__date=three_days_ago)
            fourDaysAgoUsers = User.objects.filter(created_at__date=four_days_ago)

            # Example: print or process each group
            if yesterdayUsers.exists():
                # Do something with yesterdayUsers
                for user in yesterdayUsers:
                    profile = user.profile
                    push_notification = PushNotification(user=user)
                    
                    if profile.coins == 0:
                        notification_title = "دیروز سکه‌هات پرید!"
                        notification_body = """هر روزی که فعالیتت رو ثبت نکنی، فرصت گرفتن سکه‌ها از دست میره ❌
        دیروز هیچ چیزی نگرفتی، ولی امروز می‌تونی همه‌چیز رو تغییر بدی 🚀
        شروع کن تا سکه‌هات رو از دست ندی!""" 
                    else:
                        notification_title = f"💰{profile.coins} سکه به حساب شما واریز شد!"
                        notification_body = """امتیازهای روزانه شما در پایان روز به سکه تبدیل می‌شن. دیروز اولین واریزی به بانک سلامت شما انجام شد و شما میتوانید از سکه‌ها داخل اپلیکیشن استفاده کنید""" 
                    
                    push_notification.send_notification_to_user(user, notification_title, notification_body)

            if twoDaysAgoUsers.exists():
                # Do something with twoDaysAgoUsers
                for user in twoDaysAgoUsers:
                    profile = user.profile
                    # push_notification = PushNotification(user=user)
                    
                    points = Points.objects.filter(user=user)
                    send_notification = True
                    for point in points:
                        point.total_points
                        # if point.total_points > 0:
                        #     send_notification = send_notification and True
                        #     break
                        # else:
                            
                    
        #             if profile.coins == 0:
        #                 notification_title = "دیروز سکه‌هات پرید!"
        #                 notification_body = """هر روزی که فعالیتت رو ثبت نکنی، فرصت گرفتن سکه‌ها از دست میره ❌
        # دیروز هیچ چیزی نگرفتی، ولی امروز می‌تونی همه‌چیز رو تغییر بدی 🚀
        # شروع کن تا سکه‌هات رو از دست ندی!""" 
        #             else:
        #                 notification_title = f"💰{profile.coins} سکه به حساب شما واریز شد!"
        #                 notification_body = """امتیازهای روزانه شما در پایان روز به سکه تبدیل می‌شن. دیروز اولین واریزی به بانک سلامت شما انجام شد و شما میتوانید از سکه‌ها داخل اپلیکیشن استفاده کنید""" 
                    
                    push_notification.send_notification_to_user(user, notification_title, notification_body)

            # if threeDaysAgoUsers.exists():
            #     print(f"Users created three days ago ({three_days_ago}): {threeDaysAgoUsers.count()}")
            #     # Do something with threeDaysAgoUsers

            # if fourDaysAgoUsers.exists():
            #     print(f"Users created four days ago ({four_days_ago}): {fourDaysAgoUsers.count()}")
            #     # Do something with fourDaysAgoUsers

        except Exception as e:
            print(f"Exception in sendCoinMessage: {e}")
    
    
class SendReports(CronJobBase):
    RUN_AT_TIMES = ['23:55']  # Runs daily at midnight
    schedule = Schedule(run_at_times=RUN_AT_TIMES)
    code = 'APIs.SendReports'  # a unique code

    # Telegram Configuration
    BOT_TOKEN = "7935660276:AAH6M8WDXC99YyUfKWL01fnrAn3iZ6C3BUQ"
    CHAT_ID = -4680417517

    def do(self):
        print("Starting send_reports job at", datetime.now())
        try:
            # Initialize bot
            bot = telebot.TeleBot(self.BOT_TOKEN)
            
            # 1. New Users Report
            new_users = self.get_new_users_today()
            new_users_message = f"📊 New Users Report for {jdatetime.date.today().strftime('%Y/%m/%d')}\n\n"
            new_users_message += f"Total new users today: {new_users.count()}\n\n"
            
            if new_users.count() > 0:
                new_users_message += "New Users List:\n"
                for i, user in enumerate(new_users, 1):
                    new_users_message += f"{i}. {user.identifier}\n"
                    if user.phone_number:
                        new_users_message += f"   📱 Phone: {user.phone_number}\n"
                    if user.profile:
                        new_users_message += f"   👤 Profile: {user.profile.first_name} {user.profile.last_name}\n"
                    new_users_message += "\n"
            
            # Send new users report
            bot.send_message(chat_id=self.CHAT_ID, text=new_users_message)
            
            # 2. Active Users Report
            active_users = self.get_active_users_today()
            active_users_message = f"👥 Active Users Today ({jdatetime.date.today().strftime('%Y/%m/%d')})\n\n"
            active_users_message += f"Total active users today: {active_users.count()}\n\n"
            
            if active_users.count() > 0:
                active_users_message += "Active Users List:\n"
                for i, point in enumerate(active_users, 1):
                    user = point.user
                    active_users_message += f"{i}. {user.identifier}\n"
                    if user.phone_number:
                        active_users_message += f"   📱 Phone: {user.phone_number}\n"
                    if user.profile:
                        active_users_message += f"   👤 Profile: {user.profile.first_name} {user.profile.last_name}\n"
                    active_users_message += f"   ⭐ Points: {point.total_points}\n\n"
            
            # Send active users report
            bot.send_message(chat_id=self.CHAT_ID, text=active_users_message)
            
            # 3. New Purchases Report
            new_purchases = self.get_new_purchases_today()
            purchases_message = f"💰 New Purchases Today ({jdatetime.date.today().strftime('%Y/%m/%d')})\n\n"
            purchases_message += f"Total new purchases today: {new_purchases.count()}\n\n"
            
            if new_purchases.count() > 0:
                purchases_message += "New Purchases List:\n"
                for i, purchase in enumerate(new_purchases, 1):
                    user = purchase.user
                    purchases_message += f"{i}. {user.identifier}\n"
                    if user.phone_number:
                        purchases_message += f"   📱 Phone: {user.phone_number}\n"
                    if user.profile:
                        purchases_message += f"   👤 Profile: {user.profile.first_name} {user.profile.last_name}\n"
                    purchases_message += f"   💵 Amount: {purchase.amount_after_discount:,} Rials\n"
                    purchases_message += f"   📦 Plan: {purchase.get_plan_display()}\n\n"
            
            # Send purchases report
            bot.send_message(chat_id=self.CHAT_ID, text=purchases_message)
            
            print(f"Successfully sent reports for {new_users.count()} new users, {active_users.count()} active users, and {new_purchases.count()} new purchases")
            print("Completed send_reports job at", datetime.now())
        except Exception as e:
            log(f"Error in send_reports job: {str(e)}")
            print(f"Error in send_reports job: {str(e)}")


    def get_new_users_today(self):
        # Get today's date at 00:00
        today = date.today()
        today_start = datetime.combine(today, datetime.min.time())

        # Query for users created today
        new_users = User.objects.filter(created_at__gte=today_start)

        return new_users

    def get_active_users_today(self):
        # Get today's date
        today = date.today()

        # Query for users with points today
        active_users = Points.objects.filter(date=today).select_related('user', 'user__profile')

        return active_users

    def get_new_purchases_today(self):
        # Get today's date at 00:00
        today = date.today()
        today_start = datetime.combine(today, datetime.min.time())

        # Query for successful purchases today
        new_purchases = ZarinPalPayment.objects.filter(created_at__gte=today_start, is_payed=True)

        return new_purchases


video_links = [
    "https://lacto.ir/v1.mp4",
    "",
    "",
    "https://lacto.ir/day2.mp4",
    "https://lacto.ir/day3.mp4",
    "https://lacto.ir/day4.mp4",
    "https://lacto.ir/day5.mp4",
    "https://lacto.ir/day6.mp4",
    "https://lacto.ir/day7.mp4",
    "https://lacto.ir/day8.mp4",
    "https://lacto.ir/day9.mp4",
    " https://lacto.ir/day10.mp4",
    "https://lacto.ir/day11.mp4",
    "",
    "https://lacto.ir/day13.mp4",
    "https://lacto.ir/day14.mp4",
    "https://lacto.ir/day15.mp4",
    "https://lacto.ir/day16.mp4",
    "https://lacto.ir/day17.mp4",
    "https://lacto.ir/day18.mp4",
    "https://lacto.ir/day19.mp4",
    "https://lacto.ir/day20.mp4",
    "https://lacto.ir/day21.mp4",
    "Video kharab bood bayad dobare az mahdiye begiram",
    "https://lacto.ir/day23.mp4",
    "https://lacto.ir/day24.mp4",
    "https://lacto.ir/day25.mp4",
    "https://lacto.ir/day26.mp4",
    "https://lacto.ir/day27.mp4",
    "https://lacto.ir/day28.mp4",
    "",
    "",
    "",
    "https://lacto.ir/day32.mp4",
    "",
    "https://lacto.ir/day34.mp4",
    "",
    "https://lacto.ir/day36.mp4",
    "https://lacto.ir/day37.mp4",
]

video_texts = [
  "غذا، میکروب‌ها و سلول‌های بدن، مثلثی رو تشکیل میدهند که همه در سلامت شما نقش دارند با اولین ویدیو لاکتو ماجراجویی در دنیای میکروب هارو آغاز کن!",
  "میکروبیوم هرکسی مثل اثر انگشت خاص و منحصربه‌فرده! تو این ویدیو می‌گیم چرا تعادل باکتری‌های خوب و بد روده مهمه و چطور می‌تونه روی سلامتی‌تون تأثیر بذاره. پس ویدیو امشب رو از دست ندین!",
  "توی ویدیو امشب یاد میگیریم که چطور یه رژیم غذایی می‌تونه دنیای باکتری‌های خوب روده‌مون رو متحول کنه! از نون خمیر ترش گرفته تا ماهی‌های پرچرب، همه این‌ها می‌تونن تعادل میکروبیوم روده‌تون رو بسازن میخوای بدونی چطور سلامت گوارش و آینده‌ات رو تضمین کنی؟ همین الان ویدیو رو ببین و با ما همراه شو!",
  "میدونستی میلیاردها باکتری تو روده‌ات زندگی می‌کنن که می‌تونن روی خلق و خو، سیستم ایمنی و حتی هضم غذا تأثیر بذارن؟! راز سلامتی اینه که این دنیای کوچک رو متنوع و متعادل نگه داری! ویدیو امشب رو ببین و قدم به دنیای سلامت روده بذار!",
  "می‌دونستی هزار روز اول زندگی، کلید ساختن میکروبیوم سالمه؟ از دوران جنینی گرفته تا نوع زایمان و تغذیه با شیر مادر، همه اینا تو شکل‌گیری \"اثر انگشت میکروبی\" شما نقش دارن! پس همین الان ویدیو رو ببین و رازهای شگفت‌انگیز میکروبیوم رو کشف کن!",
  "آیا می‌دونید شناسنامه میکروبی شما توی هر مرحله از زندگی‌تون دستخوش تغییر می‌شه؟! از کودکی تا بلوغ و میانسالی، هر چرخه فرصت مهمیه تا باکتری‌های مفید دستگاه گوارشتون رو تقویت کنید و سلامت ذهنی و جسمی‌تون رو تضمین کنید. ویدیو رو ببینید و راهکارهای تغذیه‌ای برای داشتن یک شناسنامه میکروبی سالم رو یاد بگیرید!",
  "حدود 70 درصد از سلول‌های ایمنی بدن، اطراف روده هستن. هرچی میکروبیوم روده متنوع‌تر و سالم‌تر باشه، سیستم ایمنی قوی‌تری داریم ویدیو رو ببین و قدم به قدم به سمت تقویت میکروبیوم و سلامت بیشتر حرکت کن!",
  "خیلی وقتا نمی‌دونیم کی باید دست از غذا خوردن بکشیم، چون سیری و پری معده رو با هم اشتباه می‌گیریم! 🤯 توی این ویدیو یاد می‌گیریم که چجوری با چند ترفند ساده احساس سیری بهتری داشته باشیم. ویدیو روببین و یاد بگیر چجوری آگاهانه‌تر غذا بخوری! 🎥👇",
  "آیا تا حالا به قدرت جویدن فکر کردید؟! هر لقمه‌ای که خوب می‌جوید، نه تنها به هضم بهتر کمک می‌کنه، بلکه به رشد باکتری‌های مفید دستگاه گوارش هم کمک می‌کنه! ویدیو رو ببینید و برای داشتن یک گوارش سالم‌تر همراه ما باشید!",
  "زمان و تعداد وعده‌های غذایی روی سلامت میکروبیوم روده تأثیر داره! با تنظیم درست اون‌ها می‌تونید به گوارش بهتر و سلامت بیشتر برسید. پس بیاین ببینیم چطور! 🎥👇",
  "مطمئنم که میدونی آب برای بدن چقدر مهمه! آب کافی می‌تونه از یبوست و نفخ جلوگیری کنه و به حرکت راحت‌تر غذا تو دستگاه گوارش کمک کنه. می‌خوای بدونی چطور با آب خوردن می‌تونی به سلامت روده‌هات کمک کنی؟ این ویدیو رو از دست نده!",
  "بعضی وقتا بدون اینکه گرسنه باشیم، حجم زیادی غذا می‌خوریم و بعدش احساس می‌کنیم کنترل از دستمون خارج شده. این رفتار می‌تونه به بدن و روح ما آسیب بزنه. توی این ویدیو یاد می‌گیریم چطور این چرخه رو بشکنیم و با تغییرات کوچیک توی سبک زندگی، حالمون رو بهتر کنیم. حتما ببینید!",
  "در این ویدیو با هم بررسی می‌کنیم که ریزه‌خوری چی هست و چطور می‌تونه باعث بهم خوردن تعادل میکروبیوم روده بشه. اگر می‌خواهید بدونید چطور می‌تونید با ریزه‌خوری خداحافظی کنید و کنترل بهتری روی میکروبیوم روده‌تون داشته باشید، حتما ویدیو رو ببینید!",
  "غذاهای فرآوری‌شده، دشمن خاموش سلامت روده! 🚨 این خوراکی‌ها تعادل میکروبیوم رو به هم می‌زنن و راه رو برای بیماری‌ها باز می‌کنن. وقتشه انتخاب‌های سالم‌تری داشته باشیم! پس حتما ویدیو امشب رو ببین",
  "شاید همه بدونیم که قند و شیرینی برای بدن مضره، اما چرا باز هم نمی‌تونیم ازش دست بکشیم؟! توی ویدیو امشب می‌بینیم چطور می‌شه این چرخه رو شکست و به سلامت روده‌ و بهبود حال روحی‌مون کمک کنیم. ویدیو رو حتما ببینید و قدمی برای سلامت خودتون بردارید!",
  "نان و برنج سفید کمتر، میکروبیوم سالم‌تر! یه تغییر کوچک تو انتخاب کربوهیدرات‌ها می‌تونه روده‌ات رو قوی‌تر کنه و از بیماری‌ها دور نگهت داره. چطوری؟ همین الان ویدیو رو ببین!",
  "همه چربی‌ها بد نیستن! بعضی‌ها مثل امگا ۳ و روغن زیتون، به سلامت مغز، روده و قلبت کمک می‌کنن و حتی هضم غذا رو راحت‌تر می‌کنن. پس وقتشه که چربی‌های خوب رو بشناسی و به رژیم غذاییت اضافه کنی! چطوری؟ ویدیو رو ببین!",
  "الکل و تنباکو دشمن‌های روده‌ شما هستن! با ترک این عادت‌ها، میکروبیوم روده‌تون نفس می‌کشه، هضم بهتر می‌شه و انرژی‌تون برمی‌گرده! امروز به فکر روده‌تون باشید و ویدیو رو از دست ندین!",
  "گلوتن می‌تونه تعادل روده رو به هم بزنه، باعث التهاب بشه و حتی مشکل نشت روده‌ای ایجاد کنه! 🤯 اگه مشکلات گوارشی داری، شاید این ویدیو بتونه بهت کمک کنه. پس همین الان ویدیو رو ببین!",
  "پری‌بیوتیک‌ها فیبرهایی هستن که به رشد باکتری‌های خوب کمک می‌کنن، گوارش رو بهتر می‌کنن و حتی سیستم ایمنی رو تقویت می‌کنن! بدون اون‌ها، روده‌ات خوشحال نیست! 😅 این ویدیو رو ببین و راز یه روده سالم رو کشف کن!",
  "حالا که فهمیدیم پری‌بیوتیک‌ها چقدر برای روده مهمن، وقتشه بدونی تو چه غذاهایی پیدا می‌شن! 😍 پس ویدیو رو ببین و غذای مناسب روده‌ات رو پیدا کن!",
  "در این ویدیو می‌گم پروبیوتیک‌ها چی هستن، چه فوایدی دارن و چطور می‌تونن به سلامت روده و سیستم ایمنی کمک کنن. اگه می‌خواید بدونید چطور این باکتری‌های مفید رو به رژیم غذاییتون اضافه کنید، ویدیو رو حتما مشاهده کنید!",
  "\"سلام شب بخیر! آیا می‌دونستید مکمل‌های پروبیوتیک می‌تونند زندگی شما رو تغییر بدن؟ توی این ویدیو به شما می‌گم که مکملهای پروبیوتیک‌ چطور میتونن به شما کمک می‌کنن و چه نکاتی رو قبل از مصرف باید بدونید! برای حال بهتر، این ویدیو رو از دست ندید!\"",
  "یه دنیای نامرئی توی بدنت هست که روی انرژی، خلق‌وخو و حتی سیستم ایمنیت تأثیر می‌ذاره! پروبیوتیک‌ها و پری‌بیوتیک‌ها قهرمانای گوارش تو هستن، ولی دقیقا چطور؟ ویدیو رو ببین و جواب سوال رو کشف کن✌",
  "در این ویدیو، قراره با سوپرفودها آشنا بشید و یاد بگیرید چطور این مواد غذایی پرقدرت به بهبود میکروبیوم روده و سلامت کلی بدن کمک می‌کنن! اگر به سلامت‌تون اهمیت می‌دید، این ویدیو رو از دست ندید!",
  "بیوفیلم یه سپر نامرئیه که باکتری‌های بد تو روده‌مون می‌سازن تا از خودشون در برابر آنتی‌بیوتیک‌ها و آنزیم‌ها محافظت کنن! ولی خبر خوب اینه که می‌تونیم با تغذیه‌ی مناسب این بیوفیلم رو بشکنیم و تعادل روده‌مون رو برگردونیم. 🌱🦠 پس اگه می‌خوای بدونی چطور این سد مقاوم رو از بین ببری و روده سالم‌تری داشته باشی، ویدیو رو از دست نده!",
  "نوشیدنی‌های دتاکس واقعاً معجزه می‌کنن یا یه جور تبلیغ هستن؟ 🤔 راستش رو بخوای، سم‌زدایی واقعی از بدن فقط با یه نوشیدنی انجام نمیشه! اگه می‌خوای بدونی چطور یه پاکسازی اصولی داشته باشی، ویدیو رو ببین! 🎥✨",
  "این ویدیو قراره راز قدرت سبزیجات چلیپایی رو برات فاش کنه! 🥦 از سم‌زدایی بدن تا دفع فلزات سنگین، این سبزیجات یه معجزه‌ی طبیعی هستن! پس اگه می‌خوای بدونی چطور می‌تونن به سلامتیت کمک کنن، همین الان ویدیو رو ببین!💚",
  "می‌خوای بدونی دستگاه گوارشت چقدر خوب کار می‌کنه؟ 🤔🔥 تو این ویدیو یه تست ساده و جذاب بهت معرفی کردیم که کمکت میکنه سلامت گوارشت رو بهتر بشناسی! 🍽💜 پس اگه دوست داری این تست جالب رو یاد بگیری، حتما ویدیو رو ببین!",
  "نفخ و گاز معده می‌تونه حسابی اذیت‌کننده باشه! 😣 ولی نگران نباش! توی این ویدیو، دلایل اصلی این مشکل، راه‌های کنترلش و تغذیه مناسب برای کاهش نفخ رو بررسی می‌کنیم.🥗 اگه می‌خوای شکم سبک‌تر و آرام‌تری داشته باشی، این ویدیو رو از دست نده! 🎥🔥"
]

